/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class VariableMapDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(VariableMapDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public VariableMapDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, "VariableMap", RepositoryMetaDataFactory.getRepositoryMetaData().getDocumentType("Variables"));
    }

    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, parent, relationshipInfo, attrList});
        }
        String type = WorkspaceHelper.getType(session, parent);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type", type);
        }
        if (type.equals("ServerCluster") && WorkspaceHelper.containVersion5Memeber(session, parent)) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0500E", new Object[]{parent}, null);
            throw new ConfigServiceException(msg);
        }
        if (type.equals("Deployment") && WorkspaceHelper.containVersion5DeploymentTarget(session, parent)) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0501E", new Object[]{parent}, null);
            throw new ConfigServiceException(msg);
        }
        ObjectName[] existing = this.baseConfigService.getRelationship(session, parent, "VariableMap");
        if (existing.length > 0) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0502E", new Object[]{parent, existing[0]}, null);
            throw new ConfigServiceException(msg);
        }
        ObjectName result = super.createConfigObject(session, parent, relationshipInfo, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", result);
        }
        return result;
    }
}

