/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.models.base.resources.init.ResourcesInit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.util.WCCM;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.configservice.MetadataFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;

public class TypeRegistry {
    private static TraceComponent tc = Tr.register(TypeRegistry.class, "management", "com.ibm.ws.management.resources.configservice");
    private HashMap typeTable = new HashMap();
    private static final String[] validPackagePrefix = new String[]{"com.ibm.ejs.models.base.resources", "com.ibm.websphere.models.config", "com.ibm.etools.jca", "org.eclipse.jst.j2ee.jca", "org.eclipse.jst.j2ee.common", "com.ibm.tivoli.models.config", "com.ibm.etools.j2ee.common", "com.ibm.etools.webservice"};
    private static final String[] emptyStringArray = new String[0];
    private static final TypeRegistry instance = new TypeRegistry();

    public static String getFullyQualifiedType(String shortTypeName) throws InvalidConfigDataTypeException {
        TypeInfo typeInfo = (TypeInfo)TypeRegistry.instance.typeTable.get(shortTypeName);
        if (typeInfo == null) {
            throw new InvalidConfigDataTypeException(shortTypeName);
        }
        return typeInfo.getFullyQualifiedType();
    }

    public static Set getAllTypes(Properties nodeProps) {
        HashSet filteredTypes = new HashSet(TypeRegistry.getAllTypes());
        MetadataFilter.filterAllTypes(filteredTypes, nodeProps);
        return filteredTypes;
    }

    public static Set getAllTypes() {
        return TypeRegistry.instance.typeTable.keySet();
    }

    public static String[] getSubTypes(String parentType, Properties nodeProps) throws InvalidConfigDataTypeException {
        String[] subTypes = TypeRegistry.getSubTypes(parentType);
        EClass parentClass = TypeRegistry.getMetaObject(parentType);
        LinkedList<String> subTypesList = new LinkedList<String>(Arrays.asList(subTypes));
        MetadataFilter.filterSubTypes(parentClass, subTypesList, nodeProps);
        return subTypesList.toArray(new String[0]);
    }

    public static String[] getSubTypes(String parentType) throws InvalidConfigDataTypeException {
        TypeInfo typeInfo = (TypeInfo)TypeRegistry.instance.typeTable.get(parentType);
        if (typeInfo == null) {
            throw new InvalidConfigDataTypeException(parentType);
        }
        return typeInfo.getSubTypes();
    }

    public static boolean isSubType(String parentType, String subType, Properties nodeProps) throws InvalidConfigDataTypeException {
        EClass parentClass = TypeRegistry.getMetaObject(parentType);
        EClass subClass = TypeRegistry.getMetaObject(subType);
        return MetadataFilter.isSubType(parentClass, subClass, nodeProps);
    }

    public static boolean isSubType(String parentType, String subType) throws InvalidConfigDataTypeException {
        String[] subTypes = TypeRegistry.getSubTypes(parentType);
        boolean result = false;
        for (int i = 0; i < subTypes.length; ++i) {
            if (!subTypes[i].equals(subType)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getShortType(String fullyQualifiedType) {
        TypeInfo ti = (TypeInfo)TypeRegistry.instance.typeTable.get(fullyQualifiedType);
        if (ti != null) {
            return fullyQualifiedType;
        }
        return fullyQualifiedType.substring(fullyQualifiedType.lastIndexOf(46) + 1, fullyQualifiedType.length());
    }

    public static EClass getMetaObject(String shortTypeName, Properties nodeProps) throws InvalidConfigDataTypeException {
        EClass newVersion = TypeRegistry.getMetaObject(shortTypeName);
        boolean valid = MetadataFilter.isValidType(newVersion, nodeProps);
        if (!valid) {
            throw new InvalidConfigDataTypeException("Config Type: " + shortTypeName + "is not valid in version: " + nodeProps);
        }
        return newVersion;
    }

    public static EClass getMetaObject(String shortTypeName) throws InvalidConfigDataTypeException {
        TypeInfo typeInfo = (TypeInfo)TypeRegistry.instance.typeTable.get(shortTypeName);
        if (typeInfo == null) {
            throw new InvalidConfigDataTypeException(shortTypeName);
        }
        return typeInfo.getMetaObject();
    }

    public static String getTypeShortName(EClassifier metaObj) {
        if (TypeRegistry.isEnumType(metaObj)) {
            return "ENUM";
        }
        String fullyQualifiedType = metaObj.getInstanceClass().getName();
        TypeInfo ti = (TypeInfo)TypeRegistry.instance.typeTable.get(fullyQualifiedType);
        if (ti != null) {
            return fullyQualifiedType;
        }
        return fullyQualifiedType.substring(fullyQualifiedType.lastIndexOf(46) + 1);
    }

    public static void main(String[] args) {
        System.out.println("currentTime:" + new Date(System.currentTimeMillis()).toString());
        ConfigInit.init();
        ResourcesInit.init();
        System.out.println("start generate type registry");
        System.out.println("currentTime:" + new Date(System.currentTimeMillis()).toString());
        TypeRegistry generator = new TypeRegistry();
        generator.generate();
        System.out.println("currentTime:" + new Date(System.currentTimeMillis()).toString());
        StringBuffer buf = new StringBuffer();
        generator.dumpState(buf);
        System.out.println(buf.toString());
    }

    private TypeRegistry() {
    }

    private void generate() {
        EPackage.Registry registry = null;
        ModelMgr.initialize((String)"ws-server");
        registry = EPackage.Registry.INSTANCE;
        if (registry instanceof EPackageRegistryImpl.Delegator) {
            this.generateMultipleClassLoaderTypeRegistry();
        } else if (registry instanceof EPackageRegistryImpl) {
            this.generateSingleClassLoaderTypeRegistry();
        } else {
            System.out.println("Error creating TypeRegistry: Unrecognized EMF Package registry implemnetation found: " + registry);
        }
    }

    private void generateSingleClassLoaderTypeRegistry() {
        EPackage.Registry registry = null;
        registry = WCCM.getPackageRegistry();
        if (registry == null) {
            ConfigInit.init();
            registry = WCCM.getPackageRegistry();
        }
        Set pkgUris = registry.keySet();
        Object[] pkgUriObjs = pkgUris.toArray();
        for (int i = 0; i < pkgUriObjs.length; ++i) {
            EPackage pkg;
            Object pkgUri = pkgUriObjs[i];
            if (pkgUri == null || (pkg = registry.getEPackage(pkgUri.toString())) == null || !this.isValidType(pkg.getClass().getName())) continue;
            EList types = pkg.getEClassifiers();
            for (Object type : types) {
                if (!(type instanceof EClass)) continue;
                this.registerType((EClass)type);
            }
        }
    }

    private void generateMultipleClassLoaderTypeRegistry() {
        EPackage.Registry registry = null;
        for (ClassLoader cl = ExtClassLoader.getInstance(); cl != null; cl = cl.getParent()) {
            registry = EPackageRegistryImpl.getRegistry(cl);
            Set pkgUris = registry.keySet();
            Object[] pkgUriObjs = pkgUris.toArray();
            for (int i = 0; i < pkgUriObjs.length; ++i) {
                EPackage pkg;
                Object pkgUri = pkgUriObjs[i];
                if (pkgUri == null || (pkg = registry.getEPackage(pkgUri.toString())) == null || !this.isValidType(pkg.getClass().getName())) continue;
                EList types = pkg.getEClassifiers();
                for (Object type : types) {
                    if (!(type instanceof EClass)) continue;
                    this.registerType((EClass)type);
                    EClass e = (EClass)type;
                }
            }
        }
    }

    private boolean isValidType(String type, Properties nodeProps) throws InvalidConfigDataTypeException {
        EClass typeClass = TypeRegistry.getMetaObject(type);
        return MetadataFilter.isValidType(typeClass, nodeProps);
    }

    private boolean isValidType(String type) {
        boolean result = false;
        for (int i = 0; i < validPackagePrefix.length; ++i) {
            if (!type.startsWith(validPackagePrefix[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    private TypeInfo basicRegisterType(EClass metaObj) {
        String shortName = TypeRegistry.getTypeShortName(metaObj);
        String fQName = metaObj.getInstanceClass().getName();
        TypeInfo typeInfo = (TypeInfo)this.typeTable.get(shortName);
        if (typeInfo == null) {
            typeInfo = (TypeInfo)this.typeTable.get(fQName);
        }
        if (typeInfo == null) {
            typeInfo = new TypeInfo(metaObj);
            if (fQName.startsWith("com.ibm.etools.webservice")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using fully qualified name for " + shortName + " : value is " + fQName);
                }
                this.typeTable.put(fQName, typeInfo);
            } else if (shortName.equals("Property")) {
                if (fQName.startsWith("com.ibm.websphere.models.config")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using " + shortName + " from " + fQName);
                    }
                    this.typeTable.put(shortName, typeInfo);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using fully qualified name for " + shortName + " : value is " + fQName);
                    }
                    this.typeTable.put(fQName, typeInfo);
                }
            } else {
                this.typeTable.put(shortName, typeInfo);
            }
        } else {
            fQName = metaObj.getInstanceClass().getName();
            String oldFQName = typeInfo.getFullyQualifiedType();
            if (fQName != null && oldFQName != null && !oldFQName.equals(fQName) && tc.isDebugEnabled()) {
                Tr.debug(tc, "duplicate type=" + shortName + " new=" + fQName + " old=" + oldFQName);
            }
        }
        return typeInfo;
    }

    private void registerType(EClass metaObj) {
        if (metaObj.getInstanceClass() == null) {
            return;
        }
        String fQName = metaObj.getInstanceClass().getName();
        if (this.isValidType(fQName)) {
            String shortName = TypeRegistry.getTypeShortName(metaObj);
            TypeInfo typeInfo = this.basicRegisterType(metaObj);
            if (metaObj instanceof EClass) {
                EList superTypes = metaObj.getEAllSuperTypes();
                for (EClassifier superClass : superTypes) {
                    String superTypeName = superClass.getInstanceClass().getName();
                    if (!this.isValidType(superTypeName)) continue;
                    TypeInfo superTypeInfo = this.basicRegisterType((EClass)superClass);
                    superTypeInfo.addSubType(shortName);
                }
            }
        }
    }

    private void dumpState(StringBuffer buf) {
        Set entrySet = this.typeTable.entrySet();
        buf.append("Dump the state of type registry\n");
        for (Map.Entry entry : entrySet) {
            buf.append("Short type name:").append(entry.getKey()).append('\n');
            TypeInfo typeInfo = (TypeInfo)entry.getValue();
            buf.append("FQ type name:").append(typeInfo.getFullyQualifiedType()).append('\n');
            String[] subTypes = typeInfo.getSubTypes();
            for (int i = 0; i < subTypes.length; ++i) {
                if (i == 0) {
                    buf.append("Subtype names:");
                }
                buf.append(subTypes[i]);
                if (i < subTypes.length - 1) {
                    buf.append(", ");
                    continue;
                }
                buf.append('\n');
            }
            buf.append('\n');
        }
    }

    static boolean isEnumType(EClassifier metaObj) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "metaObj", metaObj);
        }
        return metaObj instanceof EEnum;
    }

    static {
        instance.generate();
    }

    private class TypeInfo {
        private EClass metaObj;
        private List subTypes = null;

        public TypeInfo(EClass metaObj) {
            this.metaObj = metaObj;
        }

        public void addSubType(String shortSubType) {
            if (this.subTypes == null) {
                this.subTypes = new ArrayList(3);
            }
            this.subTypes.add(shortSubType);
        }

        public String[] getSubTypes() {
            String[] result;
            if (this.subTypes == null) {
                result = emptyStringArray;
            } else {
                result = new String[this.subTypes.size()];
                this.subTypes.toArray(result);
            }
            return result;
        }

        public String getFullyQualifiedType() {
            return this.metaObj.getInstanceClass().getName();
        }

        public EClass getMetaObject() {
            return this.metaObj;
        }
    }
}

