/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.csmetadata.EMFAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SpecialAttributeRegistry {
    private static TraceComponent tc;
    private static final HashSet readOnlyAttrs;
    private static final HashMap uniqueAttrs;

    public static boolean isReadOnlyAttribute(EStructuralFeature attrMetaObj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isReadOnlyAttribute", attrMetaObj);
        }
        String attrId = ((EClass)attrMetaObj.eContainer()).getInstanceClassName() + '.' + attrMetaObj.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrId", attrId);
        }
        boolean result = readOnlyAttrs.contains(attrId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isReadOnlyAttribute," + result);
        }
        return result;
    }

    static void checkUnique(EClass metaObj, List listVal, EObject newElement) throws ConfigServiceException {
        String type;
        String uniqueAttr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnique", new Object[]{metaObj, listVal, newElement});
        }
        if ((uniqueAttr = (String)uniqueAttrs.get(type = TypeRegistry.getTypeShortName(metaObj))) != null) {
            EStructuralFeature attrMetaObj = metaObj.getEStructuralFeature(uniqueAttr);
            Object uniqueAttrVal = newElement.eGet(attrMetaObj);
            for (EObject val : listVal) {
                String thisType = TypeRegistry.getTypeShortName(val.eClass());
                if (!thisType.equals(type) && !TypeRegistry.isSubType(type, thisType) || !uniqueAttrVal.equals(val.eGet(attrMetaObj))) continue;
                throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0037E", new Object[]{type, uniqueAttr, uniqueAttrVal}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnique");
        }
    }

    static {
        EMFAttribute attr;
        int i;
        tc = Tr.register(SpecialAttributeRegistry.class, "management", "com.ibm.ws.management.resources.configservice");
        readOnlyAttrs = new HashSet();
        EList attrs = CSMetadataMgr.getConfigServiceMetadata().getReadOnlyAttributes();
        for (i = 0; i < attrs.size(); ++i) {
            attr = (EMFAttribute)attrs.get(i);
            readOnlyAttrs.add(attr.getTypeName() + '.' + attr.getAttrName());
        }
        uniqueAttrs = new HashMap();
        attrs = CSMetadataMgr.getConfigServiceMetadata().getUniqueAttributes();
        for (i = 0; i < attrs.size(); ++i) {
            attr = (EMFAttribute)attrs.get(i);
            uniqueAttrs.put(TypeRegistry.getShortType(attr.getTypeName()), attr.getAttrName());
        }
    }
}

