/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServletCachingDelegator
extends ConfigServiceDelegator {
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.configservice");
    private static TraceComponent tc = Tr.register(ServletCachingDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    protected static final String WEB_CONTAINER = "WebContainer";
    protected static final String ENABLE_SERVLET_CACHING_ATTR = "enableServletCaching";

    public ServletCachingDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService);
    }

    public String getType() {
        return WEB_CONTAINER;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        block6: {
            try {
                Object val = ConfigServiceHelper.getAttributeValue(attrList, ENABLE_SERVLET_CACHING_ATTR);
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setAttributes", val);
                }
                if (val instanceof Boolean && !((Boolean)val).booleanValue()) {
                    Properties props = ConfigServiceHelper.getObjectLocation(configData);
                    String server = (String)props.get("server");
                    String node = (String)props.get("node");
                    String scope = "Node=" + node + ":Server=" + server;
                    ObjectName[] on2 = this.baseConfigService.resolve(session, scope);
                    ObjectName portletContainer = this.baseConfigService.queryConfigObjects(session, on2[0], ConfigServiceHelper.createObjectName(null, "PortletContainer"), null)[0];
                    AttributeList attrList2 = new AttributeList();
                    attrList2.add(new Attribute("enablePortletCaching", new Boolean(false)));
                    this.baseConfigService.setAttributes(session, portletContainer, attrList2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set enableServletCaching to true");
                    }
                }
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "WARNING: caught anfe while changing enablePortletCaching: " + anfe);
            }
        }
        super.setAttributes(session, configData, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }
}

