/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.model.ModelHelper;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServerDelegator
extends BaseServerDelegator {
    private static TraceComponent tc = Tr.register(ServerDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public ServerDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService);
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws InvalidConfigDataTypeException {
        AttributeList metaInfo = super.getAttributesMetaInfo(configDataType);
        AttributeList adjustPortMetaInfo = new AttributeList();
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Name", "adjustPort"));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Type", "Boolean"));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        metaInfo.add(new Attribute("adjustPort", adjustPortMetaInfo));
        return metaInfo;
    }

    public ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        try {
            ObjectName template;
            AdminCommand cmd;
            ObjectName templateCreatedON;
            boolean templateCreated;
            block21: {
                boolean genPort = true;
                try {
                    Object val = ConfigServiceHelper.getAttributeValue(attrList, "adjustPort");
                    if (val instanceof Boolean && !((Boolean)val).booleanValue()) {
                        genPort = false;
                        EndpointConfigHelper.setAdjustFlag(new Boolean(false));
                    }
                    ConfigServiceHelper.removeAttribute(attrList, "adjustPort");
                }
                catch (AttributeNotFoundException anfe) {
                    // empty catch block
                }
                templateCreated = false;
                templateCreatedON = null;
                Node node = (Node)MOFUtil.convertToEObject(session, parent);
                String nodeName = node.getName();
                CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                cmd = cmdMgr.createCommand("createApplicationServer");
                cmd.setConfigSession(session);
                cmd.setTargetObject(nodeName);
                String serverName = (String)ConfigServiceHelper.getAttributeValue(attrList, "name");
                cmd.setParameter("name", serverName);
                cmd.setParameter("genUniquePorts", new Boolean(genPort));
                String serverType = "APPLICATION_SERVER";
                template = null;
                try {
                    template = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Template");
                }
                catch (AttributeNotFoundException ex) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "No Template found");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Template: " + template);
            }
            if (template != null) {
                Properties loc = ConfigServiceHelper.getObjectLocation(template);
                String templateServerType = loc.getProperty("servertype");
                String templateServerName = loc.getProperty("server");
                String templateNodeName = loc.getProperty("node");
                Tr.debug(tc, "Location: ", new Object[]{templateServerType, templateServerName, templateNodeName});
                if (templateServerType == null || templateServerType.trim().equals("")) {
                    templateCreatedON = this.createServerTemplate(session, templateNodeName, templateServerName);
                    templateCreated = true;
                    loc = ConfigServiceHelper.getObjectLocation(templateCreatedON);
                    templateServerName = loc.getProperty("server");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Template: " + templateServerName);
                }
                if (templateServerName != null) {
                    if (templateServerName.endsWith("|server.xml")) {
                        templateServerName = templateServerName.substring(0, templateServerName.indexOf("|server.xml"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Template: " + templateServerName);
                        }
                    }
                    cmd.setParameter("templateName", templateServerName);
                }
            }
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
                Throwable th = result.getException();
                throw th;
            }
            ObjectName finishedserver = (ObjectName)result.getResult();
            this.baseConfigService.setAttributes(session, finishedserver, attrList);
            if (templateCreated) {
                this.deleteServerTemplate(session, templateCreatedON);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{finishedserver});
            }
            return finishedserver;
        }
        catch (Exception ex) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{ex});
            }
            throw new ConfigServiceException(ex);
        }
        catch (Throwable th) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{th});
            }
            throw new ConfigServiceException(th);
        }
    }

    private void deleteServerTemplate(Session session, ObjectName template) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerTemplate", new Object[]{session, template});
        }
        if (template == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteServerTemplate", new Object[]{null});
            }
            return;
        }
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = cmdMgr.createCommand("deleteServerTemplate");
            cmd.setConfigSession(session);
            cmd.setTargetObject(template);
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
                Throwable th = result.getException();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteServerTemplate", new Object[]{th});
                }
                throw new ConfigServiceException(th);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteServerTemplate");
            }
            return;
        }
        catch (Exception ex) {
            throw new ConfigServiceException(ex);
        }
    }

    private ObjectName createServerTemplate(Session session, String nodeName, String serverName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerTemplate", new Object[]{session, nodeName, serverName});
        }
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = cmdMgr.createCommand("createApplicationServerTemplate");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("serverName", serverName);
            String newTemplateName = serverName + session + System.currentTimeMillis();
            cmd.setParameter("templateName", newTemplateName);
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
                Throwable th = result.getException();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createServerTemplate", new Object[]{th});
                }
                throw new ConfigServiceException(th);
            }
            ObjectName newtemp = (ObjectName)result.getResult();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createServerTemplate", new Object[]{newtemp});
            }
            return newtemp;
        }
        catch (Exception ex) {
            throw new ConfigServiceException(ex);
        }
    }

    public ObjectName createBasicConfigObject(Session session, ObjectName parent, AttributeList attrList) throws ConfigServiceException {
        AttributeList varAttrList;
        String symbolicName;
        List entries;
        boolean create;
        ObjectName varMap;
        ObjectName[] varMaps;
        ObjectName pattern;
        ObjectName[] matches;
        String servertype = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicConfigObject", new Object[]{session, parent, attrList});
        }
        ConfigObjectDelegator.ChildTypeInfo relationshipInfo = null;
        try {
            relationshipInfo = this.getChildInfo("Server");
        }
        catch (InvalidAttributeNameException ex) {
            // empty catch block
        }
        ObjectName server = super.createConfigObject(session, parent, relationshipInfo, attrList);
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            servertype = (String)cs.getAttribute(session, server, "serverType");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ServerDelegator", (String)"999");
        }
        if (!servertype.equals("WEB_SERVER") || !servertype.equals("ADMIN_AGENT")) {
            PlatformServerConfigHelper helper = ConfigHelperFactory.getPlatformServerConfigHelper((Node)((Node)MOFUtil.convertToEObject(session, parent)));
            helper.configureServer((Server)MOFUtil.convertToEObject(session, server));
        }
        if ((matches = this.baseConfigService.queryConfigObjects(session, server, ConfigServiceHelper.createObjectName(null, "AdminService"), null)).length > 0) {
            ObjectName adminService = matches[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminService", adminService);
            }
            Properties location = ConfigServiceHelper.getObjectLocation(parent);
            String cellName = location.getProperty("cell");
            ObjectName cell = this.baseConfigService.resolve(session, "Cell=" + cellName)[0];
            boolean standAlone = "STANDALONE".equals(this.baseConfigService.getAttribute(session, cell, "cellType"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "standAlone," + standAlone);
            }
            AttributeList standAloneAttrList = new AttributeList();
            standAloneAttrList.add(new Attribute("standalone", new Boolean(standAlone)));
            this.baseConfigService.setAttributes(session, adminService, standAloneAttrList);
        }
        String serverName = ConfigServiceHelper.getDisplayName(server);
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "VariableMap");
            varMaps = this.baseConfigService.queryConfigObjects(session, server, pattern, null);
            if (varMaps.length == 0) {
                varMap = this.baseConfigService.createConfigData(session, server, "VariableMap", "VariableMap", new AttributeList());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new varMap = ", varMap);
                }
            } else {
                varMap = varMaps[0];
            }
            create = true;
            entries = (List)this.baseConfigService.getAttribute(session, varMap, "entries");
            for (AttributeList entry : entries) {
                try {
                    symbolicName = (String)ConfigServiceHelper.getAttributeValue(entry, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "symbolicName = ", symbolicName);
                    }
                    if (!symbolicName.equals("SERVER_LOG_ROOT")) continue;
                    ConfigServiceHelper.setAttributeValue(entry, "value", "${LOG_ROOT}/" + serverName);
                    this.baseConfigService.setAttributes(session, ConfigServiceHelper.createObjectName(entry), entry);
                    create = false;
                    break;
                }
                catch (AttributeNotFoundException ex) {
                }
            }
            if (create) {
                varAttrList = new AttributeList();
                varAttrList.add(new Attribute("symbolicName", "SERVER_LOG_ROOT"));
                varAttrList.add(new Attribute("value", "${LOG_ROOT}/" + serverName));
                varAttrList.add(new Attribute("description", "The log root directory for server " + serverName + "."));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "varAttrList = ", varAttrList);
                }
                this.baseConfigService.createConfigData(session, varMap, "entries", "VariableSubstitutionEntry", varAttrList);
            }
        }
        catch (ConfigServiceException ex) {
            Tr.warning(tc, "ADMG0025W", new Object[]{serverName, ex});
        }
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "VariableMap");
            varMaps = this.baseConfigService.queryConfigObjects(session, server, pattern, null);
            if (varMaps.length == 0) {
                varMap = this.baseConfigService.createConfigData(session, server, "VariableMap", "VariableMap", new AttributeList());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new varMap = ", varMap);
                }
            } else {
                varMap = varMaps[0];
            }
            create = true;
            entries = (List)this.baseConfigService.getAttribute(session, varMap, "entries");
            for (AttributeList entry : entries) {
                try {
                    symbolicName = (String)ConfigServiceHelper.getAttributeValue(entry, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "symbolicName = ", symbolicName);
                    }
                    if (!symbolicName.equals("WAS_SERVER_NAME")) continue;
                    ConfigServiceHelper.setAttributeValue(entry, "value", serverName);
                    this.baseConfigService.setAttributes(session, ConfigServiceHelper.createObjectName(entry), entry);
                    create = false;
                    break;
                }
                catch (AttributeNotFoundException ex) {
                }
            }
            if (create) {
                varAttrList = new AttributeList();
                varAttrList.add(new Attribute("symbolicName", "WAS_SERVER_NAME"));
                varAttrList.add(new Attribute("value", serverName));
                varAttrList.add(new Attribute("description", "Name of the application server."));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "varAttrList = ", varAttrList);
                }
                this.baseConfigService.createConfigData(session, varMap, "entries", "VariableSubstitutionEntry", varAttrList);
            }
        }
        catch (ConfigServiceException ex) {
            Tr.warning(tc, "ADMG0025W", new Object[]{serverName, ex});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicConfigObject", server);
        }
        return server;
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        try {
            Properties props = ConfigServiceHelper.getObjectLocation(configData);
            String nodeName = props.getProperty("node");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Name: " + nodeName);
            }
            String serverName = props.getProperty("server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server Name: " + serverName);
            }
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = cmdMgr.createCommand("deleteServer");
            cmd.setConfigSession(session);
            cmd.setParameter("nodeName", nodeName);
            cmd.setParameter("serverName", serverName);
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
                Throwable th = result.getException();
                throw th;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", new Object[0]);
            }
            return;
        }
        catch (Exception ex) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", new Object[]{ex});
            }
            throw new ConfigServiceException(ex);
        }
        catch (Throwable th) {
            th.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", new Object[]{th});
            }
            throw new ConfigServiceException(th);
        }
    }

    public void deleteBasicConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        ObjectName[] matches;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBasicConfigData", new Object[]{session, configData});
        }
        ConfigDataId serverId = ConfigServiceHelper.getConfigDataId(configData);
        RepositoryContext context = WorkspaceHelper.getContext(session, serverId);
        String serverName = ConfigServiceHelper.getDisplayName(configData);
        String nodeName = ConfigServiceHelper.getObjectLocation(configData).getProperty("node");
        String clusterName = (String)this.baseConfigService.getAttribute(session, configData, "clusterName");
        try {
            AppManagement appmgr = this.baseConfigService.getAppManagement();
            ObjectName server = ConfigServiceHelper.createObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(configData));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server", server);
            }
            Hashtable<String, Object> pref = new Hashtable<String, Object>();
            Object locale = this.baseConfigService.getSessionProperty(session, "LOCALE");
            if (locale != null) {
                pref.put("app.client.locale", locale);
            }
            appmgr.removeAllAppsFromServer(server, pref, session.toString());
            ModelHelper fact = ModelHelper.getSingleton();
            fact.removeAppServerFromCUs(server, session.toString());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ServerDelegator", (String)"78", (Object)this);
            throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", new Object[]{ex}, null));
        }
        if (clusterName != null && clusterName.length() >= 0 && (matches = this.baseConfigService.resolve(session, "ServerCluster=" + clusterName)).length > 0) {
            ObjectName cluster = matches[0];
            AttributeList attrList = this.baseConfigService.getAttributes(session, cluster, new String[]{"members"}, false);
            List members = (List)((Attribute)attrList.get(0)).getValue();
            for (ObjectName member : members) {
                if (!this.baseConfigService.getAttribute(session, member, "memberName").equals(serverName) || !this.baseConfigService.getAttribute(session, member, "nodeName").equals(nodeName)) continue;
                this.baseConfigService.deleteConfigDataBasic(session, member);
            }
        }
        super.deleteConfigData(session, configData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBasicConfigData");
        }
    }
}

