/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.model.ModelHelper;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.management.util.PlatformClusterMemberConfigHelper;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerClusterDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(ServerClusterDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public ServerClusterDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("clusters"));
    }

    public ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        ObjectName obj = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        try {
            try {
                Object val = ConfigServiceHelper.getAttributeValue(attrList, "adjustPort");
                ConfigServiceHelper.removeAttribute(attrList, "adjustPort");
            }
            catch (AttributeNotFoundException ex) {
                // empty catch block
            }
            obj = super.createConfigObject(session, parent, relationshipInfo, attrList);
            String cName = (String)ConfigServiceHelper.getAttributeValue(attrList, "name");
            ClusterConfigHelper.addDefaultResources(this.baseConfigService, session, cName);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "VariableMap");
            ObjectName[] varMaps = this.baseConfigService.queryConfigObjects(session, obj, pattern, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Var maps = ", varMaps);
            }
            if (varMaps == null || varMaps.length == 0) {
                ObjectName varMap = this.baseConfigService.createConfigDataByTemplate(session, obj, "VariableMap", new AttributeList(), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new varMap = ", varMap);
                }
            }
        }
        catch (Exception ex) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{ex});
            }
            throw new ConfigServiceException(ex);
        }
        catch (Throwable th) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{th});
            }
            throw new ConfigServiceException(th);
        }
        return obj;
    }

    public ObjectName createConfigData(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        String nodeName = null;
        try {
            nodeName = (String)ConfigServiceHelper.getAttributeValue(attrList, "nodeName");
        }
        catch (Exception e) {
            // empty catch block
        }
        ObjectName result = super.createConfigData(session, parent, attributeName, attrList);
        if (attributeName.equals("members")) {
            this.clusterMemberCreated(session, parent, -1);
        }
        return result;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        try {
            ConfigServiceHelper.getAttributeValue(attrList, "members");
            throw new UnsupportedOperationException("can not reset cluster member");
        }
        catch (AttributeNotFoundException ex) {
            super.setAttributes(session, configData, attrList);
            return;
        }
    }

    public void resetAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        try {
            ConfigServiceHelper.getAttributeValue(attrList, "members");
            throw new UnsupportedOperationException("can not reset cluster member");
        }
        catch (AttributeNotFoundException ex) {
            super.setAttributes(session, configData, attrList);
            return;
        }
    }

    public void addElement(Session session, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException {
        super.addElement(session, configData, attribute, element, position);
        this.clusterMemberCreated(session, configData, position);
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        String clusterName = null;
        try {
            AppManagement appmgr = this.baseConfigService.getAppManagement();
            ObjectName cl = ConfigServiceHelper.createObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(configData));
            Properties p = ConfigServiceHelper.getObjectLocation(configData);
            clusterName = p.getProperty("cluster");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster = " + cl + " and clusterName = " + clusterName);
            }
            Hashtable<String, Object> pref = new Hashtable<String, Object>();
            Object locale = this.baseConfigService.getSessionProperty(session, "LOCALE");
            if (locale != null) {
                pref.put("app.client.locale", locale);
            }
            appmgr.removeAllAppsFromCluster(cl, pref, session.toString());
            ModelHelper fact = ModelHelper.getSingleton();
            fact.removeClusterFromCUs(cl, session.toString());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.ServerClusterDelegator", (String)"48", (Object)this);
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", new Object[]{ex}, null));
        }
        AttributeList attrList = this.baseConfigService.getAttributes(session, configData, new String[]{"members"}, false);
        List members = (List)((Attribute)attrList.get(0)).getValue();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            this.baseConfigService.deleteConfigData(session, (ObjectName)iter.next());
        }
        super.deleteConfigData(session, configData);
        try {
            RepositoryContext clusterContext = ServerClusterDelegator.getClusterTemplateContext(clusterName, session);
            if (clusterContext != null) {
                clusterContext.delete(true);
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", "Cannot get cluster template context");
            }
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    protected static RepositoryContext findContext(RepositoryContext parent, String typeName, String name) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findContext", new Object[]{parent, typeName, name});
        }
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType type = metadata2.getContextType(typeName);
        RepositoryContext child = parent.getChild(type, name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findContext", child);
        }
        return child;
    }

    protected static RepositoryContext getClusterTemplateContext(String clusterName, Session session) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterContext", clusterName);
        }
        WorkSpace ws = null;
        try {
            ws = WorkspaceHelper.getWorkspace(session);
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot get workspace");
            }
            throw new ClusterConfigException(e, e.getMessage());
        }
        TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)ws);
        RepositoryContext templateContext = null;
        try {
            templateContext = templateMan.getRootTemplateContext();
        }
        catch (WorkSpaceException we) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find template context");
            }
            throw new ClusterConfigException(we, we.getMessage());
        }
        if (templateContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "template context is null");
            }
            throw new ClusterConfigException("template context is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found template context ", templateContext);
        }
        RepositoryContext clusterContext = null;
        try {
            clusterContext = ServerClusterDelegator.findContext(templateContext, "clusters", clusterName);
        }
        catch (Throwable t) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find cluster template context");
            }
            throw new ClusterConfigException(t, t.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterContext", clusterName);
        }
        return clusterContext;
    }

    private void clusterMemberCreated(Session session, ObjectName cl, int position) throws ConfigServiceException {
        PlatformClusterMemberConfigHelper helper;
        List members = (List)this.baseConfigService.getAttribute(session, cl, "members");
        int numOfMem = members.size();
        if (position == -1) {
            position = numOfMem - 1;
        }
        AttributeList memberAttrList = (AttributeList)members.get(position);
        ObjectName member = ConfigServiceHelper.createObjectName(memberAttrList);
        StringBuffer pattern = new StringBuffer();
        String nodeName = null;
        try {
            nodeName = (String)ConfigServiceHelper.getAttributeValue(memberAttrList, "nodeName");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (nodeName != null) {
            pattern.append("Node=").append(nodeName).append(":");
        }
        String serverName = null;
        try {
            serverName = (String)ConfigServiceHelper.getAttributeValue(memberAttrList, "memberName");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (serverName != null) {
            pattern.append("Server=").append(serverName);
        }
        ObjectName server = this.baseConfigService.resolve(session, pattern.toString())[0];
        Server s = (Server)MOFUtil.convertToEObject(session, server);
        RepositoryContext nodeContext = null;
        RepositoryContext serverContext = ((ContextResourceSet)s.eResource().getResourceSet()).getContext();
        nodeContext = serverContext.getParent();
        ObjectName nodeObjectName = this.baseConfigService.resolve(session, "Node=" + nodeContext.getName())[0];
        Node node = (Node)MOFUtil.convertToEObject(session, nodeObjectName);
        if (numOfMem == 1) {
            try {
                String nodeGroupName = (String)this.baseConfigService.getAttribute(session, cl, "nodeGroupName");
                if (nodeGroupName == null || nodeGroupName.length() <= 0) {
                    String[] nodeGroups = NodeGroupHelper.listNodeGroups(session, this.baseConfigService, nodeName);
                    if (nodeGroups != null && nodeGroups.length > 0) {
                        String nodeGroup = nodeGroups[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeGroup", nodeGroup);
                        }
                        if (nodeGroup != null && nodeGroup.length() > 0) {
                            AttributeList list = new AttributeList();
                            ConfigServiceHelper.setAttributeValue(list, "nodeGroupName", nodeGroup);
                            this.baseConfigService.setAttributes(session, cl, list);
                        }
                    } else {
                        String memberNodeVersion = ClusterConfigHelper.getMemberNodeVersion(this.baseConfigService, session, nodeName);
                        if (!memberNodeVersion.equals("5")) {
                            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0447E", new Object[]{nodeName}, null));
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", new Object[]{ex}, null));
            }
            helper = ConfigHelperFactory.getPlatformClusterConfigHelper((Node)node);
            ServerCluster cluster = (ServerCluster)MOFUtil.convertToEObject(session, cl);
            helper.configureServerClusterFromServer(cluster, s);
        }
        helper = ConfigHelperFactory.getPlatformClusterMemberConfigHelper((Node)node);
        ClusterMember m = (ClusterMember)MOFUtil.convertToEObject(session, member);
        helper.configureClusterMember(m, s);
        if (nodeContext != null) {
            String clusterName = (String)this.baseConfigService.getAttribute(session, cl, "name");
            this.saveClusterConfig(nodeContext.getParent(), clusterName);
        }
    }

    private void saveClusterConfig(RepositoryContext cellContext, String clusterName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveClusterConfig", new Object[]{cellContext, clusterName});
        }
        try {
            Collection clusterCollection = cellContext.findContext("clusters", clusterName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterCollection", new Object[]{clusterCollection});
            }
            RepositoryContext clusterCtx = (RepositoryContext)clusterCollection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterCtx", new Object[]{clusterCtx});
            }
            URI uri = URI.createURI("cluster.xml");
            Resource resource = clusterCtx.getResourceSet().getResource(uri, true);
            resource.save(new HashMap());
        }
        catch (Exception e) {
            Tr.error(tc, "Error occured during save");
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0004E", new Object[]{e}, null));
        }
    }
}

