/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SecurityDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(SecurityDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public SecurityDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, "Security", RepositoryMetaDataFactory.getRepositoryMetaData().getDocumentType("Security"));
    }

    public ObjectName createConfigData(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        if ("authDataEntries".equals(attributeName)) {
            this.checkDuplicateAlias(session, parent, attrList);
        }
        return super.createConfigData(session, parent, attributeName, attrList);
    }

    public void addElement(Session session, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException {
        if ("authDataEntries".equals(attribute) && element instanceof AttributeList) {
            this.checkDuplicateAlias(session, configData, (AttributeList)element);
        }
        super.addElement(session, configData, attribute, element, position);
    }

    private void checkDuplicateAlias(Session session, ObjectName parent, AttributeList attrList) throws ConfigServiceException {
        String userId;
        String alias;
        boolean duplicate;
        block4: {
            duplicate = false;
            alias = null;
            userId = null;
            try {
                alias = (String)ConfigServiceHelper.getAttributeValue(attrList, "alias");
                userId = (String)ConfigServiceHelper.getAttributeValue(attrList, "userId");
                if (alias == null || userId == null) break block4;
                List authDataEntries = (List)this.baseConfigService.getAttribute(session, parent, "authDataEntries");
                for (AttributeList authData : authDataEntries) {
                    if (!alias.equals(ConfigServiceHelper.getAttributeValue(authData, "alias"))) continue;
                    duplicate = true;
                    break;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.JAASAuthDataDelegator.createConfigData", (String)"58", (Object)this);
            }
        }
        if (duplicate) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0032E", new Object[]{alias, userId}, null);
            throw new ConfigServiceException(msg);
        }
    }
}

