/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class SecureSocketLayerDelegator
extends ConfigServiceDelegator {
    private static TraceComponent tc = Tr.register(SecureSocketLayerDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final String KEY_FILE_FORMAT = "keyFileFormat";
    private static final String TRUST_FILE_FORMAT = "trustFileFormat";
    private static final String KEY_FILE_PROP = "com.ibm.ssl.keyStoreType";
    private static final String TRUST_FILE_PROP = "com.ibm.ssl.trustStoreType";
    private static final String KEY_FILE_FORMAT_VALUE = "JCE4758RACFKS";
    private static final String TRUST_FILE_FORMAT_VALUE = "JCE4758RACFKS";

    public SecureSocketLayerDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService);
    }

    public String getType() {
        return "SecureSocketLayer";
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, configData, attrList});
        }
        ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
        DocAccessor accessor = WorkspaceHelper.getDocAccessor(session, id);
        boolean chgKeyFile = false;
        boolean chgTrustFile = false;
        boolean keyFileFound = false;
        boolean trustFileFound = false;
        boolean found = false;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute a;
            if (found) {
                --i;
                found = false;
            }
            if (KEY_FILE_FORMAT.equals((a = (Attribute)attrList.get(i)).getName())) {
                chgKeyFile = true;
                if ("JCE4758RACFKS".equals(a.getValue())) {
                    attrList.remove(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "JCE4758RACFKS removed from SecureSocketLayer Attribute List");
                    }
                    keyFileFound = true;
                    found = true;
                }
            }
            if (!TRUST_FILE_FORMAT.equals(a.getName())) continue;
            chgTrustFile = true;
            if (!"JCE4758RACFKS".equals(a.getValue())) continue;
            attrList.remove(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JCE4758RACFKS removed from SecureSocketLayer Attribute List");
            }
            trustFileFound = true;
            found = true;
        }
        AttributeList confProps = super.getAttributes(session, configData, new String[]{"properties"}, false);
        List props = (List)((Attribute)confProps.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)this.baseConfigService.getAttribute(session, property, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property is: " + propName);
            }
            if (chgKeyFile && propName.equals(KEY_FILE_PROP)) {
                this.baseConfigService.deleteConfigData(session, property);
            }
            if (!chgTrustFile || !propName.equals(TRUST_FILE_PROP)) continue;
            this.baseConfigService.deleteConfigData(session, property);
        }
        try {
            try {
                ObjectName p;
                EObject newObj = accessor.lookup(id);
                ObjectName result = MOFUtil.createObjectName(newObj);
                AttributeList aList = new AttributeList();
                if (keyFileFound) {
                    ConfigServiceHelper.setAttributeValue(aList, "name", KEY_FILE_PROP);
                    ConfigServiceHelper.setAttributeValue(aList, "value", "JCE4758RACFKS");
                    p = this.baseConfigService.createConfigData(session, result, "properties", "Property", aList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New property created for JCE4758RACFKS-KeyStore");
                    }
                }
                if (trustFileFound) {
                    ConfigServiceHelper.setAttributeValue(aList, "name", TRUST_FILE_PROP);
                    ConfigServiceHelper.setAttributeValue(aList, "value", "JCE4758RACFKS");
                    p = this.baseConfigService.createConfigData(session, result, "properties", "Property", aList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New property created for JCE4758RACFKS-trustStore");
                    }
                }
                accessor.setAttributes(session, id, attrList);
                accessor.localSave();
            }
            catch (Exception ex) {
                throw new ConfigServiceException(ex, "unexpected exception trying to create new repertoire custom property during object modification");
            }
            Object var18_19 = null;
            accessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            accessor.cleanup();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)});
        }
        boolean keyFileFormatPropExist = false;
        boolean trustFileFormatPropExist = false;
        AttributeList confProps = super.getAttributes(session, configData, new String[]{"properties"}, false);
        List props = (List)((Attribute)confProps.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)super.getAttribute(session, property, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property is: " + propName);
            }
            if (propName.equals(KEY_FILE_PROP)) {
                keyFileFormatPropExist = true;
            }
            if (!propName.equals(TRUST_FILE_PROP)) continue;
            trustFileFormatPropExist = true;
        }
        AttributeList result = super.getAttributes(session, configData, attributes, recursive);
        boolean removeKeyFileProp = false;
        boolean removeTrustFileProp = false;
        for (int i = 0; i < result.size(); ++i) {
            Attribute a = (Attribute)result.get(i);
            if (KEY_FILE_FORMAT.equals(a.getName()) && keyFileFormatPropExist) {
                result.remove(i);
                result.add(new Attribute(KEY_FILE_FORMAT, "JCE4758RACFKS"));
                removeKeyFileProp = true;
            }
            if (TRUST_FILE_FORMAT.equals(a.getName()) && trustFileFormatPropExist) {
                result.remove(i);
                result.add(new Attribute(TRUST_FILE_FORMAT, "JCE4758RACFKS"));
                removeTrustFileProp = true;
            }
            if (KEY_FILE_PROP.equals(a.getName()) && removeKeyFileProp) {
                result.remove(i);
                removeKeyFileProp = false;
            }
            if (!TRUST_FILE_PROP.equals(a.getName()) || !removeTrustFileProp) continue;
            result.remove(i);
            removeTrustFileProp = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, configData, attribute});
        }
        boolean keyFileFormatPropExist = false;
        boolean trustFileFormatPropExist = false;
        AttributeList confProps = super.getAttributes(session, configData, new String[]{"properties"}, false);
        List props = (List)((Attribute)confProps.get(0)).getValue();
        for (ObjectName property : props) {
            String propName = (String)super.getAttribute(session, property, "name");
            String propValue = (String)super.getAttribute(session, property, "value");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property is: " + propName + " with value " + propValue);
            }
            if (propName.equals(KEY_FILE_PROP)) {
                keyFileFormatPropExist = true;
                String string = propValue;
            }
            if (!propName.equals(TRUST_FILE_PROP)) continue;
            trustFileFormatPropExist = true;
            String string = propValue;
        }
        Object result = keyFileFormatPropExist ? "JCE4758RACFKS" : (trustFileFormatPropExist ? "JCE4758RACFKS" : super.getAttribute(session, configData, attribute));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }
}

