/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.tasks.InstallRARTask;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ResourceProviderDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(ResourceProviderDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    protected static final String ARCHIVE_PATH = "archivePath";
    protected static final String NATIVE_PATH = "nativePath";
    protected static final String ISOLATED_CLASS_LOADER = "isolatedClassLoader";

    public ResourceProviderDelegator(ConfigServiceImpl baseConfigService, String type, RepositoryDocumentType documentType) {
        super(baseConfigService, type, documentType);
    }

    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        String type = WorkspaceHelper.getType(session, parent);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type", type);
        }
        if (type.equals("ServerCluster") && WorkspaceHelper.containVersion5Memeber(session, parent)) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0500E", new Object[]{parent}, null);
            throw new ConfigServiceException(msg);
        }
        if (type.equals("Deployment") && WorkspaceHelper.containVersion5DeploymentTarget(session, parent)) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0501E", new Object[]{parent}, null);
            throw new ConfigServiceException(msg);
        }
        String ctype = relationshipInfo.getRelationshipName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "child type", ctype);
        }
        if (ctype.equals("J2CResourceAdapter")) {
            String apath = null;
            String npath = null;
            ObjectName template = null;
            boolean createWithTemplate = true;
            try {
                template = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Template");
                apath = (String)this.baseConfigService.getAttribute(session, template, ARCHIVE_PATH);
                npath = (String)this.baseConfigService.getAttribute(session, template, NATIVE_PATH);
            }
            catch (AttributeNotFoundException e) {
                createWithTemplate = false;
            }
            catch (Throwable th) {
                createWithTemplate = false;
            }
            if (createWithTemplate) {
                this.checkIsolatedClassLoader(session, parent, attrList, apath, npath);
            }
        }
        ObjectName result = super.createConfigObject(session, parent, relationshipInfo, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", result);
        }
        return result;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        String type = WorkspaceHelper.getType(session, configData);
        if (type.equals("J2CResourceAdapter")) {
            String apath = null;
            String npath = null;
            try {
                apath = (String)this.baseConfigService.getAttribute(session, configData, ARCHIVE_PATH);
                npath = (String)this.baseConfigService.getAttribute(session, configData, NATIVE_PATH);
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (apath != null) {
                    this.checkIsolatedClassLoader(session, configData, attrList, apath, npath);
                }
            }
            catch (ConfigServiceException e) {
                throw e;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        super.setAttributes(session, configData, attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    private void checkIsolatedClassLoader(Session session, ObjectName configData, AttributeList attrList, String aPath, String nPath) throws ConfigServiceException {
        Object val;
        block16: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archivePath " + aPath + " npath = " + nPath);
            }
            val = null;
            try {
                val = ConfigServiceHelper.getAttributeValue(attrList, ISOLATED_CLASS_LOADER);
            }
            catch (AttributeNotFoundException anfe) {
                val = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isolatedClassLoader setAttributes", val);
            }
            String archivePath = null;
            try {
                archivePath = (String)ConfigServiceHelper.getAttributeValue(attrList, ARCHIVE_PATH);
            }
            catch (Throwable th) {
                archivePath = null;
            }
            if (archivePath == null) {
                archivePath = aPath;
            }
            if (val instanceof Boolean && ((Boolean)val).booleanValue()) {
                String nativePath = null;
                try {
                    nativePath = (String)ConfigServiceHelper.getAttributeValue(attrList, NATIVE_PATH);
                }
                catch (AttributeNotFoundException e) {
                    nativePath = null;
                }
                if (nativePath != null) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0305E", new Object[]{archivePath}, null);
                    throw new ConfigServiceException(msg);
                }
                nativePath = nPath;
                if (nativePath != null) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0305E", new Object[]{archivePath}, null);
                    throw new ConfigServiceException(msg);
                }
            }
            try {
                ObjectName scope = this.createScopeObject(session, this.baseConfigService, configData);
                Boolean exist = InstallRARTask.isJ2CRAExist(session, this.baseConfigService, archivePath, (Boolean)val, scope, configData);
            }
            catch (ConfigServiceException e) {
                throw e;
            }
            catch (Throwable e) {
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Unexpected exception in delegator of Resource Provider " + e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set isolatedClassLoader to " + val);
        }
    }

    private ObjectName createScopeObject(Session session, ConfigService configService, ObjectName configData) {
        Properties props = ConfigServiceHelper.getObjectLocation(configData);
        String cell = (String)props.get("cell");
        String server = (String)props.get("server");
        String node = (String)props.get("node");
        String cluster = (String)props.get("cluster");
        ObjectName obj = null;
        String str = null;
        if (cell != null) {
            str = "Cell=" + cell + ":";
        }
        if (node != null) {
            str = str + "Node=" + node + ":";
            if (server != null) {
                str = str + "Server=" + server;
            }
        } else if (cluster != null) {
            str = str + "ServerCluster=" + cluster;
        }
        if (str != null) {
            ObjectName[] matches = null;
            try {
                matches = configService.resolve(session, str);
            }
            catch (ConfigServiceException e) {
                FFDCFilter.processException((Throwable)new Throwable().fillInStackTrace(), (String)"com.ibm.ws.management.configservice.ResoucrProviderDelregator", (String)"183", (Object)this);
            }
            catch (ConnectorException e) {
                FFDCFilter.processException((Throwable)new Throwable().fillInStackTrace(), (String)"com.ibm.ws.management.configservice.ResoucrProviderDelregator", (String)"185", (Object)this);
            }
            if (matches.length == 0) {
                FFDCFilter.processException((Throwable)new Throwable().fillInStackTrace(), (String)"com.ibm.ws.management.configservice.ResoucrProviderDelregator", (String)"190", (Object)this);
            } else {
                obj = matches[0];
            }
        }
        return obj;
    }
}

