/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeDelegator
extends RootObjectDelegator {
    private static final String HOST_NAME = "hostName";
    private static final String HOST_NAME_TYPE = "String";
    private static TraceComponent tc = Tr.register(NodeDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public NodeDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes"));
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws InvalidConfigDataTypeException {
        AttributeList metaInfo = super.getAttributesMetaInfo(configDataType);
        AttributeList hostNameMetaInfo = new AttributeList();
        hostNameMetaInfo.add(new Attribute("_Attribute_MetaInfo_Name", HOST_NAME));
        hostNameMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        hostNameMetaInfo.add(new Attribute("_Attribute_MetaInfo_Type", HOST_NAME_TYPE));
        hostNameMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.FALSE));
        hostNameMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        metaInfo.add(new Attribute(HOST_NAME, hostNameMetaInfo));
        return metaInfo;
    }

    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        if (System.getProperties().get("ConfigService.TestMode") == null) {
            String msg = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configservice", "ADMG0023W");
            throw new UnsupportedOperationException(msg);
        }
        attrList = (AttributeList)attrList.clone();
        String hostName = this.removeHostNameAttr(attrList);
        ObjectName node = super.createConfigObject(session, parent, relationshipInfo, attrList);
        this.setHostName(session, node, hostName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", node);
        }
        return node;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, configData, attrList});
        }
        attrList = (AttributeList)attrList.clone();
        String hostName = this.removeHostNameAttr(attrList);
        super.setAttributes(session, configData, attrList);
        this.setHostName(session, configData, hostName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void unsetAttributes(Session session, ObjectName configData, String[] attributes) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, configData, attributes});
        }
        ArrayList<String> attrs = new ArrayList<String>(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].equals(HOST_NAME)) {
                this.setHostName(session, configData, null);
                continue;
            }
            attrs.add(attributes[i]);
        }
        String[] restAttrs = new String[attrs.size()];
        attrs.toArray(restAttrs);
        super.unsetAttributes(session, configData, restAttrs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, configData, attrList});
        }
        attrList = (AttributeList)attrList.clone();
        String hostName = this.removeHostNameAttr(attrList);
        super.resetAttributes(session, configData, attrList);
        this.setHostName(session, configData, hostName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)});
        }
        boolean hostNameNeeded = false;
        if (attributes == null) {
            hostNameNeeded = true;
        } else {
            ArrayList<String> attrs = new ArrayList<String>(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].equals(HOST_NAME)) {
                    hostNameNeeded = true;
                    continue;
                }
                attrs.add(attributes[i]);
            }
            attributes = new String[attrs.size()];
            attrs.toArray(attributes);
        }
        AttributeList result = super.getAttributes(session, configData, attributes, recursive);
        if (hostNameNeeded) {
            Object hostNameVal = this.getHostName(session, configData);
            result.add(new Attribute(HOST_NAME, hostNameVal));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, configData, attribute});
        }
        Object result = HOST_NAME.equals(attribute) ? this.getHostName(session, configData) : super.getAttribute(session, configData, attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHostName(Session session, ObjectName node, String hostName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHostName", new Object[]{session, node, hostName});
        }
        if (hostName == null || hostName.length() == 0) {
            return;
        }
        ConfigDataId nodeId = ConfigServiceHelper.getConfigDataId(node);
        RepositoryContext context = WorkspaceHelper.getContext(session, nodeId);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context, "serverindex.xml");
        Resource res = docAccessor.getResource();
        try {
            Resource resource = res;
            synchronized (resource) {
                EList ext = res.getContents();
                if (ext.size() == 0) {
                    ext.add(MOFUtil.newInstance(TypeRegistry.getMetaObject("ServerIndex")));
                }
                ServerIndex serverIndex = (ServerIndex)ext.get(0);
                serverIndex.setHostName(hostName);
                docAccessor.localSave();
            }
            Object var13_12 = null;
            docAccessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            docAccessor.cleanup();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHostName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getHostName(Session session, ObjectName node) throws ConfigServiceException {
        Resource res;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName", new Object[]{session, node});
        }
        String result = null;
        ConfigDataId nodeId = ConfigServiceHelper.getConfigDataId(node);
        RepositoryContext context = WorkspaceHelper.getContext(session, nodeId);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context, "serverindex.xml");
        Resource resource = res = docAccessor.getResource();
        synchronized (resource) {
            EList ext = res.getContents();
            if (ext.size() != 0) {
                ServerIndex serverIndex = (ServerIndex)ext.get(0);
                result = serverIndex.getHostName();
            }
        }
        return result;
    }

    private String removeHostNameAttr(AttributeList attrList) throws InvalidAttributeValException {
        String hostName = null;
        try {
            Object val = ConfigServiceHelper.getAttributeValue(attrList, HOST_NAME);
            if (val != null && !(val instanceof String)) {
                throw new InvalidAttributeValException(HOST_NAME);
            }
            hostName = (String)val;
            ConfigServiceHelper.removeAttribute(attrList, HOST_NAME);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return hostName;
    }
}

