/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.ConfigTimeLineDataBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MetadataFilter {
    private List pkgs;
    private static TraceComponent tc = Tr.register(MetadataFilter.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final MetadataFilter instance = new MetadataFilter();
    private static ConfigTimeLineDataBase ctldb = null;

    private MetadataFilter() {
    }

    protected static boolean isValidType(EClass type, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidType", new Object[]{type, nodeProps});
        }
        String typName = MetadataFilter.getShortType(type.getInstanceClassName());
        String pkgName = type.getEPackage().getName();
        boolean result = ctldb.isPackageValid(nodeProps, pkgName);
        if (result) {
            result &= ctldb.isTypeValid(nodeProps, pkgName, typName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidType", new Boolean(result));
        }
        return result;
    }

    protected static List filterAttrs(EClass typ, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterAttrs", new Object[]{typ, nodeProps});
        }
        ArrayList<EAttribute> retAttrs = new ArrayList<EAttribute>();
        ArrayList attrs = new ArrayList(typ.getEAllAttributes());
        ArrayList<EClass> types = new ArrayList<EClass>(typ.getEAllSuperTypes());
        types.add(typ);
        for (EClass type : types) {
            String pkgName = type.getEPackage().getName();
            String className = MetadataFilter.getShortType(type.getInstanceClassName());
            Iterator itr1 = attrs.iterator();
            while (itr1.hasNext()) {
                EAttribute attr = (EAttribute)itr1.next();
                if (!instance.localAttr(type, attr.getName()) || !MetadataFilter.isValidAttribute(pkgName, className, attr.getName(), nodeProps)) continue;
                retAttrs.add(attr);
                itr1.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterAttrs", retAttrs);
        }
        return retAttrs;
    }

    protected static void filterSubTypes(EClass parentType, List subTypes, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterSubTypes", new Object[]{parentType, subTypes, nodeProps});
        }
        Iterator itr = subTypes.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof EClass)) continue;
            EClass subType = (EClass)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Class: " + subType);
            }
            if (!MetadataFilter.isValidType(subType.getEPackage().getName(), MetadataFilter.getShortType(subType.getInstanceClassName()), nodeProps)) continue;
            itr.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterSubTypes");
        }
    }

    protected static boolean isSubType(EClass parentType, EClass subType, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSubType", new Object[]{parentType, subType, nodeProps});
        }
        if (!MetadataFilter.isValidType(subType.getEPackage().getName(), MetadataFilter.getShortType(subType.getInstanceClassName()), nodeProps)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSubType", new Boolean(false));
            }
            return false;
        }
        if (!MetadataFilter.isValidType(parentType.getEPackage().getName(), MetadataFilter.getShortType(parentType.getInstanceClassName()), nodeProps)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSubType", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSubType", new Boolean(true));
        }
        return true;
    }

    protected static void filterAllTypes(Set typs, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterAllTypes", new Object[]{typs, nodeProps});
        }
        Iterator itr = typs.iterator();
        while (itr.hasNext()) {
            EClass typ;
            Object obj = itr.next();
            if (!(obj instanceof EClass) || MetadataFilter.isValidType((typ = (EClass)obj).getEPackage().getName(), MetadataFilter.getShortType(typ.getInstanceClassName()), nodeProps)) continue;
            itr.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterAllTypes");
        }
    }

    protected static void filterAttributes(List attrs, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterAttributes", new Object[]{attrs, nodeProps});
        }
        if (nodeProps == null) {
            return;
        }
        Iterator itr = attrs.iterator();
        while (itr.hasNext()) {
            String className;
            EAttribute attr = (EAttribute)itr.next();
            EDataType dtyp = attr.getEAttributeType();
            String pkgName = dtyp.getEPackage().getName();
            if (MetadataFilter.isValidAttribute(pkgName, className = MetadataFilter.getShortType(dtyp.getInstanceClassName()), attr.getName(), nodeProps)) continue;
            itr.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterAttributes");
        }
    }

    protected static boolean isValidAttr(EStructuralFeature feature, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidAttr", new Object[]{feature, nodeProps});
        }
        boolean result = true;
        String className = MetadataFilter.getShortType(feature.getEContainingClass().getInstanceClassName());
        String pkgName = feature.getEContainingClass().getEPackage().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "className", className);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pkgName", pkgName);
        }
        if (!MetadataFilter.isValidAttribute(pkgName, className, feature.getName(), nodeProps)) {
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidAttr", new Boolean(result));
        }
        return result;
    }

    protected static String[] getValidRanges(EStructuralFeature feature, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidRanges", new Object[]{feature, nodeProps});
        }
        String[] result = null;
        String className = MetadataFilter.getShortType(feature.getEContainingClass().getInstanceClassName());
        String pkgName = feature.getEContainingClass().getEPackage().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "className", className);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pkgName", pkgName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValidRanges", result);
        }
        return result;
    }

    private static boolean strippedPkgNameEqual(String pkgName, String newPkgName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "strippedPkgNameEqual", new Object[]{pkgName, newPkgName});
        }
        boolean result = false;
        if (pkgName.lastIndexOf(".") > 0) {
            String stripped = pkgName.substring(pkgName.lastIndexOf(".") + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stripped PKG Name: " + stripped);
            }
            if (stripped.equals(newPkgName)) {
                result = true;
                return result;
            }
        }
        return result;
    }

    private boolean localAttr(EClass type, String attrName) {
        EList attrs = type.getEAttributes();
        for (EAttribute attr : attrs) {
            if (!attr.getName().equals(attrName)) continue;
            return true;
        }
        return false;
    }

    private static String getShortType(String type) {
        return type.substring(type.lastIndexOf(46) + 1, type.length());
    }

    protected static boolean isValidAttribute(String pkgName, String typName, String attrName, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidAttribute", new Object[]{pkgName, typName, attrName, nodeProps});
        }
        boolean typeValid = MetadataFilter.isValidType(pkgName, typName, nodeProps);
        boolean result = false;
        if (typeValid) {
            result = ctldb.isAttributeValid(nodeProps, pkgName, typName, attrName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidAttribute", new Boolean(result));
        }
        return result;
    }

    protected static boolean isValidType(String pkgName, String typName, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidType", new Object[]{pkgName, typName, nodeProps});
        }
        boolean packValid = MetadataFilter.isValidPackage(pkgName, nodeProps);
        boolean result = false;
        if (packValid) {
            result = ctldb.isTypeValid(nodeProps, pkgName, typName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidType", new Boolean(result));
        }
        return result;
    }

    protected static boolean isValidPackage(String pkgName, Properties nodeProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidPackage", new Object[]{pkgName, nodeProps});
        }
        boolean result = ctldb.isPackageValid(nodeProps, pkgName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidPackage", new Boolean(result));
        }
        return result;
    }

    static {
        ctldb = ConfigTimeLineDataBase.getInstance();
    }
}

