/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class InnerConfigObjectDelegator
extends ConfigObjectDelegator {
    private static TraceComponent tc = Tr.register(InnerConfigObjectDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private String type;
    private String mofAttribute;

    public InnerConfigObjectDelegator(ConfigServiceImpl baseConfigService, String type, String mofAttribute) {
        super(baseConfigService);
        this.type = type;
        this.mofAttribute = mofAttribute;
    }

    public String getType() {
        return this.type;
    }

    public ObjectName[] getAll(Session session, ObjectName scope) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", scope);
        }
        ObjectName[] arrayResult = null;
        if (scope == null || WorkspaceHelper.isScopeContext(session, scope)) {
            ArrayList<ObjectName> result = new ArrayList<ObjectName>();
            ArrayList fileNames = new ArrayList();
            this.getFileNames(this, fileNames);
            Collection rootContexts = WorkspaceHelper.getScopeContexts(session, scope);
            for (RepositoryContext rootContext : rootContexts) {
                Iterator docIter = fileNames.iterator();
                while (docIter.hasNext()) {
                    List docs = this.getTypedDocuments(rootContext, (String)docIter.next());
                    Iterator iter = docs.iterator();
                    while (iter.hasNext()) {
                        try {
                            WorkSpaceFile file = (WorkSpaceFile)iter.next();
                            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, file);
                            ObjectName[] selectedObjs = docAccessor.getTypedObjects(session, this.getType());
                            for (int j = 0; selectedObjs != null && j < selectedObjs.length; ++j) {
                                result.add(selectedObjs[j]);
                            }
                        }
                        catch (ConfigDocumentLoadException ex) {
                            Tr.error(tc, "ADMG0003E", ex);
                        }
                    }
                }
            }
            arrayResult = new ObjectName[result.size()];
            result.toArray(arrayResult);
        } else {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(scope);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, id);
            EObject scopeObj = docAccessor.lookup(id);
            arrayResult = docAccessor.getTypedObjects(this.type, scopeObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", arrayResult);
        }
        return arrayResult;
    }

    protected ObjectName getParent(Session session, ObjectName kid) throws ConfigServiceException {
        return this.getMOFParent(session, kid);
    }

    protected ObjectName[] getChildren(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo) throws ConfigServiceException {
        ObjectName[] result;
        ConfigDataId parentId = ConfigServiceHelper.getConfigDataId(parent);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, parentId);
        try {
            ObjectName[] children = docAccessor.getRelationship(session, parentId, this.mofAttribute);
            ArrayList<ObjectName> selected = new ArrayList<ObjectName>();
            for (int i = 0; i < children.length; ++i) {
                if (!ConfigServiceHelper.getConfigDataType(children[i]).equals(relationshipInfo.getChildDelegator().getType())) continue;
                selected.add(children[i]);
            }
            result = new ObjectName[selected.size()];
            selected.toArray(result);
        }
        catch (ConfigDataNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.InnerConfigObjectDelegator.getChildren", (String)"93", (Object)this);
            return new ObjectName[0];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        ObjectName result;
        ConfigDataId parentId = ConfigServiceHelper.getConfigDataId(parent);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, parentId);
        this.dupJndi(session, parent, null, attrList);
        ConfigServiceHelper.setAttributeValue(attrList, "_Websphere_Config_Data_Type", this.getType());
        try {
            result = relationshipInfo.isCollection() ? docAccessor.addElementAt(session, parentId, this.mofAttribute, attrList, -1, true) : docAccessor.createConfigData(session, parentId, this.mofAttribute, attrList, true);
            docAccessor.localSave();
            Object var9_8 = null;
            docAccessor.cleanup();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            docAccessor.cleanup();
            throw throwable;
        }
        return result;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(configData);
        WorkspaceHelper.getDocAccessor(session, configDataId);
        this.dupJndi(session, this.getParent(session, configData), configData, attrList);
        super.setAttributes(session, configData, attrList);
    }

    public void resetAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(configData);
        WorkspaceHelper.getDocAccessor(session, configDataId);
        this.dupJndi(session, this.getParent(session, configData), configData, attrList);
        super.resetAttributes(session, configData, attrList);
    }

    private void getFileNames(ConfigObjectDelegator delegator, List fileNames) {
        Iterator iter = delegator.parentTypes.iterator();
        while (iter.hasNext()) {
            ConfigServiceDelegator parentDelegator = this.baseConfigService.getDelegator((String)iter.next());
            if (parentDelegator == null || !(parentDelegator instanceof ConfigObjectDelegator)) continue;
            if (parentDelegator instanceof RootObjectDelegator) {
                fileNames.add(((RootObjectDelegator)parentDelegator).getFileName());
                continue;
            }
            this.getFileNames((ConfigObjectDelegator)parentDelegator, fileNames);
        }
    }

    void dupJndi(Session session, ObjectName parent, ObjectName factory, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dupJndi", new Object[]{parent, attrList});
        }
        boolean dup = false;
        String jndiName = null;
        try {
            jndiName = (String)ConfigServiceHelper.getAttributeValue(attrList, "jndiName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jndiName", jndiName);
            }
            if (jndiName != null) {
                ObjectName scope = this.baseConfigService.getRelationship(session, parent, "parent")[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scope", scope);
                }
                CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                AdminCommand cmd = cmdMgr.createCommand("lookupResources");
                cmd.setConfigSession(session);
                cmd.setParameter("scope", scope);
                cmd.setParameter("jndiName", jndiName);
                cmd.execute();
                CommandResult cmdResult = cmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    List matches = (List)cmdResult.getResult();
                    int matchesNum = matches.size();
                    switch (matchesNum) {
                        case 0: {
                            dup = false;
                            break;
                        }
                        case 1: {
                            if (factory != null) {
                                dup = !ConfigServiceHelper.getConfigDataId((ObjectName)matches.get(0)).equals(ConfigServiceHelper.getConfigDataId(factory));
                                break;
                            }
                            dup = true;
                            break;
                        }
                        default: {
                            dup = true;
                            break;
                        }
                    }
                } else {
                    throw cmdResult.getException();
                }
                if (dup) {
                    throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0037E", new Object[]{this.type, "jndiName", jndiName}, null));
                }
            }
        }
        catch (AttributeNotFoundException ex) {
        }
        catch (ConfigServiceException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ConfigServiceException(ex, "unexpected exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dupJndi");
        }
    }
}

