/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.serverindex.DistinguishedEndpointConstants;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerTypeConstants;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndPointConfigThreadLocal;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.PortConflictResolver;
import com.ibm.ws.management.util.PortConflictResolverException;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EndpointConfigHelper
implements DistinguishedEndpointConstants,
ServerTypeConstants {
    private static TraceComponent tc = Tr.register(EndpointConfigHelper.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final List emptyArray = new ArrayList(0);
    private static final ServerindexFactory serverIndexFactory;
    private static EndPointConfigThreadLocal thisThread;
    private static String propertyFile;
    private static String skipPorts;
    private static List skipList;
    private static Properties props;
    private static final IpcPackage ipcPckg;
    private static Map endpointMap;
    private static Map serverTypeMap;

    static void getAllEndpointMetaInfo(EClassifier metaObj, AttributeList attrList) {
        String type;
        DistinguishedEndpointInfo[] endpoints;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllEndpointMetaInfo", metaObj);
        }
        if ((endpoints = (DistinguishedEndpointInfo[])endpointMap.get(type = TypeRegistry.getTypeShortName(metaObj))) != null) {
            for (int i = 0; i < endpoints.length; ++i) {
                String endpointName = endpoints[i].getEndpointName();
                AttributeList metaInfo = EndpointConfigHelper.getEndpointMetaInfo(endpointName);
                attrList.add(new Attribute(endpointName, metaInfo));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllEndpointMetaInfo");
        }
    }

    static List getEndpointAttributeNames(EClassifier metaObj) {
        ArrayList<String> attrNames;
        String type;
        DistinguishedEndpointInfo[] info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointAttributeNames", metaObj);
        }
        if ((info = (DistinguishedEndpointInfo[])endpointMap.get(type = TypeRegistry.getTypeShortName(metaObj))) != null) {
            attrNames = new ArrayList<String>(info.length);
            for (int i = 0; i < info.length; ++i) {
                attrNames.add(info[i].getEndpointName());
            }
        } else {
            attrNames = emptyArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointAttributeNames", attrNames);
        }
        return attrNames;
    }

    static boolean isEndpointAttribute(EClassifier metaObj, String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEndpointAttribute", new Object[]{metaObj, attributeName});
        }
        String type = TypeRegistry.getTypeShortName(metaObj);
        DistinguishedEndpointInfo[] info = (DistinguishedEndpointInfo[])endpointMap.get(type);
        boolean result = false;
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].getEndpointName().equals(attributeName)) continue;
                result = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEndpointAttribute," + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getEndpointAttribute(EObject obj, String attribute, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointAttribute", new Object[]{obj, attribute, new Boolean(recursive)});
        }
        String type = TypeRegistry.getTypeShortName(obj.eClass());
        DocAccessor docAccessor = EndpointConfigHelper.getServerIndexAccessor(obj);
        Resource res = docAccessor.getResource();
        Object result = null;
        Resource resource = res;
        synchronized (resource) {
            RepositoryContext context = WorkspaceHelper.getContext(obj.eResource());
            String serverName = context.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", serverName);
            }
            ServerIndex rootObj = (ServerIndex)res.getContents().get(0);
            EList serverEntries = rootObj.getServerEntries();
            ServerEntry matched = null;
            for (ServerEntry serverEntry : serverEntries) {
                if (!serverEntry.getServerName().equals(serverName)) continue;
                matched = serverEntry;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "matched", matched);
                break;
            }
            if (matched != null) {
                result = EndpointConfigHelper.getNamedEndpoint(matched, attribute, recursive);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointAttribute", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerType(RepositoryContext serverContext, EClassifier metaObj) throws ConfigServiceException {
        String type = TypeRegistry.getTypeShortName(metaObj);
        String serverType = (String)serverTypeMap.get(type);
        if (serverType != null) {
            RepositoryContext nodeContext = serverContext.getParent();
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
            Resource res = docAccessor.getResource();
            Object result = null;
            Resource resource = res;
            synchronized (resource) {
                String serverName = serverContext.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverName", serverName);
                }
                ServerIndex rootObj = (ServerIndex)res.getContents().get(0);
                EList serverEntries = rootObj.getServerEntries();
                ServerEntry matched = null;
                for (ServerEntry serverEntry : serverEntries) {
                    if (!serverEntry.getServerName().equals(serverName)) continue;
                    matched = serverEntry;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "matched", matched);
                    break;
                }
                if (matched == null) {
                    matched = EndpointConfigHelper.createServerEntry(nodeContext, serverName);
                }
                if (serverType != null) {
                    serverType = "DEPLOYMENT_MANAGER".equals(serverType) ? "DEPLOYMENT_MANAGER" : ("NODE_AGENT".equals(serverType) ? "NODE_AGENT" : ("ADMIN_AGENT".equals(serverType) ? "ADMIN_AGENT" : ("APPLICATION_SERVER".equals(serverType) && (matched.getServerType() == null || matched.getServerType().equals("MESSAGE_BROKER")) ? "APPLICATION_SERVER" : ("MESSAGE_BROKER".equals(serverType) && matched.getServerType() == null ? "MESSAGE_BROKER" : matched.getServerType()))));
                    matched.setServerType(serverType);
                }
                docAccessor.localSave();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getServerType(RepositoryContext serverContext) throws ConfigServiceException {
        Resource res;
        String result = null;
        RepositoryContext nodeContext = serverContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        Resource resource = res = docAccessor.getResource();
        synchronized (resource) {
            String serverName = serverContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", serverName);
            }
            ServerIndex rootObj = (ServerIndex)res.getContents().get(0);
            EList serverEntries = rootObj.getServerEntries();
            ServerEntry matched = null;
            for (ServerEntry serverEntry : serverEntries) {
                if (!serverEntry.getServerName().equals(serverName)) continue;
                matched = serverEntry;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "matched", matched);
                break;
            }
            if (matched != null) {
                result = matched.getServerType();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerEntry", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setEndpointAttribute(RepositoryContext serverContext, EClassifier metaObj, String endpointName, AttributeList attrList, MOFUtil.ReferenceHandler referenceHandler, Stack attributePathContext) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEndpointAttribute", new Object[]{serverContext, metaObj, endpointName, attrList});
        }
        String type = TypeRegistry.getTypeShortName(metaObj);
        RepositoryContext nodeContext = serverContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        Resource res = docAccessor.getResource();
        Object result = null;
        Resource resource = res;
        synchronized (resource) {
            String serverName = serverContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", serverName);
            }
            ServerIndex rootObj = (ServerIndex)res.getContents().get(0);
            EList serverEntries = rootObj.getServerEntries();
            ServerEntry matched = null;
            for (ServerEntry serverEntry : serverEntries) {
                if (!serverEntry.getServerName().equals(serverName)) continue;
                matched = serverEntry;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "matched", matched);
                break;
            }
            if (matched == null) {
                matched = EndpointConfigHelper.createServerEntry(nodeContext, serverName);
            }
            EndpointConfigHelper.setNamedEndpoint(matched, type, endpointName, attrList, referenceHandler, attributePathContext);
            docAccessor.localSave();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEndpointAttribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteEndpoints(RepositoryContext nodeContext, String serverName, EClassifier metaObj) throws ConfigServiceException {
        Resource res;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteEndpoints", new Object[]{nodeContext, serverName, metaObj});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        Resource resource = res = docAccessor.getResource();
        synchronized (resource) {
            try {
                ServerIndex serverIndex;
                ServerEntry serverEntry;
                EList extent = res.getContents();
                if (extent != null && extent.size() > 0 && (serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex = (ServerIndex)extent.get(0), serverName)) != null) {
                    List endpointNames = EndpointConfigHelper.getEndpointAttributeNames(metaObj);
                    Iterator iter = endpointNames.iterator();
                    while (iter.hasNext()) {
                        NamedEndPoint namedEndpoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, (String)iter.next());
                        if (namedEndpoint == null) continue;
                        MOFUtil.deleteEObject(namedEndpoint);
                    }
                    docAccessor.localSave();
                }
                Object var13_12 = null;
                docAccessor.cleanup();
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                docAccessor.cleanup();
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteEndpoints");
        }
    }

    static EClassifier getEndpointMetaObj() {
        return ipcPckg.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerEntry createServerEntry(RepositoryContext nodeContext, String serverName, ObjectName serverTemplate) throws ConfigServiceException {
        ServerEntry serverEntry;
        Resource res;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerEntry", new Object[]{nodeContext, serverName, serverTemplate});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        Resource resource = res = docAccessor.getResource();
        synchronized (resource) {
            try {
                ServerIndex rootObj;
                EList extent = res.getContents();
                if (extent.size() == 0) {
                    rootObj = serverIndexFactory.createServerIndex();
                    extent.add(rootObj);
                } else {
                    rootObj = (ServerIndex)res.getContents().get(0);
                }
                serverEntry = EndpointConfigHelper.lookupServerEntry(rootObj, serverName);
                if (serverEntry == null) {
                    if (serverTemplate != null) {
                        RepositoryContext serverTemplateContext;
                        RepositoryContext nodeTemplateContext;
                        DocAccessor serverIndexAccessor;
                        ServerIndex templateServerIndex;
                        ServerEntry serverEntryTemplate;
                        WorkSpace templateWS = nodeContext.getWorkSpace();
                        Session templateSession = WorkspaceHelper.getConfigSession(serverTemplate);
                        if (templateSession != null) {
                            templateWS = WorkspaceHelper.getWorkspace(templateSession);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "template workspace", templateWS);
                        }
                        if ((serverEntryTemplate = EndpointConfigHelper.lookupServerEntry(templateServerIndex = (ServerIndex)(serverIndexAccessor = WorkspaceHelper.getDocAccessor(nodeTemplateContext = (serverTemplateContext = WorkspaceHelper.getContext(templateWS, ConfigServiceHelper.getConfigDataId(serverTemplate))).getParent(), "serverindex.xml")).getResource().getContents().get(0), ConfigServiceHelper.getDisplayName(serverTemplate))) != null) {
                            serverEntry = (ServerEntry)RefObjectHelperFactory.getRefObjectHelper().clone((EObject)serverEntryTemplate);
                        }
                    }
                    if (serverEntry == null) {
                        serverEntry = serverIndexFactory.createServerEntry();
                    }
                    serverEntry.setServerName(serverName);
                    String hostName = rootObj.getHostName();
                    EList endpoints = serverEntry.getSpecialEndpoints();
                    ArrayList<Integer> definedPorts = new ArrayList<Integer>();
                    for (NamedEndPoint namedEP : endpoints) {
                        String endPointName = namedEP.getEndPointName();
                        EndPoint ep = namedEP.getEndPoint();
                        if (ep == null) continue;
                        int port = ep.getPort();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "End point name is " + namedEP.getEndPointName());
                            Tr.debug(tc, "End point port is " + port);
                        }
                        if (port != 0) {
                            int newPort;
                            ep.setPort(0);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Actual port generated " + port);
                            }
                            if (skipList.size() > 0) {
                                boolean matchesSkipList;
                                do {
                                    newPort = EndpointConfigHelper.adjustPort(nodeContext, port, definedPorts);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adjusted port: " + newPort);
                                    }
                                    matchesSkipList = false;
                                    if (!skipList.contains(new Integer(newPort))) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Port- " + newPort + " is in skip port list-> adjusting port..");
                                    }
                                    port = ++newPort;
                                    matchesSkipList = true;
                                } while (matchesSkipList);
                            } else {
                                newPort = EndpointConfigHelper.adjustPort(nodeContext, port, definedPorts);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adjusted port: " + newPort);
                                }
                            }
                            ep.setPort(newPort);
                            definedPorts.add(new Integer(newPort));
                        }
                        if ("IPC_CONNECTOR_ADDRESS".equals(endPointName) || "*".equals(ep.getHost())) continue;
                        ep.setHost(hostName);
                    }
                    rootObj.getServerEntries().add(serverEntry);
                }
                docAccessor.localSave();
                Object var20_19 = null;
                docAccessor.cleanup();
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                docAccessor.cleanup();
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerEntry", serverEntry);
        }
        return serverEntry;
    }

    static ServerEntry createServerEntry(RepositoryContext nodeContext, String serverName) throws ConfigServiceException {
        return EndpointConfigHelper.createServerEntry(nodeContext, serverName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteServerEntry(RepositoryContext nodeContext, String serverName) throws ConfigServiceException {
        Resource res;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerEntry", new Object[]{nodeContext, serverName});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        Resource resource = res = docAccessor.getResource();
        synchronized (resource) {
            try {
                EList extent = res.getContents();
                if (extent.size() > 0) {
                    ServerIndex rootObj = (ServerIndex)res.getContents().get(0);
                    ServerEntry serverEntry = EndpointConfigHelper.lookupServerEntry(rootObj, serverName);
                    if (serverEntry != null) {
                        MOFUtil.deleteEObject(serverEntry);
                    }
                    docAccessor.localSave();
                }
                Object var9_8 = null;
                docAccessor.cleanup();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                docAccessor.cleanup();
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServerEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getDeployedApplications(Session session, ObjectName server) throws ConfigServiceException {
        Resource res;
        RepositoryContext nodeContext = WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(server)).getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        Resource resource = res = docAccessor.getResource();
        synchronized (resource) {
            ServerEntry serverEntry = EndpointConfigHelper.lookupServerEntry((ServerIndex)res.getContents().get(0), ConfigServiceHelper.getDisplayName(server));
            ArrayList result = new ArrayList(serverEntry.getDeployedApplications());
            return result;
        }
    }

    private static DocAccessor getServerIndexAccessor(EObject obj) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexAccessor", obj);
        }
        RepositoryContext serverContext = WorkspaceHelper.getContext(obj.eResource());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverContext", serverContext);
        }
        RepositoryContext nodeContext = serverContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(nodeContext, "serverindex.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexAccessor", docAccessor);
        }
        return docAccessor;
    }

    private static ServerEntry lookupServerEntry(ServerIndex serverIndex, String serverName) {
        EList serverEntries = serverIndex.getServerEntries();
        ServerEntry found = null;
        for (ServerEntry serverEntry : serverEntries) {
            if (!serverEntry.getServerName().equals(serverName)) continue;
            found = serverEntry;
            break;
        }
        return found;
    }

    private static Object getNamedEndpoint(ServerEntry serverEntry, String endpointName, boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamedEndpoint", new Object[]{serverEntry, endpointName});
        }
        Serializable result = null;
        NamedEndPoint namedEndpoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, endpointName);
        if (namedEndpoint != null) {
            if (recursive) {
                try {
                    result = MOFUtil.getAttributes(namedEndpoint.getEndPoint(), null, true);
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught when getting attributes", ex);
                    }
                }
            } else {
                result = MOFUtil.createObjectName(namedEndpoint.getEndPoint());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedEndpoint", result);
        }
        return result;
    }

    private static NamedEndPoint lookupNamedEndpoint(ServerEntry serverEntry, String endpointName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupNamedEndpoint", new Object[]{serverEntry, endpointName});
        }
        NamedEndPoint result = null;
        EList endpoints = serverEntry.getSpecialEndpoints();
        for (NamedEndPoint namedEndpoint : endpoints) {
            if (!endpointName.equals(namedEndpoint.getEndPointName())) continue;
            result = namedEndpoint;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedEndpoint", result);
        }
        return result;
    }

    private static void setNamedEndpoint(ServerEntry serverEntry, String type, String endpointName, AttributeList attrList, MOFUtil.ReferenceHandler referenceHandler, Stack attributePathContext) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNamedEndpoint", new Object[]{serverEntry, endpointName, attrList});
        }
        EList endpoints = serverEntry.getSpecialEndpoints();
        NamedEndPoint found = null;
        for (NamedEndPoint namedEndpoint : endpoints) {
            if (!endpointName.equals(namedEndpoint.getEndPointName())) continue;
            found = namedEndpoint;
            break;
        }
        if (attrList == null) {
            if (found != null) {
                MOFUtil.deleteEObject(found);
            }
        } else {
            EObject parent;
            for (parent = serverEntry.eContainer(); parent != null && !(parent instanceof ServerIndex); parent = parent.eContainer()) {
            }
            ServerIndex serverIndex = (ServerIndex)parent;
            if (found == null) {
                found = serverIndexFactory.createNamedEndPoint();
                found.setEndPointName(endpointName);
                endpoints.add(found);
                if (EndpointConfigHelper.isUniqueEndpoint(type, endpointName)) {
                    serverIndex.getEndPointRefs().add(found);
                }
            }
            if (found.getEndPoint() == null) {
                EndPoint endPoint = ipcPckg.getIpcFactory().createEndPoint();
                endPoint.setPort(-1);
                found.setEndPoint(endPoint);
            }
            EndpointConfigHelper.fillDefaultEndpoint(serverIndex, serverEntry, type, endpointName, attrList);
            MOFUtil.setAttributes(WorkspaceHelper.getContext(serverEntry.eResource()), found.getEndPoint(), attrList, referenceHandler, attributePathContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNamedEndpoint");
        }
    }

    private static AttributeList getEndpointMetaInfo(String endpointName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointMetaInfo", endpointName);
        }
        AttributeList result = new AttributeList();
        result.add(new Attribute("_Attribute_MetaInfo_Name", endpointName));
        result.add(new Attribute("_Attribute_MetaInfo_Default_Value", null));
        result.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        String typeName = TypeRegistry.getTypeShortName(ipcPckg.getEndPoint());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "typeName", typeName);
        }
        result.add(new Attribute("_Attribute_MetaInfo_Type", typeName));
        try {
            String[] subTypes = TypeRegistry.getSubTypes(typeName);
            if (subTypes != null && subTypes.length > 0) {
                result.add(new Attribute("_Attribute_MetaInfo_Subtypes", Arrays.asList(subTypes)));
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            // empty catch block
        }
        result.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        result.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointMetaInfo", result);
        }
        return result;
    }

    private static int defaultEndpoint(String type, String endpointName) {
        DistinguishedEndpointInfo[] info = (DistinguishedEndpointInfo[])endpointMap.get(type);
        int result = 0;
        for (int i = 0; i < info.length; ++i) {
            if (!info[i].getEndpointName().equals(endpointName)) continue;
            result = info[i].getDefaultPort();
            break;
        }
        return result;
    }

    private static boolean isUniqueEndpoint(String type, String endpointName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUniqueEndpoint for type " + type + " end point name " + endpointName);
        }
        DistinguishedEndpointInfo[] info = (DistinguishedEndpointInfo[])endpointMap.get(type);
        boolean result = false;
        for (int i = 0; i < info.length; ++i) {
            if (!info[i].getEndpointName().equals(endpointName)) continue;
            result = info[i].isUnique();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUniqueEndpoint" + result);
        }
        return result;
    }

    public static synchronized void setAdjustFlag(Boolean config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointConfigThreadLocal, " + config);
        }
        thisThread.set(config);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointConfigThreadLocal");
        }
    }

    public static Integer adjustPort(Session session, String nodeName, Integer defaultPort) throws ConfigServiceException {
        RepositoryContext nodeContext = WorkspaceHelper.getNodeContext(session, nodeName);
        Integer port = new Integer(EndpointConfigHelper.adjustPort(nodeContext, defaultPort, null));
        return port;
    }

    public static int adjustPort(RepositoryContext context, int defaultPort, List definedPorts) throws ConfigServiceException {
        Boolean b;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustPort," + defaultPort);
        }
        if (!(b = (Boolean)thisThread.get()).booleanValue()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "adjustPort," + defaultPort);
            }
            return defaultPort;
        }
        if (defaultPort == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "adjustPort," + defaultPort);
            }
            return defaultPort;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "context.getType().getName()=" + context.getType().getName());
                Tr.debug(tc, "context.getName()=" + context.getName());
                Tr.debug(tc, "context.getPath()=" + context.getPath());
            }
            if (context.getType().getName().equals("servers")) {
                Tr.debug(tc, "context is servers, changing context to the parent");
                context = context.getParent();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "context.getType().getName()=" + context.getType().getName());
                    Tr.debug(tc, "context.getName()=" + context.getName());
                    Tr.debug(tc, "context.getPath()=" + context.getPath());
                }
            }
            if (!context.getType().getName().equals("nodes")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning defaultPort without calling getUniquePort");
                    Tr.exit(tc, "adjustPort, " + defaultPort);
                }
                return defaultPort;
            }
            defaultPort = EndpointConfigHelper.getUniquePort(defaultPort);
            if (definedPorts == null || definedPorts.size() == 0) {
                if (definedPorts == null) {
                    definedPorts = new ArrayList<Integer>();
                }
                if (context.getType().getName().equals("servers")) {
                    context = context.getParent();
                }
                if (!AdminHelper.getPlatformHelper().isZOS()) {
                    if (!context.getType().getName().equals("nodes")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "should never happen");
                        }
                        return defaultPort;
                    }
                    RepositoryContextType type = context.getType();
                    RepositoryDocumentType rootDocType = type.getRootDocumentType();
                    ConfigDataId id = new ConfigDataId(context.getURI(), rootDocType.getFilePattern());
                    ObjectName thisNode = ConfigServiceHelper.createObjectName(id, rootDocType.getRootRefObjectTypes()[0], context.getName());
                    ConfigServiceImpl configService = ConfigServiceImpl.getInstance();
                    Session session = new Session(context.getWorkSpace().getUserName(), true);
                    String thisHostName = (String)configService.getAttribute(session, thisNode, "hostName");
                    String thisHostIPAddr = null;
                    if (thisHostName != null) {
                        thisHostIPAddr = EndpointConfigHelper.getHostIPAddress(thisHostName);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The hostname of this node is null - should not happen");
                    }
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
                    ObjectName[] nodes = configService.queryConfigObjects(session, null, pattern, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodes.length=" + nodes.length);
                    }
                    for (int i = 0; i < nodes.length; ++i) {
                        String hostName = (String)configService.getAttribute(session, nodes[i], "hostName");
                        String hostIPAddr = null;
                        if (hostName != null) {
                            hostIPAddr = EndpointConfigHelper.getHostIPAddress(hostName);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The hostname of the node " + nodes[i] + "is null - should not happen");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "thisHostIPAdrr=" + thisHostIPAddr + " hostIPAddr=" + hostIPAddr + " thisHostName=" + thisHostName + " hostName=" + hostName);
                        }
                        if ((thisHostIPAddr != null && hostIPAddr != null || !thisHostName.equals(hostName)) && !thisHostIPAddr.equals(hostIPAddr)) continue;
                        ObjectName scope = nodes[i];
                        String nodeName = ConfigServiceHelper.getDisplayName(scope);
                        ManagedObjectMetadataHelper mh = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "mh.getNodeMajorVersion(" + nodeName + "=" + mh.getNodeMajorVersion(nodeName));
                        }
                        ObjectName[] endPoints = null;
                        if (mh.getNodeMajorVersion(nodeName).equals("5")) {
                            endPoints = configService.queryConfigObjects(session, scope, ConfigServiceHelper.createObjectName(null, "EndPoint"), null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "endPoints.length=" + endPoints.length);
                            }
                        } else {
                            ObjectName serverIndex = configService.getRelationship(session, scope, "ServerIndex")[0];
                            endPoints = configService.resolve(session, serverIndex, "EndPoint=");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "serverIndex=" + serverIndex);
                                Tr.debug(tc, "endPoints.length=" + endPoints.length);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "scope=" + scope);
                        }
                        for (int j = 0; endPoints != null && j < endPoints.length; ++j) {
                            Integer thisPort = (Integer)configService.getAttribute(session, endPoints[j], "port");
                            if (thisPort == null) continue;
                            definedPorts.add(thisPort);
                        }
                    }
                } else {
                    if (context.getType().getName().equals("nodes")) {
                        context = context.getParentContext();
                    }
                    if (!context.getType().getName().equals("cells")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "z/OS - not scanning at cell level");
                        }
                        return defaultPort;
                    }
                    ObjectName scope = MOFUtil.createObjectName(context);
                    ConfigServiceImpl configService = ConfigServiceImpl.getInstance();
                    Session session = new Session(context.getWorkSpace().getUserName(), true);
                    ObjectName[] endPoints = configService.queryConfigObjects(session, scope, ConfigServiceHelper.createObjectName(null, "EndPoint"), null);
                    for (int i = 0; i < endPoints.length; ++i) {
                        Integer thisPort = (Integer)configService.getAttribute(session, endPoints[i], "port");
                        if (thisPort == null) continue;
                        definedPorts.add(thisPort);
                    }
                }
            }
            boolean isDefaultPortUnique = false;
            while (!isDefaultPortUnique) {
                int count = 0;
                Iterator iter = definedPorts.iterator();
                while (iter.hasNext()) {
                    Integer aDefinedPortNum = (int)((Integer)iter.next());
                    if (defaultPort == aDefinedPortNum) {
                        ++defaultPort;
                        break;
                    }
                    ++count;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "count=" + count);
                }
                if (count != definedPorts.size()) continue;
                isDefaultPortUnique = true;
            }
        }
        catch (ConfigServiceException ex) {
            throw ex;
        }
        catch (AdminException ex) {
        }
        catch (ConnectorException ex) {
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustPort," + defaultPort);
        }
        return defaultPort;
    }

    private static int getUniquePort(int defaultPort) throws WSProfileException, PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniquePort " + defaultPort);
        }
        int newPort = 0;
        String[] configRoots = EndpointConfigHelper.getConfigRoots();
        PortConflictResolver pcr = new PortConflictResolver(configRoots);
        newPort = Utils.resolvePort(defaultPort, pcr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniquePort " + newPort);
        }
        return newPort;
    }

    private static String getHostIPAddress(String hostname) throws InvalidAttributeValException {
        InetAddress inetAddr = null;
        try {
            inetAddr = hostname.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
        }
        catch (UnknownHostException uhe) {
            String errMsg = "UnknownHostException caught when getting the host IP address: homename = " + hostname;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errMsg, uhe);
            }
            return null;
        }
        catch (Exception e) {
            String errMsg = "A exception caught when getting the host IP address: homename = " + hostname;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errMsg, e);
            }
            return null;
        }
        return inetAddr.getHostAddress();
    }

    private static void fillDefaultEndpoint(ServerIndex serverIndex, ServerEntry serverEntry, String objectType, String endpointName, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillDefaultEndpoint", new Object[]{serverIndex, endpointName, attrList});
        }
        Object val = null;
        try {
            val = ConfigServiceHelper.getAttributeValue(attrList, "host");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (val == null) {
            ConfigServiceHelper.setAttributeValue(attrList, "host", serverIndex.getHostName());
        }
        val = null;
        try {
            val = ConfigServiceHelper.getAttributeValue(attrList, "port");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (val == null) {
            EndPoint ep;
            int defaultPort = -1;
            NamedEndPoint existingEndpoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, endpointName);
            if (existingEndpoint != null && (ep = existingEndpoint.getEndPoint()) != null) {
                defaultPort = ep.getPort();
                ep.setPort(0);
            }
            if (defaultPort == -1) {
                defaultPort = EndpointConfigHelper.defaultEndpoint(objectType, endpointName);
            }
            defaultPort = EndpointConfigHelper.adjustPort(WorkspaceHelper.getContext(serverIndex.eResource()), defaultPort, null);
            ConfigServiceHelper.setAttributeValue(attrList, "port", new Integer(defaultPort));
        }
    }

    private static String[] getConfigRoots() throws WSProfileException {
        String[] wsLocations;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoots");
        }
        if ((wsLocations = EndpointConfigHelper.getAllWASLocations()) == null || wsLocations.length == 0) {
            return EndpointConfigHelper.getConfigRoots2();
        }
        Vector vConfigRootLocations = new Vector();
        for (int locIndex = 0; locIndex < wsLocations.length; ++locIndex) {
            EndpointConfigHelper.getAllConfigLocations(vConfigRootLocations, wsLocations[locIndex]);
        }
        String[] configRoots = new String[vConfigRootLocations.size()];
        for (int i = 0; i < vConfigRootLocations.size(); ++i) {
            configRoots[i] = (String)vConfigRootLocations.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRoots", configRoots);
        }
        return configRoots;
    }

    private static String[] getConfigRoots2() throws WSProfileException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoots");
        }
        String[] configRoots = null;
        File registryFile = WSProfile.getRegistryFile();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using profile registry: " + registryFile);
        }
        List profiles = WSProfile.listProfileNames(registryFile);
        configRoots = new String[profiles.size()];
        int curProfile = 0;
        for (String profileName : profiles) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found profile: " + profileName);
            }
            File profileLoc = WSProfile.getProfileLocation(profileName, registryFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   Profile location: " + profileLoc);
            }
            configRoots[curProfile++] = profileLoc.getAbsolutePath() + "/config";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRoots", configRoots);
        }
        return configRoots;
    }

    private static String[] getAllWASLocations() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllWASLocations");
        }
        WASSystem aSys = null;
        try {
            aSys = WASSystem.getWASSystemInstance();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAllWASLocations", aSys.getWASLocations());
            }
            return aSys.getWASLocations();
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllWASLocations", null);
            }
            return null;
        }
    }

    private static Vector getAllConfigLocations(Vector container2, String sWASHome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllConfigLocations", sWASHome);
        }
        if (sWASHome == null) {
            return container2;
        }
        if (container2 == null) {
            container2 = new Vector<String>();
        }
        try {
            File registryFile = WSProfile.getRegistryFile(sWASHome);
            if (registryFile != null && registryFile.exists()) {
                List profileList = WSProfile.getProfileList(registryFile);
                for (Profile profile : profileList) {
                    String profileHome = profile.getPath().getAbsolutePath();
                    String configRoot = EndpointConfigHelper.getConfigRootFromProfileHome(profileHome);
                    if (configRoot == null) continue;
                    container2.addElement(configRoot);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllConfigLocations");
        }
        return container2;
    }

    private static String getConfigRootFromProfileHome(String sProfileHome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootFromProfileHome", sProfileHome);
        }
        String S_CONFIG = "config";
        String configRoot = null;
        File configFile = new File(sProfileHome + File.separator + S_CONFIG);
        if (configFile.exists() && configFile.isDirectory()) {
            try {
                configRoot = configFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                configRoot = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRootFromProfileHome", configRoot);
        }
        return configRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadPropertyFile(String propertyFile) {
        block24: {
            InputStream in;
            block21: {
                block20: {
                    in = null;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "loadPropertyFile ", propertyFile);
                    }
                    if ((in = ExtClassLoader.getSystemClassLoader().getResourceAsStream("port_skip.props")) != null) {
                        props.load(in);
                        skipPorts = (String)props.get("com.ibm.websphere.createservercommand.skipports");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Skip Port list taken from property file: ", skipPorts);
                        }
                        if (skipPorts != null) {
                            StringTokenizer st = new StringTokenizer(skipPorts, ",");
                            while (st.hasMoreTokens()) {
                                try {
                                    skipList.add(new Integer(st.nextToken().trim()));
                                }
                                catch (Throwable th) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Skip port is not in proper format, put \",\" as a seperator. ignoring this entry..");
                                }
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Skip ports list: " + skipList);
                        }
                        break block20;
                    }
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Property file (optional) not found in classpath:", propertyFile);
                }
                Object var5_5 = null;
                try {
                    in.close();
                }
                catch (Throwable th2) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Exception while closing inputstream");
                }
            }
            in = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertyFile ", propertyFile);
            }
            break block24;
            {
                catch (Throwable th) {
                    block22: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "IOException reading from property file.", th);
                        }
                        Object var5_6 = null;
                        try {
                            in.close();
                        }
                        catch (Throwable th2) {
                            if (!tc.isDebugEnabled()) break block22;
                            Tr.debug(tc, "Exception while closing inputstream");
                        }
                    }
                    in = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadPropertyFile ", propertyFile);
                    }
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Object var5_7 = null;
                    try {
                        in.close();
                    }
                    catch (Throwable th2) {
                        if (!tc.isDebugEnabled()) break block23;
                        Tr.debug(tc, "Exception while closing inputstream");
                    }
                }
                in = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadPropertyFile ", propertyFile);
                }
                throw throwable;
            }
        }
    }

    static {
        thisThread = new EndPointConfigThreadLocal();
        propertyFile = "port_skip.props";
        skipPorts = null;
        skipList = new ArrayList();
        props = new Properties();
        EndpointConfigHelper.loadPropertyFile(propertyFile);
        serverIndexFactory = ServerindexFactory.eINSTANCE;
        ipcPckg = IpcFactory.eINSTANCE.getIpcPackage();
        endpointMap = new HashMap();
        endpointMap.put("SystemMessageServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("DRS_CLIENT_ADDRESS", 7873, false)});
        endpointMap.put("JMSServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("JMSSERVER_DIRECT_ADDRESS", 5559, false), new DistinguishedEndpointInfo("JMSSERVER_QUEUED_ADDRESS", 5558, false)});
        if (AdminHelper.getPlatformHelper().isZOS()) {
            endpointMap.put("NameServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("BOOTSTRAP_ADDRESS", 9810, false), new DistinguishedEndpointInfo("ORB_LISTENER_ADDRESS", 9810, false), new DistinguishedEndpointInfo("ORB_SSL_LISTENER_ADDRESS", 0, false)});
            endpointMap.put("LocationServiceDaemon", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", 9021, false), new DistinguishedEndpointInfo("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", 9022, false), new DistinguishedEndpointInfo("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", 9023, false)});
        } else {
            endpointMap.put("NameServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("BOOTSTRAP_ADDRESS", 9810, false)});
            endpointMap.put("ObjectRequestBroker", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("ORB_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", 0, false)});
        }
        endpointMap.put("NodeAgent", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("NODE_DISCOVERY_ADDRESS", 7272, true)});
        endpointMap.put("CellManager", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("CELL_MULTICAST_DISCOVERY_ADDRESS", 5000, true), new DistinguishedEndpointInfo("CELL_DISCOVERY_ADDRESS", 7277, true)});
        endpointMap.put("SOAPConnector", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("SOAP_CONNECTOR_ADDRESS", 8880, false)});
        serverTypeMap = new HashMap();
        serverTypeMap.put("ApplicationServer", "APPLICATION_SERVER");
        serverTypeMap.put("JMSServer", "MESSAGE_BROKER");
        serverTypeMap.put("NodeAgent", "NODE_AGENT");
        serverTypeMap.put("AdminAgent", "ADMIN_AGENT");
        serverTypeMap.put("CellManager", "DEPLOYMENT_MANAGER");
    }

    private static class DistinguishedEndpointInfo {
        private String endpointName;
        private int defaultPort;
        private boolean isUnique;

        DistinguishedEndpointInfo(String endpointName, int defaultPort, boolean isUnique) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DistinguishedEndpointInfo for endPointName " + endpointName + " port is " + defaultPort + " isUnique is " + isUnique);
            }
            this.endpointName = endpointName;
            this.defaultPort = defaultPort;
            this.isUnique = isUnique;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DistinguishedEndpointInfo");
            }
        }

        public String getEndpointName() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEndpointName");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getEndpointName", this.endpointName);
            }
            return this.endpointName;
        }

        public int getDefaultPort() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDefaultPort");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultPort" + this.defaultPort);
            }
            return this.defaultPort;
        }

        public boolean isUnique() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isUnique");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isUnique" + this.isUnique);
            }
            return this.isUnique;
        }
    }
}

