/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.InnerConfigObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.emf.ecore.resource.Resource;

public class DataSourceDelegator
extends InnerConfigObjectDelegator {
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.configservice");
    private static TraceComponent tc = Tr.register(DataSourceDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private HashMap deletedJndiNames = new HashMap();

    public DataSourceDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, "DataSource", "factories");
    }

    private ObjectName getBuiltInRelationalResourceAdapter(Session session, DocAccessor docAccessor) throws ConfigServiceException {
        ObjectName[] rras = docAccessor.getTypedObjects(session, "J2CResourceAdapter");
        ObjectName builtInRRA = null;
        for (int i = 0; i < rras.length; ++i) {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(rras[i]);
            if (!id.toString().endsWith("#builtin_rra")) continue;
            builtInRRA = rras[i];
        }
        return builtInRRA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        ObjectName result = super.createConfigObject(session, parent, relationshipInfo, attrList);
        Object val = null;
        try {
            val = ConfigServiceHelper.getAttributeValue(attrList, "relationalResourceAdapter");
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        if (val == null) {
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(result));
            Resource resource = docAccessor.getResource();
            synchronized (resource) {
                ObjectName builtInRRA = this.getBuiltInRelationalResourceAdapter(session, docAccessor);
                AttributeList rraAttrList = new AttributeList();
                rraAttrList.add(new Attribute("relationalResourceAdapter", builtInRRA));
                this.baseConfigService.setAttributes(session, result, rraAttrList);
            }
            docAccessor.localSave();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", result);
        }
        return result;
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        try {
            try {
                this.removeJNDIEntry(session, configData);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to unbind jndi name", e.getMessage());
                }
                e.printStackTrace();
            }
            super.deleteConfigData(session, configData);
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public void discardSession(Session session) {
        List deletedNames;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discardSession", session);
        }
        if ((deletedNames = this.getDeletedJndiNames(session)) != null && deletedNames.size() > 0) {
            for (int i = 0; i < deletedNames.size(); ++i) {
                String jndiName = (String)deletedNames.get(i);
                Tr.info(tc, "JNDI " + jndiName + " was unbound during this session. And the session is being discarded without saving. " + "To restore the jndi binding either use TestConnection or restart the application server.");
            }
        }
        this.cleanDeletedJndiNames(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discardSession");
        }
    }

    public void saveSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveSession", session);
        }
        this.cleanDeletedJndiNames(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveSession");
        }
    }

    public void saveDeletedJndiName(String jndiName, Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveDeletedJndiName", new Object[]{jndiName, session});
        }
        ArrayList<String> names = (ArrayList<String>)this.deletedJndiNames.get(session.toString());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jndiNames ", names);
        }
        if (names == null) {
            names = new ArrayList<String>();
        }
        if (!names.contains(jndiName)) {
            names.add(jndiName);
        }
        this.deletedJndiNames.put(session.toString(), names);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveDeletedJndiName");
        }
    }

    private void cleanDeletedJndiNames(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanDeletedJndiNames", session);
        }
        if (this.deletedJndiNames.containsKey(session.toString())) {
            this.deletedJndiNames.remove(session.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanDeletedJndiNames");
        }
    }

    private List getDeletedJndiNames(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeletedJndiNames", session);
        }
        List lst = (List)this.deletedJndiNames.get(session.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeletedJndiNames", lst);
        }
        return lst;
    }

    private void removeJNDIEntry(Session session, ObjectName configData) throws Exception {
        String jndiName;
        AdminService as;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeJNDIEntry", new Object[]{session, configData});
        }
        if ((as = AdminServiceFactory.getAdminService()) != null && (jndiName = this.getJndiName(session, configData)) != null) {
            String jndiNameSpace = "cell/persistent/rra/" + jndiName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unbinding " + jndiNameSpace);
            }
            try {
                InitialContext ctx = new InitialContext();
                ctx.unbind(jndiNameSpace);
                this.saveDeletedJndiName(jndiName, session);
            }
            catch (NameNotFoundException ne) {
                Tr.debug(tc, "Jndi name space is not found " + jndiNameSpace);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeJNDIEntry");
        }
    }

    private String getJndiName(Session session, ObjectName ds) throws Exception {
        String jndiName = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJndiName", new Object[]{session, ds});
        }
        ObjectName[] resourceProperties = this.baseConfigService.resolve(session, ds, "J2EEResourceProperty=");
        for (int i = 0; resourceProperties != null && i < resourceProperties.length; ++i) {
            String name = (String)this.baseConfigService.getAttribute(session, resourceProperties[i], "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JndiName", name);
            }
            if (!name.equals("clientRerouteServerListJNDIName")) continue;
            jndiName = (String)this.baseConfigService.getAttribute(session, resourceProperties[i], "value");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJndiName", jndiName);
        }
        return jndiName;
    }
}

