/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ConfigServiceUtils {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigServiceUtils.class, "ConfigServiceUtils", "com.ibm.ws.management.resources.configservice");

    public static List listMatchingServerTemplatesForNode(ConfigService cs, Session session, String serverType, String nodeName) throws Exception {
        return TemplateConfigHelper.listMatchingServerTemplatesForNode(cs, session, serverType, nodeName);
    }

    public static List listMatchingServersForNode(ConfigService cs, Session session, String nodeName) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        final String nodeFinal = nodeName;
        List lst = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            lst = (List)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return TemplateConfigHelper.listMatchingServersForNode(csFinal, sessionFinal, nodeFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        catch (Exception e) {
            throw e;
        }
        if (lst != null) {
            Iterator itr = lst.iterator();
            while (itr.hasNext()) {
                ObjectName server = (ObjectName)itr.next();
                String res = ConfigServiceHelper.getConfigDataId(server).toString();
                if (ConfigServiceUtils.checkAccess(res, "monitor")) continue;
                itr.remove();
            }
        }
        return lst;
    }

    public static List listAvailableClusterMemberNodes(ConfigService cs, Session session, String firstNodeName, String ngName) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        final String nodeFinal = firstNodeName;
        final String ngFinal = ngName;
        List lst = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            lst = (List)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return TemplateConfigHelper.listAvailableClusterMemberNodes(csFinal, sessionFinal, nodeFinal, ngFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        catch (Exception e) {
            throw e;
        }
        if (lst != null) {
            Iterator itr = lst.iterator();
            while (itr.hasNext()) {
                String node = (String)itr.next();
                node = "nodes/" + node;
                if (ConfigServiceUtils.checkAccess(node, "configurator")) continue;
                itr.remove();
            }
        }
        return lst;
    }

    public static List listAvailableClusterMemberNodes(ConfigService cs, Session session, String clusterName) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        final String clusterFinal = clusterName;
        List lst = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            lst = (List)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return TemplateConfigHelper.listAvailableClusterMemberNodes(csFinal, sessionFinal, clusterFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        catch (Exception e) {
            throw e;
        }
        if (lst != null) {
            Iterator itr = lst.iterator();
            while (itr.hasNext()) {
                String node = (String)itr.next();
                node = "nodes/" + node;
                if (ConfigServiceUtils.checkAccess(node, "configurator")) continue;
                itr.remove();
            }
        }
        return lst;
    }

    private static boolean checkAccess(String res, String role) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{res, role});
        }
        boolean result = true;
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa != null) {
            result = aa.checkAccess(res, role);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(result));
        }
        return result;
    }

    public static List listAvailableServersToConvert(ConfigService cs, Session session) throws Exception {
        if (!ConfigServiceUtils.checkAccess("cell.xml", "configurator")) {
            return new ArrayList();
        }
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        List lst = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            lst = (List)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return TemplateConfigHelper.listAllServers(csFinal, sessionFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        catch (Exception e) {
            throw e;
        }
        return lst;
    }

    public static List listAllAvailableClusterMemberNodes(ConfigService cs, Session session) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        List lst = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            lst = (List)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return TemplateConfigHelper.listAvailableClusterMemberNodes(csFinal, sessionFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        catch (Exception e) {
            throw e;
        }
        if (lst != null) {
            Iterator itr = lst.iterator();
            while (itr.hasNext()) {
                String node = (String)itr.next();
                node = "nodes/" + node;
                if (ConfigServiceUtils.checkAccess(node, "configurator")) continue;
                itr.remove();
            }
        }
        return lst;
    }
}

