/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class ConfigServiceServerProxy
implements ConfigService {
    private static TraceComponent tc = Tr.register(ConfigServiceServerProxy.class, "management", "com.ibm.ws.management.resources.configservice");
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    protected static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    protected ConfigService _configService;

    public ConfigServiceServerProxy(ConfigService cs) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceServerProxy", cs);
        }
        this._configService = cs;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceServerProxy");
        }
    }

    public void setProperties(final Session session, final HashMap props) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, props});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("setProperties", new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"setProperties", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.setProperties(session, props);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.setProperties", (String)"88");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public ValidationResult validate(final Session session, final ObjectName scope) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, scope});
        }
        ValidationResult result = null;
        try {
            result = (ValidationResult)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ValidationResult retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("validate", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"validate", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.validate(session, scope);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.validate", (String)"122");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", result);
        }
        return result;
    }

    public void save(final Session session, final boolean overwriteOnConflict) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save", new Object[]{session, new Boolean(overwriteOnConflict)});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("save", new String[]{"com.ibm.websphere.management.Session", "boolean"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"save", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.save(session, overwriteOnConflict);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.save", (String)"160");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(final Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", session);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("discard", new String[]{"com.ibm.websphere.management.Session"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"discard", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.discard(session);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.discard", (String)"195");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", session);
        }
    }

    public String[] getUnsavedChanges(final Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        String[] result = null;
        try {
            result = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    String[] retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getUnsavedChanges", new String[]{"com.ibm.websphere.management.Session"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getUnsavedChanges", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getUnsavedChanges(session);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getUnsavedChanges", (String)"229");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", result);
        }
        return result;
    }

    public Map getConflictDocuments(final Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        Map result = null;
        try {
            result = (Map)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    Map retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getConflictDocuments", new String[]{"com.ibm.websphere.management.Session"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getConflictDocuments", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getConflictDocuments(session);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getConflictDocuments", (String)"267");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", result);
        }
        return result;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        String[] result = null;
        try {
            result = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    String[] retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getSupportedConfigObjectTypes", null);
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getSupportedConfigObjectTypes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getSupportedConfigObjectTypes();
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getSupportedConfigObjectTypes", (String)"307");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", result);
        }
        return result;
    }

    public AttributeList getAttributesMetaInfo(final String configDataType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", configDataType);
        }
        AttributeList result = null;
        try {
            result = (AttributeList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getAttributesMetaInfo", new String[]{"java.lang.String"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getAttributesMetaInfo", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getAttributesMetaInfo(configDataType);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getAttributesMetaInfo", (String)"348");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", result);
        }
        return result;
    }

    public AttributeList getRelationshipsMetaInfo(final String configObjectType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", configObjectType);
        }
        AttributeList result = null;
        try {
            result = (AttributeList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getRelationshipsMetaInfo", new String[]{"java.lang.String"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getRelationshipsMetaInfo", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getRelationshipsMetaInfo(configObjectType);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getRelationshipsMetaInfo", (String)"386");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", result);
        }
        return result;
    }

    public ObjectName[] queryConfigObjects(final Session inSession, final ObjectName scope, final ObjectName name, final QueryExp query) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryConfigObjects", new Object[]{inSession, scope, name, query});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("queryConfigObjects", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"queryConfigObjects", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.queryConfigObjects(inSession, scope, name, query);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.queryConfigObjects", (String)"424");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", result);
        }
        return result;
    }

    public ObjectName[] queryTemplates(final Session inSession, final String type) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryTemplates", new Object[]{inSession, type});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("queryTemplates", new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"queryTemplates", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.queryTemplates(inSession, type);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.queryTemplates", (String)"460");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", result);
        }
        return result;
    }

    public ObjectName[] resolve(final Session inSession, final String containmentPath) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{inSession, containmentPath});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("resolve", new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"resolve", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.resolve(inSession, containmentPath);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.resolve", (String)"499");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    public ObjectName[] resolve(Session inSession, ObjectName scope, String containmentPath) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{inSession, containmentPath});
        }
        ObjectName[] result = null;
        boolean valid = ConfigServiceServerProxy.securityCheck("resolve", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (!valid) {
            throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"resolve", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
        }
        result = this._configService.resolve(inSession, scope, containmentPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    public ObjectName createConfigDataByTemplate(final Session inSession, final ObjectName parent, final String attributeName, final AttributeList attrList, final ObjectName template) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{inSession, parent, attributeName, attrList, template});
        }
        ObjectName result = null;
        try {
            result = (ObjectName)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("createConfigDataByTemplate", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"createConfigDataByTemplate", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.createConfigDataByTemplate(inSession, parent, attributeName, attrList, template);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.createConfigDataByTemplate", (String)"557");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", result);
        }
        return result;
    }

    public ObjectName createConfigData(final Session inSession, final ObjectName parent, final String attributeName, final String type, final AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{inSession, parent, attributeName, type, attrList});
        }
        ObjectName result = null;
        try {
            result = (ObjectName)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("createConfigData", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"createConfigData", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.createConfigData(inSession, parent, attributeName, type, attrList);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.createConfigData", (String)"602");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", result);
        }
        return result;
    }

    public void setAttributes(final Session inSession, final ObjectName configData, final AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{inSession, configData, attrList});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("setAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"setAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.setAttributes(inSession, configData, attrList);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.setAttributes", (String)"642");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void addElement(final Session inSession, final ObjectName configData, final String attribute, final Object element, final int position) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{inSession, configData, attribute, element, new Integer(position)});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("addElement", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"addElement", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.addElement(inSession, configData, attribute, element, position);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.addElement", (String)"678");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    public void removeElement(final Session inSession, final ObjectName configData, final String attribute, final Object element) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{inSession, configData, attribute, element});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("removeElement", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"removeElement", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.removeElement(inSession, configData, attribute, element);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.removeElement", (String)"713");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    public void unsetAttributes(final Session inSession, final ObjectName configData, final String[] attributes) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{inSession, configData, attributes});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("unsetAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"unsetAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.unsetAttributes(inSession, configData, attributes);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.unsetAttributes", (String)"748");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(final Session inSession, final ObjectName configData, final AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{inSession, configData, attrList});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("resetAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"resetAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.resetAttributes(inSession, configData, attrList);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.resetAttributes", (String)"785");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(final Session inSession, final ObjectName configData, final String[] attributes, final boolean recursive) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{inSession, configData, attributes, new Boolean(recursive)});
        }
        AttributeList result = null;
        try {
            result = (AttributeList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getAttributes(inSession, configData, attributes, recursive);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getAttributes", (String)"823");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(final Session inSession, final ObjectName configData, final String attribute) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{inSession, configData, attribute});
        }
        Object result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    Object retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getAttribute", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getAttribute", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getAttribute(inSession, configData, attribute);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getAttribute", (String)"859");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute, boolean recursive) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigureServiceProxy.getAttribute", new Object[]{session, configData, attribute, new Boolean(recursive)});
        }
        if (recursive) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
            }
            return this.getAttribute(session, configData, attribute);
        }
        AttributeList attrList = this.getAttributes(session, configData, new String[]{attribute}, false);
        Object result = null;
        try {
            result = ConfigServiceHelper.getAttributeValue(attrList, attribute);
        }
        catch (AttributeNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", (String)"39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
        }
        return result;
    }

    public void deleteConfigData(final Session inSession, final ObjectName configData) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{inSession, configData});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean valid = ConfigServiceServerProxy.securityCheck("deleteConfigData", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"deleteConfigData", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.deleteConfigData(inSession, configData);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.deleteConfigData", (String)"919");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public AttributeList getRelationships(final Session inSession, final ObjectName configData, final String[] relationshipNames) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{inSession, configData, relationshipNames});
        }
        AttributeList result = null;
        try {
            result = (AttributeList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getRelationships", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getRelationships", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getRelationships(inSession, configData, relationshipNames);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getRelationships", (String)"956");
            throw new ConfigServiceException(e);
        }
        return result;
    }

    public ObjectName[] getRelationship(final Session inSession, final ObjectName configData, final String relationship) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{inSession, configData, relationship});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] retVal1 = null;
                    boolean valid = ConfigServiceServerProxy.securityCheck("getRelationship", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
                    if (!valid) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getRelationship", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    retVal1 = ConfigServiceServerProxy.this._configService.getRelationship(inSession, configData, relationship);
                    return retVal1;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ConfigServiceException) {
                throw (ConfigServiceException)e;
            }
            if (e instanceof ConnectorException) {
                throw (ConnectorException)e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.ConfigServiceServerProxy.getRelationship", (String)"991");
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", result);
        }
        return result;
    }

    protected static boolean securityCheck(String operationName, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "securityCheck");
        }
        return true;
    }
}

