/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ClusterMemberDelegator
extends ConfigServiceDelegator {
    private static TraceComponent tc = Tr.register(ClusterMemberDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public ClusterMemberDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService);
    }

    public String getType() {
        return "ClusterMember";
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws InvalidConfigDataTypeException {
        AttributeList metaInfo = super.getAttributesMetaInfo(configDataType);
        AttributeList adjustPortMetaInfo = new AttributeList();
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Name", "adjustPort"));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Type", "Boolean"));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        adjustPortMetaInfo.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        metaInfo.add(new Attribute("adjustPort", adjustPortMetaInfo));
        return metaInfo;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        try {
            Object val = ConfigServiceHelper.getAttributeValue(attrList, "adjustPort");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "val: " + val);
            }
            if (val instanceof Boolean && !((Boolean)val).booleanValue()) {
                EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            }
            ConfigServiceHelper.removeAttribute(attrList, "adjustPort");
        }
        catch (AttributeNotFoundException anfe) {
            // empty catch block
        }
        super.setAttributes(session, configData, attrList);
        EndpointConfigHelper.setAdjustFlag(new Boolean(true));
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        String memberName = null;
        String nodeName = null;
        ObjectName clusterMemberObj = null;
        String clusterName = null;
        try {
            ObjectName[] matches;
            memberName = (String)this.baseConfigService.getAttribute(session, configData, "memberName");
            nodeName = (String)this.baseConfigService.getAttribute(session, configData, "nodeName");
            super.deleteConfigData(session, configData);
            ObjectName[] node = this.baseConfigService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Node", nodeName), null);
            if (node.length > 0 && (matches = this.baseConfigService.queryConfigObjects(session, node[0], ConfigServiceHelper.createObjectName(null, "Server", memberName), null)).length > 0) {
                clusterMemberObj = matches[0];
                clusterName = (String)this.baseConfigService.getAttribute(session, clusterMemberObj, "clusterName");
                this.baseConfigService.deleteConfigData(session, clusterMemberObj);
            }
        }
        catch (Exception ex) {
            Tr.warning(tc, "ADMG0028W", memberName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "memberName = " + memberName + " nodeName = " + nodeName + " clusterName = " + clusterName + " clusterMemberObj = " + clusterMemberObj);
        }
        ObjectName clusterObj = null;
        try {
            clusterObj = ClusterConfigHelper.getClusterObj(this.baseConfigService, session, clusterName);
        }
        catch (ConnectorException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData");
            }
            throw new ConfigServiceException(e);
        }
        if (nodeName != null && clusterName != null && clusterObj != null) {
            try {
                ClusterConfigHelper.deleteMemberTemplate(this.baseConfigService, session, clusterName, clusterObj, nodeName);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown by deleteMemberTemplate");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteConfigData");
                }
                throw new ConfigServiceException(e);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not try to delete member template!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }
}

