/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.configservice.csmetadata.ConfigServiceMetadata;
import com.ibm.ws.management.configservice.csmetadata.CsmetadataPackage;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.framework.Bundle;

public class CSMetadataMgr {
    private static TraceComponent tc = Tr.register(CSMetadataMgr.class, "management", "com.ibm.ws.management.resources.configservice");
    private static CSMetadataMgr instance = new CSMetadataMgr();
    private ConfigServiceMetadata metadata = null;

    public static ConfigServiceMetadata getConfigServiceMetadata() {
        return CSMetadataMgr.instance.metadata;
    }

    private void init() {
        HashSet<URL> resourceSet = new HashSet<URL>();
        try {
            CsmetadataPackage pkg = CsmetadataPackage.eINSTANCE;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (!(loader instanceof ExtClassLoader)) {
                loader = ExtClassLoader.getInstance();
            }
            Enumeration<URL> eOld = loader.getResources("META-INF/ws-configservice-metadata.xml");
            while (eOld.hasMoreElements()) {
                resourceSet.add(eOld.nextElement());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Tr.warning(tc, "unable to access config service meta data", ex);
        }
        String resourceName = "META-INF/ws-configservice-metadata.xml";
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
        } else {
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".configservice-metadata";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
            if (extensionPoint == null) {
                Tr.error(tc, "Unable to get extension point - " + epid);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing extension point " + epid);
                }
                HashSet<Long> bundlesProcessed = new HashSet<Long>();
                IExtension[] extensions = extensionPoint.getExtensions();
                for (int i = 0; i < extensions.length; ++i) {
                    Bundle bundle;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing extension " + extensions[i].getUniqueIdentifier());
                    }
                    if ((bundle = Platform.getBundle((String)extensions[i].getNamespace())) == null) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Null bundle. Invoked outside Eclipse/OSGi environment");
                        break;
                    }
                    long bundleId = bundle.getBundleId();
                    Long bundleIdObj = new Long(bundleId);
                    String bundleName = bundle.getSymbolicName();
                    if (!bundlesProcessed.contains(bundleIdObj)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing bundle " + bundleName + " " + bundleId);
                        }
                        bundlesProcessed.add(bundleIdObj);
                        Enumeration e = null;
                        try {
                            e = bundle.getResources(resourceName);
                        }
                        catch (IOException e1) {
                            Tr.error(tc, "unable to get resources for bundle " + bundleName + " " + bundleId, e1);
                            continue;
                        }
                        if (e == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "unable to get resources for bundle " + bundleName + " " + bundleId);
                            continue;
                        }
                        int numAdded = 0;
                        while (e.hasMoreElements()) {
                            resourceSet.add((URL)e.nextElement());
                            ++numAdded;
                        }
                        if (numAdded != 0 || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "bundle " + bundleName + " " + bundleId + " has no configservice metadata to add");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bundle " + bundleName + " " + bundleId + " has already been processed");
                }
            }
        }
        for (URL u : resourceSet) {
            ConfigServiceMetadata newMetadata = instance.loadMetadata(u);
            if (newMetadata == null) continue;
            instance.mergeMetadata(newMetadata);
        }
    }

    private void mergeMetadata(ConfigServiceMetadata newMetadata) {
        if (this.metadata == null) {
            this.metadata = newMetadata;
        } else {
            this.metadata.getReadOnlyAttributes().addAll(newMetadata.getReadOnlyAttributes());
            this.metadata.getRequiredAttributes().addAll(newMetadata.getRequiredAttributes());
            this.metadata.getResourceProviderTypes().addAll(newMetadata.getResourceProviderTypes());
            this.metadata.getUniqueAttributes().addAll(newMetadata.getUniqueAttributes());
        }
    }

    private ConfigServiceMetadata loadMetadata(URL uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMetadata", uri);
        }
        ConfigServiceMetadata result = null;
        try {
            XMLResourceImpl s = new XMLResourceImpl();
            XMLMapImpl xmlMap = new XMLMapImpl();
            HashMap<String, XMLMapImpl> loadOptions = new HashMap<String, XMLMapImpl>(1);
            loadOptions.put("XML_MAP", xmlMap);
            InputStream ins = uri.openStream();
            s.load(ins, loadOptions);
            EList content = s.getContents();
            if (content.size() > 0) {
                result = (ConfigServiceMetadata)s.getContents().get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Tr.warning(tc, "unable to load META-INF/configservice-metadata.xml in " + uri.getFile(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMetadata", result);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("CSMetadata" + CSMetadataMgr.instance.metadata);
    }

    static {
        instance.init();
    }
}

