/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class AuthorizationTableExtDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(AuthorizationTableExtDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final String[] fileNames = new String[]{"admin-authz.xml", "audit-authz.xml", "naming-authz.xml"};
    private static final String PSEUDO_ATTRIBUTE = "fileName";

    public AuthorizationTableExtDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, "AuthorizationTableExt", null);
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws InvalidConfigDataTypeException {
        AttributeList metaInfo = super.getAttributesMetaInfo(configDataType);
        AttributeList nameAttr = new AttributeList();
        nameAttr.add(new Attribute("_Attribute_MetaInfo_Name", PSEUDO_ATTRIBUTE));
        nameAttr.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        nameAttr.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.FALSE));
        nameAttr.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        nameAttr.add(new Attribute("_Attribute_MetaInfo_Is_Required", Boolean.FALSE));
        nameAttr.add(new Attribute("_Attribute_MetaInfo_Type", "String"));
        metaInfo.add(new Attribute(PSEUDO_ATTRIBUTE, nameAttr));
        return metaInfo;
    }

    public ObjectName[] getAll(Session session, ObjectName scope) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", scope);
        }
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (int i = 0; i < fileNames.length; ++i) {
            this.setDocumentType(this.getDocumentType(fileNames[i]));
            ObjectName[] partialResult = super.getAll(session, scope);
            for (int j = 0; j < partialResult.length; ++j) {
                result.add(this.setFileName(partialResult[j], fileNames[i]));
            }
        }
        this.setDocumentType(null);
        ObjectName[] arrayResult = new ObjectName[result.size()];
        result.toArray(arrayResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", arrayResult);
        }
        return arrayResult;
    }

    protected ObjectName[] getChildren(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildren", new Object[]{parent, relationshipInfo});
        }
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (int i = 0; i < fileNames.length; ++i) {
            this.setDocumentType(this.getDocumentType(fileNames[i]));
            ObjectName[] partialResult = super.getChildren(session, parent, relationshipInfo);
            for (int j = 0; j < partialResult.length; ++j) {
                result.add(this.setFileName(partialResult[j], fileNames[i]));
            }
        }
        this.setDocumentType(null);
        ObjectName[] arrayResult = new ObjectName[result.size()];
        result.toArray(arrayResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildren", arrayResult);
        }
        return arrayResult;
    }

    protected ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent});
        }
        String fileName = this.getPseudoAttribute(attrList);
        if (fileName == null) {
            throw new RequiredAttributeNotFoundException(PSEUDO_ATTRIBUTE);
        }
        RepositoryDocumentType documentType = this.getDocumentType(fileName);
        if (documentType == null) {
            throw new InvalidAttributeValException(PSEUDO_ATTRIBUTE);
        }
        this.setDocumentType(documentType);
        ObjectName result = super.createConfigObject(session, parent, relationshipInfo, attrList);
        this.setDocumentType(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", result);
        }
        return result;
    }

    public AttributeList getAttributes(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)});
        }
        boolean fileNameNeeded = false;
        if (attributes == null) {
            fileNameNeeded = true;
        } else {
            ArrayList<String> attrs = new ArrayList<String>(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].equals(PSEUDO_ATTRIBUTE)) {
                    fileNameNeeded = true;
                    continue;
                }
                attrs.add(attributes[i]);
            }
            attributes = new String[attrs.size()];
            attrs.toArray(attributes);
        }
        AttributeList result = super.getAttributes(session, configData, attributes, recursive);
        if (fileNameNeeded) {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
            String fileName = MOFUtil.getURI(id).path();
            result.add(new Attribute(PSEUDO_ATTRIBUTE, fileName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        Object result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, configData, attribute});
        }
        if (PSEUDO_ATTRIBUTE.equals(attribute)) {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(configData);
            result = MOFUtil.getURI(id).path();
        } else {
            result = super.getAttribute(session, configData, attribute);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    private String getPseudoAttribute(AttributeList attrList) throws InvalidAttributeValException {
        String fileName = null;
        try {
            Object val = ConfigServiceHelper.getAttributeValue(attrList, PSEUDO_ATTRIBUTE);
            if (val != null && !(val instanceof String)) {
                throw new InvalidAttributeValException(PSEUDO_ATTRIBUTE);
            }
            fileName = (String)val;
            ConfigServiceHelper.removeAttribute(attrList, PSEUDO_ATTRIBUTE);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return fileName;
    }

    private RepositoryDocumentType getDocumentType(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocumentType", fileName);
        }
        RepositoryDocumentType docType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells").getChildDocumentType(fileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDocumentType", docType);
        }
        return docType;
    }

    private ObjectName setFileName(ObjectName name, String fileName) {
        return ConfigServiceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(name), this.getType(), fileName);
    }
}

