/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AuthorizationGroupDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(AuthorizationGroupDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public AuthorizationGroupDelegator(ConfigServiceImpl baseConfigService) {
        super(baseConfigService, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("authorizationgroups"));
    }

    public ObjectName createConfigObject(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, parent, relationshipInfo, attrList});
        }
        this.checkAccess(parent);
        final Session sessionFinal = session;
        final ObjectName parentFinal = parent;
        final ConfigObjectDelegator.ChildTypeInfo relationshipInfoFinal = relationshipInfo;
        final AttributeList attrListFinal = attrList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName obj = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.createConfigObjectAsSystem(sessionFinal, parentFinal, relationshipInfoFinal, attrListFinal);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", obj);
            }
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private ObjectName createConfigObjectAsSystem(Session session, ObjectName parent, ConfigObjectDelegator.ChildTypeInfo relationshipInfo, AttributeList attrList) throws ConfigServiceException {
        return super.createConfigObject(session, parent, relationshipInfo, attrList);
    }

    public ObjectName createConfigData(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, parent, attributeName, attrList});
        }
        this.checkAccess(parent);
        final Session sessionFinal = session;
        final ObjectName parentFinal = parent;
        final String attributeNameFinal = attributeName;
        final AttributeList attrListFinal = attrList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName obj = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.createConfigDataAsSystem(sessionFinal, parentFinal, attributeNameFinal, attrListFinal);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigData", obj);
            }
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private ObjectName createConfigDataAsSystem(Session session, ObjectName parent, String attributeName, AttributeList attrList) throws ConfigServiceException {
        return super.createConfigData(session, parent, attributeName, attrList);
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, configData, attrList});
        }
        this.checkAccess(configData);
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        final AttributeList attrListFinal = attrList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.setAttributesAsSystem(sessionFinal, configDataFinal, attrListFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void setAttributesAsSystem(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        super.setAttributes(session, configData, attrList);
    }

    public void resetAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, configData, attrList});
        }
        this.checkAccess(configData);
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        final AttributeList attrListFinal = attrList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.resetAttributesAsSystem(sessionFinal, configDataFinal, attrListFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public void resetAttributesAsSystem(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException {
        super.setAttributes(session, configData, attrList);
    }

    public void addElement(Session session, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, configData});
        }
        this.checkAccess(configData);
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        final String attributeFinal = attribute;
        final Object elementFinal = element;
        final int positionFinal = position;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.addElementAsSystem(sessionFinal, configDataFinal, attributeFinal, elementFinal, positionFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    private void addElementAsSystem(Session session, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException {
        super.addElement(session, configData, attribute, element, position);
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        this.checkAccess(configData);
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.deleteConfigDataAsSystem(sessionFinal, configDataFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    private void deleteConfigDataAsSystem(Session session, ObjectName configData) throws ConfigServiceException {
        super.deleteConfigData(session, configData);
    }

    public void unsetAttributes(Session session, ObjectName configData, String[] attributes) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, configData, attributes});
        }
        this.checkAccess(configData);
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        final String[] attributesFinal = attributes;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.unsetAttributesAsSystem(sessionFinal, configDataFinal, attributesFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    private void unsetAttributesAsSystem(Session session, ObjectName configData, String[] attributes) throws ConfigServiceException {
        super.unsetAttributes(session, configData, attributes);
    }

    public AttributeList getAttributes(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData});
        }
        if (attributes != null && attributes.length == 1 && !attributes[0].equals("name")) {
            this.checkAccess(configData);
        } else if (attributes != null && attributes.length > 1) {
            this.checkAccess(configData);
        }
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        final String[] attributesFinal = attributes;
        final boolean recursiveFinal = recursive;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            AttributeList obj = (AttributeList)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.getAttributesAsSystem(sessionFinal, configDataFinal, attributesFinal, recursiveFinal);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttributes", obj);
            }
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private AttributeList getAttributesAsSystem(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException {
        return super.getAttributes(session, configData, attributes, recursive);
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, configData, attribute});
        }
        if (attribute != null && !attribute.equals("name")) {
            this.checkAccess(configData);
        }
        final Session sessionFinal = session;
        final ObjectName configDataFinal = configData;
        final String attributeFinal = attribute;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            Object obj = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.getAttributeAsSystem(sessionFinal, configDataFinal, attributeFinal);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttribute", obj);
            }
            return obj;
        }
        catch (PrivilegedActionException pae) {
            throw new ConfigServiceException(pae.getException());
        }
        catch (Exception e) {
            throw new ConfigServiceException(e);
        }
    }

    private Object getAttributeAsSystem(Session session, ObjectName configData, String attribute) throws ConfigServiceException {
        return super.getAttribute(session, configData, attribute);
    }

    private void checkAccess(ObjectName obj) throws ConfigServiceException {
        this.checkAccess(obj, "adminsecuritymanager");
    }

    private void checkAccess(ObjectName obj, String roleName) throws ConfigServiceException {
        if (obj == null) {
            return;
        }
        Properties location = ConfigServiceHelper.getObjectLocation(obj);
        String cellName = location.getProperty("cell");
        String res = "cells/" + cellName;
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa != null && !aa.checkAccess(res, roleName)) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0505E", new Object[]{obj}, null);
            throw new ConfigServiceException(msg);
        }
    }
}

