/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.naming.util.ImportProfileUtility;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportStep;
import javax.management.ObjectName;

public class UpdateNameBindingsExt
extends ImportStep {
    private static TraceComponent tc = Tr.register(UpdateNameBindingsExt.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static final String CLASS_NAME;

    public UpdateNameBindingsExt(AbstractTaskCommand taskcmd, CommandMetadata commandmetadata) {
        super(taskcmd, commandmetadata);
    }

    public UpdateNameBindingsExt(AbstractTaskCommand taskcmd, CommandData commanddata) throws CommandNotFoundException {
        super(taskcmd, commanddata);
    }

    protected void executeStep() {
        TaskCommandResultImpl result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeStep");
        }
        if (!(result = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult()).isSuccessful()) {
            return;
        }
        try {
            super.executeStep();
            Session session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "session", session);
            }
            String workSpaceID = WorkspaceHelper.getWorkspace(session).getUserName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "workSpaceID", workSpaceID);
            }
            String nodename = this.getNodeName(session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodename", nodename);
            }
            ImportProfileUtility ipu = ImportProfileUtility.createUtilityInstance((String)workSpaceID, (String)nodename);
            ipu.updateNameBindings();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)(CLASS_NAME + ".executeStep"), (String)"93");
            result.setException((Throwable)new ConfigArchiveException(th, "update node name step failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeStep");
        }
    }

    private String getNodeName(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName");
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = cs.queryConfigObjects(session, null, pattern, null)[0];
        ObjectName nodeObject = cs.getRelationship(session, cell, "Node")[0];
        String nodeName = ConfigServiceHelper.getDisplayName(nodeObject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName", nodeName);
        }
        return nodeName;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.jmx/src/com/ibm/ws/management/configarchive/UpdateNameBindingsExt.java, WAS.admin.jmx, WAS70.SERV1, q0834.18, ver. 1.1");
        }
        CLASS_NAME = UpdateNameBindingsExt.class.getName();
    }
}

