/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportStep;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RemoveNodeSecurityExt
extends ImportStep {
    private static TraceComponent tc = Tr.register(RemoveNodeSecurityExt.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public RemoveNodeSecurityExt(AbstractTaskCommand taskcmd, CommandMetadata commandmetadata) {
        super(taskcmd, commandmetadata);
    }

    public RemoveNodeSecurityExt(AbstractTaskCommand taskcmd, CommandData commanddata) throws CommandNotFoundException {
        super(taskcmd, commanddata);
    }

    protected void executeStep() {
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult();
        if (!result.isSuccessful()) {
            return;
        }
        try {
            super.executeStep();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            String nodeName = (String)this.taskCmd.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName: ", nodeName);
            }
            this.cleanupSecurityConfig(session, cs, nodeName);
            this.cleanupNodeReferences(session, cs, nodeName);
            cs.save(session, true);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.RemoveNodeSecurityExt.executeStep", (String)"82");
            result.setException((Throwable)new ConfigArchiveException(th, "cleanup security step failed"));
        }
    }

    private void cleanupSecurityConfig(Session session, ConfigService cs, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSecurityConfig", new Object[]{nodeName});
        }
        ObjectName secObj = this.getSecurity(session, cs);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellSecurity: ", secObj);
        }
        try {
            int i;
            ArrayList<ObjectName> nodeScopeObjs = new ArrayList<ObjectName>();
            String node = "(node):" + nodeName;
            ObjectName[] managementScopes = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, "ManagementScope"), null);
            for (i = 0; i < managementScopes.length; ++i) {
                ObjectName managementScope = managementScopes[i];
                String scopeName = (String)cs.getAttribute(session, managementScope, "scopeName");
                if (scopeName.indexOf(node) <= 0) continue;
                nodeScopeObjs.add(managementScope);
            }
            if (nodeScopeObjs.size() > 0) {
                for (i = 0; i < nodeScopeObjs.size(); ++i) {
                    ObjectName scopeObj = (ObjectName)nodeScopeObjs.get(i);
                    this.cleanupSecurityObj(session, cs, secObj, "SSLConfigGroup", scopeObj);
                    this.cleanupSecurityObj(session, cs, secObj, "KeyStore", scopeObj);
                    this.cleanupSecurityObj(session, cs, secObj, "SSLConfig", scopeObj);
                    this.cleanupSecurityObj(session, cs, secObj, "KeyManager", scopeObj);
                    this.cleanupSecurityObj(session, cs, secObj, "TrustManager", scopeObj);
                    this.cleanupSecurityObj(session, cs, secObj, "KeySetGroup", scopeObj);
                    this.cleanupSecurityObj(session, cs, secObj, "KeySet", scopeObj);
                    cs.deleteConfigData(session, scopeObj);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.configarchive.RemoveNodeSecurityExt.cleanupSecurityConfig", (String)"155");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSecurityConfig");
        }
    }

    private void cleanupSecurityObj(Session session, ConfigService cs, ObjectName secObj, String objType, ObjectName scopeObj) throws Exception {
        ObjectName[] objs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSecurityObj", new Object[]{secObj, objType, scopeObj});
        }
        if ((objs = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(null, objType), null)) != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                ObjectName obj = objs[i];
                ObjectName mgmScope = (ObjectName)cs.getAttribute(session, obj, "managementScope");
                if (mgmScope == null || !mgmScope.equals(scopeObj)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing " + mgmScope + " from the security configuration");
                }
                cs.deleteConfigData(session, obj);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSecurityObj");
        }
    }

    private void cleanupNodeReferences(Session session, ConfigService cs, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupNodeReference", new Object[]{nodeName});
        }
        String node = "nodes/" + nodeName;
        List clusterList = null;
        try {
            clusterList = this.getClusterWithNode(session, cs, nodeName);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
            ObjectName[] domains = cs.queryConfigObjects(session, null, pattern, null);
            if (domains.length > 0) {
                for (int i = 0; i < domains.length; ++i) {
                    ObjectName domain = domains[i];
                    List members = (List)cs.getAttribute(session, domain, "members");
                    for (AttributeList member : members) {
                        String resourceName = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                        if (resourceName.indexOf(node) > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "removing " + resourceName + " from the security domain");
                            }
                            cs.deleteConfigData(session, ConfigServiceHelper.createObjectName(member));
                            continue;
                        }
                        if (clusterList == null || clusterList.size() <= 0) continue;
                        for (String cluster : clusterList) {
                            if (resourceName.indexOf(cluster) <= 0) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "removing " + resourceName + " from the security domain");
                            }
                            cs.deleteConfigData(session, ConfigServiceHelper.createObjectName(member));
                        }
                    }
                    List postMembers = (List)cs.getAttribute(session, domain, "members");
                    if (members.size() <= 0 || postMembers.size() != 0) continue;
                    cs.deleteConfigData(session, domain);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.configarchive.RemoveNodeSecurityExt.cleanupNodeReference", (String)"251");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupNodeReference");
        }
    }

    private List getClusterWithNode(Session session, ConfigService cs, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterWithNode");
        }
        ArrayList<String> clusterList = new ArrayList<String>();
        try {
            ObjectName[] clusters = null;
            clusters = cs.resolve(session, "ServerCluster");
            block2: for (int i = 0; i < clusters.length; ++i) {
                ObjectName cluster = clusters[i];
                String clusterName = (String)cs.getAttribute(session, cluster, "name");
                clusterList.add("clusters/" + clusterName);
                ObjectName[] members = cs.queryConfigObjects(session, cluster, ConfigServiceHelper.createObjectName(null, "ClusterMember"), null);
                for (int j = 0; j < members.length; ++j) {
                    ObjectName member = members[j];
                    String node = (String)cs.getAttribute(session, member, "nodeName");
                    if (node.equals(nodeName)) continue;
                    clusterList.remove("clusters/" + clusterName);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.configarchive.RemoveNodeSecurityExt.cleanupNodeReference", (String)"290");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterWithNode");
        }
        return clusterList;
    }

    private ObjectName getSecurity(Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurity");
        }
        ObjectName security = cs.resolve(session, null, "Cell=:Security=")[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurity", security);
        }
        return security;
    }
}

