/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportCommand;
import java.util.Collection;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ImportServer
extends ImportCommand {
    private static TraceComponent tc = Tr.register(ImportServer.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private RepositoryContext nodeInArchiveCxt = null;
    private RepositoryContext serverInArchiveCxt = null;
    private RepositoryContext nodeCxt = null;

    public ImportServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportServer(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            String serverName;
            String serverInArchive;
            Collection servers;
            WorkSpace archivews = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            RepositoryMetaData meta = RepositoryMetaDataFactory.getRepositoryMetaData();
            String nodeInArchive = (String)this.getParameter("nodeInArchive");
            Collection nodes = archivews.getRootContext().findContext("nodes", nodeInArchive);
            if (nodes.size() != 1) {
                throw new InvalidParameterValueException(this.getName(), "nodeInArchive", nodeInArchive);
            }
            this.nodeInArchiveCxt = (RepositoryContext)nodes.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeInArchiveCxt", this.nodeInArchiveCxt);
            }
            if ((servers = this.nodeInArchiveCxt.findContext("servers", serverInArchive = (String)this.getParameter("serverInArchive"))).size() != 1) {
                throw new InvalidParameterValueException(this.getName(), "serverInArchive", serverInArchive);
            }
            this.serverInArchiveCxt = (RepositoryContext)servers.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverInArchiveCxt", this.serverInArchiveCxt);
            }
            String nodeName = (String)this.getParameter("nodeName");
            WorkSpace ws = WorkspaceHelper.getWorkspace(this.getConfigSession());
            nodes = ws.getRootContext().findContext("nodes", nodeName);
            if (nodes.size() != 1) {
                throw new InvalidParameterValueException(this.getName(), "nodeName", nodeName);
            }
            this.nodeCxt = (RepositoryContext)nodes.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeCxt", this.nodeCxt);
            }
            if ((servers = this.nodeCxt.findContext("servers", serverName = (String)this.getParameter("serverName"))).size() != 0) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0007E", new Object[]{serverName, nodeName}, null);
                throw new CommandValidationException(msg);
            }
            String coreGrp = (String)this.getParameter("coreGroup");
            if (coreGrp != null && coreGrp.length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "coreGrp", coreGrp);
                }
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "CoreGroup", coreGrp);
                ObjectName[] match = ConfigServiceFactory.getConfigService().queryConfigObjects(this.getConfigSession(), null, pattern, null);
                if (match.length != 1) {
                    throw new InvalidParameterValueException(this.getName(), "coreGroup", coreGrp);
                }
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ImportServer.validate", (String)"89");
            throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setParameter(String paramName, Object value) throws InvalidParameterValueException, InvalidParameterNameException {
        if (ImportServer.tc.isEntryEnabled()) {
            Tr.entry(ImportServer.tc, "setParameter", new Object[]{paramName, value});
        }
        super.setParameter(paramName, value);
        if (paramName.equals("archive")) {
            try {
                ws = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
                meta = RepositoryMetaDataFactory.getRepositoryMetaData();
                nodes = ws.findContext(meta.getContextType("nodes"));
                if (nodes.size() == 1) {
                    this.setParameter("nodeInArchive", ((RepositoryContext)nodes.iterator().next()).getName());
                }
                if ((servers = ws.findContext(meta.getContextType("servers"))).size() != 1) ** GOTO lbl22
                this.setParameter("serverInArchive", ((RepositoryContext)servers.iterator().next()).getName());
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ImportServer.setParameter", (String)"71");
                throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            }
        } else if (paramName.equals("serverInArchive") && this.getParameter("serverName") == null) {
            super.setParameter(paramName, value);
            this.setParameter("serverName", value);
        } else {
            super.setParameter(paramName, value);
        }
lbl22:
        // 4 sources

        if (ImportServer.tc.isEntryEnabled()) {
            Tr.exit(ImportServer.tc, "setParameter");
        }
    }

    public Object[] getChoices(String param) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", param);
        }
        Object[] result = null;
        try {
            Collection nodes;
            RepositoryMetaData meta = RepositoryMetaDataFactory.getRepositoryMetaData();
            WorkSpace archiveWs = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            WorkSpace ws = WorkspaceHelper.getWorkspace(this.getConfigSession());
            if (archiveWs != null) {
                if (param.equals("nodeInArchive")) {
                    nodes = archiveWs.findContext(meta.getContextType("nodes"));
                    result = ConfigArchiveUtils.toNames(nodes);
                }
                if (param.equals("serverInArchive")) {
                    String nodeInArchive = (String)this.getParameter("nodeInArchive");
                    Collection nodes2 = archiveWs.getRootContext().findContext("nodes", nodeInArchive);
                    if (nodes2.size() == 1) {
                        RepositoryContext node = (RepositoryContext)nodes2.iterator().next();
                        List servers = node.getChildren(meta.getContextType("servers"));
                        result = ConfigArchiveUtils.toNames(servers);
                    }
                }
            }
            if (param.equals("nodeName")) {
                nodes = ws.findContext(meta.getContextType("nodes"));
                result = ConfigArchiveUtils.toNames(nodes);
            }
            if (param.equals("coreGroup")) {
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "CoreGroup", null);
                ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                result = new Object[match.length];
                for (int i = 0; i < match.length; ++i) {
                    result[i] = ConfigServiceHelper.getDisplayName(match[i]);
                }
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", ex);
            }
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.ImportServer.getChoices", (String)"105");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices", result);
        }
        return result;
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            result.setResult(this.importServer());
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ImportServer.beforeStepsExecuted", (String)"175");
            result.setException((Throwable)new ConfigArchiveException(th, "importServer command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private ObjectName importServer() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importServer");
        }
        ObjectName svrInArchive = MOFUtil.createObjectName(this.serverInArchiveCxt);
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Session bldSession = this.getConfigArchiveSession();
        AdminCommand cmd = ConfigArchiveUtils.getCreateCommand(cs, session, bldSession, svrInArchive);
        cmd.setTargetObject(this.getParameter("nodeName"));
        cmd.setParameter("name", this.getParameter("serverName"));
        cmd.setParameter("templateName", this.serverInArchiveCxt.getName());
        svrInArchive = WorkspaceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(svrInArchive), ConfigServiceHelper.getConfigDataType(svrInArchive), ConfigServiceHelper.getDisplayName(svrInArchive), bldSession);
        cmd.setParameter("templateLocation", svrInArchive);
        CommandStep configCoreGroup = null;
        try {
            configCoreGroup = ((TaskCommand)cmd).getCommandStep("configCoreGroup");
        }
        catch (CommandNotFoundException ex) {
            // empty catch block
        }
        if (configCoreGroup != null) {
            Object val = this.getParameter("coreGroup");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "coreGroup", val);
            }
            configCoreGroup.setParameter("coregroupName", val);
        }
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        ObjectName svr = null;
        if (!res.isSuccessful()) {
            throw res.getException();
        }
        svr = (ObjectName)res.getResult();
        this.fixSSLConfigAlias(svr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importServer", svr);
        }
        return svr;
    }

    public void setConfigSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigSession", session);
        }
        super.setConfigSession(session);
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
            if (match.length == 1) {
                this.setParameter("nodeName", ConfigServiceHelper.getDisplayName(match[0]));
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ImportServer.setConfigSession", (String)"135");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigSession");
        }
    }

    private void fixSSLConfigAlias(ObjectName svr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixSSLConfigAlias", svr);
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session s = this.getConfigSession();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName[] matches = cs.queryConfigObjects(s, null, pattern, null);
        matches = cs.getRelationship(s, matches[0], "Security");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell level security", matches[0]);
        }
        if ((matches = cs.queryConfigObjects(s, matches[0], pattern = ConfigServiceHelper.createObjectName(null, "SSLConfig"), null)).length > 0) {
            String val;
            int i;
            String newSSLConfig = (String)cs.getAttribute(s, matches[0], "alias");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newSSLConfig", newSSLConfig);
            }
            if ((matches = cs.queryConfigObjects(s, svr, pattern = ConfigServiceHelper.createObjectName(null, "SOAPConnector"), null)) == null || matches.length <= 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fixSSLConfigAlias", "soap connector context not found");
                }
                return;
            }
            ObjectName soapConnector = matches[0];
            AttributeList attrList = new AttributeList();
            List props = (List)cs.getAttribute(s, soapConnector, "properties", false);
            for (ObjectName prop : props) {
                String val2;
                if (!"sslConfig".equals(cs.getAttribute(s, prop, "name")) || !(val2 = (String)cs.getAttribute(s, prop, "value")).endsWith("/DefaultSSLSettings")) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "value", newSSLConfig);
                cs.setAttributes(s, prop, attrList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ssl config alias is update from " + val2 + " to " + newSSLConfig);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "SSLInboundChannel");
            matches = cs.queryConfigObjects(s, svr, pattern, null);
            for (i = 0; i < matches.length; ++i) {
                val = (String)cs.getAttribute(s, matches[i], "sslConfigAlias");
                if (val == null || !val.endsWith("/DefaultSSLSettings")) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "sslConfigAlias", newSSLConfig);
                cs.setAttributes(s, matches[i], attrList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ssl config alias is update from " + val + " to " + newSSLConfig);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "SSLOutboundChannel");
            matches = cs.queryConfigObjects(s, svr, pattern, null);
            for (i = 0; i < matches.length; ++i) {
                val = (String)cs.getAttribute(s, matches[i], "sslConfigAlias");
                if (val == null || !val.endsWith("/DefaultSSLSettings")) continue;
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "sslConfigAlias", newSSLConfig);
                cs.setAttributes(s, matches[i], attrList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ssl config alias is update from " + val + " to " + newSSLConfig);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSSLConfigAlias");
        }
    }
}

