/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ExportCommandBase;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.util.HashSet;
import javax.management.ObjectName;

public class ExportServer
extends ExportCommandBase {
    private static TraceComponent tc = Tr.register(ExportServer.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private ObjectName server;

    public ExportServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportServer(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String nodeName = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        String serverName = (String)this.getParameter("serverName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", serverName);
        }
        try {
            ObjectName[] match = cs.resolve(session, "Node=" + nodeName + ":Server=" + serverName);
            if (match.length != 1) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0005E", new Object[]{nodeName, serverName}, null);
                throw new CommandValidationException(msg);
            }
            this.server = match[0];
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ExportServer.validate", (String)"62");
            throw new CommandValidationException(th, "validation for command ExportServer failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.exportServer(this.server);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ExportServer.beforeStepsExecuted", (String)"159");
            result.setException((Throwable)new ConfigArchiveException(th, "exportServer command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String paramName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", paramName);
        }
        Object[] result = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (paramName.equals("serverName")) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                result = new String[match.length];
                for (int i = 0; i < match.length; ++i) {
                    result[i] = ConfigServiceHelper.getDisplayName(match[i]);
                }
            } else if (paramName.equals("nodeName")) {
                HashSet<String> nodes = new HashSet<String>();
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server", (String)this.getParameter("serverName"));
                ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < match.length; ++i) {
                    String nodeName = ConfigServiceHelper.getObjectLocation(match[i]).getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName", nodeName);
                    }
                    nodes.add(nodeName);
                }
                result = nodes.toArray();
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ExportServer.getChoices", (String)"111");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return result;
    }

    public void setConfigSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigSession", session);
        }
        super.setConfigSession(session);
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
            if (match.length == 1) {
                this.setParameter("nodeName", ConfigServiceHelper.getDisplayName(match[0]));
                pattern = ConfigServiceHelper.createObjectName(null, "Server");
                match = cs.queryConfigObjects(session, match[0], pattern, null);
                if (match.length == 1) {
                    this.setParameter("severName", ConfigServiceHelper.getDisplayName(match[0]));
                }
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ExportServer.setConfigSession", (String)"135");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigSession");
        }
    }

    public void setParameter(String paramName, Object value) throws InvalidParameterValueException, InvalidParameterNameException {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setParameter", new Object[]{paramName, value});
            }
            super.setParameter(paramName, value);
            if (paramName.equals("serverName") && this.getParameter("nodeName") == null) {
                try {
                    ConfigService cs = ConfigServiceFactory.getConfigService();
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server", (String)value);
                    ObjectName[] match = cs.queryConfigObjects(this.getConfigSession(), null, pattern, null);
                    if (match.length == 1) {
                        String nodeName = ConfigServiceHelper.getObjectLocation(match[0]).getProperty("node");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeName", nodeName);
                        }
                        this.setParameter("nodeName", nodeName);
                    }
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "unexpected exception", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }
}

