/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.configarchive.ExportCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ExportCommandBase
extends ExportCommand {
    private static TraceComponent tc = Tr.register(ExportCommandBase.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public ExportCommandBase(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportCommandBase(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectName exportServer(ObjectName server) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportServer", server);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        WorkSpace archiveWorkspace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
        Properties props = ConfigServiceHelper.getObjectLocation(server);
        String cellName = props.getProperty("cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName", cellName);
        }
        String nodeName = props.getProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        String serverName = props.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", serverName);
        }
        RepositoryContext contextInArchive = archiveWorkspace.getRootContext();
        contextInArchive = ConfigArchiveUtils.createContextIfNeeded(contextInArchive, "cells", cellName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context in archive", contextInArchive);
        }
        contextInArchive = ConfigArchiveUtils.createContextIfNeeded(contextInArchive, "nodes", nodeName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node context in archive", contextInArchive);
        }
        TemplateManager tm = TemplateManagerFactory.getManager((WorkSpace)archiveWorkspace);
        RepositoryContext nodeContext = (RepositoryContext)workspace.getRootContext().findContext("nodes", nodeName).iterator().next();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node context", nodeContext);
        }
        tm.createFile(contextInArchive, "node-metadata.properties", tm.getTemplate(nodeContext), null);
        if (!contextInArchive.isAvailable("serverindex.xml")) {
            ObjectName node = MOFUtil.createObjectName(nodeContext);
            ObjectName serverindex = configService.getRelationship(session, node, "ServerIndex")[0];
            AttributeList attrList = configService.getAttributes(session, serverindex, new String[]{"hostName"}, false);
            ObjectName nodeInArchiveId = MOFUtil.createObjectName(contextInArchive);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeInArchiveId", nodeInArchiveId);
            }
            Session archiveSession = this.getConfigArchiveSession();
            serverindex = configService.createConfigData(archiveSession, nodeInArchiveId, "ServerIndex", "ServerIndex", attrList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverindex in archive", serverindex);
            }
        }
        ConfigDataId id = new ConfigDataId(contextInArchive.getURI(), null);
        ObjectName templateLocation = WorkspaceHelper.createObjectName(id, "Node", nodeName, this.getConfigArchiveSession());
        AdminCommand cmd = ConfigArchiveUtils.getCreateTemplateCommand(configService, session, server);
        cmd.setParameter("nodeName", nodeName);
        cmd.setParameter("serverName", serverName);
        cmd.setParameter("templateName", serverName);
        cmd.setParameter("templateLocation", templateLocation);
        try {
            EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            cmd.execute();
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            EndpointConfigHelper.setAdjustFlag(new Boolean(true));
            throw throwable;
        }
        EndpointConfigHelper.setAdjustFlag(new Boolean(true));
        CommandResult cmdResult = cmd.getCommandResult();
        if (!cmdResult.isSuccessful()) {
            throw cmdResult.getException();
        }
        ObjectName serverInArchive = (ObjectName)cmdResult.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportServer", serverInArchive);
        }
        return serverInArchive;
    }

    protected ObjectName exportCluster(ObjectName cluster) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportCluster", cluster);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        WorkSpace archiveWorkspace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
        Properties props = ConfigServiceHelper.getObjectLocation(cluster);
        String cellName = props.getProperty("cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName", cellName);
        }
        String clusterName = props.getProperty("cluster");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusterName", clusterName);
        }
        RepositoryContext contextInArchive = archiveWorkspace.getRootContext();
        contextInArchive = ConfigArchiveUtils.createContextIfNeeded(contextInArchive, "cells", cellName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context in archive", contextInArchive);
        }
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType type = metadata2.getContextType("cells");
        RepositoryContext context = workspace.getRootContext().getChild(type, cellName);
        type = metadata2.getContextType("clusters");
        context = context.getChild(type, clusterName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cluster context", context);
        }
        RepositoryContext child = ConfigArchiveUtils.copyContext(contextInArchive, context, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cluster context in archive", contextInArchive);
        }
        this.exportDmgrNodeProperties();
        ConfigDataId id = new ConfigDataId(child.getURI(), child.getType().getRootDocumentType().getFilePattern());
        ObjectName clusterInArchive = ConfigServiceHelper.createObjectName(id, "ServerCluster", clusterName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusterin archive", clusterInArchive);
        }
        List members = this.getClusterMembers(cluster);
        for (ObjectName member : members) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "member", member);
            }
            ObjectName memberInArchive = this.exportServer(member);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberInArchive", memberInArchive);
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, "clusterName", clusterName);
            configService.setAttributes(this.getConfigArchiveSession(), memberInArchive, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportCluster");
        }
        return clusterInArchive;
    }

    protected List getClusterMembers(ObjectName cluster) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterMembers", cluster);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        List members = (List)configService.getAttribute(session, cluster, "members");
        for (AttributeList member : members) {
            String memberName = (String)ConfigServiceHelper.getAttributeValue(member, "memberName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberName", memberName);
            }
            String nodeName = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", nodeName);
            }
            ObjectName[] match = configService.resolve(session, "Node=" + nodeName + ":Server=" + memberName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "match", match);
            }
            result.addAll(Arrays.asList(match));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterMembers", result);
        }
        return result;
    }

    protected void exportDmgrNodeProperties() throws Throwable {
    }
}

