/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConfigArchiveRepositoryAdapter
implements WorkSpaceRepositoryAdapter,
WorkSpaceMessage,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ConfigArchiveRepositoryAdapter.class);
    private static boolean init = false;
    private static RepositoryMetaData defaultMetaData = null;

    public String[] getCatalog(WorkSpace workspace, String uri, int type, int depth) throws WorkSpaceException {
        FileAccessor fa = ((WorkSpaceImpl)workspace).getFileAccessor();
        String path = this.getURI(workspace, uri);
        List list = FileAccessorUtil.listFiles((FileAccessor)fa, (String)path, (int)type, (int)depth);
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String fileURI = (String)list.get(i);
            int index = path.length() == 0 ? 0 : path.length() + 1;
            fileURI = fileURI.substring(index);
            result[i] = fileURI = fileURI.replace(FILE_SEPERATOR_CHAR, '/');
        }
        return result;
    }

    private String getURI(WorkSpace workspace, String uri) {
        StringBuffer path = new StringBuffer("");
        path.append(uri);
        return path.toString();
    }

    public boolean exist(WorkSpace workspace, String uri) throws WorkSpaceException {
        FileAccessor fa = ((WorkSpaceImpl)workspace).getFileAccessor();
        return FileAccessorUtil.exist((FileAccessor)fa, (String)this.getURI(workspace, uri));
    }

    public Integer checkSynchState(WorkSpaceFile file) throws WorkSpaceException {
        return ConflictState.UN_MODIFIED;
    }

    public void update(Map[] files) throws WorkSpaceException {
    }

    public void extract(WorkSpaceFile file) throws WorkSpaceException {
    }

    public void release(WorkSpaceFile file) throws WorkSpaceException {
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        if (ws.cleanupNeeded()) {
            FileAccessorUtil.deleteTree((FileAccessor)fa, (String)file.getURI());
        }
    }

    public void release(RepositoryContext context) throws WorkSpaceException {
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        if (ws.cleanupNeeded()) {
            FileAccessorUtil.deleteTree((FileAccessor)fa, (String)context.getURI());
        }
    }

    public void delete(RepositoryContext context) throws WorkSpaceException {
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        FileAccessorUtil.deleteTree((FileAccessor)fa, (String)context.getURI());
    }

    public void delete(WorkSpaceFile file) throws WorkSpaceException {
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        FileAccessorUtil.delete((FileAccessor)fa, (String)file.getURI());
    }

    public void setSessionId(WorkSpace ws) throws WorkSpaceException {
    }

    public void unsetSessionId(WorkSpace ws) throws WorkSpaceException {
    }

    public boolean isValid(WorkSpace ws) throws WorkSpaceException {
        return true;
    }

    public void initialize(Properties prop) throws WorkSpaceException {
    }

    public void remove(WorkSpace ws) throws WorkSpaceException {
        FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
        if (((WorkSpaceImpl)ws).cleanupNeeded()) {
            FileAccessorUtil.deleteTree((FileAccessor)fa, (String)"");
        }
    }

    public void save(RepositoryContext context) throws WorkSpaceException {
        Object bw = null;
        String path = context.getURI();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saving Context: (" + context.getState() + ") " + path);
        }
        try {
            FileAccessorUtil.makeDir((FileAccessor)fa, (String)path);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved  Context: (" + context.getState() + ") " + path);
            }
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException((TraceComponent)tc, (String)"WKSP0006E Error while saving context {0}-{1}", (Object[])new Object[]{context.getName(), e}, (Throwable)e);
        }
    }

    public String restore(RepositoryContext context) throws WorkSpaceException {
        return null;
    }

    public RepositoryMetaData getMetaData() {
        return this.getDefaultMetaData();
    }

    private RepositoryMetaData getDefaultMetaData() {
        if (defaultMetaData == null) {
            defaultMetaData = RepositoryMetaDataFactory.getFactory().getMetaData();
        }
        return defaultMetaData;
    }
}

