/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerImpl;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ConfigArchiveComposer {
    private static TraceComponent tc = Tr.register(ConfigArchiveComposer.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static final int MAXBYTES = 2048;
    static final String BUNDLE_WORKSPACE_PATH_NAME = WorkSpaceConstant.WORKSPACE_PATH_NAME + File.separator;

    public static WorkSpace createConfigArchive(String archiveName, FileAccessor fileAccessor) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigArchive " + archiveName + " " + fileAccessor);
        }
        String wsId = archiveName;
        WorkSpace ws = null;
        String location = BUNDLE_WORKSPACE_PATH_NAME;
        ws = ConfigArchiveComposer.getWorkSpace(wsId, location, fileAccessor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigArchive");
        }
        return ws;
    }

    public static Session createConfigArchiveSession(String archiveName, FileAccessor fileAccessor) throws ConfigArchiveException {
        WorkSpace ws = ConfigArchiveComposer.createConfigArchive(archiveName, fileAccessor);
        return new Session(ws.getUserName(), true);
    }

    public static WorkSpace loadConfigArchive(File archive, FileAccessor fileAccessor) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfigArchive " + archive + " " + fileAccessor);
        }
        String wsId = null;
        WorkSpace ws = null;
        String location = BUNDLE_WORKSPACE_PATH_NAME;
        wsId = ConfigArchiveComposer.getWsId(archive);
        ws = ConfigArchiveComposer.getWorkSpace(wsId, location, fileAccessor);
        ConfigArchiveComposer.loadArchiveToWorkSpace(ws, archive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigArchive");
        }
        return ws;
    }

    public static Session loadConfigArchiveSession(File archive, FileAccessor fileAccessor) throws ConfigArchiveException {
        WorkSpace ws = ConfigArchiveComposer.loadConfigArchive(archive, fileAccessor);
        return new Session(ws.getUserName(), true);
    }

    public static void saveConfigArchive(String archiveName, File archive) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveConfigArchive " + archiveName + " " + archive);
        }
        String wsId = archiveName;
        WorkSpace ws = null;
        if (wsId == null) {
            throw new ConfigArchiveException("No archive name specified for saveConfigArchive");
        }
        Properties props = new Properties();
        props.setProperty("workspace.user.id", wsId);
        try {
            ws = WorkSpaceManagerFactory.getManager().getWorkSpace(props);
        }
        catch (Exception e) {
            throw new ConfigArchiveException((Throwable)e, "Failed to create workspace for archive");
        }
        ConfigArchiveComposer.saveConfigArchiveFromWorkspace(ws, archiveName, archive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveConfigArchive");
        }
    }

    public static void unloadConfigArchive(String archiveName) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unloadConfigArchive ", archiveName);
        }
        String wsId = archiveName;
        WorkSpace ws = null;
        Properties props = new Properties();
        if (wsId != null) {
            props.setProperty("workspace.user.id", wsId);
        }
        try {
            ws = WorkSpaceManagerFactory.getManager().getWorkSpace(props);
        }
        catch (Exception e) {
            throw new ConfigArchiveException((Throwable)e, "Failed to create workspace for archive");
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            cs.discard(new Session(archiveName, true));
        }
        catch (Exception e) {
            throw new ConfigArchiveException((Throwable)e, "Failed to unload archive related files from workspace");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unloadConfigArchive");
        }
    }

    private static String getWsId(File archive) {
        if (archive != null) {
            return archive.getName();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static void loadArchiveToWorkSpace(WorkSpace ws, File archive) throws ConfigArchiveException {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadArchiveToWorkSpace " + ws + " " + archive);
            }
            if (archive == null) {
                return;
            }
            FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
            ZipFile zipFile = null;
            String userPath = ws.getUserPath();
            zipFile = new ZipFile(archive, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int nbytes;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                String wsFileName = fileName.replace('\\', '/');
                OutputStream os = fa.getOutputStream(wsFileName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loading  " + wsFileName + " into workspace");
                }
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                BufferedOutputStream bos = new BufferedOutputStream(os, 2048);
                byte[] data = new byte[2048];
                while ((nbytes = is.read(data, 0, 2048)) != -1) {
                    bos.write(data, 0, nbytes);
                }
                bos.flush();
                bos.close();
                is.close();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "loaded  " + wsFileName + " into workspace.");
            }
            Object var15_15 = null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block16;
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ConfigArchiveComposer.loadConfigArchive", (String)"321");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", th);
                }
                break block16;
            }
            {
                catch (Exception e) {
                    throw new ConfigArchiveException((Throwable)e, "Failed to unload archive archive to workspace");
                }
            }
            catch (Throwable throwable) {
                block17: {
                    Object var15_16 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (Throwable th) {
                        FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.ConfigArchiveComposer.loadConfigArchive", (String)"321");
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug(tc, "unexpected exception", th);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadArchiveToWorkSpace");
        }
    }

    private static void saveConfigArchiveFromWorkspace(WorkSpace ws, String archiveName, File archive) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveConfigArchiveFromWorkspace " + ws + " " + archiveName + " " + archive);
        }
        FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
        try {
            String userPath = ws.getUserPath();
            byte[] buf = new byte[2048];
            File parent = archive.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive));
            List fils = new ArrayList();
            fils = ws.getRootContext().getAllList(true);
            for (int i = 0; i < fils.size(); ++i) {
                int len;
                WorkSpaceFile file = (WorkSpaceFile)fils.get(i);
                String uri = file.getURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "saving  " + uri);
                }
                if (!fa.exists(uri)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "file does not exist  " + uri);
                    continue;
                }
                InputStream fin = fa.load(uri);
                String pathname = uri;
                zos.putNextEntry(new ZipEntry(pathname));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "saving  " + fin);
                }
                while ((len = fin.read(buf, 0, 2048)) > 0) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                fin.close();
            }
            zos.close();
        }
        catch (Exception e) {
            throw new ConfigArchiveException((Throwable)e, "Failed to load archive archive from workspace");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveConfigArchiveFromWorkspace");
        }
    }

    public static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataHelper", session);
        }
        ManagedObjectMetadataHelper result = null;
        try {
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            result = ws.getMetadataHelper();
        }
        catch (Exception ex) {
            throw new ConfigArchiveException((Throwable)ex, "fail to get ManagedObjectMetadataHelper for session " + session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataHelper", result);
        }
        return result;
    }

    private static WorkSpace getWorkSpace(String wsId, String location, FileAccessor fileAccessor) throws ConfigArchiveException {
        int MAX_ATTEMPTS = 20;
        WorkSpace ws = null;
        int attempts = 0;
        while (ws == null) {
            Properties props = new Properties();
            if (wsId == null) {
                wsId = "archive" + System.currentTimeMillis();
            }
            props.setProperty("workspace.user.id", wsId);
            props.setProperty("workspace.repository.adapter", "com.ibm.ws.management.configarchive.ConfigArchiveRepositoryAdapter");
            location = location + wsId;
            if (fileAccessor != null) {
                props.put("workspace.file.accessor", fileAccessor);
            } else {
                props.setProperty("workspace.root", location);
            }
            try {
                WorkSpaceManagerImpl wmgr = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
                ws = wmgr.createUniqueWorkSpace(props);
            }
            catch (Exception e) {
                ws = null;
            }
            if (ws == null) {
                ++attempts;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (attempts <= MAX_ATTEMPTS) continue;
            throw new ConfigArchiveException("Failed to create workspace for archive");
        }
        return ws;
    }
}

