/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import javax.management.ObjectName;

public class CleanupNode
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CleanupNode.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private ObjectName nodeId = null;
    private String nodeName = null;

    public CleanupNode(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public CleanupNode(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node", this.nodeName);
            ObjectName[] match = cs.queryConfigObjects(this.getConfigSession(), null, pattern, null);
            if (match.length != 1) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0009E", new Object[]{this.nodeName}, null);
                throw new CommandValidationException(msg);
            }
            this.nodeId = match[0];
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configarchive.CleanupNode.validate", (String)"63");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", ex);
            }
            CommandValidationException exception = new CommandValidationException(ex, "unexpected exception during validation");
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.removeApplicationsFromNode(this.nodeName);
            try {
                this.removeNodeFromAllNodeGroups();
            }
            catch (Throwable thw) {
                FFDCFilter.processException((Throwable)thw, (String)"com.ibm.ws.management.configarchive.CleanupNode.beforeStepsExecuted", (String)"99");
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.CleanupNode.beforeStepsExecuted", (String)"175");
            result.setException(new CommandException(th, "cleanupNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            Session session = this.getConfigSession();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] match = cs.queryConfigObjects(this.getConfigSession(), this.nodeId, pattern, null);
            for (int i = 0; i < match.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "match[" + i + "]", match[i]);
                }
                cs.deleteConfigData(session, match[i]);
            }
            cs.deleteConfigData(session, this.nodeId);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.configarchive.CleanupNode.afterStepsExecuted", (String)"126");
            result.setException(new CommandException(th, "cleanupNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private void removeApplicationsFromNode(String nodeName) throws Exception {
        AppManagement appmgmt = CommandMgr.getCommandMgr().getCommandProviderHelper().getAppManagement();
        Session session = this.getConfigSession();
        String wsId = session.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wsId", wsId);
        }
        String cellName = ConfigArchiveUtils.getCellName();
        appmgmt.removeAllAppsFromNode(nodeName, cellName, null, wsId);
    }

    private void removeNodeFromAllNodeGroups() throws Throwable {
        Session session = this.getConfigSession();
        Object th = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand cmd = cmdMgr.createCommand("removeNodeFromNodeGroups");
        cmd.setConfigSession(session);
        cmd.setTargetObject(this.nodeName);
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            throw result.getException();
        }
    }
}

