/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.MissingResourceException;

public class PluginConfigServiceImpl
extends ComponentImpl {
    private static TraceComponent tc = Tr.register(PluginConfigServiceImpl.class, "PLUGINCFG", "com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
    private VariableMap variableMap = null;
    private Repository repository = null;
    private static boolean started = false;
    protected static TraceNLS nls;
    static String className;

    protected void setState(String state) {
        try {
            super.setState(state);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(className + "setState"), (String)"1", (Object)((Object)this));
        }
    }

    public void initialize(Object config) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        String m = "initialize: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, m);
        }
        this.setState("INITIALIZING");
        super.initialize(config);
        this.setState("INITIALIZED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, m);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        String m = "start: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, m);
        }
        this.setState("STARTING");
        super.start();
        this.setState("STARTED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, m);
        }
    }

    public void stop() {
        String m = "stop: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, m);
        }
        this.setState("STOPPING");
        super.stop();
        this.setState("STOPPED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, m);
        }
    }

    public void destroy() {
        String m = "destroy: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, m);
        }
        this.setState("DESTROYING");
        super.destroy();
        this.setState("DESTROYED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, m);
        }
    }

    public void initializePluginConfigService(ConfigObject pluginConfigService) {
        String m;
        block25: {
            block24: {
                m = "initializePluginConfigService: ";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, m);
                }
                try {
                    nls = TraceNLS.getTraceNLS("com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
                }
                catch (MissingResourceException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.plugincfg.initializers.PluginConfigService.initialize", (String)"26");
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, m + "Unable to Find NLS Resources: " + ex.getMessage());
                }
            }
            this.setState("INITIALIZING");
            try {
                if (AdminHelper.getPlatformHelper().isZOS() && !AdminHelper.getPlatformHelper().isControlJvm()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, m + "Plugin config service is started only in the control region.");
                    }
                } else {
                    String pType;
                    this.variableMap = (VariableMap)this.getService(VariableMap.class);
                    this.repository = (Repository)this.getService(Repository.class);
                    ConfigObject wccmServerCO = this.getServer();
                    List serverComponents = wccmServerCO.getObjectList("components");
                    boolean nodeAgentFound = false;
                    boolean cellManagerFound = false;
                    boolean appServerFound = false;
                    boolean wasNodeFound = false;
                    for (int i = 0; i < serverComponents.size(); ++i) {
                        ConfigObject s = (ConfigObject)serverComponents.get(i);
                        if (s.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/nodeagent.xmi", "NodeAgent")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, m + "Found an instance of NodeAgent");
                            }
                            nodeAgentFound = true;
                            continue;
                        }
                        if (s.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/cellmanager.xmi", "CellManager")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, m + "Found an instance of CellManager");
                            }
                            cellManagerFound = true;
                            continue;
                        }
                        if (!s.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, m + "Found an instance of ApplicationServer");
                        }
                        appServerFound = true;
                    }
                    AdminService adminServ = AdminServiceFactory.getAdminService();
                    if (adminServ != null && (pType = adminServ.getProcessType()) != null) {
                        if (cellManagerFound || pType.equals("UnManagedProcess")) {
                            this.registerWebServerMBean(this.repository.getRootURI());
                            this.registerPluginCfgMBean();
                        } else {
                            wasNodeFound = true;
                        }
                    }
                    if (pluginConfigService != null) {
                        boolean enabled = pluginConfigService.getBoolean("enable", false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, m + "PluginConfigService enabled=" + enabled);
                        }
                        if (!enabled) {
                            Tr.info(tc, "pluginconfigservice.notstarted");
                        } else {
                            String className = "com.ibm.websphere.plugincfg.initializers.PluginRepositoryListener";
                            Class<?> PluginRepositoryListener = Class.forName(className);
                            if (PluginRepositoryListener != null) {
                                Class[] paramTypes = new Class[]{Repository.class, VariableMap.class, TraceNLS.class, Boolean.class, Boolean.class};
                                Method method = PluginRepositoryListener.getMethod("createInstance", paramTypes);
                                method.invoke(null, this.repository, this.variableMap, nls, new Boolean(cellManagerFound), new Boolean(wasNodeFound));
                            }
                            Tr.info(tc, "pluginconfigservice.started");
                            started = true;
                        }
                    } else {
                        Tr.info(tc, "pluginconfigservice.notstarted");
                    }
                }
            }
            catch (Throwable e) {
                Tr.error(tc, "pluginconfigservice.starterror");
                if (!tc.isDebugEnabled()) break block25;
                Tr.debug(tc, m + e.getMessage());
            }
        }
        this.setState("INITIALIZED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, m);
        }
    }

    private void registerPluginCfgMBean() {
        block3: {
            String m = "registerPluginCfgMBean: ";
            try {
                String className = "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator";
                Class<?> PluginConfigGenerator = Class.forName(className);
                Object generator = PluginConfigGenerator.newInstance();
                AdminServiceFactory.getMBeanFactory().activateMBean("PluginCfgGenerator", (RuntimeCollaborator)generator, "PluginCfgGenerator", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, m + "Plugin config generator MBean is registered.");
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.PluginConfigServiceImpl", (String)"329", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, m + "Unable to register plugin config generator MBean.");
            }
        }
    }

    private void registerWebServerMBean(String rootURI) {
        block3: {
            String m = "registerWebServerMBean: ";
            try {
                String className = "com.ibm.ws.management.webserver.WebServer";
                Class<?> WebServer2 = Class.forName(className);
                Class[] args = new Class[]{String.class};
                Constructor<?> webCtor = WebServer2.getConstructor(args);
                Object webserver = webCtor.newInstance(rootURI);
                AdminServiceFactory.getMBeanFactory().activateMBean("WebServer", (RuntimeCollaborator)webserver, "WebServer", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, m + "WebServer MBean is registered.");
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.PluginConfigServiceImpl", (String)"330", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, m + "Unable to register WebServer operations MBean.");
            }
        }
    }

    private ConfigObject getServer() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServer");
        }
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        ConfigScope scope = configService.createScope(4);
        List resource = configService.getDocumentObjects(scope, "server.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServer", (ConfigObject)resource.get(0));
        }
        return (ConfigObject)resource.get(0);
    }

    static {
        className = "com.ibm.ws.management.component.PluginConfigServiceImpl.";
    }
}

