/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.metadata.NodeAgentCollector;
import com.ibm.ws.management.nodeagent.Forwarder;
import com.ibm.ws.management.service.NodeAgent;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class NodeAgentImpl
extends ComponentImpl
implements NodeAgent {
    private static TraceComponent tc = Tr.register(NodeAgentImpl.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private ConfigObject nodeAgent;
    private static final int UUID_LENGTH = 16;
    private VariableMap variableMap = null;
    private SecurityService securityService = null;
    private NodeSync nodeSync = null;

    public void initialize(Object config) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        ConfigObject temp;
        ConfigObject stateMgmt;
        String initialState;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        if ((initialState = (stateMgmt = (temp = (ConfigObject)config).getObject("stateManagement")).getString("initialState", "START")).equals("STOP")) {
            throw new ComponentDisabledException();
        }
        this.nodeAgent = (ConfigObject)config;
        this.addService(NodeAgent.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            try {
                this.variableMap = (VariableMap)this.getService(VariableMap.class);
                this.registerAgentMBean();
                this.startFileTransferService();
                NodeAgentCollector naCollector = new NodeAgentCollector();
                this.initializeNodeSync();
                String os = System.getProperty("os.name");
                if (os != null && os.equalsIgnoreCase("os/400")) {
                    try {
                        ConfigRepositoryListener lstnr = (ConfigRepositoryListener)Class.forName("com.ibm.ws.os400.RepositoryChangedListener").newInstance();
                        ConfigRepositoryFactory.getConfigRepository().addListener(lstnr);
                    }
                    catch (Throwable th) {
                        Tr.error(tc, "ADMN0064E", th);
                    }
                }
                Object var5_6 = null;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.NodeAgentImpl.start", (String)"89", (Object)this);
                throw new RuntimeError(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.releaseService(this.variableMap);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "start");
            throw throwable;
        }
        this.releaseService(this.variableMap);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "start");
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this.nodeSync != null) {
            this.nodeSync.stop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
    }

    protected String getUuid(long id) {
        String uuid = Long.toHexString(id);
        if (uuid.length() < 16) {
            for (int i = 16 - uuid.length(); i > 0; --i) {
                uuid = uuid + "0";
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startFileTransferService() {
        ConfigObject wccmftcfg = this.nodeAgent.getObject("fileTransferService");
        if (wccmftcfg == null) return;
        if (!wccmftcfg.getBoolean("enable", false)) {
            return;
        }
        FileTransferConfig ftConfig = null;
        try {
            Class<?> ftConfigClass = Class.forName("com.ibm.ws.management.filetransfer.FileTransferConfigImpl");
            ftConfig = (FileTransferConfig)ftConfigClass.newInstance();
        }
        catch (Throwable e) {
            Tr.error(tc, "ADMN0016E", e);
        }
        ftConfig.setTransferRequestTimeout(new Integer(wccmftcfg.getInt("retryWaitTime", 0)));
        ftConfig.setTransferRetryCount(new Integer(wccmftcfg.getInt("retriesCount", 0)));
        ftConfig.setVariableMap((Object)this.variableMap);
        Properties props = ComponentImpl.getProperties((ConfigObject)wccmftcfg);
        if (props == null) {
            props = new Properties();
        } else {
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = props.getProperty(key);
                value = this.variableMap.expand(value);
                props.put(key, value);
            }
        }
        ftConfig.setProperties(props);
        try {
            try {
                FileTransferFactory.initialize((FileTransferConfig)ftConfig);
            }
            catch (Throwable e) {
                Tr.error(tc, "ADFS0102", e);
                Object var8_10 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "initialize");
                return;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "initialize");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "initialize");
    }

    private void initializeNodeSync() throws ConfigurationWarning {
        Properties p = new Properties();
        ConfigObject syncCfg = this.nodeAgent.getObject("fileSynchronizationService");
        List props = syncCfg.getObjectList("properties");
        for (ConfigObject prop : props) {
            p.setProperty(prop.getString("name", "__null__"), prop.getString("value", "__null__"));
        }
        List exclusions = null;
        if (syncCfg != null) {
            p.setProperty("was.sync.processType", "NodeAgent");
            p.setProperty("was.sync.autoSyncEnabled", new Boolean(syncCfg.getBoolean("autoSynchEnabled", false)).toString());
            p.setProperty("was.sync.syncInterval", new Integer(syncCfg.getInt("synchInterval", 0)).toString());
            p.setProperty("was.sync.serverStartupSyncEnabled", new Boolean(syncCfg.getBoolean("synchOnServerStartup", false)).toString());
            exclusions = syncCfg.getStringList("exclusions");
            try {
                this.nodeSync = NodeSync.createNodeSync();
                if (this.nodeSync != null) {
                    this.nodeSync.initialize(p, exclusions, this.variableMap);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initializeNodeSync", (String)"604", (Object)this);
                throw new ConfigurationWarning("Problem initializing node sync.", e);
            }
        }
    }

    private void registerAgentMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAgentMBeans");
        }
        ConfigService configService = (ConfigService)WsServiceRegistry.getService((Object)this, ConfigService.class);
        Server server = (Server)this.getService(Server.class);
        ThreadPoolMgr tpMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
        Forwarder.initReceiver(configService, this.variableMap, tpMgr);
        Forwarder.serverListenerRegistration(server);
        this.releaseService(server);
        this.releaseService(tpMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAgentMBeans");
        }
    }

    public SecurityService registerSecurityService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSecurityService");
        }
        this.securityService = (SecurityService)this.getService(SecurityService.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSecurityService");
        }
        return this.securityService;
    }
}

