/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.jvm.Dump;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.DumpNotSupportedException;
import com.ibm.websphere.management.exception.DumpOnDiskLimitReachedException;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.websphere.management.exception.HeapDumpOnDiskLimitReachedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.Notification;

public class JVMMBean
extends J2EEManagedObjectCollaborator {
    private static final TraceComponent tc = Tr.register(JVMMBean.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static final String bundleName = "com.ibm.ws.management.resources.adminservice";
    private static final TraceNLS bundleNLS = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.adminservice");
    private int seqNum = 0;
    private int maxDumpsOnDisk = 10;
    private int maxSystemDumpsOnDisk = 10;
    private MBeanServer platformMBeanServer = null;
    private MemoryMXBean mxbean = null;
    private static final boolean isZOS = AdminHelper.getPlatformHelper().isZOS();

    public String getTotalMemory() {
        Runtime rt = Runtime.getRuntime();
        String mem = new Long(rt.totalMemory()).toString();
        return mem;
    }

    public void setVerbose(boolean verbose, String processType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose " + verbose + " " + processType);
        }
        try {
            if (this.platformMBeanServer == null) {
                this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (isZOS) {
                if (processType.equals("Servant") && AdminHelper.getPlatformHelper().isServantJvm() && !AdminHelper.getPlatformHelper().isCRAJvm() || processType.equals("Adjunct") && AdminHelper.getPlatformHelper().isCRAJvm()) {
                    this.setVerbose(verbose);
                }
            } else {
                this.setVerbose(verbose);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.JVMMBean.setVerbose", (String)"70", (Object)((Object)this));
            Tr.debug(tc, "Could not set verbose on JVM", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose " + verbose + " " + processType);
        }
    }

    public void setVerbose(boolean verbose) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose " + verbose);
        }
        if (this.mxbean == null) {
            this.mxbean = ManagementFactory.getMemoryMXBean();
        }
        if (this.mxbean != null) {
            this.mxbean.setVerbose(verbose);
        } else {
            Tr.debug(tc, "MemoryMXBean not registered");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose");
        }
    }

    public boolean isVerbose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVerbose");
        }
        boolean isVerbose = false;
        if (this.mxbean == null) {
            this.mxbean = ManagementFactory.getMemoryMXBean();
        }
        if (this.mxbean != null) {
            isVerbose = this.mxbean.isVerbose();
        } else {
            Tr.debug(tc, "MemoryMXBean not registered");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVerbose " + isVerbose);
        }
        return isVerbose;
    }

    public String getFreeMemory() {
        Runtime rt = Runtime.getRuntime();
        String mem = new Long(rt.freeMemory()).toString();
        return mem;
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getProperty(String key) {
        return System.getProperty(key);
    }

    public String getIPAddress(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.component.JVMMBean.getIPAddress", (String)"60", (Object)((Object)this));
            return null;
        }
    }

    public long getCurrentTimeInMillis() {
        return System.currentTimeMillis();
    }

    public String getJVMNode() {
        String host = null;
        try {
            host = AdminHelper.getInstance().getNodeHostName(AdminServiceFactory.getAdminService().getNodeName());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.JVMMBean.getJVMNode", (String)"90", (Object)((Object)this));
            Tr.service(tc, "ADMN0020W", e);
        }
        return host;
    }

    public void dumpThreads() {
        Process proc = null;
        try {
            proc = ProcessFactory.createSelf();
            proc.generateJVMDump();
        }
        catch (ProcessOpException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.management.component.JVMMBean.dumpThreads", (String)"97", (Object)((Object)this));
            Tr.error(tc, "ADMN0021W", (Object)pe);
        }
    }

    public void setMaxDumpsOnDisk(Integer max) {
        Tr.entry(tc, "setMaxDumpsOnDisk ");
        this.maxDumpsOnDisk = max;
        Tr.exit(tc, "setMaxDumpsOnDisk " + this.maxDumpsOnDisk);
    }

    public Integer getMaxDumpsOnDisk() {
        return new Integer(this.maxDumpsOnDisk);
    }

    public String getMaxMemory() {
        return String.valueOf(Runtime.getRuntime().maxMemory());
    }

    public void setMaxSystemDumpsOnDisk(Integer max) {
        Tr.entry(tc, "setMaxSystemDumpsOnDisk ");
        this.maxSystemDumpsOnDisk = max;
        Tr.exit(tc, "setMaxSystemDumpsOnDisk " + this.maxSystemDumpsOnDisk);
    }

    public Integer getMaxSystemDumpsOnDisk() {
        return new Integer(this.maxSystemDumpsOnDisk);
    }

    private boolean isApplicable() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isApplicable");
            }
            try {
                String jvmVendor = System.getProperty("java.vendor");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JVM Vendor is " + jvmVendor);
                }
                if (jvmVendor != null && jvmVendor.indexOf("IBM") != -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Is IBM JDK and we can take heap/system dumps");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isApplicable");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "could not create system prop and test for applicability: " + e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicable");
        }
        return false;
    }

    private boolean isApplicableOnOS400() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isApplicableOnOS400");
            }
            try {
                if (System.getProperty("os.name").equals("OS/400")) {
                    if (System.getProperty("os400.use.j9").equals("true")) {
                        return true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using Classic JVM.  Dump not supported");
                    }
                    break block7;
                }
                return true;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "could not create system prop and test for applicability: " + e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicableOnOS400");
        }
        return false;
    }

    private String takeDump() throws HeapDumpOnDiskLimitReachedException {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "takeDump");
            }
            File f = null;
            try {
                String heapDumpDir = System.getenv("IBM_HEAPDUMPDIR");
                String heapDump = System.getenv("IBM_HEAPDUMP");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM_HEAPDUMPDIR", heapDumpDir);
                    Tr.debug(tc, "IBM_HEAPDUMP", heapDump);
                }
                if (heapDumpDir != null && heapDumpDir.length() > 0) {
                    f = new File(heapDumpDir);
                } else if (isZOS) {
                    String userHome = System.getProperty("user.home");
                    f = new File(userHome);
                } else {
                    f = new File(".");
                }
                DumpFileNameFilter filter = new DumpFileNameFilter("HEAP");
                File[] initialContents = f.listFiles(filter);
                ArrayList newFiles = new ArrayList();
                if (initialContents == null) {
                    initialContents = new File[]{};
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are " + initialContents.length + " dumps on disk");
                }
                if (initialContents.length >= this.maxDumpsOnDisk) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not take heap dump because we have exceded max heap dumps on disk");
                    }
                    throw new HeapDumpOnDiskLimitReachedException("There are already " + this.maxDumpsOnDisk + " heap dumps on disk");
                }
                System.gc();
                Dump.HeapDump();
                File[] currentContents = f.listFiles(filter);
                if (currentContents == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find heap dump file");
                    }
                    break block16;
                }
                return this.compareFileLists(initialContents, currentContents);
            }
            catch (HeapDumpOnDiskLimitReachedException e1) {
                throw e1;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception caught when taking heap dump : " + e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "takeDump");
        }
        return null;
    }

    public String generateHeapDump() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "received manual request to take heap dumps");
        }
        if (!this.isApplicableOnOS400()) {
            throw new HeapDumpNotSupportedException("Heap Dump not supported on Classic JVM", true);
        }
        if (!this.isApplicable()) {
            throw new HeapDumpNotSupportedException("Could not take single dump as " + System.getProperty("java.vendor") + " is not supported", true);
        }
        try {
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                this.sendNotification(new Notification("websphere.jvm.heapdump.attempting", this.getObjectName(), this.seqNum++));
            }
            String filePath = this.takeDump();
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                this.sendNotification(new Notification("websphere.jvm.heapdump.generated", (Object)this.getObjectName(), (long)this.seqNum++, filePath));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "file absolute path", filePath);
            }
            return filePath;
        }
        catch (HeapDumpOnDiskLimitReachedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "coud not take heap dump:  " + e.toString());
            }
            throw e;
        }
    }

    public String[] generateHeapDumps() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDumps");
        }
        String[] retval = new String[]{this.generateHeapDump()};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDumps", retval);
        }
        return retval;
    }

    public String[] generateHeapDump(String stoken) throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDump", stoken);
        }
        String[] retval = new String[]{this.generateHeapDump()};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDump", retval);
        }
        return retval;
    }

    public String generateSystemDump() throws MBeanException, DumpNotSupportedException, DumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSystemDump");
        }
        String dumpFileName = null;
        if (!this.isApplicableOnOS400()) {
            throw new DumpNotSupportedException("System Dump not supported on Classic JVM", true);
        }
        if (!this.isApplicable()) {
            throw new DumpNotSupportedException("System Dump not supported on " + System.getProperty("java.vendor"), true);
        }
        File dumpFile = null;
        if (isZOS) {
            String userHome = System.getProperty("user.home");
            dumpFile = new File(userHome);
        } else {
            dumpFile = new File(".");
        }
        this.sendNotification(new Notification("websphere.jvm.systemdump.attempting", this.getObjectName(), this.seqNum++));
        DumpFileNameFilter filter = new DumpFileNameFilter("SYSTEM");
        File[] initialContents = dumpFile.listFiles(filter);
        if (initialContents == null) {
            initialContents = new File[]{};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There are " + initialContents.length + " dumps on disk");
        }
        if (initialContents.length >= this.maxSystemDumpsOnDisk) {
            throw new DumpOnDiskLimitReachedException("There are already " + this.maxSystemDumpsOnDisk + " System dump files on disk");
        }
        System.gc();
        Dump.SystemDump();
        this.sendNotification(new Notification("websphere.jvm.systempdump.generated", this.getObjectName(), this.seqNum++));
        if (isZOS) {
            dumpFileName = bundleNLS.getString("ADMN1210I");
        } else {
            File[] currentContents = dumpFile.listFiles(filter);
            if (currentContents == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find System dump file");
                }
            } else {
                dumpFileName = this.compareFileLists(initialContents, currentContents);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateSystemDump " + dumpFileName);
        }
        return dumpFileName;
    }

    private String compareFileLists(File[] initialList, File[] finalList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareFileLists");
        }
        String dumpFile = null;
        boolean oldDumpFile = false;
        for (int i = 0; i < finalList.length; ++i) {
            oldDumpFile = false;
            String currentFileName = finalList[i].getAbsolutePath();
            for (int j = 0; j < initialList.length; ++j) {
                String initialFileName = initialList[j].getAbsolutePath();
                if (!currentFileName.equals(initialFileName)) continue;
                oldDumpFile = true;
                break;
            }
            if (oldDumpFile) continue;
            dumpFile = currentFileName;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compareFileLists " + dumpFile);
            }
            return dumpFile;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareFileLists null");
        }
        return null;
    }

    public String generateSystemDump(String stoken) throws MBeanException, DumpNotSupportedException, DumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSystemDump", stoken);
        }
        String retval = this.generateSystemDump();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateSystemDump", retval);
        }
        return retval;
    }

    private class DumpFileNameFilter
    implements FilenameFilter {
        public static final String SYSTEM_DUMP_EXT = "dmp";
        public static final String HEAP_DUMP_EXT = "phd";
        public String dumpType = "HEAP";

        public DumpFileNameFilter(String type) {
            this.dumpType = type;
        }

        public boolean accept(File dir, String name) {
            StringTokenizer st = new StringTokenizer(name, ".", false);
            if (st.countTokens() < 2) {
                return false;
            }
            String ext = "";
            while (st.hasMoreTokens()) {
                ext = st.nextToken();
            }
            if (this.dumpType.equals("SYSTEM") && ext.equals(SYSTEM_DUMP_EXT)) {
                return true;
            }
            return this.dumpType.equals("HEAP") && ext.equals(HEAP_DUMP_EXT);
        }
    }
}

