/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiagnosticProviderAggregator
implements AggregationHandler {
    private static final String sThisClass = DiagnosticProviderAggregator.class.getName();
    private static Logger sDiagnosticAggregatorLogger = DiagnosticEventHelper.getLogger((String)sThisClass, (String)"com.ibm.ws.rasdiag.resources.RasDiagMessages");

    public Object aggregateResults(String methodName, Object[] params, String[] signatures, ServantMBeanResult[] servantMBeanResults, StateObject stateObject) {
        if (methodName == null || servantMBeanResults == null) {
            sDiagnosticAggregatorLogger.logp(Level.WARNING, sThisClass, "aggregateResults", "RasDiag.All.NullParm");
            return null;
        }
        sDiagnosticAggregatorLogger.entering(sThisClass, "aggregateResults", "Method: " + methodName);
        if (sDiagnosticAggregatorLogger.isLoggable(Level.FINER)) {
            for (int i = 0; i < params.length; ++i) {
                sDiagnosticAggregatorLogger.logp(Level.FINER, sThisClass, "aggregateResults", i + " Signature: " + signatures[i] + " Parm: " + params[i]);
            }
        }
        if (methodName.equals("configDump") || methodName.equals("stateDump") || methodName.equals("selfDiagnostic")) {
            ArrayList<DiagnosticEvent> resultList = new ArrayList<DiagnosticEvent>(16);
            int totalResults = 0;
            for (int i = 0; i < servantMBeanResults.length; ++i) {
                if (servantMBeanResults[i] == null) continue;
                DiagnosticEvent[] diagEvents = (DiagnosticEvent[])servantMBeanResults[i].getResult();
                for (int j = 0; j < diagEvents.length; ++j) {
                    resultList.add(totalResults++, diagEvents[j]);
                }
            }
            DiagnosticEvent[] resultEvents = new DiagnosticEvent[totalResults];
            resultEvents = resultList.toArray(resultEvents);
            sDiagnosticAggregatorLogger.exiting(sThisClass, "aggregateResults", "# of DEs: " + resultEvents.length);
            return resultEvents;
        }
        sDiagnosticAggregatorLogger.logp(Level.FINE, sThisClass, "aggregateResults", "Aggregator called with an invalid method of: " + methodName);
        return null;
    }
}

