/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.deploymentmanager.DeploymentManager;
import com.ibm.ws.management.service.CellManager;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;

public class CellManagerImpl
extends ComponentImpl
implements CellManager {
    private static TraceComponent tc = Tr.register(CellManagerImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private VariableMap variableMap = null;
    private EndPointMgr endPtMgr = null;
    private CellSync cellSync = null;

    public void initialize(Object config) throws ComponentDisabledException {
        ConfigObject temp;
        ConfigObject stateManageable;
        String initialStateString;
        boolean initialState;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        if (initialState = !(initialStateString = (stateManageable = (temp = (ConfigObject)config).getObject("stateManagement")).getString("initialState", "START")).equals("START")) {
            throw new ComponentDisabledException();
        }
        this.addService(CellManager.class);
        this.variableMap = (VariableMap)this.getService(VariableMap.class);
        this.endPtMgr = (EndPointMgr)this.getService(EndPointMgr.class);
        this.releaseService(this.variableMap);
        this.releaseService(this.endPtMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        boolean bypass = false;
        if (AdminHelper.getPlatformHelper().isZOS() && !AdminHelper.getPlatformHelper().isControlJvm()) {
            bypass = true;
        }
        if (!bypass) {
            try {
                this.registerAgentMBean();
                this.initializeCellSync();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.CellManagerImpl.start", (String)"67", (Object)this);
                throw new RuntimeError(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this.cellSync != null) {
            this.cellSync.stop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
    }

    private void initializeCellSync() throws ConfigurationWarning {
        this.cellSync = CellSync.getCellSync();
        try {
            this.cellSync.initialize(this.variableMap);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.CellManagerImpl.initializeCellSync", (String)"302", (Object)this);
            throw new ConfigurationWarning("Problem initializing cell sync.", e);
        }
    }

    private void registerAgentMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAgentMBeans");
        }
        ConfigService configService = null;
        try {
            configService = (ConfigService)WsServiceRegistry.getService((Object)this, ConfigService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.CellManagerImpl.registerAgentMBean", (String)"183", (Object)this);
        }
        String cellName = AdminServiceFactory.getAdminService().getCellName();
        String repositoryRootURI = configService.getPath();
        DeploymentManager cellmgr = new DeploymentManager(repositoryRootURI, cellName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAgentMBeans");
        }
    }
}

