/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.asc.bridge.ws.server.WsAntAgent;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminHelperImpl;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.AdminServiceImplProxy;
import com.ibm.ws.management.ControlAdminService;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.DataSourceConfigHelperMBean;
import com.ibm.ws.management.MBeanExtensions;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.PlatformMBeanServer;
import com.ibm.ws.management.application.J2EEAppDeployment;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgr;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgrImpl;
import com.ibm.ws.management.cmdframework.impl.ServerCommandMgr;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.component.AdminOperationsMBean;
import com.ibm.ws.management.component.AdminOperationsMBeanProxy;
import com.ibm.ws.management.component.ConfigChangeHandler;
import com.ibm.ws.management.component.JMXConnectors;
import com.ibm.ws.management.component.JVMMBean;
import com.ibm.ws.management.component.JVMMBeanProxy;
import com.ibm.ws.management.component.PluginConfigServiceImpl;
import com.ibm.ws.management.configservice.ConfigServiceFactoryInitializer;
import com.ibm.ws.management.dm.AdminDiagnosticModule;
import com.ibm.ws.management.event.NotificationServiceMBean;
import com.ibm.ws.management.event.ZServantListener;
import com.ibm.ws.management.fileservice.FileServiceFactory;
import com.ibm.ws.management.j2ee.J2EEDomain;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheClient;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerMBean;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.management.collaborator.AgentProxyCollaborator;
import com.ibm.wsspi.management.collaborator.AgentProxyServantCollaborator;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ContainerConfig;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServices;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.resource.Resource;

public class AdminImpl
extends ContainerImpl
implements Admin,
PropertyChangeListener {
    private static final TraceComponent tc = Tr.register(AdminImpl.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private ConfigChangeHandler configChangeHandler = new ConfigChangeHandler();
    private boolean serverStarted = false;
    private ControlAdminService control = null;
    private ConfigRepositoryListener crListener = null;
    private ObjectName nameServerMBeanName = null;
    private String _serverLogRoot = null;
    private StatusCacheClient cacheClient = null;
    private VariableMap variableMap = null;
    private EndPointMgr endpointMgr = null;
    private Repository repository = null;
    private ConfigService configService = null;
    private String serverType = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError {
        Properties adminProps;
        ConfigObject wccmServerCO;
        ConfigObject thisCell;
        ConfigObject thisNode;
        block127: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", config);
            }
            boolean zos = false;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                zos = true;
            }
            boolean isServant = AdminHelper.getPlatformHelper().isServantJvm();
            Server thisServer = null;
            thisNode = null;
            thisCell = null;
            wccmServerCO = null;
            ConfigObject wccmServerEntryCO = null;
            ConfigObject nodeAgentCfgCO = null;
            String adminType = null;
            String rootURI = null;
            adminProps = null;
            ContainerConfig containerConfig = (ContainerConfig)config;
            ConfigObject adminServiceCO = containerConfig.getConfig();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting AdminService ConfigObject", adminServiceCO);
            }
            ((BeanContextServices)this.getBeanContext()).addService(Admin.class, (BeanContextServiceProvider)((Object)this));
            adminProps = AdminImpl.getProperties((ConfigObject)adminServiceCO);
            try {
                try {
                    ObjectName name;
                    RuntimeCollaborator mbean;
                    boolean unmanagedCellRegistered;
                    boolean enable;
                    boolean startClient;
                    boolean startCache;
                    boolean cellRegistered;
                    AdminServiceImpl _adminService;
                    block130: {
                        block129: {
                            block126: {
                                String serverName;
                                _adminService = new AdminServiceImpl();
                                AdminServiceFactoryInitializer.setAdminService((AdminService)_adminService);
                                MBeanFactoryImpl _mbeanFactory = (MBeanFactoryImpl)_adminService.getMBeanFactory();
                                MBeanServer mbServer = _mbeanFactory.getMBeanServer();
                                if (mbServer instanceof PlatformMBeanServer) {
                                    ((PlatformMBeanServer)mbServer).setAdminProps(adminProps);
                                }
                                try {
                                    _mbeanFactory.activateMBean("AdminService", (RuntimeCollaborator)((Object)_adminService), "AdminService", null);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"217", (Object)this);
                                }
                                thisServer = (Server)this.getService(Server.class);
                                this.repository = (Repository)this.getService(Repository.class);
                                this.configService = (ConfigService)WsServiceRegistry.getService((Object)this, ConfigService.class);
                                this.endpointMgr = (EndPointMgr)this.getService(EndPointMgr.class);
                                this.variableMap = (VariableMap)this.getService(VariableMap.class);
                                this._serverLogRoot = this.variableMap.expand("${LOG_ROOT}/" + thisServer.getName());
                                thisServer.addPropertyChangeListener("state", (PropertyChangeListener)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Server service = " + thisServer);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Repository service = " + this.repository);
                                    Tr.debug(tc, "Config service = " + this.configService.toString());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "EndpoitMgr service = " + this.endpointMgr);
                                }
                                AdminHelperImpl.setEndPointManager(this.endpointMgr);
                                rootURI = this.configService.getPath();
                                adminProps.put("repositoryRootURIProperty", rootURI);
                                cellRegistered = false;
                                try {
                                    thisCell = this.getCell();
                                    String cellName = thisCell.getString("name", "__null__");
                                    adminProps.put("cellNameConfigProperty", cellName);
                                    String cellType = thisCell.getString("cellType", "STANDALONE");
                                    adminProps.put("cellTypeConfigProperty", cellType);
                                    cellRegistered = thisCell.getBoolean("cellRegistered", false);
                                    adminProps.put("cellRegisteredConfigProperty", String.valueOf(cellRegistered));
                                    AdminServiceFactoryInitializer.setCellRegistered((boolean)cellRegistered);
                                    String cellDiscoveryProtocol = thisCell.getString("cellDiscoveryProtocol", "TCP");
                                    adminProps.put("cellDiscoveryProtocolConfigProperty", cellDiscoveryProtocol);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"174", (Object)this);
                                    throw new ConfigurationWarning("Problem loading Cell document.", e);
                                }
                                try {
                                    thisNode = this.getNode();
                                    String nodeName = thisNode.getString("name", "__null__");
                                    adminProps.put("nodeNameConfigProperty", nodeName);
                                    String discoveryProtocol = thisNode.getString("discoveryProtocol", "TCP");
                                    adminProps.put("nodeDiscoveryProtocolConfigProperty", discoveryProtocol);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"183", (Object)this);
                                    throw new ConfigurationWarning("Problem loading Node document.", e);
                                }
                                try {
                                    wccmServerCO = this.getServer();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "WCCM Server CO= " + wccmServerCO);
                                    }
                                    serverName = wccmServerCO.getString("name", null);
                                    adminProps.put("processNameConfigProperty", serverName);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"171", (Object)this);
                                    throw new ConfigurationWarning("Problem loading Server.", e);
                                }
                                try {
                                    serverName = wccmServerCO.getString("name", null);
                                    wccmServerEntryCO = this.getServerEntry(serverName);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "WCCM ServerEntry = " + wccmServerEntryCO);
                                    }
                                    this.serverType = wccmServerEntryCO.getString("serverType", null);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "WCCM ServerEntry ServerType = " + this.serverType);
                                    }
                                    adminProps.put("serverTypeConfigProperty", this.serverType);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"291", (Object)this);
                                    throw new ConfigurationWarning("Problem loading ServerEntry.", e);
                                }
                                boolean standAlone = adminServiceCO.getBoolean("standalone", true);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "AdminService Properties ConfigObject Standalone: " + standAlone);
                                }
                                adminType = standAlone ? "UnManagedProcess" : "ManagedProcess";
                                List serverComponents = wccmServerCO.getObjectList("components");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "number of serverComponents: " + serverComponents.size());
                                }
                                for (int i = 0; i < serverComponents.size(); ++i) {
                                    ConfigObject s = (ConfigObject)serverComponents.get(i);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "ServerComponent: " + s);
                                    }
                                    try {
                                        if (s.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/nodeagent.xmi", "NodeAgent")) {
                                            adminType = "NodeAgent";
                                            nodeAgentCfgCO = s;
                                            break;
                                        }
                                        if (s.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/cellmanager.xmi", "CellManager")) {
                                            adminType = "DeploymentManager";
                                            break;
                                        }
                                        if (this.serverType.equals("ADMIN_AGENT")) {
                                            adminType = "AdminAgent";
                                            break;
                                        }
                                        if (!this.serverType.equals("JOB_MANAGER")) continue;
                                        adminType = "JobManager";
                                        break;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "process type = " + adminType);
                                }
                                adminProps.put("adminTypeProperty", adminType);
                                AdminServiceFactoryInitializer.setAdminType((String)adminType);
                                if ("AdminAgent".equals(adminType)) {
                                    AdminServiceFactoryInitializer.setProxy((AdminService)new AdminServiceImplProxy());
                                }
                                String cellName = thisCell.getString("name", null);
                                String nodeName = thisNode.getString("name", null);
                                String serverName2 = wccmServerCO.getString("name", null);
                                _mbeanFactory.setCellName(cellName);
                                _mbeanFactory.setNodeName(nodeName);
                                _mbeanFactory.setProcessName(serverName2);
                                _mbeanFactory.setRepositoryDir(rootURI);
                                AdminInitializer.getInstance().initialize(adminProps);
                                AdminInitializer.getInstance().setMBeanExtensions(new MBeanExtensions(adminServiceCO, this.variableMap, (ExtClassLoader)thisServer.getRuntimeClassLoader()));
                                this.initializeConfigRepository(adminServiceCO, this.variableMap, rootURI);
                                try {
                                    if (zos) {
                                        if (isServant) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Activate JVMMBean in Servant JVM");
                                            }
                                            AdminServiceFactory.getMBeanFactory().activateMBean("JVM", (RuntimeCollaborator)((Object)new JVMMBean()), "JVM", null);
                                            break block126;
                                        }
                                        JVMMBeanProxy jvmProxy = new JVMMBeanProxy();
                                        ObjectName name2 = AdminServiceFactory.getMBeanFactory().activateMBean("JVM", jvmProxy, "JVM", null);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Activate JVMMBean Proxy in Control JVM", name2);
                                        }
                                        break block126;
                                    }
                                    AdminServiceFactory.getMBeanFactory().activateMBean("JVM", (RuntimeCollaborator)((Object)new JVMMBean()), "JVM", null);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"237", (Object)this);
                                    throw new ConfigurationWarning("Problem registering JVM MBean.", e);
                                }
                            }
                            startCache = false;
                            startClient = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Begining Status Cache load");
                            }
                            if (!AdminHelper.getPlatformHelper().isZOS()) break block129;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Loading Status Cache on z/OS");
                            }
                            if (AdminHelper.getPlatformHelper().isControlJvm()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Running in z/OS Control Region");
                                }
                                startCache = true;
                                WsAntAgent waa = new WsAntAgent(adminProps);
                                if (waa != null) {
                                    this.activateMBean("AntAgent", waa, "AntAgent", null);
                                }
                                break block130;
                            } else if (isServant) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Running in z/OS Servant Region");
                                }
                                startClient = true;
                            }
                            break block130;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Running on Distributed");
                        }
                        startCache = true;
                        startClient = true;
                    }
                    boolean disableCache = Boolean.getBoolean("com.ibm.websphere.management.status.disable");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Disable Switch: " + disableCache);
                    }
                    if (!disableCache) {
                        if (startCache) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Status Cache load");
                            }
                            StatusCacheFactory.init(this.repository);
                            StatusCache cache = StatusCacheFactory.getStatusCache();
                            ObjectName cache_bean = AdminServiceFactory.getMBeanFactory().activateMBean("StatusCache", (RuntimeCollaborator)((Object)cache), "StatusCache", null);
                            ((RuntimeCollaborator)((Object)cache)).setObjectName(cache_bean);
                        }
                        if (startClient) {
                            String processType;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Status Client load");
                            }
                            if ((processType = AdminServiceFactory.getAdminService().getProcessType()).equals("DeploymentManager") || processType.equals("UnManagedProcess")) {
                                this.cacheClient = StatusCacheFactory.getStatusCacheClient(false);
                            }
                        }
                    }
                    try {
                        Object adminOp = null;
                        if (zos) {
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "AdminOperationsMBeanProxy init");
                                }
                                if (AdminHelper.getPlatformHelper().isControlJvm()) {
                                    AdminOperationsMBeanProxy.init(this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Starting just proxy for ALL Control Regions");
                                    }
                                    adminOp = new AdminOperationsMBeanProxy();
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Starting AdminOperationsMBean in servant");
                                }
                                adminOp = new AdminOperationsMBean(this);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"255", (Object)this);
                                throw new ConfigurationWarning("Problem registering AdminOperations MBean.", e);
                            }
                        } else {
                            adminOp = new AdminOperationsMBean(this);
                        }
                        if (adminOp != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Activating AdminOperationsMBean");
                            }
                            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(adminOp, "AdminOperations");
                            AdminServiceFactory.getMBeanFactory().activateMBean("AdminOperations", (RuntimeCollaborator)collab, "AdminOperations", null);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"255", (Object)this);
                        throw new ConfigurationWarning("Problem registering AdminOperations MBean.", e);
                    }
                    if (adminType == "UnManagedProcess" || adminType == "DeploymentManager") {
                        try {
                            String domainName = _adminService.getDomainName();
                            Properties mbeanprops = new Properties();
                            mbeanprops.setProperty("name", domainName);
                            AdminServiceFactory.getMBeanFactory().activateMBean("J2EEDomain", (RuntimeCollaborator)((Object)new J2EEDomain(domainName)), "J2EEDomain", null, mbeanprops);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"309", (Object)this);
                            throw new ConfigurationWarning("Problem registering J2EEDomain MBean.", e);
                        }
                    }
                    boolean activateWorkspaceManager = false;
                    boolean bl = activateWorkspaceManager = zos && AdminHelper.getPlatformHelper().isServantJvm();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Activate WorkSpace manager", new Boolean(activateWorkspaceManager));
                    }
                    if (activateWorkspaceManager) {
                        try {
                            WorkSpaceManagerMBean wmbean = WorkSpaceManagerMBean.getInstance();
                            ObjectName bean = AdminServiceFactory.getMBeanFactory().activateMBean("WorkSpaceManager", (RuntimeCollaborator)wmbean, "WorkSpaceManager", null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WorkSpaceManager MBean", wmbean);
                            }
                            wmbean.setObjectName(bean);
                            WorkSpaceManagerMBean.setActive((boolean)true);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"500", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception activating WorkSpace MBean", e);
                            }
                            throw new ConfigurationWarning("Problem registering WorkSpaceManager MBean.", e);
                        }
                    }
                    String enableConfigPropVal = adminProps.getProperty("com.ibm.websphere.management.enableConfigMBean");
                    boolean bl2 = enable = adminType.equals("DeploymentManager") || adminType.equals("UnManagedProcess") || adminType.equals("JobManager") || adminType.equals("AdminAgent");
                    if (enableConfigPropVal != null) {
                        if ("true".equalsIgnoreCase(enableConfigPropVal)) {
                            enable = true;
                        } else if ("false".equalsIgnoreCase(enableConfigPropVal)) {
                            enable = false;
                        }
                    }
                    boolean bl3 = unmanagedCellRegistered = cellRegistered && "UnManagedProcess".equals(adminType);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Enable is ", enable);
                        Tr.debug(tc, "adminType is ", adminType);
                        Tr.debug(tc, "serverType is ", this.serverType);
                        Tr.debug(tc, "adminProps is ", adminProps);
                        Tr.debug(tc, "unmanagedCellRegistered is ", unmanagedCellRegistered);
                    }
                    try {
                        com.ibm.websphere.management.configservice.ConfigService configService;
                        block132: {
                            WsAntAgent waa;
                            RuntimeCollaborator cmdMgrCollab;
                            RuntimeCollaborator configServiceCollaborator;
                            block131: {
                                configService = null;
                                configServiceCollaborator = null;
                                if (!unmanagedCellRegistered) {
                                    configService = ConfigServiceFactory.createConfigService(enable, adminProps);
                                }
                                if (!zos) break block131;
                                if (isServant) {
                                    if (unmanagedCellRegistered) {
                                        configServiceCollaborator = new AgentProxyServantCollaborator(com.ibm.websphere.management.configservice.ConfigService.class);
                                        configService = (com.ibm.websphere.management.configservice.ConfigService)((Object)((AgentProxyServantCollaborator)configServiceCollaborator).getProxy());
                                        ConfigServiceFactoryInitializer.setConfigService((com.ibm.websphere.management.configservice.ConfigService)configService);
                                    }
                                    if (configServiceCollaborator != null) {
                                        this.activateMBean("ConfigService", configServiceCollaborator, "ConfigService", null);
                                    } else if (configService != null) {
                                        this.activateMBean("ConfigService", configService, "ConfigService", null);
                                    }
                                    cmdMgrCollab = null;
                                    if (unmanagedCellRegistered) {
                                        cmdMgrCollab = new AgentProxyServantCollaborator(RemoteCommandMgr.class);
                                    } else {
                                        RemoteCommandMgrImpl rcm = new RemoteCommandMgrImpl();
                                        ((ServerCommandMgr)CommandMgr.getCommandMgr()).setRCMMbean((RemoteCommandMgr)rcm);
                                        cmdMgrCollab = rcm;
                                    }
                                    if (cmdMgrCollab != null) {
                                        this.activateMBean("RemoteCommandMgr", cmdMgrCollab, "RemoteCommandMgr", null);
                                    }
                                    break block132;
                                } else if (unmanagedCellRegistered) {
                                    configServiceCollaborator = new AgentProxyCollaborator(com.ibm.websphere.management.configservice.ConfigService.class);
                                    configService = (com.ibm.websphere.management.configservice.ConfigService)((Object)((AgentProxyCollaborator)configServiceCollaborator).getProxy());
                                    ConfigServiceFactoryInitializer.setConfigService((com.ibm.websphere.management.configservice.ConfigService)configService);
                                    this.activateMBean("ConfigService", configServiceCollaborator, "ConfigService", null);
                                    cmdMgrCollab = new AgentProxyCollaborator(RemoteCommandMgr.class);
                                    this.activateMBean("RemoteCommandMgr", cmdMgrCollab, "RemoteCommandMgr", null);
                                }
                                break block132;
                            }
                            if (unmanagedCellRegistered) {
                                configServiceCollaborator = new AgentProxyCollaborator(com.ibm.websphere.management.configservice.ConfigService.class);
                                configService = (com.ibm.websphere.management.configservice.ConfigService)((Object)((AgentProxyCollaborator)configServiceCollaborator).getProxy());
                                ConfigServiceFactoryInitializer.setConfigService((com.ibm.websphere.management.configservice.ConfigService)configService);
                            }
                            if (configServiceCollaborator != null) {
                                this.activateMBean("ConfigService", configServiceCollaborator, "ConfigService", null);
                            } else if (configService != null) {
                                this.activateMBean("ConfigService", configService, "ConfigService", null);
                            }
                            cmdMgrCollab = null;
                            if (unmanagedCellRegistered) {
                                cmdMgrCollab = new AgentProxyCollaborator(RemoteCommandMgr.class);
                            } else {
                                RemoteCommandMgrImpl rcm = new RemoteCommandMgrImpl();
                                ((ServerCommandMgr)CommandMgr.getCommandMgr()).setRCMMbean((RemoteCommandMgr)rcm);
                                cmdMgrCollab = rcm;
                            }
                            if (cmdMgrCollab != null) {
                                this.activateMBean("RemoteCommandMgr", cmdMgrCollab, "RemoteCommandMgr", null);
                            }
                            if ((waa = new WsAntAgent(adminProps)) != null) {
                                this.activateMBean("AntAgent", waa, "AntAgent", null);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "configService is ", configService);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"288", (Object)this);
                        throw new ConfigurationWarning("Problem initializing config service.", e);
                    }
                    if (enable) {
                        this.registerAppManagementMBean(zos, isServant, adminProps, unmanagedCellRegistered);
                    }
                    try {
                        mbean = new DataSourceConfigHelperMBean(this.variableMap, this.repository);
                        name = this.activateMBean("DataSourceCfgHelper", mbean, "DataSourceCfgHelper", null);
                        mbean.setObjectName(name);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"344", (Object)this);
                        throw new ConfigurationWarning("Problem registering DataSource config helper.", e);
                    }
                    try {
                        mbean = new NotificationServiceMBean(_adminService.getNotificationService());
                        name = this.activateMBean("NotificationService", mbean, "NotificationService", null);
                        mbean.setObjectName(name);
                    }
                    catch (Exception exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"357", (Object)this);
                        throw new ConfigurationWarning("Problem registering NotificationService MBean", exc);
                    }
                    AdminDiagnosticModule.registerAll();
                    this.components = this.loadComponents("META-INF/ws-admin-startup.xml");
                    this.initializeComponents(adminServiceCO, null);
                    this.getJMXConnectors().initializeConnectors(adminServiceCO);
                    ConfigObject pluginConfig = adminServiceCO.getObject("pluginConfigService");
                    PluginConfigServiceImpl plgcfgsvc = this.getPluginConfigServiceImpl();
                    if (plgcfgsvc != null) {
                        plgcfgsvc.initializePluginConfigService(pluginConfig);
                    }
                    if (adminType != "ManagedProcess") {
                        this.createFileBrowserMBean(adminServiceCO);
                        if (adminType == "UnManagedProcess" || adminType == "AdminAgent" || adminType == "JobManager" || adminType == "DeploymentManager") {
                            try {
                                if (!zos || AdminHelper.getPlatformHelper().isControlJvm()) {
                                    ManagedObjectMetadataCollectorManager collMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null);
                                    collMgr.updateMetadata("Collect Metadata", null);
                                }
                            }
                            catch (AdminException ex) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Metadata collection failed.", ex);
                                }
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.AdminImpl", (String)"760", (Object)this);
                            }
                        }
                    }
                    Object var36_60 = null;
                    if (thisServer == null) break block127;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"353", (Object)this);
                    throw new ConfigurationError("Problem initializing AdminImpl: ", t);
                }
            }
            catch (Throwable throwable) {
                Object var36_61 = null;
                if (thisServer != null) {
                    this.releaseService(thisServer);
                }
                if (this.repository != null) {
                    this.releaseService(this.repository);
                }
                if (this.configService != null) {
                    this.releaseService(this.configService);
                }
                if (this.endpointMgr != null) {
                    this.releaseService(this.endpointMgr);
                }
                if (this.variableMap != null) {
                    this.releaseService(this.variableMap);
                }
                thisCell = null;
                thisNode = null;
                wccmServerCO = null;
                throw throwable;
            }
            this.releaseService(thisServer);
        }
        if (this.repository != null) {
            this.releaseService(this.repository);
        }
        if (this.configService != null) {
            this.releaseService(this.configService);
        }
        if (this.endpointMgr != null) {
            this.releaseService(this.endpointMgr);
        }
        if (this.variableMap != null) {
            this.releaseService(this.variableMap);
        }
        thisCell = null;
        thisNode = null;
        wccmServerCO = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "initialize", adminProps);
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            this.registerRepositoryListener();
            NodeSync.addLocalSyncEventListener(this.configChangeHandler);
            this.startComponents();
        }
        catch (RuntimeError re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeError(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        this.deregisterRepositoryListener();
        this.stopComponents();
    }

    public void destroy() {
    }

    public ObjectName activateMBean(String type, Object collaborator, String configId, String descriptor) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean");
        }
        RuntimeCollaborator collab = null;
        ObjectName result = null;
        try {
            if (!(collaborator instanceof RuntimeCollaborator)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using DefaultRuntimeCollaborator.");
                }
                collab = new DefaultRuntimeCollaborator(collaborator, configId);
            } else {
                collab = (RuntimeCollaborator)collaborator;
            }
            result = AdminServiceFactory.getMBeanFactory().activateMBean(type, collab, configId, descriptor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "activateMBean " + result);
            }
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.activateMBean", (String)"402", (Object)this);
            throw new AdminException(e, "MBean could not be registered.");
        }
    }

    public void deactivateMBean(String configId) throws AdminException {
        super.deregisterMBean(configId);
    }

    public ConfigObject getCell() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCell");
        }
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        ConfigScope scope = configService.getScope(0);
        List resource = configService.getDocumentObjects(scope, "cell.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCell", (ConfigObject)resource.get(0));
        }
        return (ConfigObject)resource.get(0);
    }

    public ConfigObject getNode() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNode");
        }
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        ConfigScope scope = configService.createScope(0);
        scope = configService.createScope(3);
        List resource = configService.getDocumentObjects(scope, "node.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNode", (ConfigObject)resource.get(0));
        }
        return (ConfigObject)resource.get(0);
    }

    public ConfigObject getServerEntry(String serverName) throws Exception {
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        ConfigScope scope = configService.createScope(0);
        scope = configService.createScope(3);
        List resource = null;
        try {
            resource = configService.getDocumentObjects(scope, "serverindex.xml");
        }
        catch (Exception e) {
            Tr.error(tc, "ADMN0066E", e);
            throw e;
        }
        ConfigObject serverEntryCO = null;
        List serverEntryList = ((ConfigObject)resource.get(0)).getObjectList("serverEntries");
        for (int i = 0; i < serverEntryList.size(); ++i) {
            ConfigObject serverEntry = (ConfigObject)serverEntryList.get(i);
            String name = serverEntry.getString("serverName", null);
            if (!serverName.equals(name)) continue;
            serverEntryCO = serverEntry;
            break;
        }
        return serverEntryCO;
    }

    public ConfigObject getServer() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServer");
        }
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        ConfigScope scope = configService.createScope(4);
        List resource = configService.getDocumentObjects(scope, "server.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServer", (ConfigObject)resource.get(0));
        }
        return (ConfigObject)resource.get(0);
    }

    public com.ibm.websphere.models.config.process.Server getServer(Repository repository2) throws Exception {
        Resource res = repository2.getConfigRoot().getResource(4, "server.xml");
        return (com.ibm.websphere.models.config.process.Server)res.getContents().get(0);
    }

    String expandGivenVariable(String variable) {
        return super.expandVariable(variable);
    }

    private void initializeConfigRepository(ConfigObject adminCO, VariableMap variableMap, String rootURI) throws ConfigurationWarning {
        try {
            ConfigRepository configRepository;
            ConfigObject configRepositoryServiceCO = adminCO.getObject("configRepository");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigRepository CO", configRepositoryServiceCO);
            }
            if ((configRepository = ConfigRepositoryFactory.createConfigRepository((configRepositoryServiceCO != null ? 1 : 0) != 0)) == null) {
                return;
            }
            Properties crProperties = new Properties();
            Properties crPropertiesCO = AdminImpl.getProperties((ConfigObject)configRepositoryServiceCO);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigRepository CO properties", crPropertiesCO);
            }
            Set<Map.Entry<Object, Object>> keySet = crPropertiesCO.entrySet();
            for (Map.Entry<Object, Object> me : keySet) {
                String pname = (String)me.getKey();
                String pval = (String)me.getValue();
                if (pname == null || pval == null) continue;
                try {
                    crProperties.setProperty(pname, variableMap.expand(pval));
                }
                catch (IllegalArgumentException iae) {
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.management.component.AdminImpl.initializeConfigRepository", (String)"618", (Object)this);
                    Tr.warning(tc, "ADMN0024W", new Object[]{pval, iae.getMessage()});
                }
            }
            boolean auditEnabled = configRepositoryServiceCO.getBoolean("auditEnabled", true);
            crProperties.setProperty("auditingEnabled", new Boolean(auditEnabled).toString());
            if (rootURI != null) {
                crProperties.setProperty("was.repository.root", rootURI);
            }
            configRepository.initialize(crProperties);
            configRepository.addListener((ConfigRepositoryListener)this.configChangeHandler);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initializeConfigRepository", (String)"666", (Object)this);
            throw new ConfigurationWarning("Problem initializing config repository.", e);
        }
    }

    private void registerAppManagementMBean(boolean zos, boolean isServant, Properties adminProps, boolean unmanagedCellRegistered) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAppManagementMBean:" + unmanagedCellRegistered);
        }
        try {
            if (unmanagedCellRegistered) {
                if (zos) {
                    if (isServant) {
                        AgentProxyServantCollaborator appmgmtCollab = new AgentProxyServantCollaborator(AppManagement.class);
                        this.activateMBean("AppManagement", appmgmtCollab, "AppManagement", null);
                        AgentProxyServantCollaborator j2eeAppDepCollab = new AgentProxyServantCollaborator(J2EEAppDeployment.class);
                        this.activateMBean("J2EEAppDeployment", j2eeAppDepCollab, "J2EEAppDeployment", null);
                    } else {
                        AgentProxyCollaborator appmgmtCollab = new AgentProxyCollaborator(AppManagement.class);
                        this.activateMBean("AppManagement", appmgmtCollab, "AppManagement", null);
                        AgentProxyCollaborator j2eeAppDepCollab = new AgentProxyCollaborator(J2EEAppDeployment.class);
                        this.activateMBean("J2EEAppDeployment", j2eeAppDepCollab, "J2EEAppDeployment", null);
                    }
                } else {
                    AgentProxyCollaborator appmgmtCollab = new AgentProxyCollaborator(AppManagement.class);
                    this.activateMBean("AppManagement", appmgmtCollab, "AppManagement", null);
                    AgentProxyCollaborator j2eeAppDepCollab = new AgentProxyCollaborator(J2EEAppDeployment.class);
                    this.activateMBean("J2EEAppDeployment", j2eeAppDepCollab, "J2EEAppDeployment", null);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerAppManagementMBean:" + unmanagedCellRegistered);
                }
                return;
            }
            if (zos && !isServant) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "registerAppManagementMBean in zos servant. unmanagedCellRegistered:" + unmanagedCellRegistered);
                }
                return;
            }
            Class<?> c = Class.forName("com.ibm.websphere.management.application.AppManagementFactory");
            Method m = c.getMethod("initMBean", String.class, String.class, String.class, String.class);
            m.invoke(c, adminProps.getProperty("repositoryRootURIProperty"), adminProps.getProperty("cellNameConfigProperty"), adminProps.getProperty("nodeNameConfigProperty"), adminProps.getProperty("processNameConfigProperty"));
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.component.AdminImpl.registerAppManagementMBean", (String)"738", (Object)this);
            Tr.warning(tc, "ADMN0018W", th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAppManagementMBean");
        }
    }

    private JMXConnectors getJMXConnectors() {
        JMXConnectors connectors = null;
        for (Object o : this.components) {
            if (!(o instanceof JMXConnectors)) continue;
            connectors = (JMXConnectors)o;
            break;
        }
        return connectors;
    }

    private PluginConfigServiceImpl getPluginConfigServiceImpl() {
        PluginConfigServiceImpl pluginConfigServiceImpl = null;
        for (Object o : this.components) {
            if (!(o instanceof PluginConfigServiceImpl)) continue;
            pluginConfigServiceImpl = (PluginConfigServiceImpl)((Object)o);
            break;
        }
        return pluginConfigServiceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent event2) {
        File f;
        String currentState = (String)event2.getNewValue();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                if (!tc.isDebugEnabled()) return;
                Tr.debug(tc, "Request from Server Region. Do not update the PID file. Current State = " + currentState);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request from Control Region. Update the PID file. Current State = " + currentState);
            }
        }
        if (currentState.equals("STARTED")) {
            this.serverStarted = true;
            String pid = null;
            try {
                Process proc = ProcessFactory.createSelf();
                if (proc != null) {
                    pid = proc.id();
                }
            }
            catch (ProcessOpException pe) {
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.management.component.AdminImpl.propertyChange", (String)"773", (Object)this);
            }
            if (pid == null) return;
            File f2 = new File(this.getServerPidFile());
            f2.getParentFile().mkdirs();
            FileOutputStream out = null;
            if (!f2.exists()) {
                f2.createNewFile();
            }
            out = new FileOutputStream(f2);
            out.write(pid.getBytes());
            Object var8_8 = null;
            if (out == null) return;
            try {
                out.flush();
                out.close();
                return;
            }
            catch (IOException e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.component.AdminImpl.propertyChange", (String)"744", (Object)this);
            }
            return;
            {
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.propertyChange", (String)"732", (Object)this);
                    Object var8_9 = null;
                    if (out == null) return;
                    try {
                        out.flush();
                        out.close();
                        return;
                    }
                    catch (IOException e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.component.AdminImpl.propertyChange", (String)"744", (Object)this);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (out == null) throw throwable;
                try {
                    out.flush();
                    out.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.component.AdminImpl.propertyChange", (String)"744", (Object)this);
                }
                throw throwable;
            }
        }
        if (!currentState.equals("DESTROYED") || !this.serverStarted || !(f = new File(this.getServerPidFile())).exists()) return;
        f.delete();
    }

    private String getServerPidFile() {
        String serverName = AdminServiceFactory.getAdminService().getProcessName();
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        String pidFile = processType.equals("NodeAgent") ? "nodeagent" : serverName;
        String logRoot = this.expandVariable("${LOG_ROOT}");
        pidFile = logRoot + "/" + pidFile + "/" + pidFile + ".pid";
        return pidFile;
    }

    public void addConfigChangeListener(ConfigChangeListener listener) {
        this.configChangeHandler.addConfigChangeListener(listener);
    }

    public void removeConfigChangeListener(ConfigChangeListener listener) {
        this.configChangeHandler.removeConfigChangeListener(listener);
    }

    void configChanged(ConfigRepositoryEvent e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged");
        }
        this.configChangeHandler.configChanged(e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public String getTotalMemory() {
        Runtime rt = Runtime.getRuntime();
        String mem = new Long(rt.totalMemory()).toString();
        return mem;
    }

    public String getFreeMemory() {
        Runtime rt = Runtime.getRuntime();
        String mem = new Long(rt.freeMemory()).toString();
        return mem;
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getProperty(String key) {
        return System.getProperty(key);
    }

    public String getIPAddress(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.component.AdminImpl.getIPAddress", (String)"474", (Object)this);
            return null;
        }
    }

    public long getCurrentTimeInMillis() {
        return System.currentTimeMillis();
    }

    public String getJVMNode() {
        String host = null;
        try {
            host = AdminHelper.getInstance().getNodeHostName(AdminServiceFactory.getAdminService().getNodeName());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.getJVMNode", (String)"452", (Object)this);
            Tr.service(tc, "ADMN0020W", e);
        }
        return host;
    }

    public void dumpThreads() {
        Process proc = null;
        try {
            proc = ProcessFactory.createSelf();
            proc.generateJVMDump();
        }
        catch (ProcessOpException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.management.component.AdminImpl.dumpThreads", (String)"469", (Object)this);
            Tr.error(tc, "ADMN0021W", (Object)pe);
        }
    }

    private void registerRepositoryListener() {
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isControlJvm()) {
            if (processType.equals("DeploymentManager") || processType.equals("NodeAgent") || processType.equals("AdminAgent") || processType.equals("JobManager") || processType.equals("UnManagedProcess")) {
                this.crListener = (ConfigRepositoryListener)ImplFactory.loadImplFromKey((String)"com.ibm.ws.management.util.zos.ZOSConfigRepositoryListener");
                if (this.crListener != null) {
                    ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
                    configRepository.addListener(this.crListener);
                } else {
                    Tr.warning(tc, "Unable to load ZOSConfigRepositoryListener");
                }
            }
            if (processType.equals("NodeAgent")) {
                NodeSync.addLocalSyncEventListener((NotificationListener)this.crListener);
            }
        }
        if (!AdminHelper.getPlatformHelper().isServantJvm() && !Boolean.getBoolean("com.ibm.websphere.management.status.disable")) {
            StatusCache cache = StatusCacheFactory.getStatusCache();
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            if (processType.equals("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding StatusCache as ConfigChangeListener");
                }
                this.addConfigChangeListener((ConfigChangeListener)cache);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding StatusCache as ConfigRepositoryListener");
                }
                configRepository.addListener((ConfigRepositoryListener)cache);
            }
        }
    }

    private void deregisterRepositoryListener() {
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (AdminHelper.getPlatformHelper().isControlJvm() && this.crListener != null) {
                ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
                configRepository.removeListener(this.crListener);
            }
            if (processType.equals("NodeAgent")) {
                NodeSync.removeLocalSyncEeventListener((NotificationListener)this.crListener);
            }
        }
    }

    public void createControlAdminService() {
        if (AdminServiceFactoryInitializer.getPlatformHelper().isControlJvm()) {
            try {
                this.control = new ControlAdminServiceImpl(AdminServiceFactory.getMBeanFactory());
                Class<?> c = Class.forName("com.ibm.ws390.management.ServantJVMListener");
                c.newInstance();
                ZServantListener listener = ZServantListener.getInstance();
                if (listener != null) {
                    listener.initialize();
                }
                try {
                    StatusCache cache = StatusCacheFactory.getStatusCache();
                    if (cache != null) {
                        cache.registerServantStartup();
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not initialze Servant Listener in StatusCache", e);
                    }
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private void createFileBrowserMBean(ConfigObject adminServiceCO) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFileServiceMBean");
        }
        boolean enable = true;
        Properties props = AdminImpl.getProperties((ConfigObject)adminServiceCO);
        String pval = props.getProperty("com.ibm.websphere.management.enableFileServiceMBean");
        if (pval != null && pval.equalsIgnoreCase("false")) {
            enable = false;
        }
        if (enable) {
            FileServiceFactory.createFileBrowserMBean(this.variableMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFileServiceMBean");
        }
    }

    private void dump() {
        try {
            ObjectName query = new ObjectName("WebSphere:*");
            MBeanServer mbs = AdminServiceFactory.getMBeanFactory().getMBeanServer();
            Set s = mbs.queryNames(query, null);
            if (s.isEmpty()) {
                System.out.println("DUMPDUMP empty");
            } else {
                System.out.println("DUMPDUMP BEGIN");
                for (ObjectName on : s) {
                    System.out.println(on);
                }
            }
            System.out.println("DUMPDUMP END");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

