/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import com.ibm.ws.management.commands.templates.TemplateConfigException;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class TemplateConfigHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(TemplateConfigHelper.class, "TemplateConfigHelper", "com.ibm.ws.management.resources.configservice");
    private static final String PROD_VER_PREFIX = "com.ibm.websphere.";
    private static final String PROD_VER_SUFFIX = "ProductVersion";
    private static final String FEATURE_PROD_VER_SUFFIX = "FeaturePackProductVersion";

    public static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args) {
        String message = null;
        try {
            message = bundle.getString(key);
            if (message == null) {
                message = new String("Cannot find message key " + key + "in resource bundle" + bundle.toString());
                Tr.event(tc, message);
            }
            message = MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            message = new String("Cannot find message key " + key + "in resource bundle " + bundle.toString());
            Tr.event(tc, message);
            return message;
        }
        catch (NullPointerException npe) {
            message = new String("Null pointer exception caught trying to find message key " + key + " in resource bundle " + bundle.toString());
            Tr.event(tc, message);
        }
        return message;
    }

    public static List getServerTemplatesObjNames(ConfigService cs, Session session, String serverType) throws TemplateConfigException {
        return TemplateConfigHelper.getTemplatesServertypes(cs, session, "listServerTemplates", serverType, null);
    }

    public static List getServerTypes(ConfigService cs, Session session) throws TemplateConfigException {
        return TemplateConfigHelper.getTemplatesServertypes(cs, session, "listServerTypes", null, null);
    }

    public static List getTemplatesServertypes(ConfigService cs, Session session, String cmdName, String serverType, String nodeName) throws TemplateConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplatesServertypes", new Object[]{cs, session, cmdName, serverType, nodeName});
        }
        List res = null;
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminCommand cmd = null;
            cmd = cmdMgr.createCommand(cmdName);
            cmd.setConfigSession(session);
            if (serverType != null) {
                cmd.setParameter("serverType", serverType);
            }
            if (nodeName != null) {
                cmd.setParameter("nodeName", nodeName);
            }
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
                Object errMsg = result.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new TemplateConfigException(result.getException(), (String)errMsg);
                }
                throw new TemplateConfigException(result.getException());
            }
            res = (List)result.getResult();
        }
        catch (Exception e) {
            throw new TemplateConfigException(e, e.getMessage());
        }
        if (tc.isDebugEnabled() && res != null) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : res) {
                String s = obj.toString();
                sb.append(s);
                sb.append(" ");
            }
            Tr.debug(tc, "return list = " + sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplatesServertypes", res);
        }
        return res;
    }

    public static ObjectName getServerTemplateObjectName(ConfigService configService, Session session, String serverType, String serverName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTemplateObjectName", new Object[]{session, configService, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        ObjectName objName = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            if (serverTypeContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTemplateObjectName - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        RepositoryContextType serversContextType = metadata2.getContextType("servers");
        List servers = serverTypeContext.getChildren(serversContextType);
        for (RepositoryContext sCtx : servers) {
            ConfigDataId id = new ConfigDataId(sCtx.getURI(), metadata2.getContextType("servers").getRootDocumentType().getFilePattern());
            if (!sCtx.getName().equals(serverName)) continue;
            objName = ConfigServiceHelper.createObjectName(id, null, sCtx.getName());
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTemplateObjectName", objName);
        }
        return objName;
    }

    public static RepositoryContext getServerContext(ConfigService configService, Session session, String serverName, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerContext", new Object[]{session, configService, serverName, nodeName});
        }
        WorkSpace ws = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext rootContext = ws.getRootContext();
        RepositoryContextType type = metadata2.getContextType("cells");
        RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
        type = metadata2.getContextType("nodes");
        RepositoryContext nodeContext = (RepositoryContext)cellContext.findContext("nodes", nodeName).iterator().next();
        type = metadata2.getContextType("servers");
        RepositoryContext serverContext = (RepositoryContext)nodeContext.findContext("servers", serverName).iterator().next();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerContext", serverContext);
        }
        return serverContext;
    }

    public static List getServerTemplates(ConfigService configService, Session session, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTemplates", new Object[]{session, configService, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        List servers = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            if (serverTypeContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTemplates - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        RepositoryContextType serversContextType = metadata2.getContextType("servers");
        servers = serverTypeContext.getChildren(serversContextType);
        if (tc.isDebugEnabled() && servers != null) {
            StringBuffer sb = new StringBuffer();
            for (RepositoryContext rc : servers) {
                String s = rc.getName();
                sb.append(s);
                sb.append(" ");
            }
            Tr.debug(tc, "return list = " + sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTemplates", servers);
        }
        return servers;
    }

    public static RepositoryContext getServerTemplateContext(ConfigService configService, Session session, String serverType, String templateName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTemplate", new Object[]{session, configService, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        RepositoryContext template = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            if (serverTypeContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTemplate - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        RepositoryContextType serversContextType = metadata2.getContextType("servers");
        List servers = serverTypeContext.getChildren(serversContextType);
        for (RepositoryContext serverTemplate : servers) {
            if (!serverTemplate.getName().equals(templateName)) continue;
            template = serverTemplate;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTemplate", template);
        }
        return template;
    }

    public static RepositoryContext getServerTypeContext(ConfigService configService, Session session, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypeContext", new Object[]{session, configService, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            if (serverTypeContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTypeMetadata - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        return serverTypeContext;
    }

    public static ObjectName getServerTypeMetadata(ConfigService configService, Session session, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypeMetadata", new Object[]{session, configService, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metadata2.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            if (serverTypeContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTypeMetadata - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        ConfigDataId id = new ConfigDataId(serverTypeContext.getURI(), "servertype-metadata.xml");
        ObjectName metadataTypeId = ConfigServiceHelper.createObjectName(id, null, serverType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTypeMetadata", metadataTypeId);
        }
        return metadataTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectName[] getTemplateMetadataForServerType(ConfigService configService, Session session, String serverType) throws Exception {
        ObjectName[] list;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTemplateMetadataForServerType", new Object[]{session, configService, serverType});
            }
            list = null;
            ObjectName metadataTypeId = TemplateConfigHelper.getServerTypeMetadata(configService, session, serverType);
            try {
                try {
                    WorkSpace ws = WorkspaceHelper.getWorkspace(session);
                    String contextUri = ConfigServiceHelper.getConfigDataId(metadataTypeId).getContextUri();
                    RepositoryContext context = ws.findContext(contextUri);
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
                    list = docAccessor.getRootObjects(session);
                }
                catch (ConfigDataNotFoundException cdnfe) {
                    Object var10_12 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getTemplateMetadataForServerType - none", null);
                        }
                        return null;
                    }
                    break block15;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occured during getMetadata", ex);
                    }
                    Object var10_13 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getTemplateMetadataForServerType - none", null);
                        }
                        return null;
                    }
                    break block15;
                }
                Object var10_11 = null;
                if (list != null) break block15;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (list != null) {
                    throw throwable;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTemplateMetadataForServerType - none", null);
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTemplateMetadataForServerType - none", null);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplateMetadataForServerType", list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PropertySet getTemplateMetadata(ConfigService configService, Session session, String serverType, String templateName) throws Exception {
        ObjectName[] list;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMetadata", new Object[]{session, configService, serverType, templateName});
            }
            list = null;
            ObjectName metadataTypeId = TemplateConfigHelper.getServerTypeMetadata(configService, session, serverType);
            try {
                Object var11_13;
                try {
                    WorkSpace ws = WorkspaceHelper.getWorkspace(session);
                    String contextUri = ConfigServiceHelper.getConfigDataId(metadataTypeId).getContextUri();
                    RepositoryContext context = ws.findContext(contextUri);
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
                    list = docAccessor.getRootObjects(session);
                }
                catch (ConfigDataNotFoundException cdnfe) {
                    var11_13 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMetadata - none", null);
                        }
                        return null;
                    }
                    break block19;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", (String)"291");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occured during getMetadata", ex);
                    }
                    var11_13 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMetadata - none", null);
                        }
                        return null;
                    }
                    break block19;
                }
                var11_13 = null;
                if (list != null) break block19;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (list != null) {
                    throw throwable;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata - none", null);
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetadata - none", null);
            }
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, list[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + set);
            }
            EList props = set.getProperties();
            for (Property p : props) {
                if (!p.getName().equals("name") || !p.getValue().equals(templateName)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata", set);
                }
                return set;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadata", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PropertySet getTemplateMetadata(ConfigService configService, Session session, RepositoryContext templateContext) throws Exception {
        ObjectName[] list;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTemplateMetadata", new Object[]{session, configService, templateContext});
            }
            list = null;
            try {
                try {
                    WorkSpace ws = WorkspaceHelper.getWorkspace(session);
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessorNoCreate(templateContext, "template-metadata.xml");
                    list = docAccessor.getRootObjects(session);
                }
                catch (ConfigDataNotFoundException cdnfe) {
                    Object var7_9 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getTemplateMetadata - none", null);
                        }
                        return null;
                    }
                    break block19;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", (String)"291");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occured during getTemplateMetadata", ex);
                    }
                    Object var7_10 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getTemplateMetadata - none", null);
                        }
                        return null;
                    }
                    break block19;
                }
                Object var7_8 = null;
                if (list != null) break block19;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (list != null) {
                    throw throwable;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTemplateMetadata - none", null);
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTemplateMetadata - none", null);
            }
            return null;
        }
        if (list.length > 1 && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTemplateMetadata - too many property sets", new Integer(list.length));
        }
        if (list.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTemplateMetadata - no property sets found ", new Integer(list.length));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTemplateMetadata");
            }
            return null;
        }
        PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, list[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplateMetadata", set);
        }
        return set;
    }

    public static String getTemplateName(ConfigService configService, Session session, RepositoryContext templateContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplateName", new Object[]{session, configService, templateContext});
        }
        String templateName = null;
        PropertySet set = TemplateConfigHelper.getTemplateMetadata(configService, session, templateContext);
        if (set != null) {
            EList props = set.getProperties();
            for (Property p : props) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template property " + p.getName() + "=" + p.getValue());
                }
                if (!p.getName().equals("name")) continue;
                templateName = p.getValue();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplateName", templateName);
        }
        return templateName;
    }

    public static List getFeatureTemplateContexts(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateContexts", new Object[]{cs, session});
        }
        ArrayList allFeatures = new ArrayList();
        List serverTypes = TemplateConfigHelper.getServerTypes(cs, session);
        for (String serverType : serverTypes) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " servertype ", serverType);
            }
            List features = TemplateConfigHelper.getFeatureTemplateContexts(cs, session, serverType);
            allFeatures.addAll(features);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateContexts", allFeatures);
        }
        return allFeatures;
    }

    public static List getFeatureTemplateContexts(ConfigService cs, Session session, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateContexts", new Object[]{cs, session, serverType});
        }
        ArrayList<RepositoryContext> features = new ArrayList<RepositoryContext>();
        List servers = TemplateConfigHelper.getServerTemplates(cs, session, serverType);
        if (servers == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureTemplateContexts", servers);
            }
            return features;
        }
        for (RepositoryContext serverTemplate : servers) {
            PropertySet ps = TemplateConfigHelper.getTemplateMetadata(cs, session, serverTemplate);
            if (ps == null || !TemplateConfigHelper.isFeatureTemplate(ps)) continue;
            String templateName = TemplateConfigHelper.getTemplateName(cs, session, serverTemplate);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate ", templateName);
            }
            if (templateName == null) continue;
            features.add(serverTemplate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateContexts", features);
        }
        return features;
    }

    public static List getFeatureTemplateMetadata(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateMetadata", new Object[]{cs, session});
        }
        ArrayList allFeatures = new ArrayList();
        List serverTypes = TemplateConfigHelper.getServerTypes(cs, session);
        for (String serverType : serverTypes) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " servertype ", serverType);
            }
            List features = TemplateConfigHelper.getFeatureTemplateMetadata(cs, session, serverType);
            allFeatures.addAll(features);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateMetadata", allFeatures);
        }
        return allFeatures;
    }

    public static List getFeatureTemplateMetadata(ConfigService cs, Session session, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateMetadata", new Object[]{cs, session, serverType});
        }
        ArrayList<PropertySet> features = new ArrayList<PropertySet>();
        List servers = TemplateConfigHelper.getServerTemplates(cs, session, serverType);
        if (servers == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureTemplateMetadata", features);
            }
            return features;
        }
        for (RepositoryContext serverTemplate : servers) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate ", serverTemplate);
            }
            PropertySet ps = TemplateConfigHelper.getTemplateMetadata(cs, session, serverTemplate);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate metadata ", ps);
            }
            if (ps == null || !TemplateConfigHelper.isFeatureTemplate(ps)) continue;
            features.add(ps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateMetadata", features);
        }
        return features;
    }

    public static PropertySet getFeatureTemplateMetadata(ConfigService cs, Session session, String serverType, String featureTemplateName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateMetadata", new Object[]{cs, session, serverType, featureTemplateName});
        }
        PropertySet ps = null;
        List servers = TemplateConfigHelper.getServerTemplates(cs, session, serverType);
        if (servers == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureTemplateMetadata", ps);
            }
            return ps;
        }
        for (RepositoryContext serverTemplate : servers) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate ", serverTemplate);
            }
            ps = TemplateConfigHelper.getTemplateMetadata(cs, session, serverTemplate);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate metadata ", ps);
            }
            boolean found = false;
            if (ps != null && TemplateConfigHelper.isFeatureTemplate(ps)) {
                EList props = ps.getProperties();
                for (Property p : props) {
                    String templateName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "template property " + p.getName() + "=" + p.getValue());
                    }
                    if (!p.getName().equals("name") || !(templateName = p.getValue()).equals(featureTemplateName)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateMetadata", ps);
        }
        return ps;
    }

    public static List getFeatureNames(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureNames", new Object[]{cs, session});
        }
        ArrayList allFeatures = new ArrayList();
        List serverTypes = TemplateConfigHelper.getServerTypes(cs, session);
        for (String serverType : serverTypes) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " servertype ", serverType);
            }
            List features = TemplateConfigHelper.getFeatureNames(cs, session, serverType);
            allFeatures.addAll(features);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureNames", allFeatures);
        }
        return allFeatures;
    }

    public static List getFeatureNames(ConfigService cs, Session session, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureNames", new Object[]{cs, session, serverType});
        }
        ArrayList<String> features = new ArrayList<String>();
        List servers = TemplateConfigHelper.getServerTemplates(cs, session, serverType);
        if (servers == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureNames", servers);
            }
            return features;
        }
        for (RepositoryContext serverTemplate : servers) {
            PropertySet ps = TemplateConfigHelper.getTemplateMetadata(cs, session, serverTemplate);
            if (ps == null || !TemplateConfigHelper.isFeatureTemplate(ps)) continue;
            String templateName = TemplateConfigHelper.getTemplateName(cs, session, serverTemplate);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template name ", templateName);
            }
            if (templateName == null) continue;
            features.add(templateName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureNames", features);
        }
        return features;
    }

    public void createTemplateMetadata(PropertySet baseSet, PropertySet fpSet, String serverType) throws TemplateConfigException {
    }

    public void deleteTemplateMetadata() throws TemplateConfigException {
    }

    public static boolean canCombine(ConfigService cs, Session session, PropertySet ps, PropertySet featurePs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCombine", new Object[]{ps, featurePs});
        }
        boolean res = false;
        List fpMatchingProperties = TemplateConfigHelper.getMatchingProperties(featurePs);
        List matchingProperties = TemplateConfigHelper.getMatchingProperties(ps);
        String fpMatchingProperty = null;
        String matchingProperty = null;
        if (fpMatchingProperties != null && fpMatchingProperties.size() > 0) {
            fpMatchingProperty = TemplateConfigHelper.getFpMatchingProperty(featurePs);
        }
        if (matchingProperties != null && matchingProperties.size() > 0) {
            matchingProperty = TemplateConfigHelper.getMatchingProperty(ps);
        }
        String fpMatchingPropertyValue = TemplateConfigHelper.getPropValue(featurePs, fpMatchingProperty);
        String matchingPropertyValue = TemplateConfigHelper.getPropValue(ps, matchingProperty);
        boolean isDefaultAndSystem = TemplateConfigHelper.isSystemAndDefault(ps);
        if (isDefaultAndSystem && TemplateConfigHelper.canCombine(cs, session, fpMatchingProperty, fpMatchingPropertyValue, matchingProperty, matchingPropertyValue)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "canCombine if additional properties also match");
            }
            res = true;
        }
        for (int i = 1; res && i < fpMatchingProperties.size(); ++i) {
            String fprop = (String)fpMatchingProperties.get(i);
            String fvalue = TemplateConfigHelper.getPropValue(featurePs, fprop);
            String bvalue = TemplateConfigHelper.getPropValue(ps, fprop);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " fprop, fvalue, bvalue ", new Object[]{fprop, fvalue, bvalue});
            }
            if (fprop.equals("com.ibm.websphere.nodeOperatingSystem") && fvalue.equals("os390")) {
                if (bvalue.equals("os390")) continue;
                return false;
            }
            if (fprop.equals("com.ibm.websphere.nodeOperatingSystem") && !fvalue.equals("os390")) {
                if (!bvalue.equals("os390")) continue;
                return false;
            }
            if (bvalue == null || bvalue.equals(fvalue)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCombine", new Boolean(res));
        }
        return res;
    }

    public static boolean canCombine(ConfigService cs, Session session, String fpMatchingProperty, String fpMatchingPropertyValue, String matchingProperty, String matchingPropertyValue) throws Exception {
        PropertySet cps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCombine", new Object[]{fpMatchingProperty, fpMatchingPropertyValue, matchingProperty, matchingPropertyValue});
        }
        if ((cps = TemplateConfigHelper.getCompatibilityInfo(cs, session, fpMatchingProperty, fpMatchingPropertyValue)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(false));
            }
            return false;
        }
        String baseStart = TemplateConfigHelper.getPropValue(cps, "baseStart");
        String baseEnd = TemplateConfigHelper.getPropValue(cps, "baseEnd");
        String baseProperty = TemplateConfigHelper.getPropValue(cps, "basePropertyName");
        if (!baseProperty.equals(matchingProperty)) {
            Tr.debug(tc, "matching property in template metadata does contain base product version as the first matching property");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(false));
            }
            return false;
        }
        if (TemplateConfigHelper.withInRange(baseStart, baseEnd, matchingPropertyValue)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(true));
            }
            return true;
        }
        String[] templateVersions = TemplateConfigHelper.getBaseProductInfo(cs, session, "com.ibm.websphere.baseProductVersion", matchingPropertyValue);
        if (TemplateConfigHelper.withInRange(templateVersions[0], templateVersions[1], baseStart)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCombine", new Boolean(false));
        }
        return false;
    }

    public static boolean isSystemAndDefault(PropertySet set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSystemAndDefault", new Object[]{set});
        }
        EList props = set.getProperties();
        Iterator it = props.iterator();
        String defaultValue = null;
        String systemValue = null;
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (p.getName().equals("isDefaultTemplate")) {
                defaultValue = p.getValue();
            } else if (p.getName().equals("isSystemTemplate")) {
                systemValue = p.getValue();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " name, value ", new Object[]{p.getName(), p.getValue()});
            }
            if (defaultValue == null || systemValue == null) continue;
            break;
        }
        if (defaultValue != null && defaultValue.equals("true") && systemValue != null && systemValue.equals("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSystemAndDefault", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSystemAndDefault", new Boolean(false));
        }
        return false;
    }

    public static void checkIfTemplateDeprecated(ConfigService cs, Session session, ObjectName template) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfTemplateDeprecated", new Object[]{cs, session, template});
        }
        PropertySet set = null;
        try {
            set = TemplateConfigHelper.getPropertySetOfTemplate(cs, session, template);
        }
        catch (Exception e) {
            Tr.debug(tc, "Got a exception while getting the property set for the template " + template.toString() + ": " + e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "property set for the template is: ", new Object[]{set});
        }
        EList props = set.getProperties();
        Iterator propsIt = props.iterator();
        boolean isDeprecated = false;
        String deprecatedBy = null;
        String deprecatedRelease = null;
        while (propsIt.hasNext()) {
            Property prop = (Property)propsIt.next();
            String pName = prop.getName();
            String pValue = prop.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " name, value = ", new Object[]{pName, pValue});
            }
            if (pName != null && pName.equals("deprecatedBy")) {
                isDeprecated = true;
                deprecatedBy = pValue;
            }
            if (pName == null || !pName.equals("deprecatedRelease")) continue;
            deprecatedRelease = pValue;
        }
        if (isDeprecated) {
            String deprecatedMsg = "As of " + deprecatedRelease + ", the template " + ConfigServiceHelper.getDisplayName(template) + " is deprecated and replaced by the tempalte " + deprecatedBy;
            Tr.warning(tc, "ADMG0700W", new Object[]{deprecatedRelease, ConfigServiceHelper.getDisplayName(template), deprecatedBy});
            System.out.println("Attention: " + deprecatedMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfTemplateDeprecated");
        }
    }

    public static List getMatchingProperties(PropertySet set) {
        List<String> mp = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingProperties", set);
        }
        if ((mp = TemplateConfigHelper.getMatchingPropertiesReal(set)) == null || mp.size() == 0) {
            EList props = set.getProperties();
            Iterator it = props.iterator();
            String prodVersion = null;
            boolean foundOS = false;
            while (it.hasNext()) {
                Property p = (Property)it.next();
                String pName = p.getName();
                if (pName.startsWith(PROD_VER_PREFIX) && pName.endsWith(PROD_VER_SUFFIX) || pName.equals("com.ibm.websphere.nodeOperatingSystem")) {
                    mp.add(pName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " matching property ", pName);
                    }
                }
                if (pName.equals("com.ibm.websphere.baseProductVersion")) {
                    prodVersion = p.getValue();
                }
                if (!pName.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
                foundOS = true;
            }
            if (!foundOS && prodVersion != null && prodVersion.length() > 0 && prodVersion.startsWith("5")) {
                mp.add("com.ibm.websphere.nodeOperatingSystem");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingProperties", mp);
        }
        return mp;
    }

    public static List getMatchingPropertiesReal(PropertySet set) {
        ArrayList<String> props = new ArrayList<String>();
        String matchingProp = TemplateConfigHelper.getMatchingPropertiesAsString(set);
        if (matchingProp != null) {
            StringTokenizer st = new StringTokenizer(matchingProp, ",");
            while (st.hasMoreTokens()) {
                props.add(st.nextToken());
            }
        }
        return props;
    }

    public static String getMatchingPropertiesAsString(PropertySet set) {
        EList props = set.getProperties();
        for (Property p : props) {
            if (!p.getName().equals("matchingProperties")) continue;
            return p.getValue();
        }
        return null;
    }

    public static boolean featureExistsInTemplate(PropertySet fps, PropertySet ps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "featureExistsInTemplate", new Object[]{fps, ps});
        }
        boolean res = true;
        List fmp = TemplateConfigHelper.getMatchingProperties(fps);
        List mp = TemplateConfigHelper.getMatchingProperties(ps);
        if (mp.size() == 0 || fmp.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot generate templates if there is no matching properties ", fmp.size() + " " + mp.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "featureExistsInTemplate", new Boolean(res));
            }
            return res;
        }
        for (String p : fmp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", p);
            }
            if (mp.contains(p)) {
                String v = TemplateConfigHelper.getPropValue(ps, p);
                String fv = TemplateConfigHelper.getPropValue(fps, p);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "values ", fv + " " + v);
                }
                if (v.equals(fv)) continue;
                res = false;
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Does not exist in template ", p);
            }
            res = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "featureExistsInTemplate", new Boolean(res));
        }
        return res;
    }

    public static boolean alreadyExists(ConfigService cs, Session session, PropertySet ps, PropertySet featurePs, ObjectName[] templates) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alreadyExists", new Object[]{cs, session, ps, featurePs, templates});
        }
        boolean res = false;
        if (TemplateConfigHelper.featureExistsInTemplate(featurePs, ps)) {
            return true;
        }
        String combinedTemplateName = TemplateConfigHelper.getCombinedTemplateName(featurePs, ps);
        res = TemplateConfigHelper.alreadyExists(cs, session, combinedTemplateName, templates);
        if (!res) {
            String p;
            int i;
            ArrayList<String> vals = new ArrayList<String>();
            List mp1 = TemplateConfigHelper.getMatchingProperties(ps);
            List mp2 = TemplateConfigHelper.getMatchingProperties(featurePs);
            if (mp1 == null || mp2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "alreadyExists", new Boolean(true));
                }
                return true;
            }
            for (i = 0; i < mp1.size(); ++i) {
                p = (String)mp1.get(i);
                vals.add(TemplateConfigHelper.getPropValue(ps, p));
            }
            for (i = 0; i < mp2.size(); ++i) {
                p = (String)mp2.get(i);
                if (mp1.contains(p)) continue;
                mp1.add(p);
                vals.add(TemplateConfigHelper.getPropValue(featurePs, p));
            }
            res = TemplateConfigHelper.matchingPropertyExists(session, mp1, vals, templates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alreadyExists", new Boolean(res));
        }
        return res;
    }

    public static boolean matchingPropertyExists(Session session, List mp, List vals, ObjectName[] templates) throws Exception {
        boolean res = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchingPropertyExists", new Object[]{mp, templates});
        }
        for (int i = 0; i < templates.length; ++i) {
            String p;
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, templates[i]);
            List tmp = TemplateConfigHelper.getMatchingProperties(set);
            if (tmp == null || mp == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "matchingPropertyExists", new Boolean(true));
                }
                return true;
            }
            int j = 0;
            for (j = 0; j < mp.size() && tmp.contains(p = (String)mp.get(j)); ++j) {
                String tv = TemplateConfigHelper.getPropValue(set, p);
                String fv = (String)vals.get(j);
                if (tv != null && fv != null && !tv.equals(fv)) break;
            }
            if (j != mp.size() || tmp.size() != j) continue;
            res = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchingPropertyExists", new Boolean(res));
        }
        return res;
    }

    public static boolean alreadyExists(ConfigService cs, Session session, String templateName, ObjectName[] templates) throws Exception {
        for (int i = 0; i < templates.length; ++i) {
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, templates[i]);
            if (!TemplateConfigHelper.alreadyExists(cs, session, templateName, set)) continue;
            return true;
        }
        return false;
    }

    public static boolean alreadyExists(ConfigService cs, Session session, String templateName, PropertySet set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alreadyExists", new Object[]{templateName, set});
        }
        EList props = set.getProperties();
        for (Property p : props) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template property " + p.getName() + "=" + p.getValue());
            }
            if (!p.getName().equals("name") || !p.getValue().equals(templateName)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "alreadyExists", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alreadyExists", new Boolean(false));
        }
        return false;
    }

    public static String getCombinedTemplateName(PropertySet featurePs, PropertySet ps) {
        String featureTemplateName = TemplateConfigHelper.getPropValue(featurePs, "name");
        String templateName = TemplateConfigHelper.getPropValue(ps, "name");
        return TemplateConfigHelper.getCombinedTemplateName(featureTemplateName, templateName);
    }

    public static String getCombinedTemplateName(String featureTeamplateName, String templateName) {
        return templateName + "_" + featureTeamplateName;
    }

    public static String getMatchingProperty(PropertySet ps) {
        return "com.ibm.websphere.baseProductVersion";
    }

    public static String getFpMatchingProperty(PropertySet fps) {
        EList props = fps.getProperties();
        for (Property p : props) {
            String pName = p.getName();
            if (!pName.startsWith(PROD_VER_PREFIX) || !pName.endsWith(PROD_VER_SUFFIX) || pName.equals("com.ibm.websphere.baseProductVersion")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " matching property ", pName);
            }
            return pName;
        }
        return null;
    }

    public static String getPropValue(PropertySet set, String name) {
        EList props = set.getProperties();
        for (Property p : props) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template property " + p.getName() + "=" + p.getValue());
            }
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    public static boolean withInRange(String start, String end, String val) {
        String vt;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "withInRange", new Object[]{start, end, val});
        }
        if (val.equals(start)) {
            return true;
        }
        if (end == null) {
            end = "Infinite";
        }
        StringTokenizer vst = new StringTokenizer(val, ".");
        StringTokenizer sst = new StringTokenizer(start, ".");
        StringTokenizer est = new StringTokenizer(end, ".");
        boolean vgs = false;
        boolean vle = false;
        while (vst.hasMoreTokens()) {
            vt = vst.nextToken();
            if (!sst.hasMoreTokens()) break;
            String st = sst.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Comparing ", vt + "," + st);
            }
            if (vt.compareTo(st) < 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "withInRange 1", new Boolean(false));
                }
                return false;
            }
            if (vt.compareTo(st) <= 0) continue;
            vgs = true;
            break;
        }
        while (!vgs && sst.hasMoreTokens()) {
            String st = sst.nextToken();
            if (Integer.parseInt(st) <= 0) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange 2", new Boolean(false));
            }
            return false;
        }
        if (end.equals("Infinite")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange X", new Boolean(true));
            }
            return true;
        }
        vst = new StringTokenizer(val, ".");
        while (vst.hasMoreTokens()) {
            vt = vst.nextToken();
            if (!est.hasMoreTokens()) break;
            String et = est.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Comparing ", vt + "," + et);
            }
            if (vt.compareTo(et) < 0) {
                vle = true;
                break;
            }
            if (vt.compareTo(et) <= 0) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange 3", new Boolean(false));
            }
            return false;
        }
        while (!vle && est.hasMoreTokens()) {
            String et = est.nextToken();
            if (Integer.parseInt(et) <= 0) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange 4", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "withInRange", new Boolean(vle));
        }
        return vle;
    }

    public static PropertySet getCompatibilityInfo(ConfigService cs, Session session, String fpName, String fpvalue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompatibilityInfo", new Object[]{fpName, fpvalue});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext rootContext = workspace.getRootContext();
        RepositoryContextType type = metadata2.getContextType("cells");
        RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(cellContext, "product-info.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompatibilityInfo", "No product-info.xml file");
            }
            return null;
        }
        ObjectName[] list = docAccessor.getRootObjects(session);
        for (int i = 0; list != null && i < list.length; ++i) {
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, list[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + set);
            }
            if (!TemplateConfigHelper.isMatchingFpInfo(fpName, fpvalue, set)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompatibilityInfo", set);
            }
            return set;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompatibilityInfo");
        }
        return null;
    }

    public static boolean isMatchingFpInfo(String fpName, String fpValue, PropertySet set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMatchingFpInfo", new Object[]{fpName, fpValue, set});
        }
        String featurePropertyName = null;
        String start = null;
        String end = null;
        EList props = set.getProperties();
        for (Property p : props) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "p = " + p);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + p.getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value = " + p.getValue());
            }
            if (p.getName().equals("featurePropertyName")) {
                featurePropertyName = p.getValue();
                continue;
            }
            if (p.getName().equals("start")) {
                start = p.getValue();
                continue;
            }
            if (!p.getName().equals("end")) continue;
            end = p.getValue();
        }
        if (featurePropertyName != null && featurePropertyName.equals(fpName) && TemplateConfigHelper.withInRange(start, end, fpValue)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isMatchingFpInfo", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchingFpInfo", new Boolean(false));
        }
        return false;
    }

    public static ObjectName createTemplate(ConfigService cs, Session session, PropertySet ps, PropertySet fps, String serverType) throws Exception {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemplate", new Object[]{ps, fps, serverType});
        }
        try {
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            String newTemplateName = TemplateConfigHelper.getCombinedTemplateName(fps, ps);
            RepositoryContext serverTypeContext = TemplateConfigHelper.getServerTypeContext(cs, session, serverType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server type context ", serverTypeContext);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server type context ", serverTypeContext.getName());
            }
            RepositoryContextType serversContextType = metadata2.getContextType("servers");
            RepositoryContext baseContext = serverTypeContext.getChild(serversContextType, TemplateConfigHelper.getPropValue(ps, "name"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "base context ", baseContext);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "base context ", baseContext.getName());
            }
            ConfigArchiveUtils.copyContext(serverTypeContext, baseContext, newTemplateName);
            RepositoryContext newTemplateContext = ConfigArchiveUtils.createContextIfNeeded(serverTypeContext, "servers", newTemplateName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new template context ", newTemplateContext);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new template context ", newTemplateContext.getName());
            }
            RepositoryContext fpContext = serverTypeContext.getChild(serversContextType, TemplateConfigHelper.getPropValue(fps, "name"));
            Set fileNames = fpContext.getFiles();
            for (String fileName : fileNames) {
                if (fileName.equals("template-metadata.xml")) continue;
                TemplateConfigHelper.copyFile(newTemplateContext, fpContext, newTemplateName, fileName);
            }
            TemplateConfigHelper.createMetadata(cs, session, ps, fps, serverTypeContext, newTemplateName);
            TemplateConfigHelper.removeServerMetadata(cs, session, newTemplateContext);
            TemplateConfigHelper.createMetadata(cs, session, ps, fps, newTemplateContext, newTemplateName);
            ConfigDataId id = new ConfigDataId(newTemplateContext.getURI(), "server.xml");
            ObjectName tempObj = ConfigServiceHelper.createObjectName(id, null, newTemplateName);
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, "name", newTemplateName);
            cs.setAttributes(session, tempObj, attrList);
            EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            EndpointConfigHelper.createServerEntry(serverTypeContext, newTemplateName, MOFUtil.createObjectName(baseContext));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTemplate", tempObj);
            }
            objectName = tempObj;
            Object var18_18 = null;
        }
        catch (Throwable t) {
            try {
                throw new Exception(t);
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                EndpointConfigHelper.setAdjustFlag(new Boolean(true));
                throw throwable;
            }
        }
        EndpointConfigHelper.setAdjustFlag(new Boolean(true));
        return objectName;
    }

    public static void createMetadata(ConfigService cs, Session session, PropertySet ps, PropertySet fps, RepositoryContext serverTypeContext, String combinedName) throws Exception {
        AttributeList property;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMetadata", new Object[]{ps, fps, serverTypeContext, combinedName});
        }
        ArrayList<AttributeList> list = new ArrayList<AttributeList>();
        EList props = ps.getProperties();
        for (Property prop : props) {
            if (prop.getName().equals("name") || prop.getName().equals("matchingProperties")) continue;
            property = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
            ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
            list.add(property);
        }
        props = fps.getProperties();
        for (Property prop : props) {
            if (prop.getName().equals("name") || prop.getName().equals("featureTemplate") || prop.getName().equals("matchingProperties")) continue;
            property = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
            ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
            list.add(property);
        }
        AttributeList property2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue(property2, "name", "name");
        ConfigServiceHelper.setAttributeValue(property2, "value", combinedName);
        list.add(property2);
        String mp1 = TemplateConfigHelper.getMatchingPropertiesAsString(ps);
        String mp2 = TemplateConfigHelper.getMatchingPropertiesAsString(fps);
        String mp = null;
        if (mp1 != null && mp2 != null) {
            mp = mp1 + "," + mp2;
            property2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property2, "name", "matchingProperties");
            ConfigServiceHelper.setAttributeValue(property2, "value", mp);
            list.add(property2);
        }
        AttributeList propertySet = new AttributeList();
        ConfigServiceHelper.setAttributeValue(propertySet, "properties", list);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(serverTypeContext, "template-metadata.xml");
        ObjectName templateMetadata = docAccessor.createRootConfigObject(session, "PropertySet", propertySet);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMetadata");
        }
    }

    public static void removeTemplate(ConfigService cs, Session session, ObjectName template) throws Exception {
        BaseServerDelegator delegator = new BaseServerDelegator(ConfigServiceImpl.getInstance());
        delegator.deleteConfigData(session, template);
    }

    public static void removeTemplateMetadata(ConfigService cs, Session session, ObjectName templateMetadata) throws Exception {
        cs.deleteConfigData(session, templateMetadata);
    }

    public static boolean checkFpVersionsForCompatibility(ConfigService cs, Session session, String v1, String v2, String propName) throws Exception {
        PropertySet cps1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFpVersionsForCompatibility", new Object[]{v1, v2, propName});
        }
        if ((cps1 = TemplateConfigHelper.getCompatibilityInfo(cs, session, propName, v1)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(false));
            }
            return false;
        }
        String start1 = TemplateConfigHelper.getPropValue(cps1, "start");
        String end1 = TemplateConfigHelper.getPropValue(cps1, "end");
        PropertySet cps2 = TemplateConfigHelper.getCompatibilityInfo(cs, session, propName, v2);
        if (cps2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(false));
            }
            return false;
        }
        String start2 = TemplateConfigHelper.getPropValue(cps2, "start");
        String end2 = TemplateConfigHelper.getPropValue(cps2, "end");
        if (start1.equals(start2) && end1.equals(end2)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(false));
        }
        return false;
    }

    public static boolean isFeaturePackUsed(ConfigService cs, Session session, PropertySet fps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeaturePackUsed", new Object[]{cs, session, fps});
        }
        List fpMatchingProperties = TemplateConfigHelper.getMatchingProperties(fps);
        String fpName = null;
        String fpValue = null;
        if (fpMatchingProperties != null && fpMatchingProperties.size() > 0) {
            fpName = TemplateConfigHelper.getFpMatchingProperty(fps);
            fpValue = TemplateConfigHelper.getPropValue(fps, fpName);
        }
        boolean res = TemplateConfigHelper.isFeaturePackUsed(cs, session, fpName, fpValue);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeaturePackUsed(", new Boolean(res));
        }
        return res;
    }

    public static boolean isFeaturePackUsed(ConfigService cs, Session session, String fpName, String fpValue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeaturePackUsed", new Object[]{cs, session, fpName, fpValue});
        }
        if (fpName == null || fpValue == null) {
            return false;
        }
        PropertySet cps = TemplateConfigHelper.getCompatibilityInfo(cs, session, fpName, fpValue);
        if (cps == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFeaturePackUsed", new Boolean(false));
            }
            return false;
        }
        String start = TemplateConfigHelper.getPropValue(cps, "start");
        String end = TemplateConfigHelper.getPropValue(cps, "end");
        ManagedObjectMetadataHelper mh = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
        ManagedObjectMetadataAccessor ma = mh.getAccessor();
        ObjectName[] matches = cs.resolve(session, "Node=");
        for (int i = 0; matches != null && i < matches.length; ++i) {
            String nodeName = ConfigServiceHelper.getDisplayName(matches[i]);
            String npValue = ma.getMetadataProperty(nodeName, fpName);
            if (npValue == null || !TemplateConfigHelper.withInRange(start, end, npValue)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFeaturePackUsed", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeaturePackUsed", new Boolean(false));
        }
        return false;
    }

    public static void addToServerMetadata(ConfigService cs, Session session, PropertySet ps, PropertySet fps, RepositoryContext serverContext, RepositoryContext fpTemplateContext) throws Exception {
        AttributeList property;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToServerMetadata", new Object[]{cs, session, ps, fps, serverContext, fpTemplateContext});
        }
        ObjectName psObjName = MOFUtil.createObjectName(ps);
        ArrayList<AttributeList> list = new ArrayList<AttributeList>();
        EList props = ps.getProperties();
        String mpSave = null;
        String mpNew = null;
        for (Property prop : props) {
            if (prop.getName().equals("matchingProperties")) {
                mpSave = prop.getValue();
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + prop.getName() + "=" + prop.getValue());
            }
            property = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
            ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
            list.add(property);
        }
        props = fps.getProperties();
        for (Property prop : props) {
            if (prop.getName().equals("name") || prop.getName().equals("featureProperty")) continue;
            if (prop.getName().equals("matchingProperties")) {
                mpNew = prop.getValue();
                continue;
            }
            if (TemplateConfigHelper.propExists(prop.getName(), ps)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + prop.getName() + "=" + prop.getValue());
            }
            property = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
            ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
            list.add(property);
        }
        if (mpSave != null) {
            mpNew = mpNew != null ? mpSave + "," + mpNew : mpSave;
        }
        if (mpNew != null) {
            AttributeList property2 = new AttributeList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding matchingProperties=" + mpNew);
            }
            ConfigServiceHelper.setAttributeValue(property2, "name", "matchingProperties");
            ConfigServiceHelper.setAttributeValue(property2, "value", mpNew);
            list.add(property2);
        }
        TemplateConfigHelper.setNewTemplateMetadata(cs, session, serverContext, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToServerMetadata");
        }
    }

    public static void removeFromServerMetadata(ConfigService cs, Session session, PropertySet ps, PropertySet fps, RepositoryContext serverContext, RepositoryContext fpTemplateContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromServerMetadata", new Object[]{cs, session, ps, fps, serverContext, fpTemplateContext});
        }
        ObjectName psObjName = MOFUtil.createObjectName(ps);
        ArrayList<AttributeList> list = new ArrayList<AttributeList>();
        ArrayList<String> removeList = new ArrayList<String>();
        List mp = TemplateConfigHelper.getMatchingPropertiesReal(ps);
        List fmp = TemplateConfigHelper.getMatchingPropertiesReal(fps);
        String mpNew = null;
        String mpSave = null;
        for (String fp : fmp) {
            if (!mp.contains(fp)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing " + fp);
            }
            removeList.add(fp);
            mp.remove(fp);
        }
        EList props = ps.getProperties();
        for (Property prop : props) {
            if (prop.getName().equals("matchingProperties")) {
                mpSave = prop.getValue();
                continue;
            }
            if (removeList.contains(prop.getName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + prop.getName() + "=" + prop.getValue());
            }
            AttributeList property = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
            ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
            list.add(property);
        }
        Iterator itr = mp.iterator();
        while (itr.hasNext()) {
            if (mpNew == null) {
                mpNew = (String)itr.next();
                continue;
            }
            mpNew = mpNew + "," + (String)itr.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adding matchineProperties=" + mpNew);
        }
        AttributeList property = new AttributeList();
        ConfigServiceHelper.setAttributeValue(property, "name", "matchingProperties");
        ConfigServiceHelper.setAttributeValue(property, "value", mpNew);
        list.add(property);
        TemplateConfigHelper.setNewTemplateMetadata(cs, session, serverContext, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromServerMetadata");
        }
    }

    public static boolean propExists(String propName, PropertySet pset) {
        EList props = pset.getProperties();
        if (props == null) {
            return false;
        }
        for (Property p : props) {
            String name = p.getName();
            if (name == null || !name.equals(propName)) continue;
            return true;
        }
        return false;
    }

    public static void copyFile(RepositoryContext parentContext, RepositoryContext templateContext, String contextName, String uri) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{parentContext, templateContext, contextName, uri});
        }
        TemplateManager templateMgr = TemplateManagerFactory.getManager((WorkSpace)parentContext.getWorkSpace());
        Template template = templateMgr.getTemplate(templateContext);
        templateMgr.createFile(parentContext, uri, template, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static boolean isFeatureUsedByServer(ConfigService cs, Session session, String featureTemplateName, String serverType, String nodeName, String serverName, boolean defaultValue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeatureUsedByServer", new Object[]{featureTemplateName, serverType, serverName, nodeName});
        }
        boolean res = true;
        PropertySet fps = TemplateConfigHelper.getFeatureTemplateMetadata(cs, session, serverType, featureTemplateName);
        if (fps == null) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0630E", new Object[]{featureTemplateName});
            throw new Exception(msg);
        }
        RepositoryContext serverContext = TemplateConfigHelper.getServerContext(cs, session, serverName, nodeName);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(serverContext, "template-metadata.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFeatureUsedByServer", new Boolean(defaultValue));
            }
            return defaultValue;
        }
        ObjectName[] objNames = docAccessor.getRootObjects(session);
        if (objNames == null || objNames.length != 1) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{serverName, nodeName});
            throw new Exception(msg);
        }
        PropertySet ps = (PropertySet)MOFUtil.convertToEObject(session, objNames[0]);
        List fmp = TemplateConfigHelper.getMatchingProperties(fps);
        List mp = TemplateConfigHelper.getMatchingProperties(ps);
        for (String fp : fmp) {
            if (mp.contains(fp)) continue;
            res = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeatureUsedByServer", new Boolean(res));
        }
        return res;
    }

    public static void setNewTemplateMetadata(ConfigService cs, Session session, RepositoryContext serverContext, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNewTemplateMetadata", new Object[]{serverContext, list});
        }
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(serverContext, "template-metadata.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{serverContext.getName(), null});
            throw new Exception(msg);
        }
        ObjectName[] objNames = docAccessor.getRootObjects(session);
        for (int i = 0; objNames != null && i < objNames.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing ", objNames[i]);
            }
            cs.deleteConfigData(session, objNames[i]);
        }
        docAccessor = WorkspaceHelper.getDocAccessor(serverContext, "template-metadata.xml");
        if (docAccessor == null) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{serverContext.getName(), null});
            throw new Exception(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "docAccessor ", docAccessor);
        }
        AttributeList propertySet = new AttributeList();
        ConfigServiceHelper.setAttributeValue(propertySet, "properties", list);
        ObjectName templateMetadata = docAccessor.createRootConfigObject(session, "PropertySet", propertySet);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNewTemplateMetadata");
        }
    }

    public static boolean isFeatureTemplate(PropertySet ps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeatureTemplate", ps);
        }
        boolean res = false;
        String featureTemplate = TemplateConfigHelper.getPropValue(ps, "featureTemplate");
        if (featureTemplate != null && featureTemplate.equals("true")) {
            res = true;
        }
        if (TemplateConfigHelper.getPropValue(ps, "com.ibm.websphere.baseProductVersion") == null) {
            EList props = ps.getProperties();
            for (Property p : props) {
                String pName = p.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template property " + pName);
                }
                if (!pName.startsWith(PROD_VER_PREFIX) || !pName.endsWith(PROD_VER_SUFFIX)) continue;
                res = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeatureTemplate", new Boolean(res));
        }
        return res;
    }

    public static ObjectName findBestMatchingDefaultTemplate(ConfigService cs, Session session, List templates) {
        return TemplateConfigHelper.findBestMatchingTemplate(cs, session, templates, new Boolean(true));
    }

    public static ObjectName findBestMatchingTemplate(ConfigService cs, Session session, List templates) {
        return TemplateConfigHelper.findBestMatchingTemplate(cs, session, templates, new Boolean(false));
    }

    public static ObjectName findBestMatchingTemplate(ConfigService cs, Session session, List templates, Boolean isDefault) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findBestMatchingTemplate", new Object[]{cs, session, templates, isDefault});
        }
        boolean defaultTemplate = isDefault;
        boolean num = false;
        int lastNum = 0;
        ObjectName bestTemplate = null;
        try {
            for (int i = 0; templates != null && i < templates.size(); ++i) {
                PropertySet set = TemplateConfigHelper.getPropertySetOfTemplate(cs, session, (ObjectName)templates.get(i));
                if (set == null || defaultTemplate && !TemplateConfigHelper.isSystemAndDefault(set)) continue;
                List mp = TemplateConfigHelper.getMatchingProperties(set);
                if (mp != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, " matching properties size ", new Integer(mp.size()));
                }
                if (mp == null || mp.size() <= lastNum) continue;
                lastNum = mp.size();
                bestTemplate = (ObjectName)templates.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " new match selected ", new Integer(lastNum));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, " new match selected ", bestTemplate);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findBestMatchingTemplate", bestTemplate);
        }
        return bestTemplate;
    }

    public static void updateTemplateMetadata(ConfigService cs, Session session, ObjectName server, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTemplateMetadata", new Object[]{cs, session, server, serverName});
        }
        try {
            ArrayList<AttributeList> list = new ArrayList<AttributeList>();
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            String contextUri = ConfigServiceHelper.getConfigDataId(server).getContextUri();
            RepositoryContext context = ws.findContext(contextUri);
            DocAccessor docAccessor = null;
            try {
                docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
            }
            catch (Exception e) {
                docAccessor = null;
            }
            if (docAccessor == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, " no metadata for ", context.getName());
                }
                return;
            }
            ObjectName[] metadata2 = docAccessor.getRootObjects(session);
            if (metadata2 != null && metadata2.length > 0) {
                AttributeList property;
                ArrayList<String> propsInMetadata = new ArrayList<String>();
                String mp = null;
                PropertySet ps = (PropertySet)MOFUtil.convertToEObject(session, metadata2[0]);
                EList props = ps.getProperties();
                for (Property prop : props) {
                    if (prop.getName().equals("matchingProperties")) {
                        mp = prop.getValue();
                        continue;
                    }
                    property = new AttributeList();
                    propsInMetadata.add(prop.getName());
                    ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
                    if (prop.getName().equals("name")) {
                        ConfigServiceHelper.setAttributeValue(property, "value", serverName);
                    } else if (prop.getName().equals("isDefaultTemplate")) {
                        ConfigServiceHelper.setAttributeValue(property, "value", "false");
                    } else if (prop.getName().equals("isSystemTemplate")) {
                        ConfigServiceHelper.setAttributeValue(property, "value", "false");
                    } else {
                        ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
                    }
                    list.add(property);
                }
                String nodeName = TemplateConfigHelper.getNodeName(cs, session, server);
                if (nodeName != null) {
                    Properties nodeProps = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(nodeName);
                    Enumeration<?> vEnum = nodeProps.propertyNames();
                    while (vEnum.hasMoreElements()) {
                        String pName = (String)vEnum.nextElement();
                        if (!pName.startsWith(PROD_VER_PREFIX) || !pName.endsWith(PROD_VER_SUFFIX) || propsInMetadata.contains(pName)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding ", pName + " = " + nodeProps.get(pName));
                        }
                        AttributeList property2 = new AttributeList();
                        ConfigServiceHelper.setAttributeValue(property2, "name", pName);
                        ConfigServiceHelper.setAttributeValue(property2, "value", nodeProps.get(pName));
                        list.add(property2);
                        if (mp == null) continue;
                        mp = mp + "," + pName;
                    }
                }
                if (mp != null) {
                    property = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(property, "name", "matchingProperties");
                    ConfigServiceHelper.setAttributeValue(property, "value", mp);
                    list.add(property);
                }
                cs.deleteConfigData(session, metadata2[0]);
                docAccessor = WorkspaceHelper.getDocAccessor(context, "template-metadata.xml");
                if (docAccessor == null) {
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{context.getName(), null});
                    throw new Exception(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "docAccessor ", docAccessor);
                }
                AttributeList propertySet = new AttributeList();
                ConfigServiceHelper.setAttributeValue(propertySet, "properties", list);
                ObjectName templateMetadata = docAccessor.createRootConfigObject(session, "PropertySet", propertySet);
                docAccessor.localSave();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTemplateMetadata");
        }
    }

    public static void removeServerMetadata(ConfigService cs, Session session, RepositoryContext context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServerMetadata", new Object[]{cs, session, context});
        }
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, " no metadata for ", context.getName());
            }
            return;
        }
        ObjectName[] metadata2 = docAccessor.getRootObjects(session);
        for (int i = 0; metadata2 != null && i < metadata2.length; ++i) {
            cs.deleteConfigData(session, metadata2[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServerMetadata");
        }
    }

    public static Integer getMatchCountInteger(ConfigService cs, Session session, ObjectName template, String nodeName) throws Exception {
        return new Integer(TemplateConfigHelper.getMatchCount(cs, session, template, nodeName));
    }

    public static int getMatchCount(ConfigService cs, Session session, ObjectName template, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchCount", new Object[]{cs, session, template, nodeName});
        }
        int num = 0;
        WorkSpace ws = WorkspaceHelper.getWorkspace(session);
        String contextUri = ConfigServiceHelper.getConfigDataId(template).getContextUri();
        RepositoryContext context = ws.findContext(contextUri);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            PropertySet tps;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " no metadata for ", context.getName());
            }
            if ((tps = TemplateConfigHelper.getPropertySetFromServerType(cs, session, context)) != null) {
                num = TemplateConfigHelper.getMatchCount(cs, session, tps, nodeName);
            } else {
                String templateNode = TemplateConfigHelper.getNodeName(cs, session, template);
                if (templateNode != null && !templateNode.equals("")) {
                    num = TemplateConfigHelper.getMatchCount(cs, session, templateNode, nodeName);
                }
            }
        } else {
            ObjectName[] metadata2 = docAccessor.getRootObjects(session);
            if (metadata2 != null && metadata2.length > 0) {
                PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, metadata2[0]);
                List mp = TemplateConfigHelper.getMatchingProperties(set);
                if (mp != null) {
                    num = mp.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " matching properties size ", new Integer(num));
                    }
                }
                if (!TemplateConfigHelper.checkNodeProperties(cs, session, set, nodeName)) {
                    num = -1;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchCount", new Integer(num));
        }
        return num;
    }

    public static boolean checkNodeProperties(ConfigService cs, Session session, PropertySet ps, String nodeName) {
        boolean res;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkNodeProperties", new Object[]{cs, session, ps, nodeName});
            }
            res = true;
            try {
                List mp = TemplateConfigHelper.getMatchingProperties(ps);
                if (mp == null) break block9;
                for (String p : mp) {
                    if (p.equals("com.ibm.websphere.nodeOperatingSystem")) {
                        String os = TemplateConfigHelper.getPropValue(ps, p);
                        if (os != null && os.equals("os390")) {
                            if (TemplateConfigHelper.isNodeZOS(session, nodeName)) continue;
                            res = false;
                        } else {
                            if (os == null || os.equals("os390") || !TemplateConfigHelper.isNodeZOS(session, nodeName)) continue;
                            res = false;
                        }
                    } else {
                        if (TemplateConfigHelper.isMatchWithNode(cs, session, p, TemplateConfigHelper.getPropValue(ps, p), nodeName)) continue;
                        res = false;
                    }
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNodeProperties", new Boolean(res));
        }
        return res;
    }

    public static boolean isMatchWithNode(ConfigService cs, Session session, String propName, String propValue, String nodeName) throws Exception {
        Properties props;
        String nodeValue;
        boolean res = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchWithNode", new Boolean(res));
        }
        if ((nodeValue = (String)(props = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(nodeName)).get(propName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find node property for ", propName + "in node " + nodeName);
            }
            res = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isMatchWithNode", new Boolean(res));
            }
            return res;
        }
        PropertySet cps = TemplateConfigHelper.getCompatibilityInfo(cs, session, propName, propValue);
        String start = null;
        String end = null;
        if (cps == null) {
            int inx;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find compatibility information in the product-info.xml ", propName);
            }
            if ((inx = propValue.indexOf(46)) != -1) {
                start = propValue.substring(0, inx);
                int s = Integer.parseInt(start);
                end = Integer.toString(++s);
                if (propName.equals("com.ibm.websphere.baseProductVersion") && propValue.startsWith("6.0")) {
                    end = "6.1";
                }
                if (propName.equals("com.ibm.websphere.baseProductVersion") && propValue.startsWith("6.1")) {
                    start = "6.1";
                }
            } else {
                start = propValue;
                end = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start ", start);
            }
        } else {
            start = TemplateConfigHelper.getPropValue(cps, "start");
            end = TemplateConfigHelper.getPropValue(cps, "end");
        }
        if (!TemplateConfigHelper.withInRange(start, end, nodeValue)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeValue ", nodeValue + " is node with in range " + start + " " + end);
            }
            res = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchWithNode", new Boolean(res));
        }
        return res;
    }

    public static Object findDefaultTemplate(ConfigService cs, Session session, String nodeName, ObjectName clusterObj, String serverType) throws Exception {
        ObjectName template = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findDefaultTemplate", new Object[]{cs, session, nodeName, clusterObj, serverType});
        }
        ArrayList errors = new ArrayList();
        try {
            Class<?> appClass = Class.forName("com.ibm.websphere.management.application.AppDeploymentUtil");
            Method method = appClass.getMethod("isNodeValidForCluster", String.class, String.class, String.class, String.class, Locale.class, List.class);
            method.invoke(null, TemplateConfigHelper.getCellName(cs, session, clusterObj), nodeName, ConfigServiceHelper.getDisplayName(clusterObj), session.toString(), Locale.getDefault(), errors);
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", (String)"291");
        }
        if (errors.size() <= 0) {
            List templates = TemplateConfigHelper.getTemplatesServertypes(cs, session, "listServerTemplates", serverType, nodeName);
            template = TemplateConfigHelper.findBestMatchingDefaultTemplate(cs, session, templates);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "errors", new Integer(errors.size()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findDefaultTemplate", template);
        }
        if (errors.size() > 0) {
            return errors;
        }
        return template;
    }

    public static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigServiceException {
        return WorkspaceHelper.getWorkspace(session).getMetadataHelper();
    }

    public static boolean isNodeZOS(Session session, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeZOS", nodeName);
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper metadataHelper = workSpace.getMetadataHelper();
        boolean result = metadataHelper.isNodeZOS(nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeZOS", new Boolean(result));
        }
        return result;
    }

    public static String getCellName(ConfigService cs, Session session, ObjectName obj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName", new Object[]{cs, session, obj});
        }
        Properties props = ConfigServiceHelper.getObjectLocation(obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "obj props = " + props);
        }
        String cellName = props.getProperty("cell");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", cellName);
        }
        return cellName;
    }

    public static String getNodeName(ConfigService cs, Session session, ObjectName template) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName", new Object[]{cs, session, template});
        }
        Properties props = ConfigServiceHelper.getObjectLocation(template);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "obj props = " + props);
        }
        String nodeName = props.getProperty("node");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName", nodeName);
        }
        return nodeName;
    }

    public static int getMatchCount(ConfigService cs, Session session, String node1, String node2) throws Exception {
        int num = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchCount", new Object[]{cs, session, node1, node2});
        }
        ArrayList<String> mp1 = new ArrayList<String>();
        ArrayList<String> mp2 = new ArrayList<String>();
        Properties props1 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(node1);
        Enumeration<?> vEnum = props1.propertyNames();
        while (vEnum.hasMoreElements()) {
            String pName = (String)vEnum.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", pName);
            }
            if ((!pName.startsWith(PROD_VER_PREFIX) || !pName.endsWith(PROD_VER_SUFFIX)) && !pName.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            mp1.add(pName);
        }
        Properties props2 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(node2);
        vEnum = props2.propertyNames();
        while (vEnum.hasMoreElements()) {
            String pName = (String)vEnum.nextElement();
            if ((!pName.startsWith(PROD_VER_PREFIX) || !pName.endsWith(PROD_VER_SUFFIX)) && !pName.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", pName);
            }
            if (!mp1.contains(pName)) continue;
            mp2.add(pName);
        }
        if (mp1.size() != mp2.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodes are not compatible", mp1.size() + " " + mp2.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkNode", new Integer(-1));
            }
            return -1;
        }
        for (String pName : mp1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", pName);
            }
            String pValue = (String)props1.get(pName);
            if (pName.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            if (!TemplateConfigHelper.isMatchWithNode(cs, session, pName, pValue, node2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No match ", pName + "=" + pValue + " " + node1 + " " + node2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkNode", new Integer(-1));
                }
                return -1;
            }
            ++num;
        }
        if (TemplateConfigHelper.isNodeZOS(session, node1)) {
            if (!TemplateConfigHelper.isNodeZOS(session, node2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node " + node1 + " is ZOS " + node1 + " is not");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkNode", new Integer(-1));
                }
                return -1;
            }
        } else if (!TemplateConfigHelper.isNodeZOS(session, node1) && TemplateConfigHelper.isNodeZOS(session, node2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node " + node1 + " is ZOS " + node1 + " is not");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkNode", new Integer(-1));
            }
            return -1;
        }
        ++num;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchCount", new Integer(num));
        }
        return num;
    }

    public static PropertySet getPropertySetFromServerType(ConfigService cs, Session session, RepositoryContext templateContext) throws Exception {
        PropertySet ps = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertySetFromServerType", new Object[]{cs, session, templateContext});
        }
        String templateName = templateContext.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "template name ", templateName);
        }
        RepositoryContext parentContext = templateContext.getParent();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent contex ", parentContext);
        }
        if (parentContext != null) {
            DocAccessor docAccessor = null;
            try {
                docAccessor = WorkspaceHelper.getDocAccessorNoCreate(parentContext, "template-metadata.xml");
            }
            catch (Exception e) {
                docAccessor = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPropertySetFromServerType", ps);
                }
                return ps;
            }
            if (docAccessor != null) {
                ObjectName[] metadata2 = docAccessor.getRootObjects(session);
                for (int i = 0; metadata2 != null && i < metadata2.length; ++i) {
                    PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, metadata2[i]);
                    String name = TemplateConfigHelper.getPropValue(set, "name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking ", name);
                    }
                    if (!templateName.equals(name)) continue;
                    ps = set;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertySetFromServerType", ps);
        }
        return ps;
    }

    public static int getMatchCount(ConfigService cs, Session session, PropertySet set, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchCount", new Object[]{cs, session, set, nodeName});
        }
        int num = 0;
        List mp = TemplateConfigHelper.getMatchingProperties(set);
        if (mp != null && mp.size() > 0) {
            num = mp.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " matching properties size ", new Integer(num));
            }
            if (!TemplateConfigHelper.checkNodeProperties(cs, session, set, nodeName)) {
                num = -1;
            }
        } else {
            String templateValue = TemplateConfigHelper.getPropValue(set, "com.ibm.websphere.baseProductVersion");
            if (templateValue == null || !TemplateConfigHelper.isMatchWithNode(cs, session, "com.ibm.websphere.baseProductVersion", templateValue, nodeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No match ", "com.ibm.websphere.baseProductVersion=" + templateValue + " " + nodeName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMatchCount", new Integer(-1));
                }
                return -1;
            }
            templateValue = TemplateConfigHelper.getPropValue(set, "com.ibm.websphere.nodeOperatingSystem");
            if (templateValue != null && templateValue.equals("os390")) {
                if (!TemplateConfigHelper.isNodeZOS(session, nodeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No match ", "com.ibm.websphere.nodeOperatingSystem=" + templateValue + " " + nodeName);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMatchCount", new Integer(-1));
                    }
                    return -1;
                }
            } else if (templateValue != null && !templateValue.equals("os390") && TemplateConfigHelper.isNodeZOS(session, nodeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No match ", "com.ibm.websphere.nodeOperatingSystem=" + templateValue + " " + nodeName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMatchCount", new Integer(-1));
                }
                return -1;
            }
            num = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchCount", new Integer(num));
        }
        return num;
    }

    public static PropertySet getPropertySetOfTemplate(ConfigService cs, Session session, ObjectName template) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertySetOfTemplate", new Object[]{cs, session, template});
        }
        PropertySet ps = null;
        WorkSpace ws = WorkspaceHelper.getWorkspace(session);
        String contextUri = ConfigServiceHelper.getConfigDataId(template).getContextUri();
        RepositoryContext context = ws.findContext(contextUri);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            ps = TemplateConfigHelper.getPropertySetFromServerType(cs, session, context);
        } else {
            ObjectName[] metadata2 = docAccessor.getRootObjects(session);
            if (metadata2 != null && metadata2.length > 0) {
                ps = (PropertySet)MOFUtil.convertToEObject(session, metadata2[0]);
            }
        }
        if (ps == null) {
            ps = TemplateConfigHelper.derivePropertySetFromTemplateNode(cs, session, template);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertySetOfTemplate", ps);
        }
        return ps;
    }

    public static PropertySet derivePropertySetFromTemplateNode(ConfigService cs, Session session, ObjectName template) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "derivePropertySetFromTemplateNode", new Object[]{cs, session, template});
        }
        PropertySet ps = null;
        String templateName = ConfigServiceHelper.getDisplayName(template);
        String templateNode = TemplateConfigHelper.getNodeName(cs, session, template);
        if (templateNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "derivePropertySetFromTemplateNode", ps);
            }
            return ps;
        }
        ps = TemplateConfigHelper.derivePropertySetFromNode(cs, session, templateNode, templateName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "derivePropertySetFromTemplateNode", ps);
        }
        return ps;
    }

    public static PropertySet derivePropertySetFromNode(ConfigService cs, Session session, String templateNode, String templateName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "derivePropertySetFromNode", new Object[]{cs, session, templateNode, templateName});
        }
        PropertySet ps = null;
        PropertiesPackage propertiespkg = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        PropertiesFactory propFactory = propertiespkg.getPropertiesFactory();
        ps = propFactory.createPropertySet();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created new ps", ps);
        }
        Properties props = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(templateNode);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got props of node ", props);
        }
        Property prop = propFactory.createProperty();
        prop.setName("name");
        prop.setValue(templateName);
        ps.getProperties().add(prop);
        Enumeration<?> vEnum = props.propertyNames();
        while (vEnum.hasMoreElements()) {
            String pName = (String)vEnum.nextElement();
            if ((!pName.startsWith(PROD_VER_PREFIX) || !pName.endsWith(PROD_VER_SUFFIX)) && !pName.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding ", pName + " = " + props.get(pName));
            }
            prop = propFactory.createProperty();
            prop.setName(pName);
            prop.setValue((String)props.get(pName));
            ps.getProperties().add(prop);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "derivePropertySetFromNode", ps);
        }
        return ps;
    }

    public static Integer getLeastDefaultTemplateMatchCount(ConfigService cs, Session session, String serverType, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLeastDefaultTemplateMatchCount", new Object[]{cs, session, serverType, nodeName});
        }
        List templates = TemplateConfigHelper.getTemplatesServertypes(cs, session, "listServerTemplates", serverType, nodeName);
        Integer cnt = TemplateConfigHelper.findLeastMatchingCnt(cs, session, templates);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLeastDefaultTemplateMatchCount", cnt);
        }
        return cnt;
    }

    public static Integer findLeastMatchingCnt(ConfigService cs, Session session, List templates) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findLeastMatchingCnt", new Object[]{cs, session, templates});
        }
        boolean defaultTemplate = true;
        boolean num = false;
        int lastNum = 0;
        ObjectName bestTemplate = null;
        try {
            for (int i = 0; templates != null && i < templates.size(); ++i) {
                PropertySet set = TemplateConfigHelper.getPropertySetOfTemplate(cs, session, (ObjectName)templates.get(i));
                if (set == null || defaultTemplate && !TemplateConfigHelper.isSystemAndDefault(set)) continue;
                List mp = TemplateConfigHelper.getMatchingProperties(set);
                if (mp != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, " matching properties size ", new Integer(mp.size()));
                }
                if (mp == null || mp.size() > lastNum) continue;
                lastNum = mp.size();
                bestTemplate = (ObjectName)templates.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " new match selected ", new Integer(lastNum));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, " new match selected ", bestTemplate);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findLeastMatchingCnt", new Integer(lastNum));
        }
        return new Integer(lastNum);
    }

    public static Integer getDefaultTemplateMatchCount(ConfigService cs, Session session, String serverType, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTemplateMatchCount", new Object[]{cs, session, serverType, nodeName});
        }
        List templates = TemplateConfigHelper.getTemplatesServertypes(cs, session, "listServerTemplates", serverType, nodeName);
        Integer cnt = TemplateConfigHelper.findBestMatchingCnt(cs, session, templates);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTemplateMatchCount", cnt);
        }
        return cnt;
    }

    public static Integer findBestMatchingCnt(ConfigService cs, Session session, List templates) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findBestMatchingCnt", new Object[]{cs, session, templates});
        }
        boolean defaultTemplate = true;
        boolean num = false;
        int lastNum = 0;
        ObjectName bestTemplate = null;
        try {
            for (int i = 0; templates != null && i < templates.size(); ++i) {
                PropertySet set = TemplateConfigHelper.getPropertySetOfTemplate(cs, session, (ObjectName)templates.get(i));
                if (set == null || defaultTemplate && !TemplateConfigHelper.isSystemAndDefault(set)) continue;
                List mp = TemplateConfigHelper.getMatchingProperties(set);
                if (mp != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, " matching properties size ", new Integer(mp.size()));
                }
                if (mp == null || mp.size() <= lastNum) continue;
                lastNum = mp.size();
                bestTemplate = (ObjectName)templates.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " new match selected ", new Integer(lastNum));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, " new match selected ", bestTemplate);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findBestMatchingCnt", new Integer(lastNum));
        }
        return new Integer(lastNum);
    }

    public static List listMatchingServerTemplatesForNode(ConfigService cs, Session session, String serverType, String nodeName) throws Exception {
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        if (serverType == null) {
            serverType = "APPLICATION_SERVER";
        }
        return TemplateConfigHelper.getTemplatesServertypes(cs, session, "listServerTemplates", serverType, nodeName);
    }

    public static List listMatchingServersForNode(ConfigService cs, Session session, String node) throws Exception {
        ArrayList<ObjectName> servers = new ArrayList<ObjectName>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listMatchingServersForNode", new Object[]{cs, session, node});
        }
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        String serverSpec = "Server=";
        int lastNum = 0;
        ObjectName[] matches = cs.resolve(session, serverSpec);
        for (int i = 0; matches != null && i < matches.length; ++i) {
            int num;
            ObjectName server = matches[i];
            String serverName = ConfigServiceHelper.getDisplayName(server);
            String nodeName = TemplateConfigHelper.getNodeName(cs, session, server);
            if (nodeName == null || nodeName.equals("") || TemplateConfigHelper.isNodeAgentOrDmgr(cs, session, nodeName, serverName, "APPLICATION_SERVER")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " checking server ", nodeName + " " + serverName);
            }
            if ((num = TemplateConfigHelper.getMatchCount(cs, session, nodeName, node)) > lastNum) {
                lastNum = num;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " found better server ", nodeName + " " + serverName);
                }
                servers.clear();
                servers.add(server);
                continue;
            }
            if (num != lastNum) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " adding server ", nodeName + " " + serverName);
            }
            servers.add(server);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listMatchingServersForNode", servers);
        }
        return servers;
    }

    public static List listAvailableClusterMemberNodes(ConfigService cs, Session session, String firstNodeName, String ngName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", new Object[]{cs, session, firstNodeName, ngName});
        }
        ArrayList<String> selectedNodes = new ArrayList<String>();
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        String[] nodes = null;
        nodes = ngName != null ? NodeGroupHelper.getNodeGroupMembers(session, cs, ngName) : TemplateConfigHelper.getAllNodes(cs, session, firstNodeName);
        for (int i = 0; i < nodes.length; ++i) {
            if (TemplateConfigHelper.isDmgrNode(cs, session, nodes[i]) || !TemplateConfigHelper.isManagedNode(cs, session, nodes[i])) continue;
            selectedNodes.add(nodes[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", selectedNodes);
        }
        return selectedNodes;
    }

    public static List listAvailableClusterMemberNodes(ConfigService cs, Session session, String clusterName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", new Object[]{cs, session, clusterName});
        }
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        ArrayList<String> selectedNodes = new ArrayList<String>();
        String clusterSpec = "ServerCluster=" + clusterName;
        ObjectName[] matches = cs.resolve(session, clusterSpec);
        if (matches != null && matches.length == 1) {
            ObjectName clusterObj = matches[0];
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            ObjectName[] currentMemberObjs = cs.queryConfigObjects(session, clusterObj, pattern, null);
            String nodeName = null;
            if (currentMemberObjs != null && currentMemberObjs.length > 0) {
                nodeName = (String)cs.getAttribute(session, currentMemberObjs[0], "nodeName");
            }
            String ngName = (String)cs.getAttribute(session, clusterObj, "nodeGroupName");
            String[] nodes = null;
            nodes = ngName != null ? NodeGroupHelper.getNodeGroupMembers(session, cs, ngName) : TemplateConfigHelper.getAllNodes(cs, session, nodeName);
            for (int i = 0; i < nodes.length; ++i) {
                if (TemplateConfigHelper.isDmgrNode(cs, session, nodes[i]) || !TemplateConfigHelper.isManagedNode(cs, session, nodes[i])) continue;
                selectedNodes.add(nodes[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", selectedNodes);
        }
        return selectedNodes;
    }

    public static String[] getAllNodes(ConfigService cs, Session session, String firstNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNodes", new Object[]{cs, session, firstNode});
        }
        ArrayList<String> nodes = new ArrayList<String>();
        String nodeSpec = "Node=";
        boolean zos = false;
        if (firstNode != null) {
            zos = TemplateConfigHelper.isNodeZOS(session, firstNode);
        }
        ObjectName[] matches = cs.resolve(session, nodeSpec);
        for (int i = 0; matches != null && i < matches.length; ++i) {
            ObjectName node = matches[i];
            String nodeName = ConfigServiceHelper.getDisplayName(node);
            if (zos) {
                if (!TemplateConfigHelper.isNodeZOS(session, nodeName)) continue;
                nodes.add(nodeName);
                continue;
            }
            if (firstNode != null) {
                if (TemplateConfigHelper.isNodeZOS(session, nodeName)) continue;
                nodes.add(nodeName);
                continue;
            }
            nodes.add(nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllNodes", nodes);
        }
        String[] result = new String[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    public static boolean isDmgrNode(ConfigService cs, Session session, String nodeName) {
        boolean res = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManaged", new Object[]{cs, session, nodeName});
        }
        try {
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext rootContext = ws.getRootContext();
            RepositoryContextType type = metadata2.getContextType("cells");
            RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
            RepositoryContext nodeContext = ws.findContext(cellContext.getURI() + "/nodes/" + nodeName);
            nodeContext.extract("serverindex.xml", false);
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI("serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex si = (ServerIndex)resource.getContents().get(0);
            EList list = si.getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                if (!serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
                res = true;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManaged", new Boolean(res));
        }
        return res;
    }

    public static boolean isManagedNode(ConfigService cs, Session session, String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManaged", new Object[]{cs, session, nodeName});
        }
        boolean managed = false;
        try {
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext rootContext = ws.getRootContext();
            RepositoryContextType type = metadata2.getContextType("cells");
            RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
            RepositoryContext nodeContext = ws.findContext(cellContext.getURI() + "/nodes/" + nodeName);
            nodeContext.extract("serverindex.xml", false);
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI("serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex si = (ServerIndex)resource.getContents().get(0);
            EList list = si.getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                if (!serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") && !serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
                managed = true;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            managed = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManaged", new Boolean(managed));
        }
        return managed;
    }

    public static boolean isNodeAgentOrDmgr(ConfigService cs, Session session, String nodeName, String serverName, String serverType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeAgentOrDmgr", new Object[]{cs, session, nodeName, serverName});
        }
        boolean res = false;
        try {
            WorkSpace ws = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext rootContext = ws.getRootContext();
            RepositoryContextType type = metadata2.getContextType("cells");
            RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
            RepositoryContext nodeContext = ws.findContext(cellContext.getURI() + "/nodes/" + nodeName);
            nodeContext.extract("serverindex.xml", false);
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI("serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex si = (ServerIndex)resource.getContents().get(0);
            EList list = si.getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                if (serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") || serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) {
                    if (!serverEntry.getServerName().equals(serverName)) continue;
                    res = true;
                } else {
                    if (serverType == null || !serverEntry.getServerName().equals(serverName) || serverEntry.getServerType().equalsIgnoreCase(serverType)) continue;
                    res = true;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeAgentOrDmgr", new Boolean(res));
        }
        return res;
    }

    private static String[] getBaseProductInfo(ConfigService cs, Session session, String propName, String propValue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBaseProductInfo", new Object[]{cs, session, propName, propValue});
        }
        String[] result = new String[2];
        PropertySet cps = TemplateConfigHelper.getCompatibilityInfo(cs, session, propName, propValue);
        String start = null;
        String end = null;
        if (cps == null) {
            int inx;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find compatibility information in the product-info.xml ", propName);
            }
            if ((inx = propValue.indexOf(46)) != -1) {
                start = propValue.substring(0, inx);
                int s = Integer.parseInt(start);
                end = Integer.toString(++s);
                if (propName.equals("com.ibm.websphere.baseProductVersion") && propValue.startsWith("6.0")) {
                    end = "6.1";
                }
                if (propName.equals("com.ibm.websphere.baseProductVersion") && propValue.startsWith("6.1")) {
                    start = "6.1";
                }
            } else {
                start = propValue;
                end = null;
            }
        } else {
            start = TemplateConfigHelper.getPropValue(cps, "start");
            end = TemplateConfigHelper.getPropValue(cps, "end");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start ", start);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "end ", end);
        }
        result[0] = start;
        result[1] = end;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBaseProductInfo ", result);
        }
        return result;
    }

    public static boolean isTemplateMatchWithNode(ConfigService cs, Session session, ObjectName template, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTemplateMatchWithNode ", new Object[]{template, nodeName});
        }
        boolean result = true;
        int cnt1 = TemplateConfigHelper.getMatchCount(cs, session, template, nodeName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "template match cnt ", new Integer(cnt1));
        }
        PropertySet ps = TemplateConfigHelper.derivePropertySetFromNode(cs, session, nodeName, "temp");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node ps ", ps);
        }
        List mp = TemplateConfigHelper.getMatchingProperties(ps);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node mp ", mp);
        }
        int cnt2 = mp.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node match cnt ", new Integer(cnt2));
        }
        result = cnt1 == cnt2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTemplateMatchWithNode ", new Boolean(result));
        }
        return result;
    }

    public static boolean isSameFeatureOnNodes(ConfigService cs, Session session, String node1, String node2) {
        boolean result = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSameFeatureOnNodes ", new Object[]{session, node1, node2});
        }
        if (node2 == null) {
            return true;
        }
        if (node1 == null) {
            return false;
        }
        try {
            String pValue1;
            Properties nodeProps1 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(node1);
            Properties nodeProps2 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(node2);
            Enumeration<?> vEnum = nodeProps1.propertyNames();
            while (vEnum.hasMoreElements()) {
                String pName1 = (String)vEnum.nextElement();
                if (!pName1.startsWith(PROD_VER_PREFIX) || !pName1.endsWith(FEATURE_PROD_VER_SUFFIX)) continue;
                pValue1 = nodeProps1.getProperty(pName1);
                String pValue2 = nodeProps2.getProperty(pName1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prop name and values ", pName1 + " " + pValue1 + " " + pValue2);
                }
                if (pValue2 == null) {
                    result = false;
                    break;
                }
                PropertySet cps1 = TemplateConfigHelper.getCompatibilityInfo(cs, session, pName1, pValue1);
                if (cps1 == null || TemplateConfigHelper.checkFpVersionsForCompatibility(cs, session, pValue1, pValue2, pName1)) continue;
                result = false;
                break;
            }
            vEnum = nodeProps2.propertyNames();
            while (vEnum.hasMoreElements()) {
                String pName2 = (String)vEnum.nextElement();
                if (!pName2.startsWith(PROD_VER_PREFIX) || !pName2.endsWith(FEATURE_PROD_VER_SUFFIX)) continue;
                pValue1 = nodeProps1.getProperty(pName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prop name and values ", pName2 + " " + pValue1);
                }
                if (pValue1 != null) continue;
                result = false;
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSameFeatureOnNodes ", new Boolean(result));
        }
        return result;
    }

    public static List listAvailableClusterMemberNodes(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", new Object[]{cs, session});
        }
        ArrayList<String> nodes = new ArrayList<String>();
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        String nodeSpec = "Node=";
        ObjectName[] matches = cs.resolve(session, nodeSpec);
        for (int i = 0; matches != null && i < matches.length; ++i) {
            ObjectName node = matches[i];
            String nodeName = ConfigServiceHelper.getDisplayName(node);
            if (TemplateConfigHelper.isDmgrNode(cs, session, nodeName) || !TemplateConfigHelper.isManagedNode(cs, session, nodeName)) continue;
            nodes.add(nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes ", nodes);
        }
        return nodes;
    }

    public static List listAllServers(ConfigService cs, Session session) throws Exception {
        ArrayList<ObjectName> servers = new ArrayList<ObjectName>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllServers", new Object[]{cs, session});
        }
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        String serverSpec = "Server=";
        ObjectName[] matches = cs.resolve(session, serverSpec);
        for (int i = 0; matches != null && i < matches.length; ++i) {
            String clusterName;
            ObjectName server = matches[i];
            String serverName = ConfigServiceHelper.getDisplayName(server);
            String nodeName = TemplateConfigHelper.getNodeName(cs, session, server);
            if (nodeName == null || nodeName.equals("") || TemplateConfigHelper.isNodeAgentOrDmgr(cs, session, nodeName, serverName, "APPLICATION_SERVER") || (clusterName = (String)cs.getAttribute(session, server, "clusterName")) != null && !clusterName.equals("")) continue;
            servers.add(server);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllServers ", servers);
        }
        return servers;
    }
}

