/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class RemoveTemplatesCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(RemoveTemplatesCommand.class, "TemplateConfig", BUNDLE_NAME);

    public RemoveTemplatesCommand(TaskCommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public RemoveTemplatesCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String[] featureTemplateNames = (String[])this.getParameter("featureTemplateNames");
            String serverType = (String)this.getParameter("serverType");
            Boolean removeDocuments = (Boolean)this.getParameter("removeDocuments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", featureTemplateNames);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeDocuments", removeDocuments);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; featureTemplateNames != null && i < featureTemplateNames.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", featureTemplateNames[i]);
                }
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            List featureNames = null;
            if (serverType != null && ((featureNames = TemplateConfigHelper.getFeatureNames(cs, session, serverType)) == null || featureNames.size() == 0)) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0620E", new Object[]{this.getName(), serverType});
                throw new CommandValidationException(msg);
            }
            if (featureTemplateNames != null && featureTemplateNames.length > 0) {
                if (serverType == null) {
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0621E", new Object[]{this.getName()});
                    throw new CommandValidationException(msg);
                }
                for (int i = 0; i < featureTemplateNames.length; ++i) {
                    if (featureNames.contains(featureTemplateNames[i])) continue;
                    String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0622E", new Object[]{this.getName(), featureTemplateNames[i]});
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        List removedTemplates = null;
        try {
            String[] featureTemplateNames = (String[])this.getParameter("featureTemplateNames");
            String serverType = (String)this.getParameter("serverType");
            Boolean removeDocuments = (Boolean)this.getParameter("removeDocuments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", featureTemplateNames);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeDocuments", removeDocuments);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; featureTemplateNames != null && i < featureTemplateNames.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", featureTemplateNames[i]);
                }
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            removedTemplates = serverType != null && featureTemplateNames != null && featureTemplateNames.length > 0 ? this.removeTemplates(cs, session, serverType, featureTemplateNames, removeDocuments) : (serverType == null ? this.removeTemplates(cs, session, removeDocuments) : this.removeTemplates(cs, session, serverType, removeDocuments));
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)result)).setException(e);
            ((CommandResultImpl)((Object)result)).setResult(msg);
        }
        ((CommandResultImpl)((Object)result)).setResult(removedTemplates);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted", removedTemplates);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private List removeTemplates(ConfigService cs, Session session, Boolean removeDocuments) throws Exception {
        List serverTypes;
        ArrayList templates = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{cs, session, removeDocuments});
        }
        if ((serverTypes = TemplateConfigHelper.getServerTypes(cs, session)) == null) {
            return templates;
        }
        for (String serverType : serverTypes) {
            List removedTemplates = this.removeTemplates(cs, session, serverType, removeDocuments);
            templates.addAll(removedTemplates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", templates);
        }
        return templates;
    }

    private List removeTemplates(ConfigService cs, Session session, String serverType, Boolean removeDocuments) throws Exception {
        List featureNames;
        ArrayList templates = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{cs, session, serverType, removeDocuments});
        }
        if ((featureNames = TemplateConfigHelper.getFeatureNames(cs, session, serverType)) == null || featureNames.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTemplates", "no feature packs");
            }
            return templates;
        }
        for (String featureName : featureNames) {
            List removedTemplates = this.removeTemplates(cs, session, serverType, featureName, removeDocuments);
            templates.addAll(removedTemplates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", templates);
        }
        return templates;
    }

    private List removeTemplates(ConfigService cs, Session session, String serverType, String[] featureTemplateNames, Boolean removeDocuments) throws Exception {
        ArrayList templates = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{cs, session, serverType, featureTemplateNames});
        }
        if (featureTemplateNames == null || featureTemplateNames.length < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTemplates", "no feature packs");
            }
            return templates;
        }
        for (int i = 0; i < featureTemplateNames.length; ++i) {
            String featureName = featureTemplateNames[i];
            List removedTemplates = this.removeTemplates(cs, session, serverType, featureName, removeDocuments);
            templates.addAll(removedTemplates);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", templates);
        }
        return templates;
    }

    private List removeTemplates(ConfigService cs, Session session, String serverType, String featureTemplateName, Boolean removeDocuments) throws Exception {
        ArrayList<String> removedTemplates = new ArrayList<String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{cs, session, serverType, featureTemplateName});
        }
        ObjectName[] templates = TemplateConfigHelper.getTemplateMetadataForServerType(cs, session, serverType);
        PropertySet featurePs = TemplateConfigHelper.getFeatureTemplateMetadata(cs, session, serverType, featureTemplateName);
        List fpMatchingProperties = TemplateConfigHelper.getMatchingProperties(featurePs);
        String fpMatchingProperty = null;
        String fval = null;
        if (featurePs != null) {
            fpMatchingProperty = TemplateConfigHelper.getFpMatchingProperty(featurePs);
            fval = TemplateConfigHelper.getPropValue(featurePs, fpMatchingProperty);
        }
        if (templates == null || fval == null || fpMatchingProperty == null) {
            return removedTemplates;
        }
        for (int i = 0; i < templates.length; ++i) {
            boolean res;
            String bval;
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, templates[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + set);
            }
            if ((bval = TemplateConfigHelper.getPropValue(set, fpMatchingProperty)) == null || !(res = TemplateConfigHelper.checkFpVersionsForCompatibility(cs, session, fval, bval, fpMatchingProperty))) continue;
            ObjectName templateObjName = TemplateConfigHelper.getServerTemplateObjectName(cs, session, serverType, TemplateConfigHelper.getPropValue(set, "name"));
            TemplateConfigHelper.removeTemplate(cs, session, templateObjName);
            TemplateConfigHelper.removeTemplateMetadata(cs, session, templates[i]);
            removedTemplates.add(TemplateConfigHelper.getPropValue(set, "name"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", removedTemplates);
        }
        return removedTemplates;
    }
}

