/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class RemoveProductInfoCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(RemoveProductInfoCommand.class, "TemplateConfig", BUNDLE_NAME);

    public RemoveProductInfoCommand(TaskCommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public RemoveProductInfoCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String featureShortName = (String)this.getParameter("featureShortName");
            String featureName = (String)this.getParameter("featurePropertyName");
            String featureVersion = (String)this.getParameter("featureVersion");
            String featureStartVersion = (String)this.getParameter("featureStartVersion");
            String featureEndVersion = (String)this.getParameter("featureEndVersion");
            String baseStartVersion = (String)this.getParameter("baseStartVersion");
            String baseEndVersion = (String)this.getParameter("baseEndVersion");
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext rootContext = workspace.getRootContext();
            RepositoryContextType type = metaData.getContextType("cells");
            RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
            DocAccessor docAccessor = null;
            try {
                docAccessor = WorkspaceHelper.getDocAccessorNoCreate(cellContext, "product-info.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean found = false;
            if (docAccessor != null) {
                ObjectName[] list = docAccessor.getRootObjects(session);
                for (int i = 0; i < list.length; ++i) {
                    PropertySet ps = (PropertySet)MOFUtil.convertToEObject(session, list[i]);
                    String val = TemplateConfigHelper.getPropValue(ps, "name");
                    if (!val.equals(featureShortName)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0626E", new Object[]{this.getName(), featureShortName});
                throw new CommandValidationException(msg);
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        try {
            String featureShortName = (String)this.getParameter("featureShortName");
            String featureName = (String)this.getParameter("featurePropertyName");
            String featureVersion = (String)this.getParameter("featureVersion");
            String featureStartVersion = (String)this.getParameter("featureStartVersion");
            String featureEndVersion = (String)this.getParameter("featureEndVersion");
            String baseStartVersion = (String)this.getParameter("baseStartVersion");
            String baseEndVersion = (String)this.getParameter("baseEndVersion");
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            this.removeFeature(cs, session, featureShortName);
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)result)).setException(e);
            ((CommandResultImpl)((Object)result)).setResult(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private void removeFeature(ConfigService cs, Session session, String featureShortName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFeature");
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext rootContext = workspace.getRootContext();
        RepositoryContextType type = metaData.getContextType("cells");
        RepositoryContext cellContext = (RepositoryContext)rootContext.findContext(type).iterator().next();
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(cellContext, "product-info.xml");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeFeature");
            }
            return;
        }
        ObjectName[] list = docAccessor.getRootObjects(session);
        for (int i = 0; i < list.length; ++i) {
            PropertySet ps = (PropertySet)MOFUtil.convertToEObject(session, list[i]);
            String val = TemplateConfigHelper.getPropValue(ps, "name");
            if (!val.equals(featureShortName)) continue;
            cs.deleteConfigData(session, list[i]);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFeature");
        }
    }
}

