/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.ObjectName;

public class AddFeaturesToServerCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(AddFeaturesToServerCommand.class, "TemplateConfig", BUNDLE_NAME);

    public AddFeaturesToServerCommand(TaskCommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public AddFeaturesToServerCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            Session session;
            CommandProviderHelper ch;
            ConfigService cs;
            List featureNames;
            String featureTemplateName = (String)this.getParameter("featureTemplateName");
            String serverType = (String)this.getParameter("serverType");
            String serverName = (String)this.getParameter("serverName");
            String nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", serverName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", nodeName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateName", featureTemplateName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            if ((featureNames = TemplateConfigHelper.getFeatureNames(cs = (ch = CommandMgr.getCommandMgr().getCommandProviderHelper()).getConfigService(), session = this.getConfigSession(), serverType)) == null || featureNames.size() == 0) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0620E", new Object[]{this.getName(), serverType});
                throw new CommandValidationException(msg);
            }
            if (!featureNames.contains(featureTemplateName)) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0622E", new Object[]{this.getName(), featureTemplateName});
                throw new CommandValidationException(msg);
            }
            String serverSpec = null;
            serverSpec = serverName == null || serverName.equals("") ? "Node=" + nodeName + ":Server=" : "Node=" + nodeName + ":Server=" + serverName;
            ObjectName[] matches = cs.resolve(session, serverSpec);
            if (matches == null || matches.length < 1) {
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0625E", new Object[]{this.getName(), nodeName, serverName});
                throw new CommandValidationException(msg);
            }
            for (int i = 0; matches != null && i < matches.length; ++i) {
                serverName = ConfigServiceHelper.getDisplayName(matches[i]);
                if (TemplateConfigHelper.isNodeAgentOrDmgr(cs, session, nodeName, serverName, serverType)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No action for ", serverName);
                    continue;
                }
                if (!TemplateConfigHelper.isFeatureUsedByServer(cs, session, featureTemplateName, serverType, nodeName, serverName, false)) continue;
                String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0627E", new Object[]{this.getName(), featureTemplateName});
                throw new CommandValidationException(msg);
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(e, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        try {
            String featureTemplateName = (String)this.getParameter("featureTemplateName");
            String serverType = (String)this.getParameter("serverType");
            String serverName = (String)this.getParameter("serverName");
            String nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", serverName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", nodeName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateName", featureTemplateName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService cs = ch.getConfigService();
            Session session = this.getConfigSession();
            String serverSpec = null;
            serverSpec = serverName == null || serverName.equals("") ? "Node=" + nodeName + ":Server=" : "Node=" + nodeName + ":Server=" + serverName;
            ObjectName[] matches = cs.resolve(session, serverSpec);
            for (int i = 0; matches != null && i < matches.length; ++i) {
                serverName = ConfigServiceHelper.getDisplayName(matches[i]);
                if (serverName.equals("dmgr") || serverName.equals("nodeagent")) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No action for ", serverName);
                    continue;
                }
                this.addFeature(cs, session, nodeName, serverName, serverType, featureTemplateName);
            }
        }
        catch (Exception e) {
            String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)result)).setException(e);
            ((CommandResultImpl)((Object)result)).setResult(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult result = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private void addFeature(ConfigService cs, Session session, String nodeName, String serverName, String serverType, String featureTemplateName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFeature", new Object[]{cs, session, nodeName, serverName, serverType, featureTemplateName});
        }
        RepositoryContext featureTemplateContext = TemplateConfigHelper.getServerTemplateContext(cs, session, serverType, featureTemplateName);
        RepositoryContext serverContext = TemplateConfigHelper.getServerContext(cs, session, serverName, nodeName);
        Set fileNames = featureTemplateContext.getFiles();
        for (String fileName : fileNames) {
            if (fileName.equals("template-metadata.xml")) continue;
            TemplateConfigHelper.copyFile(serverContext, featureTemplateContext, serverName, fileName);
        }
        PropertySet fps = TemplateConfigHelper.getFeatureTemplateMetadata(cs, session, serverType, featureTemplateName);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(serverContext, "template-metadata.xml");
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addFeature");
            }
            return;
        }
        if (docAccessor == null) {
            return;
        }
        ObjectName[] objNames = docAccessor.getRootObjects(session);
        if (objNames == null || objNames.length != 1) {
            return;
        }
        PropertySet ps = (PropertySet)MOFUtil.convertToEObject(session, objNames[0]);
        TemplateConfigHelper.addToServerMetadata(cs, session, ps, fps, serverContext, featureTemplateContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFeature");
        }
    }
}

