/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.Properties;
import javax.management.ObjectName;

public class ShowServerInfo
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ShowServerInfo.class, "ShowServerInfo", "com.ibm.ws.management.commands.server");
    private ObjectName server = null;

    public ShowServerInfo(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ShowServerInfo(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName svr = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "svr", svr);
        }
        try {
            ObjectName[] match = cs.queryConfigObjects(session, null, svr, null);
            if (match.length != 1) {
                throw new InvalidParameterValueException(this.getName(), "TargetObject", svr);
            }
        }
        catch (CommandValidationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.validate", (String)"80");
            throw new CommandValidationException(th, "validation for command ShowServerInfo failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            result.setResult(this.showServerInfo());
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.commands.server.validate", (String)"94");
            result.setException(new CommandException(th, "ShowServerInfo command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private Properties showServerInfo() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ShowServerInfo", this.server);
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session s = this.getConfigSession();
        ObjectName server = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", server);
        }
        Properties location = ConfigServiceHelper.getObjectLocation(server);
        AdminCommand cmd = CommandMgr.getCommandMgr().createCommand("getServerType");
        cmd.setConfigSession(s);
        String nodeName = location.getProperty("node");
        cmd.setParameter("nodeName", nodeName);
        cmd.setParameter("serverName", location.getProperty("server"));
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            throw result.getException();
        }
        String serverType = (String)result.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerType", serverType);
        }
        location.put("serverType", serverType);
        WorkSpace ws = WorkspaceHelper.getWorkspace(s);
        ManagedObjectMetadataHelper metaDataHelper = ws.getMetadataHelper();
        location.put("com.ibm.websphere.baseProductVersion", metaDataHelper.getNodeBaseProductVersion(nodeName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showServerInfo", location);
        }
        return location;
    }
}

