/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.server.BestTemplates;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.ServerDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class ServerConfigHelper {
    public static final String APPLICATION_SERVER_TYPE = "APPLICATION_SERVER";
    private static TraceComponent tc = Tr.register(ServerConfigHelper.class, "management", "com.ibm.ws.management.resources.configservice");

    public static List listServerTemplates(ConfigService configService, Session session, String serverType, String[] queryExp) throws Exception {
        return ServerConfigHelper.listServerTemplates(configService, session, serverType, queryExp, null);
    }

    public static List listServerTemplates(ConfigService configService, Session session, String serverType, String[] queryExp, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTemplates", new Object[]{configService, session, serverType, queryExp, nodeName});
        }
        ArrayList templates = new ArrayList();
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metaData.getContextType("servertypes");
            RepositoryContextType serverContextType = metaData.getContextType("servers");
            if (serverType != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerType Specified: " + serverType);
                }
                RepositoryContext serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
                List temp = ServerConfigHelper.getTemplatesFromServerType(session, configService, serverTypeContext, serverType, queryExp, nodeName);
                templates.addAll(temp);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerType NOT Specified: ");
                }
                List serverTypeContexts = templateContext.getChildren();
                for (RepositoryContext serverTypeContext : serverTypeContexts) {
                    if (serverTypeContext.getName().trim().equals("")) continue;
                    List temp = ServerConfigHelper.getTemplatesFromServerType(session, configService, serverTypeContext, serverType, queryExp, nodeName);
                    templates.addAll(temp);
                }
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTemplates");
        }
        return templates;
    }

    protected static List getTemplatesFromServerType(Session session, ConfigService configService, RepositoryContext serverTypeContext, String serverType, String[] queryExp) throws Exception {
        return ServerConfigHelper.getTemplatesFromServerType(session, configService, serverTypeContext, serverType, queryExp, null);
    }

    protected static List getTemplatesFromServerType(Session session, ConfigService configService, RepositoryContext serverTypeContext, String serverType, String[] queryExp, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplatesFromServerType", new Object[]{session, configService, serverTypeContext, serverType, queryExp, nodeName});
        }
        boolean check_query = false;
        Properties query = new Properties();
        Properties not_query = new Properties();
        if (queryExp != null && queryExp.length > 0) {
            for (int i = 0; i < queryExp.length; ++i) {
                String value;
                String key;
                if (queryExp[i] == null) continue;
                int eq = queryExp[i].indexOf("=");
                int neq = queryExp[i].indexOf("!=");
                if (eq <= 0 && neq <= 0) continue;
                if (neq > 0) {
                    key = queryExp[i].substring(0, neq);
                    value = queryExp[i].substring(neq + 2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding NOT to query list: ", new Object[]{key, value});
                    }
                    not_query.setProperty(key, value);
                    check_query = true;
                    continue;
                }
                key = queryExp[i].substring(0, eq);
                value = queryExp[i].substring(eq + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding equal to query list: ", new Object[]{key, value});
                }
                query.setProperty(key, value);
                check_query = true;
            }
        }
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        List<ObjectName> templates = new ArrayList();
        List servers = serverTypeContext.getChildren();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Context: " + servers);
        }
        if (servers != null) {
            Iterator it = servers.iterator();
            int defaultTemplateMatchCount = 0;
            BestTemplates selectedTemplates = new BestTemplates();
            while (it.hasNext()) {
                RepositoryContext sCtx = (RepositoryContext)it.next();
                ConfigDataId id = new ConfigDataId(sCtx.getURI(), metaData.getContextType("servers").getRootDocumentType().getFilePattern());
                ObjectName templateId = ConfigServiceHelper.createObjectName(id, null, sCtx.getName());
                PropertySet set = ServerConfigHelper.getMetadata(session, configService, serverTypeContext.getName(), sCtx.getName());
                if (set == null) continue;
                EList props = set.getProperties();
                Iterator prop_it = props.iterator();
                boolean accept_temp = true;
                if (check_query) {
                    while (prop_it.hasNext()) {
                        Property p = (Property)prop_it.next();
                        String q = query.getProperty(p.getName());
                        String nq = not_query.getProperty(p.getName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Comparing: " + p.getName() + "   " + p.getValue());
                        }
                        if (nq != null) {
                            accept_temp &= !nq.equals(p.getValue());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "AcceptTemp" + accept_temp);
                            }
                            if (accept_temp) continue;
                            break;
                        }
                        if (q == null) continue;
                        accept_temp &= q.equals(p.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "AcceptTemp - 2" + accept_temp);
                    }
                }
                if (!accept_temp) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding to list: " + templateId);
                }
                if (nodeName == null) {
                    templates.add(templateId);
                    continue;
                }
                int num = TemplateConfigHelper.getMatchCount(configService, session, set, nodeName);
                if (TemplateConfigHelper.isSystemAndDefault(set)) {
                    defaultTemplateMatchCount = selectedTemplates.setMatchCount(num);
                    selectedTemplates.addTemplate(templateId, num);
                    continue;
                }
                if (num < defaultTemplateMatchCount) continue;
                selectedTemplates.addTemplate(templateId, num);
            }
            if (nodeName != null) {
                templates = selectedTemplates.getBestTemplates();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplatesFromServerType");
        }
        return templates;
    }

    protected static ObjectName getTypeMetadataObjectName(Session session, ConfigService configService, String serverType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataObjectName", new Object[]{session, configService, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metaData.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            if (serverTypeContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadataObjectName - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        ConfigDataId id = new ConfigDataId(serverTypeContext.getURI(), "servertype-metadata.xml");
        ObjectName metadataTypeId = ConfigServiceHelper.createObjectName(id, null, serverType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataObjectName", metadataTypeId);
        }
        return metadataTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static PropertySet getMetadata(Session session, ConfigService configService, String serverType, String templateName) throws Exception {
        ObjectName[] list;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMetadata", new Object[]{session, configService, serverType, templateName});
            }
            list = null;
            ObjectName metadataTypeId = ServerConfigHelper.getTypeMetadataObjectName(session, configService, serverType);
            try {
                Object var11_13;
                try {
                    WorkSpace ws = WorkspaceHelper.getWorkspace(session);
                    String contextUri = ConfigServiceHelper.getConfigDataId(metadataTypeId).getContextUri();
                    RepositoryContext context = ws.findContext(contextUri);
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context, "template-metadata.xml");
                    list = docAccessor.getRootObjects(session);
                }
                catch (ConfigDataNotFoundException cdnfe) {
                    var11_13 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMetadata - none", null);
                        }
                        return null;
                    }
                    break block19;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.server.ServerConfigHelper.getMetadata", (String)"291");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occured during getMetadata", ex);
                    }
                    var11_13 = null;
                    if (list == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMetadata - none", null);
                        }
                        return null;
                    }
                    break block19;
                }
                var11_13 = null;
                if (list != null) break block19;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (list != null) {
                    throw throwable;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata - none", null);
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetadata - none", null);
            }
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            PropertySet set = (PropertySet)MOFUtil.convertToEObject(session, list[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + set);
            }
            EList props = set.getProperties();
            for (Property p : props) {
                if (!p.getName().equals("name") || !p.getValue().equals(templateName)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata", set);
                }
                return set;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadata", null);
        }
        return null;
    }

    protected static boolean doesServerTypeExist(ConfigService configService, Session session, String serverType) throws ConfigServiceException {
        boolean answer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesServerTypeExist", new Object[]{configService, session, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metaData.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            answer = serverTypeContext != null;
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesServerTypeExist", new Boolean(answer));
        }
        return answer;
    }

    protected static ObjectName buildServerType(ConfigService configService, Session session, String serverType) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildServerType", new Object[]{configService, session, serverType});
        }
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext serverTypeContext = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            RepositoryContextType serverTypeContextType = metaData.getContextType("servertypes");
            serverTypeContext = templateContext.getChild(serverTypeContextType, serverType);
            serverTypeContext = serverTypeContext == null ? templateContext.create(serverTypeContextType, serverType) : templateContext.getChild(serverTypeContextType, serverType);
        }
        catch (WorkSpaceException ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        ConfigDataId id = new ConfigDataId(serverTypeContext.getURI(), "servertype-metadata.xml");
        ObjectName serverTypeId = ConfigServiceHelper.createObjectName(id, null, serverType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", serverTypeId);
        }
        return serverTypeId;
    }

    static Collection getServertypesContexts(WorkSpace workspace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServertypesContexts", workspace);
        }
        TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
        RepositoryContext templateContext = templateMan.getRootTemplateContext();
        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        Collection serverTypeContexts = templateContext.findContext(metaData.getContextType("servertypes"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServertypesContexts", serverTypeContexts);
        }
        return serverTypeContexts;
    }

    private static ObjectName getMetadataOfTemplate(Session session, ObjectName template) throws Exception {
        ObjectName[] rootObjs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataOfTemplate", new Object[]{session, template});
        }
        ObjectName metadata2 = null;
        Session templateSession = WorkspaceHelper.getConfigSession(template);
        if (templateSession == null) {
            templateSession = session;
        }
        WorkSpace ws = WorkspaceHelper.getWorkspace(templateSession);
        String contextUri = ConfigServiceHelper.getConfigDataId(template).getContextUri();
        RepositoryContext context = ws.findContext(contextUri);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(context, "template-metadata.xml");
        }
        catch (Exception e) {
            docAccessor = null;
        }
        if (docAccessor != null && (rootObjs = docAccessor.getRootObjects(templateSession)) != null && rootObjs.length > 0) {
            metadata2 = rootObjs[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataOfTemplate", metadata2);
        }
        return metadata2;
    }

    private static void copyMetadata(Session session, ObjectName serverType, ObjectName metadata2, String templateName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyMetadata", new Object[]{session, serverType, metadata2, templateName});
        }
        PropertySet ps = (PropertySet)MOFUtil.convertToEObject(session, metadata2);
        ArrayList<AttributeList> list = new ArrayList<AttributeList>();
        EList props = ps.getProperties();
        for (Property prop : props) {
            AttributeList property = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property, "name", prop.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " property ", prop.getName() + "=" + prop.getValue());
            }
            if (prop.getName().equals("name")) {
                ConfigServiceHelper.setAttributeValue(property, "value", templateName);
            } else {
                ConfigServiceHelper.setAttributeValue(property, "value", prop.getValue());
            }
            list.add(property);
        }
        WorkSpace ws = WorkspaceHelper.getWorkspace(session);
        String contextUri = ConfigServiceHelper.getConfigDataId(serverType).getContextUri();
        RepositoryContext context = ws.findContext(contextUri);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context, "template-metadata.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "docAccessor ", docAccessor);
        }
        AttributeList propertySet = new AttributeList();
        ConfigServiceHelper.setAttributeValue(propertySet, "properties", list);
        ObjectName templateMetadata = docAccessor.createRootConfigObject(session, "PropertySet", propertySet);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyMetadata");
        }
    }

    private static ObjectName createMetadata(Session session, ObjectName serverType, String templateName, String nodeName, String description) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMetadata", new Object[]{session, serverType, templateName, description});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Properties props = ServerConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(nodeName);
        ArrayList<AttributeList> list = new ArrayList<AttributeList>();
        AttributeList property1 = new AttributeList();
        ConfigServiceHelper.setAttributeValue(property1, "name", "name");
        ConfigServiceHelper.setAttributeValue(property1, "value", templateName);
        list.add(property1);
        Enumeration<?> vEnum = props.propertyNames();
        String majorVersion = null;
        String prodVersion = null;
        boolean found = false;
        boolean foundOS = false;
        while (vEnum.hasMoreElements()) {
            String p = (String)vEnum.nextElement();
            AttributeList property2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue(property2, "name", p);
            ConfigServiceHelper.setAttributeValue(property2, "value", props.get(p));
            if (p.equals("com.ibm.websphere.nodeOperatingSystem")) {
                foundOS = true;
            }
            if (p.equals("com.ibm.websphere.baseProductMajorVersion")) {
                prodVersion = (String)props.get(p);
                found = true;
            }
            if (p.equals("com.ibm.websphere.baseProductVersion")) {
                majorVersion = (String)props.get(p);
                if (majorVersion.startsWith("6.1")) {
                    majorVersion = "6.1";
                } else if (majorVersion != null && majorVersion.length() > 0 && majorVersion.indexOf(".") > 0) {
                    majorVersion = majorVersion.substring(0, majorVersion.indexOf("."));
                }
            }
            list.add(property2);
        }
        if (!found && majorVersion != null && majorVersion.length() > 0) {
            AttributeList majV = new AttributeList();
            prodVersion = majorVersion;
            ConfigServiceHelper.setAttributeValue(majV, "name", "com.ibm.websphere.baseProductMajorVersion");
            ConfigServiceHelper.setAttributeValue(majV, "value", majorVersion);
            list.add(majV);
        }
        if (!foundOS && prodVersion != null && prodVersion.length() > 0 && prodVersion.startsWith("5")) {
            AttributeList osV = new AttributeList();
            ConfigServiceHelper.setAttributeValue(osV, "name", "com.ibm.websphere.nodeOperatingSystem");
            ConfigServiceHelper.setAttributeValue(osV, "value", "");
            list.add(osV);
        }
        if (description == null || description.trim().equals("")) {
            description = "";
        }
        AttributeList desc = new AttributeList();
        ConfigServiceHelper.setAttributeValue(desc, "name", "description");
        ConfigServiceHelper.setAttributeValue(desc, "value", description);
        list.add(desc);
        AttributeList system = new AttributeList();
        ConfigServiceHelper.setAttributeValue(system, "name", "isSystemTemplate");
        ConfigServiceHelper.setAttributeValue(system, "value", "false");
        list.add(system);
        AttributeList def = new AttributeList();
        ConfigServiceHelper.setAttributeValue(def, "name", "isDefaultTemplate");
        ConfigServiceHelper.setAttributeValue(def, "value", "false");
        list.add(def);
        AttributeList propertySet = new AttributeList();
        ConfigServiceHelper.setAttributeValue(propertySet, "properties", list);
        Session templateSession = WorkspaceHelper.getConfigSession(serverType);
        if (templateSession == null) {
            templateSession = session;
        }
        WorkSpace ws = WorkspaceHelper.getWorkspace(templateSession);
        String contextUri = ConfigServiceHelper.getConfigDataId(serverType).getContextUri();
        RepositoryContext context = ws.findContext(contextUri);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(context, "template-metadata.xml");
        ObjectName templateMetadata = docAccessor.createRootConfigObject(templateSession, "PropertySet", propertySet);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMetadata", templateMetadata);
        }
        return templateMetadata;
    }

    public static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigServiceException {
        return WorkspaceHelper.getWorkspace(session).getMetadataHelper();
    }

    public static List getTemplate(Session configSession, ObjectName templateLocation, String templateName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplate", new Object[]{templateLocation, templateName});
        }
        List<ObjectName> result = Collections.EMPTY_LIST;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server", templateName);
            Session session = WorkspaceHelper.getConfigSession(templateLocation);
            if (session == null) {
                session = configSession;
            }
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName[] templates = cs.queryConfigObjects(session, templateLocation, pattern, null);
            if (session != configSession) {
                for (int i = 0; i < templates.length; ++i) {
                    templates[i] = WorkspaceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(templates[i]), ConfigServiceHelper.getConfigDataType(templates[i]), ConfigServiceHelper.getDisplayName(templates[i]), session);
                }
            }
            result = Arrays.asList(templates);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.server.ServerConfigHelper.getTemplates", (String)"403");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", result);
        }
        return result;
    }

    public static ObjectName createServer(Session session, ObjectName node, String serverName, ObjectName template, boolean genUnique) throws Exception {
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, "name", serverName);
        ConfigServiceHelper.setAttributeValue(attrList, "_Websphere_Config_Data_Template", template);
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ServerDelegator delegator = new ServerDelegator(ConfigServiceImpl.getInstance());
        if (!genUnique) {
            ConfigServiceHelper.setAttributeValue(attrList, "adjustPort", new Boolean(false));
        }
        ObjectName server = delegator.createBasicConfigObject(session, node, attrList);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", server);
        }
        return server;
    }

    public static ObjectName createServerTemplate(Session session, String nodeName, String serverName, String templateName, String description, ObjectName templateLoc) throws Exception {
        ObjectName metadata2;
        ConfigService configService;
        ObjectName[] queryResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerTemplate", new Object[]{session, nodeName, serverName, templateName, description, templateLoc});
        }
        if ((queryResult = (configService = ConfigServiceFactory.getConfigService()).resolve(session, "Node=" + nodeName + ":Server=" + serverName)).length == 0) {
            throw new ConfigServiceException("server is not found");
        }
        ObjectName server = queryResult[0];
        ObjectName template = null;
        String serverType = (String)configService.getAttribute(session, server, "serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", serverType);
        }
        if (templateLoc == null) {
            PropertySet exist = ServerConfigHelper.getMetadata(session, configService, serverType, templateName);
            if (exist != null) {
                throw new ConfigServiceException("Template with name: " + templateName + " already exists");
            }
            templateLoc = ServerConfigHelper.buildServerType(configService, session, serverType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateLoc", templateLoc);
            }
        }
        BaseServerDelegator delegator = new BaseServerDelegator(ConfigServiceImpl.getInstance());
        AttributeList attrList = new AttributeList();
        server = WorkspaceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(server), ConfigServiceHelper.getConfigDataType(server), ConfigServiceHelper.getDisplayName(server), session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", server);
        }
        ConfigServiceHelper.setAttributeValue(attrList, "_Websphere_Config_Data_Template", server);
        ConfigServiceHelper.setAttributeValue(attrList, "name", templateName);
        Session templateSession = WorkspaceHelper.getConfigSession(templateLoc);
        if (templateSession == null) {
            templateSession = session;
        }
        if ((metadata2 = ServerConfigHelper.getMetadataOfTemplate(session, template = delegator.createConfigObject(templateSession, templateLoc, null, attrList))) != null) {
            ServerConfigHelper.copyMetadata(session, templateLoc, metadata2, templateName);
            TemplateConfigHelper.updateTemplateMetadata(configService, templateSession, template, templateName);
        } else {
            ServerConfigHelper.createMetadata(session, templateLoc, templateName, nodeName, description);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerTemplate", template);
        }
        return template;
    }

    public static void deleteServer(Session session, String nodeName, String serverName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServer", new Object[]{session, nodeName, serverName});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName[] queryResult = configService.resolve(session, "Node=" + nodeName + ":Server=" + serverName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Result from ConfigService: " + queryResult);
        }
        if (queryResult.length == 0) {
            throw new ConfigServiceException("server is not found");
        }
        ServerDelegator delegator = new ServerDelegator(ConfigServiceImpl.getInstance());
        delegator.deleteBasicConfigData(session, queryResult[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServer");
        }
    }

    public static void deleteServerTemplate(Session session, ObjectName template) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerTemplate", new Object[]{session, template});
        }
        Properties props = ConfigServiceHelper.getObjectLocation(template);
        String serverTypes = props.getProperty("servertype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerType: " + serverTypes);
        }
        String server = props.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server);
        }
        if (server.endsWith("|server.xml")) {
            server = server.substring(0, server.indexOf("|server.xml"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server: " + server);
            }
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName metadata2 = ServerConfigHelper.getTypeMetadataObjectName(session, configService, serverTypes);
        PropertySet propSet = ServerConfigHelper.getMetadata(session, configService, serverTypes, server);
        EList proplist = propSet.getProperties();
        for (Property p : proplist) {
            if (!p.getName().equals("isSystemTemplate") || !p.getValue().equalsIgnoreCase("true")) continue;
            throw new ConfigServiceException("Can not delete a System Template");
        }
        BaseServerDelegator delegator = new BaseServerDelegator(ConfigServiceImpl.getInstance());
        delegator.deleteConfigData(session, template);
        ObjectName serverTemplateMetadata = MOFUtil.createObjectName(propSet);
        configService.deleteConfigData(session, serverTemplateMetadata);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServerTemplate");
        }
    }
}

