/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.management.commands.server.CreateServer;
import java.util.List;
import javax.management.ObjectName;

public class CreateApplicationServer
extends CreateServer {
    private static TraceComponent tc = Tr.register(CreateApplicationServer.class, "CreateApplicationServer", "com.ibm.ws.management.commands.server");

    public CreateApplicationServer(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateApplicationServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public Object[] getTargetObjectChoices() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetObjectChoices");
        }
        Object[] choices = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        try {
            AdminCommand cmd = cmdMgr.createCommand("listManagedNodes");
            cmd.setConfigSession(this.getConfigSession());
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (result.isSuccessful()) {
                List nodes = (List)result.getResult();
                for (Object nodeName : nodes) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "nodeName = " + nodeName);
                }
                choices = nodes.toArray();
            } else {
                FFDCFilter.processException((Throwable)result.getException(), (String)"com.ibm.ws.management.commands.server.CreateApplicationServer.getTargetObjectChoices", (String)"104");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.server.CreateApplicationServer.getTargetObjectChoices", (String)"104");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetObjectChoices", choices);
        }
        return choices;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        String nodeName = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", nodeName);
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName node = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Node", nodeName), null)[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node", node);
            }
            ObjectName cell = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Cell"), null)[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell", cell);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell type is " + cs.getAttribute(session, cell, "cellType"));
                Tr.debug(tc, "isCelLRegistered attribute value is " + cs.getAttribute(session, cell, "cellRegistered"));
                Tr.debug(tc, "Test mode is " + System.getProperties().getProperty("ConfigService.TestMode"));
                Tr.debug(tc, "NodeAgent length is " + cs.queryConfigObjects(session, node, ConfigServiceHelper.createObjectName(null, "NodeAgent"), null).length);
            }
            if (!cs.getAttribute(session, cell, "cellType").equals("STANDALONE") && System.getProperties().get("ConfigService.TestMode") == null && cs.queryConfigObjects(session, node, ConfigServiceHelper.createObjectName(null, "NodeAgent"), null).length == 0) {
                throw new InvalidParameterValueException(this.getName(), "nodeName", nodeName);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.server.CreateApplicationServer.validate", (String)"118");
            throw new CommandValidationException(ex, "unexpected exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }
}

