/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.reports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.commands.reports.BaseReport;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ReportConfiguredPorts
extends BaseReport {
    private static TraceComponent tc = Tr.register(ReportConfiguredPorts.class, "Admin", "com.ibm.ws.management.resources.configarchive");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());

    public static String getReport(AbstractAdminCommand cmd) throws Exception {
        String node = (String)cmd.getParameter("node");
        return ReportConfiguredPorts.getReport(node);
    }

    public static String getReport(String node) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReport", node);
        }
        StringBuffer output = new StringBuffer();
        String cell = ReportConfiguredPorts.getCellName();
        output.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.title", new Object[]{cell}, "Ports configured in cell {0}\n\n"));
        if (node != null) {
            ReportConfiguredPorts.getPortsForNode(node, output);
        } else {
            String[] nodes = ReportConfiguredPorts.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                ReportConfiguredPorts.getPortsForNode(nodes[i], output);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReport");
        }
        return output.toString();
    }

    private static void getPortsForNode(String node, StringBuffer output) throws Exception {
        ServerIndex serverIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortsForNode", node);
        }
        if ((serverIndex = ReportConfiguredPorts.getServerIndex(node, output)) != null) {
            EList servers = serverIndex.getServerEntries();
            for (int i = 0; i < servers.size(); ++i) {
                ServerEntry server = (ServerEntry)servers.get(i);
                String serverName = server.getServerName();
                output.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.nodeAndServer", new Object[]{node, serverName}, "\n\nNode {0} / Server {1}\n"));
                EList endPoints = server.getSpecialEndpoints();
                for (int j = 0; j < endPoints.size(); ++j) {
                    NamedEndPoint nep = (NamedEndPoint)endPoints.get(j);
                    String name = nep.getEndPointName();
                    EndPoint ep = nep.getEndPoint();
                    String host = ep.getHost();
                    int port = ep.getPort();
                    output.append("    " + host + ":" + port + " " + name + "\n");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortsForNode", node);
        }
    }

    private static ServerIndex getServerIndex(String node, StringBuffer output) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndex", node);
        }
        String serverIndexURI = "cells/" + ReportConfiguredPorts.getCellName() + "/nodes/" + node + "/serverindex.xml";
        ServerIndex serverIndex = null;
        Resource resource = null;
        WASResourceSetImpl resourceSet = null;
        DocumentContentSource dcs = null;
        try {
            dcs = ConfigRepositoryFactory.getConfigRepository().extract(serverIndexURI);
            resourceSet = new WASResourceSetImpl();
            URI uri = URI.createFileURI(dcs.getDocument().getURI());
            resource = resourceSet.createResource(uri);
            if (resource != null) {
                resource.load(dcs.getSource(), new HashMap());
                serverIndex = (ServerIndex)resource.getContents().get(0);
            }
        }
        catch (Exception e) {
            if (ReportConfiguredPorts.nodeExists(node)) {
                output.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.problemNode", new Object[]{node, e.getMessage()}, "\n\nThere is a problem accessing the information for node {0}: {1}\n"));
            }
            output.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.invalidNode", new Object[]{node}, "\n\n {0} is not a valid node name\n"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndex", node);
        }
        return serverIndex;
    }
}

