/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.reports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BaseReport {
    private static String cellName = null;
    private static TraceComponent tc = Tr.register(BaseReport.class, "Admin", "com.ibm.ws.management.resources.configarchive");

    public static String getReport() throws Exception {
        throw new Exception("Implementation class must override the getReport method");
    }

    protected static String getCellName() {
        if (cellName == null) {
            ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
            String[] folders = repository2.listResourceNames("cells", 2, 1);
            cellName = folders[0].substring(folders[0].indexOf("/") + 1);
        }
        return cellName;
    }

    protected static String[] getNodes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodes");
        }
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        String[] folders = repository2.listResourceNames("cells/" + BaseReport.getCellName() + "/nodes", 2, 1);
        for (int i = 0; i < folders.length; ++i) {
            folders[i] = folders[i].substring(folders[i].indexOf("/nodes/") + 7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodes", folders);
        }
        return folders;
    }

    protected static boolean nodeExists(String node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nodeExists", node);
        }
        boolean result = false;
        ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
        String[] folders = repository2.listResourceNames("cells/" + BaseReport.getCellName() + "/nodes/" + node, 2, 0);
        if (folders.length == 1) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nodeExists", new Object[]{node, result});
        }
        return result;
    }

    protected static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args, String msg) {
        try {
            String result = bundle.getString(key);
            if (result == null) {
                return msg;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (msg == null) {
                return msg;
            }
            return MessageFormat.format(msg, args);
        }
        catch (NullPointerException npe) {
            return msg;
        }
    }
}

