/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import com.ibm.ws.management.commands.properties.resources.properties.UserDefinedVariableMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class Section {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(Section.class, "Section", "com.ibm.ws.management.resources.configservice");
    private String type;
    private String implementingResourceType;
    private String skip;
    private String skipSubSections;
    private String createTemplate;
    private String deleteTemplate;
    private String createDeleteCommandProperties;
    private String delete;
    private String cfgId;
    private String attrName;
    private String nameField;
    private String valueField;
    private String extensionId;
    private Props[] props;
    private Properties properties = null;
    private Properties headerProperties = null;

    Section() {
    }

    Section(String type, String implementingResourceType, String skip, String skipSubSections, String delete, String createTemplate, String deleteTemplate, String cfgId, Props[] props, String attrName, String nameField, String valueField) {
        this.type = type;
        this.cfgId = cfgId;
        this.implementingResourceType = implementingResourceType;
        this.delete = delete;
        this.skip = skip;
        this.skipSubSections = skipSubSections;
        this.createTemplate = createTemplate;
        this.deleteTemplate = deleteTemplate;
        this.cfgId = cfgId;
        this.props = props;
        this.attrName = attrName;
        this.nameField = nameField;
        this.valueField = valueField;
        this.properties = null;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public String getNameField() {
        return this.nameField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setProps(Props[] props) {
        this.props = props;
    }

    public Props[] getProps() {
        return this.props;
    }

    public String getCfgId() {
        return this.cfgId;
    }

    public String setCfgId(String cfgId) {
        this.cfgId = cfgId;
        return this.cfgId;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public void setExtensionId(String ext) {
        this.extensionId = ext;
    }

    public void setCreateDeleteCommandProperties(String val) {
        this.createDeleteCommandProperties = val;
    }

    public String getCreateDeleteCommandProperties() {
        return this.createDeleteCommandProperties;
    }

    public String getType() {
        return this.type;
    }

    public String getImplementingResourceType() {
        return this.implementingResourceType;
    }

    public boolean isCreateTemplate() {
        return this.createTemplate != null && this.createTemplate.equals("true");
    }

    public boolean isDeleteTemplate() {
        return this.deleteTemplate != null && this.deleteTemplate.equals("true");
    }

    public Properties getSectionHeaderProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSectionHeaderProperties");
        }
        if (this.headerProperties == null) {
            this.headerProperties = new Properties();
            if (this.skip != null) {
                this.headerProperties.setProperty("SKIP", this.skip);
            }
            if (this.skipSubSections != null) {
                this.headerProperties.setProperty("SKIPSUBSECTIONS", this.skipSubSections);
            }
            if (this.cfgId != null) {
                this.headerProperties.setProperty("RESOURCEID", this.cfgId);
            }
            if (this.type != null) {
                this.headerProperties.setProperty("RESOURCETYPE", this.type);
            }
            if (this.implementingResourceType != null) {
                this.headerProperties.setProperty("IMPLEMENTINGRESOURCETYPE", this.implementingResourceType);
            }
            if (this.attrName != null) {
                this.headerProperties.setProperty("ATTRIBUTEINFO", this.attrName);
            }
            if (this.nameField != null) {
                this.headerProperties.setProperty("ATTRIBUTENAME", this.nameField);
            }
            if (this.valueField != null) {
                this.headerProperties.setProperty("ATTRIBUTEVALUE", this.valueField);
            }
            if (this.extensionId != null) {
                this.headerProperties.setProperty("ExtensionId", this.extensionId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSectionHeaderProperties", this.headerProperties);
        }
        return this.headerProperties;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            for (int i = 0; this.props != null && i < this.props.length; ++i) {
                this.properties.setProperty(this.props[i].getName(), this.props[i].getValue());
            }
        }
        return this.properties;
    }

    public boolean canApply() {
        return this.canCreate();
    }

    public boolean canDelete() {
        return this.canCreate();
    }

    public boolean canCreate() {
        boolean result = true;
        if (this.skipSection()) {
            result = false;
        } else if (this.skipSubSections()) {
            result = false;
        }
        return result;
    }

    public boolean skipSubSections() {
        boolean result = false;
        if (this.skipSubSections != null && this.skipSubSections.equals("true")) {
            result = true;
        }
        return result;
    }

    public boolean skipSection() {
        boolean result = false;
        if (this.skip != null && this.skip.equals("true")) {
            result = true;
        }
        if (this.isCreateTemplate()) {
            result = true;
        }
        if (this.isDeleteTemplate()) {
            result = true;
        }
        return result;
    }

    public boolean canDeleteWholeSection() {
        boolean result = false;
        if (this.skipSection()) {
            result = false;
        } else if (this.skipSubSections()) {
            result = false;
        } else if (this.delete != null && this.delete.equals("true")) {
            result = true;
        }
        return result;
    }

    public String[] getAllVariables() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllVariables");
        }
        ArrayList varList = new ArrayList();
        for (int i = 0; this.props != null && i < this.props.length; ++i) {
            String val = this.props[i].getValue();
            if (!UserDefinedVariableMap.isVariable(val)) continue;
            List allVars = UserDefinedVariableMap.getAllVars(val);
            for (int j = 0; allVars != null && j < allVars.size(); ++j) {
                if (varList.contains(allVars.get(j))) continue;
                varList.add(allVars.get(j));
            }
        }
        Properties configHeaderProps = this.getSectionHeaderProperties();
        if (configHeaderProps != null) {
            Enumeration<Object> e = configHeaderProps.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = configHeaderProps.getProperty(key);
                if (!UserDefinedVariableMap.isVariable(val)) continue;
                List allVars = UserDefinedVariableMap.getAllVars(val);
                for (int j = 0; allVars != null && j < allVars.size(); ++j) {
                    if (varList.contains(allVars.get(j))) continue;
                    varList.add(allVars.get(j));
                }
            }
        }
        String[] result = varList.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllVariables", result);
        }
        return result;
    }
}

