/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesParser;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.commands.properties.resources.mapping.GlobalMappingFileData;
import com.ibm.ws.management.commands.properties.resources.mapping.MappingFileData;
import com.ibm.ws.management.commands.properties.resources.mapping.PropertiesMappingFileParser;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.ObjectName;

public class SectionedPropertiesHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(SectionedPropertiesHelper.class, "SectionedPropertiesHelper", "com.ibm.ws.management.resources.configservice");
    public static final String MAPPING_FILE_PREFIX = "com/ibm/ws/management/commands/properties/resources/description/";
    public static final String MAPPING_FILE_SUFFIX = ".props";

    public static void loadMappingFile(String configType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMappingFile", new Object[]{configType});
        }
        if (GlobalMappingFileData.get(configType) != null) {
            return;
        }
        PropertiesMappingFileParser parser = new PropertiesMappingFileParser(configType);
        PropertiesParser pParser = new PropertiesParser(parser);
        String fileName = MAPPING_FILE_PREFIX + configType + MAPPING_FILE_SUFFIX;
        pParser.parse(fileName);
        if (GlobalMappingFileData.get(configType) == null && !configType.equals("GenericType")) {
            throw new Exception("No mapping file found for configType " + configType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMappingFile");
        }
    }

    public static void loadAllMappingFiles() {
        Set types;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadAllMappingFiles");
        }
        if ((types = WASResourceTypeRegistry.getAllRegisteredTypes()) != null) {
            for (String type : types) {
                try {
                    SectionedPropertiesHelper.loadMappingFile(type);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Could not load mapping file for " + type);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadAllMappingFiles");
        }
    }

    public static String getImplType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getImplType", new Object[]{type});
        }
        String implType = null;
        MappingFileData[] md = GlobalMappingFileData.getAll();
        boolean found = false;
        for (int i = 0; md != null && i < md.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checking in " + md[i]);
            }
            SectionData[] sections = md[i].getSections();
            for (int j = 0; sections != null && j < sections.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking in " + sections[j]);
                }
                if (!sections[j].getType().equals(type)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching section " + sections[j]);
                }
                implType = md[i].getType();
                found = true;
                break;
            }
            if (found) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImplType", implType);
        }
        return implType;
    }

    public static SectionData[] getSections(ObjectName configData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSections", configData);
        }
        SectionData[] matchSections = null;
        ArrayList<SectionData> lst = new ArrayList<SectionData>();
        String configType = ConfigServiceHelper.getConfigDataType(configData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checking section for  " + configType);
        }
        MappingFileData[] md = GlobalMappingFileData.getAll();
        block0: for (int i = 0; md != null && i < md.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checking in " + md[i]);
            }
            SectionData[] sections = md[i].getSections();
            boolean foundOne = false;
            for (int j = 0; sections != null && j < sections.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking in " + sections[j]);
                }
                if (!sections[j].getType().equals(configType) && (sections[j].getContainingType() == null || !sections[j].getContainingType().equals(configType))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching section " + sections[j]);
                }
                if (!foundOne) {
                    if (sections[j].getType().equals(configType)) {
                        foundOne = true;
                    }
                } else if (sections[j].getType().equals(configType)) {
                    lst.add(sections[j]);
                    continue block0;
                }
                lst.add(sections[j]);
            }
        }
        matchSections = lst.toArray(new SectionData[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSections", matchSections);
        }
        return matchSections;
    }

    public static SectionData[] getSections(String configType) {
        MappingFileData mappingData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSections", configType);
        }
        if ((mappingData = GlobalMappingFileData.get(configType)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSections", "No MapingFileData");
            }
            return null;
        }
        SectionData[] sections = mappingData.getSections();
        if (sections == null || sections.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSections", "No Sections");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSections", sections);
        }
        return sections;
    }

    public static boolean supportsSection(String configType) {
        SectionData[] sections;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportsSection", configType);
        }
        boolean result = false;
        MappingFileData mappingData = GlobalMappingFileData.get(configType);
        if (mappingData == null && tc.isEntryEnabled()) {
            Tr.debug(tc, "no mapping data");
        }
        SectionData[] sectionDataArray = sections = mappingData != null ? mappingData.getSections() : null;
        if (sections == null || sections.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "no section data");
            }
        } else {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportsSection", new Boolean(result));
        }
        return result;
    }

    public static void setCommonSectionProperties(SectionedProperties sectionedProperties, SectionData section) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCommonSectionProperties", new Object[]{sectionedProperties, section});
        }
        if (section.getType() != null) {
            sectionedProperties.setResourceType(section.getType());
        }
        if (section.getComments() != null) {
            sectionedProperties.setComments(section.getComments());
        }
        if (section.getName() != null) {
            String str = new String(section.getAttrName() + "(" + section.getName() + "," + section.getValue() + ")");
            sectionedProperties.setAttributeInfo(str);
        } else if (section.getAttrName() != null) {
            String str = new String(section.getAttrName());
            sectionedProperties.setAttributeInfo(str);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCommonSectionProperties");
        }
    }

    public static String[] getSubTypes(String configType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubTypes", configType);
        }
        String[] subTypes = null;
        MappingFileData mappingData = GlobalMappingFileData.get(configType);
        if (mappingData == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubTypes", subTypes);
            }
            return subTypes;
        }
        subTypes = mappingData.getSubTypes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubTypes", subTypes);
        }
        return subTypes;
    }

    public static void writeProperties(SectionedProperties[] props, OutputStream os, PropWASResource res, String sectionNumber) throws IOException {
        SectionedPropertiesHelper.writeProperties(props, os, (WASResource)res, sectionNumber);
    }

    public static void writeProperties(SectionedProperties[] props, OutputStream os, WASResource res, String sectionNumber) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeProperties", new Object[]{props, os, res, sectionNumber});
        }
        if (props == null || props.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeProperties");
            }
            return;
        }
        String resId = null;
        try {
            EnvVariables varObject = (EnvVariables)res.getReferenceProperties().get("EnvironmentVariablesObject");
            resId = PropertiesUtils.convertConfigIdToConfigScope(props[0].getResourceId(), res.getSession(), res.getConfigService(), varObject);
        }
        catch (Exception e) {
            resId = props[0].getResourceId();
        }
        StringBuffer sb = new StringBuffer("\n#\n# Section " + sectionNumber + " ## " + resId + "\n#\n");
        String str = sb.toString();
        os.write(str.getBytes());
        for (int i = 0; props != null && i < props.length; ++i) {
            SectionedProperties sp = props[i];
            SectionedPropertiesHelper.writeSection(sp, os, res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeProperties");
        }
    }

    public static void writeSection(SectionedProperties sp, OutputStream os, PropWASResource res) throws IOException {
        SectionedPropertiesHelper.writeSection(sp, os, (WASResource)res);
    }

    public static void writeSection(SectionedProperties sp, OutputStream os, WASResource res) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeSection", new Object[]{sp, os, res});
        }
        SectionedPropertiesHelper.writeSectionHeader(sp, os, res, true);
        SectionedPropertiesHelper.writeSectionProperties(sp, os, res);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeSection");
        }
    }

    public static void writeSectionHeader(SectionedProperties sp, OutputStream os, WASResource res, boolean writeId) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeSectionHeader", new Object[]{sp, os, res, new Boolean(writeId)});
        }
        String str = null;
        str = sp.getComments() != null ? sp.getComments() : sp.getResourceType();
        StringBuffer sb = new StringBuffer();
        if ((sp.isCreateTemplate() || sp.isDeleteTemplate()) && (str.startsWith("Create") || str.startsWith("Delete"))) {
            sb = sb.append("\n#######################################################################################\n");
        }
        sb = sp.getSectionNumber() != null ? sb.append("\n#\n# SubSection " + sp.getSectionNumber() + " # " + str + "\n#\n") : sb.append("\n#\n# " + str + "\n#\n");
        sb = sb.append("ResourceType").append("=").append(sp.getResourceType()).append("\n").append("ImplementingResourceType").append("=").append(sp.getImplementingResourceType()).append("\n");
        if (writeId) {
            String resId = null;
            try {
                EnvVariables varObject = (EnvVariables)res.getReferenceProperties().get("EnvironmentVariablesObject");
                resId = PropertiesUtils.convertConfigIdToConfigScope(sp.getResourceId(), res.getSession(), res.getConfigService(), varObject);
            }
            catch (Exception e) {
                resId = sp.getResourceId();
            }
            sb = sb.append("ResourceId").append("=").append(resId).append("\n");
        }
        if (sp.getAttributeInfo() != null) {
            sb = sb.append("AttributeInfo").append("=").append(sp.getAttributeInfo()).append("\n");
        }
        if (sp.isCreateTemplate()) {
            sb = sb.append("SKIP").append("=").append("true").append("\n");
            sb = sb.append("CreateDeleteCommandProperties").append("=").append("true").append("\n");
        }
        if (sp.isDeleteTemplate()) {
            sb = sb.append("SKIP").append("=").append("true").append("\n");
            sb = sb.append("CreateDeleteCommandProperties").append("=").append("true").append("\n");
        }
        sb = sb.append("#\n\n#\n#Properties\n#\n");
        str = sb.toString();
        os.write(str.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeSectionHeader");
        }
    }

    public static void writeSectionProperties(SectionedProperties sp, OutputStream os, WASResource res) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeSectionProperties", new Object[]{sp, os, res});
        }
        Properties props = sp.getConfigProperties();
        SectionedPropertiesHelper.writeProperties(props, os);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeSectionProperties");
        }
    }

    public static void writeProperties(Properties props, OutputStream os) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeProperties", new Object[]{props, os});
        }
        StringBuffer sb = new StringBuffer();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String pName = (String)e.nextElement();
                String pValue = props.getProperty(pName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property ", new Object[]{pName, pValue});
                }
                sb = sb.append(pName).append("=").append(pValue).append("\n");
            }
        }
        sb = sb.append("\n");
        String str = sb.toString();
        os.write(str.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeProperties");
        }
    }

    public static void writeConfigId(String configId, String extensionId, OutputStream os, String sectionNumber) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeConfigId", new Object[]{configId, os});
        }
        StringBuffer sb = new StringBuffer("\n#\n## Section " + sectionNumber + "#" + configId + "\n#\n");
        if (extensionId != null) {
            sb = sb.append("ExtensionId").append("=").append(extensionId).append("\n");
        }
        sb = sb.append("ResourceId").append("=").append(configId).append("\n").append("\n#\n");
        String str = sb.toString();
        os.write(str.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeConfigId");
        }
    }

    public static void writeConfigId(String configId, String implType, String extensionId, OutputStream os, String sectionNumber) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeConfigId", new Object[]{configId, os});
        }
        StringBuffer sb = new StringBuffer("\n#\n## Section " + sectionNumber + "#" + configId + "\n#\n");
        sb = sb.append("ResourceType").append("=").append(implType).append("\n");
        sb = sb.append("ImplementingResourceType").append("=").append(implType).append("\n");
        if (extensionId != null) {
            sb = sb.append("ExtensionId").append("=").append(extensionId).append("\n");
        }
        sb = sb.append("ResourceId").append("=").append(configId).append("\n").append("\n#\n");
        String str = sb.toString();
        os.write(str.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeConfigId");
        }
    }

    public static void writeEndConfigId(String configId, String extensionId, OutputStream os, String sectionNumber) throws IOException {
        SectionedPropertiesHelper.writeEndConfigId(configId, extensionId, os, sectionNumber, null);
    }

    public static void writeEndConfigId(String configId, String extensionId, OutputStream os, String sectionNumber, WASResource res) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeEndConfigId", new Object[]{configId, os, res});
        }
        String resId = null;
        try {
            EnvVariables varObject = (EnvVariables)res.getReferenceProperties().get("EnvironmentVariablesObject");
            resId = PropertiesUtils.convertConfigIdToConfigScope(configId, res.getSession(), res.getConfigService(), varObject);
        }
        catch (Exception e) {
            resId = configId;
        }
        StringBuffer sb = new StringBuffer("\n#\n# End of Section " + sectionNumber + "# " + resId + "\n#\n");
        String str = sb.toString();
        os.write(str.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeEndConfigId");
        }
    }

    public static void writeFileHeader(String configId, OutputStream os) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeFileHeader", new Object[]{configId, os});
        }
        Date date = new Date();
        StringBuffer sb = new StringBuffer("\n#\n");
        sb = sb.append("# Configuration properties file for ").append(configId).append("#\n# Extracted on ").append(date.toString()).append("\n#\n");
        String str = sb.toString();
        os.write(str.getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeFileHeader");
        }
    }

    public static SectionedProperties getDeleteSectionedPropertiesForStep(String configType, String implType, String configId) {
        String comments = "Step parameters";
        SectionedProperties sp = SectionedPropertiesHelper.getCreateDeleteSectionedPropterties(configType, implType, configId, comments);
        sp.setDeleteTemplate();
        return sp;
    }

    public static SectionedProperties getCreateSectionedPropertiesForStep(String configType, String implType, String configId) {
        String comments = "Step parameters";
        SectionedProperties sp = SectionedPropertiesHelper.getCreateDeleteSectionedPropterties(configType, implType, configId, comments);
        sp.setCreateTemplate();
        return sp;
    }

    public static SectionedProperties getDeleteSectionedProperties(String configType, String implType, String configId) {
        StringBuffer sb = new StringBuffer("Delete parameters\n# Replace the line `SKIP=true` with 'SKIP=false' under each section that is needed \n# Set necessary parameters under each command or step sections \n# Invoke deleteConfigProperties command using this properties file.");
        String comments = sb.toString();
        SectionedProperties sp = SectionedPropertiesHelper.getCreateDeleteSectionedPropterties(configType, implType, configId, comments);
        sp.setDeleteTemplate();
        return sp;
    }

    public static SectionedProperties getCreateSectionedProperties(String configType, String implType, String configId) {
        StringBuffer sb = new StringBuffer("Create parameters\n# Replace the line `SKIP=true` with 'SKIP=false' under each section that is needed \n# Set necessary parameters under each command or step sections \n# Invoke applyConfigProperties command using this properties file.");
        String comments = sb.toString();
        SectionedProperties sp = SectionedPropertiesHelper.getCreateDeleteSectionedPropterties(configType, implType, configId, comments);
        sp.setCreateTemplate();
        return sp;
    }

    public static SectionedProperties getCreateDeleteSectionedPropterties(String configType, String implType, String configId, String comments) {
        SectionedProperties sp = new SectionedProperties();
        sp.setComments(comments);
        sp.setResourceType(configType);
        sp.setImplementingResourceType(implType);
        sp.setResourceId(configId);
        return sp;
    }
}

