/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.wasresource.common.WASResource;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class PropertiesUtils {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(PropertiesUtils.class, "PropertiesUtils", "com.ibm.ws.management.resources.configservice");

    public static String convertConfigScopeToConfigId(ObjectName root, String scope, Session session, ConfigService cs) throws Exception {
        if (!scope.contains("=")) {
            return scope;
        }
        ObjectName on = PropertiesUtils.convertConfigScopeToConfigObject(root, scope, session, cs);
        if (on != null) {
            return ConfigServiceHelper.getConfigDataId(on).toString();
        }
        return null;
    }

    public static ObjectName convertConfigScopeToConfigObject(ObjectName root, String scope, Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertConfigScopeToConfigId", new Object[]{root, scope, session, cs});
        }
        String newString = new String(scope);
        StringTokenizer st = null;
        st = scope.contains(":") ? new StringTokenizer(newString, ":") : new StringTokenizer(newString, "=");
        ObjectName obj = root;
        block0: while (st.hasMoreTokens()) {
            String containmentPath;
            String typeAndValue = null;
            String type = null;
            String val = null;
            if (scope.contains(":")) {
                typeAndValue = st.nextToken();
            }
            StringTokenizer st1 = null;
            st1 = scope.contains(":") ? new StringTokenizer(typeAndValue, "=") : st;
            type = st1.nextToken();
            if (st1.hasMoreTokens()) {
                val = st1.nextToken();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type and val", new Object[]{type, val});
            }
            if (val == null || !val.contains("#")) {
                containmentPath = type + "=";
                if (val != null) {
                    containmentPath = containmentPath + val;
                }
                obj = cs.resolve(session, obj, containmentPath)[0];
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "new obj", obj);
                continue;
            }
            containmentPath = type + "=";
            ObjectName[] objs = cs.resolve(session, obj, containmentPath);
            obj = null;
            for (int i = 0; i < objs.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking obj", objs[i]);
                }
                String cId = ConfigServiceHelper.getConfigDataId(objs[i]).toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking cId", cId);
                }
                if (val.startsWith("ID#")) {
                    if (!cId.contains(val.substring(3))) continue;
                    obj = objs[i];
                    continue block0;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking obj", objs[i]);
                }
                int inx = val.indexOf("#");
                String attrName = val.substring(0, inx);
                String attrValue = val.substring(inx + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking for attrName and attrValue", new Object[]{attrName, attrValue});
                }
                String newVal = (String)cs.getAttribute(session, objs[i], attrName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrValue for this object is ", newVal);
                }
                if (!newVal.equals(attrValue)) continue;
                obj = objs[i];
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertConfigScopeToConfigId", new Object[]{obj});
        }
        return obj;
    }

    public static String convertConfigIdToConfigScope(ObjectName cId, Session session, ConfigService cs, EnvVariables varObject) throws Exception {
        return PropertiesUtils.convertConfigIdToConfigScope(ConfigServiceHelper.getConfigDataId(cId).toString(), session, cs, varObject);
    }

    public static String convertConfigIdToConfigScope(String configId, Session session, ConfigService cs, EnvVariables varObject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertConfigIdToConfigScope", new Object[]{configId, session, cs, varObject});
        }
        String scope = null;
        if (configId.indexOf("/") < 0 && configId.indexOf("|") < 0) {
            return configId;
        }
        ObjectName objName = ConfigServiceHelper.createObjectName(new ConfigDataId(configId));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objName=", objName);
        }
        objName = cs.queryConfigObjects(session, null, objName, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objName=", objName);
        }
        String type = ConfigServiceHelper.getConfigDataType(objName);
        String id = PropertiesUtils.getConfigUniqueId(configId);
        EObject eObj = MOFUtil.convertToEObject(session, objName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "eObj=", eObj);
        }
        scope = PropertiesUtils.getRootObjectScope(configId, varObject);
        String rootObjType = PropertiesUtils.getRootObjectType(configId);
        String parentType = type;
        ArrayList<String> scopeElements = new ArrayList<String>();
        ObjectName pObj = objName;
        while (!parentType.equals(rootObjType)) {
            String pScope = null;
            pScope = parentType + "=" + "ID#" + PropertiesUtils.getConfigUniqueId(ConfigServiceHelper.getConfigDataId(pObj).toString());
            scopeElements.add(pScope);
            EObject parentObj = eObj.eContainer();
            if (parentObj == null) break;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObj=", parentObj);
            }
            pObj = MOFUtil.createObjectName(parentObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pObj=", pObj);
            }
            parentType = ConfigServiceHelper.getConfigDataType(pObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentType=", parentType);
            }
            eObj = parentObj;
        }
        for (int i = scopeElements.size() - 1; i >= 0; --i) {
            scope = scope + ":" + scopeElements.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertConfigIdToConfigScope", new Object[]{scope});
        }
        return scope;
    }

    public static EnvVariables createDefaultVariables(ConfigService cs, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultVariables", new Object[]{cs, session});
        }
        EnvVariables varObject = new EnvVariables();
        ObjectName[] objs = null;
        objs = cs.resolve(session, "Cell=");
        if (objs != null && objs.length == 1) {
            varObject.variablize(ConfigServiceHelper.getDisplayName(objs[0]), "cellName");
        }
        if ((objs = cs.resolve(session, "Cell=:Node=")) != null && objs.length == 1) {
            varObject.variablize(ConfigServiceHelper.getDisplayName(objs[0]), "nodeName");
        }
        if ((objs = cs.resolve(session, "Cell=:Node=:Server=")) != null && objs.length == 1) {
            varObject.variablize(ConfigServiceHelper.getDisplayName(objs[0]), "serverName");
        }
        if ((objs = cs.resolve(session, "Cell=:NodeGroup=")) != null && objs.length == 1) {
            varObject.variablize(ConfigServiceHelper.getDisplayName(objs[0]), "nodeGroup");
        }
        if ((objs = cs.resolve(session, "Cell=:CoreGroup=")) != null && objs.length == 1) {
            varObject.variablize(ConfigServiceHelper.getDisplayName(objs[0]), "coreGroup");
        }
        if ((objs = cs.resolve(session, "Cell=:AuthorizationGroup=")) != null && objs.length == 1) {
            varObject.variablize(ConfigServiceHelper.getDisplayName(objs[0]), "authorizationGroup");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultVariables", varObject);
        }
        return varObject;
    }

    public static String getRootObjectScope(String configId, EnvVariables varObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootObjectScope", new Object[]{configId});
        }
        String scope = null;
        StringBuffer sb = new StringBuffer();
        String id = new String(configId);
        StringTokenizer tokenizer = new StringTokenizer(id, "/|");
        while (tokenizer.hasMoreTokens()) {
            String appName;
            String token = tokenizer.nextToken();
            Object key = null;
            if (token.equals("cells")) {
                sb = sb.append("Cell=");
                String cellName = tokenizer.nextToken();
                if (varObject != null) {
                    cellName = varObject.variablize(cellName, "cellName");
                }
                sb = sb.append(cellName);
                continue;
            }
            if (token.equals("nodes")) {
                if (sb.length() > 0) {
                    sb = sb.append(":");
                }
                sb = sb.append("Node=");
                String nodeName = tokenizer.nextToken();
                if (varObject != null) {
                    nodeName = varObject.variablize(nodeName, "nodeName");
                }
                sb = sb.append(nodeName);
                continue;
            }
            if (token.equals("servers")) {
                if (sb.length() > 0) {
                    sb = sb.append(":");
                }
                sb = sb.append("Server=");
                String serverName = tokenizer.nextToken();
                if (varObject != null) {
                    serverName = varObject.variablize(serverName, "serverName");
                }
                sb = sb.append(serverName);
                continue;
            }
            if (token.equals("clusters")) {
                if (sb.length() > 0) {
                    sb = sb.append(":");
                }
                sb = sb.append("ServerCluster=");
                String clusterName = tokenizer.nextToken();
                if (varObject != null) {
                    clusterName = varObject.variablize(clusterName, "clusterName");
                }
                sb = sb.append(clusterName);
                continue;
            }
            if (token.equals("deployments")) {
                if (sb.length() > 0) {
                    sb = sb.append(":");
                }
                sb = sb.append("Deployment=");
                appName = tokenizer.nextToken();
                if (varObject != null) {
                    appName = varObject.variablize(appName, "applicationName");
                }
                sb = sb.append(appName);
                continue;
            }
            if (token.equals("coregroups")) {
                if (sb.length() > 0) {
                    sb = sb.append(":");
                }
                sb = sb.append("CoreGroup=");
                appName = tokenizer.nextToken();
                if (varObject != null) {
                    appName = varObject.variablize(appName, "coreGroup");
                }
                sb = sb.append(appName);
                continue;
            }
            if (token.equals("nodegroups")) {
                if (sb.length() > 0) {
                    sb = sb.append(":");
                }
                sb = sb.append("NodeGroup=");
                appName = tokenizer.nextToken();
                if (varObject != null) {
                    appName = varObject.variablize(appName, "nodeGroup");
                }
                sb = sb.append(appName);
                continue;
            }
            if (!token.equals("authorizationgroups")) continue;
            if (sb.length() > 0) {
                sb = sb.append(":");
            }
            sb = sb.append("AuthorizationGroup=");
            appName = tokenizer.nextToken();
            if (varObject != null) {
                appName = varObject.variablize(appName, "authorizationGroup");
            }
            sb = sb.append(appName);
        }
        scope = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootObjectScope", scope);
        }
        return scope;
    }

    public static String getRootObjectType(String cfgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootObjectType", cfgId);
        }
        String type = null;
        int end = cfgId.lastIndexOf("/");
        int start = cfgId.indexOf("/");
        if (start == end) {
            start = cfgId.indexOf("(");
            start = start == -1 || start > end ? 0 : ++start;
            type = cfgId.substring(start, end);
            return PropertiesUtils.convertContextToType(type);
        }
        while (true) {
            int inx;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start", new Integer(start));
            }
            if ((inx = cfgId.indexOf("/", start + 1)) >= end) break;
            start = inx;
        }
        if (start > 0 && end > 0 && end > start) {
            type = cfgId.substring(start + 1, end);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", type);
            }
        }
        type = PropertiesUtils.convertContextToType(type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootObjectType", type);
        }
        return type;
    }

    public static String convertContextToType(String context) {
        String type = null;
        if (context.equals("cells")) {
            type = "Cell";
        } else if (context.equals("nodes")) {
            type = "Node";
        } else if (context.equals("servers")) {
            type = "Server";
        } else if (context.equals("clusters")) {
            type = "ServerCluster";
        } else if (context.equals("applications")) {
            type = "Deployment";
        } else if (context.equals("deployments")) {
            type = "Deployment";
        } else if (context.equals("coregroups")) {
            type = "CoreGroup";
        } else if (context.equals("nodegroups")) {
            type = "NodeGroup";
        } else if (context.equals("authorizationgroups")) {
            type = "AuthorizationGroup";
        }
        return type;
    }

    public static String getConfigType(String cfgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigType", cfgId);
        }
        String type = null;
        int start = cfgId.lastIndexOf("#");
        int end = cfgId.lastIndexOf("_");
        if (start > 0 && end > 0 && end > start) {
            type = cfgId.substring(start + 1, end);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", type);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigType", type);
        }
        return type;
    }

    public static String getConfigUniqueId(String cfgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigUniqueId", cfgId);
        }
        String id = null;
        int start = cfgId.lastIndexOf("#");
        if (start > 0) {
            id = cfgId.substring(start + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "id", id);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigUniqueId", id);
        }
        return id;
    }

    public static String variablize(String oldVal, String varName, WASResource res) {
        EnvVariables varObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "variablize", new Object[]{oldVal, varName, res});
        }
        if ((varObject = (EnvVariables)res.getReferenceProperties().get("EnvironmentVariablesObject")) == null) {
            return oldVal;
        }
        if (oldVal == null || oldVal.equals("null")) {
            return oldVal;
        }
        String newVal = new String(oldVal);
        if (varName.equals("context")) {
            newVal = PropertiesUtils.variablizeContext(newVal, varObject);
        } else {
            StringTokenizer st = new StringTokenizer(newVal, "#");
            newVal = st.nextToken();
            newVal = newVal.trim();
            newVal = varObject.variablize(newVal, varName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "variablize", newVal);
        }
        return newVal;
    }

    public static String useExistingVariable(String oldVal, EnvVariables varObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "useExistingVariable", new Object[]{oldVal, varObject});
        }
        if (varObject == null) {
            return oldVal;
        }
        if (oldVal == null || oldVal.equals("null")) {
            return oldVal;
        }
        String newVal = new String(oldVal);
        StringTokenizer st = new StringTokenizer(newVal, "#");
        newVal = st.nextToken();
        newVal = newVal.trim();
        newVal = varObject.variablize(newVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "useExistingVariable", newVal);
        }
        return newVal;
    }

    public static String variablizeContext(String oldConfigId, EnvVariables varObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "variablizeContext", new Object[]{oldConfigId});
        }
        StringBuffer sb = new StringBuffer();
        Object scope = null;
        String configId = new String(oldConfigId);
        if (configId == null || configId.equals("null")) {
            return configId;
        }
        if (!configId.contains("/")) {
            return PropertiesUtils.useExistingVariable(configId, varObject);
        }
        if (!configId.startsWith("cells/") && configId.indexOf("(") > 0) {
            int i = configId.indexOf("(");
            sb = sb.append(configId.substring(0, i + 1));
        }
        String id = new String(configId);
        StringTokenizer tokenizer = new StringTokenizer(id, "/|");
        boolean foundContext = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = null;
            String val = null;
            String context = null;
            String currentName = null;
            if (token.equals("cells")) {
                currentName = tokenizer.nextToken();
                key = "cellName";
                context = "cells/";
            } else if (token.equals("nodes")) {
                currentName = tokenizer.nextToken();
                key = "nodeName";
                context = "nodes/";
            } else if (token.equals("servers")) {
                currentName = tokenizer.nextToken();
                key = "serverName";
                context = "servers/";
            } else if (token.equals("clusters")) {
                currentName = tokenizer.nextToken();
                key = "clusterName";
                context = "clusters/";
            } else if (token.equals("deployments")) {
                currentName = tokenizer.nextToken();
                key = "applicationName";
                context = "deployments/";
            } else if (token.equals("coregroups")) {
                currentName = tokenizer.nextToken();
                key = "coreGroup";
                context = "coregroups/";
            } else if (token.equals("nodegroups")) {
                currentName = tokenizer.nextToken();
                key = "nodeGroup";
                context = "nodegroups/";
            } else if (token.equals("authorizationgroups")) {
                currentName = tokenizer.nextToken();
                key = "authorizationGroup";
                context = "authorizationgroups/";
            }
            if (context == null || varObject == null) continue;
            val = varObject.variablize(currentName, key);
            foundContext = true;
            sb = sb.append(context).append(val);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "configId=", sb.toString());
        }
        String retVal = oldConfigId;
        if (foundContext) {
            int i = configId.indexOf("|");
            sb = sb.append(configId.substring(i));
            retVal = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "variablizeContext", retVal);
        }
        return retVal;
    }

    public static String variablizeAppContext(String oldConfigId, EnvVariables varObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "variablizeAppContext", new Object[]{oldConfigId});
        }
        StringBuffer sb = new StringBuffer();
        Object scope = null;
        String configId = new String(oldConfigId);
        if (configId == null || configId.equals("null")) {
            return configId;
        }
        if (!configId.contains("=")) {
            return configId;
        }
        if (!configId.startsWith("cell=") && configId.indexOf(":") > 0) {
            int i = configId.indexOf(":");
            sb = sb.append(configId.substring(0, i + 1));
            configId = configId.substring(i + 1);
        }
        String id = new String(configId);
        StringTokenizer tokenizer = new StringTokenizer(id, "=,");
        boolean foundContext = false;
        boolean firstTime = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = null;
            String val = null;
            String context = null;
            String currentName = null;
            if (token.equals("cell")) {
                currentName = tokenizer.nextToken();
                key = "cellName";
                context = "cell=";
            } else if (token.equals("node")) {
                currentName = tokenizer.nextToken();
                key = "nodeName";
                context = "node=";
            } else if (token.equals("server")) {
                currentName = tokenizer.nextToken();
                key = "serverName";
                context = "server=";
            } else if (token.equals("cluster")) {
                currentName = tokenizer.nextToken();
                key = "clusterName";
                context = "cluster=";
            }
            if (context == null || varObject == null) continue;
            val = varObject.variablize(currentName, key);
            foundContext = true;
            if (firstTime) {
                sb = sb.append(context).append(val);
                firstTime = false;
            } else {
                sb = sb.append(",").append(context).append(val);
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "configId=", sb.toString());
        }
        String retVal = oldConfigId;
        if (foundContext) {
            retVal = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "variablizeAppContext", retVal);
        }
        return retVal;
    }

    public static Properties getVariables(String fileName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariables", fileName);
        }
        Properties props = new Properties();
        FileReader fr = new FileReader(fileName);
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        while (line != null && (line.startsWith("#") || !line.startsWith("EnvironmentVariablesSection"))) {
            line = br.readLine();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "line=", line);
        }
        line = br.readLine();
        while (line != null) {
            if (!line.startsWith("#") && line.contains("=")) {
                StringTokenizer st = new StringTokenizer(line, "=");
                String key = st.nextToken().trim();
                String val = st.nextToken().trim();
                props.setProperty(key, val);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "key and val", new Object[]{key, val});
                }
            }
            line = br.readLine();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariables", props);
        }
        return props;
    }
}

