/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.properties.resources.common.APropertiesParser;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PropertiesParser {
    private static TraceComponent tc = Tr.register(PropertiesParser.class, "PropertiesParser", "com.ibm.ws.management.commands.properties.resources.common");
    private APropertiesParser parser;

    PropertiesParser(APropertiesParser parser) {
        this.parser = parser;
    }

    public void parse(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", fileName);
        }
        try {
            if (!this.loadConfigFile(fileName)) {
                this.loadConfigFileUsingV5Mech(fileName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.properties.resources.PropertiesParser.parse", (String)"82", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public void parse(InputStream in) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", in);
        }
        try {
            this.parser.parse(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.properties.resources.common.PropertiesParser.parse", (String)"96", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public boolean loadConfigFile(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfigFile", fileName);
        }
        boolean result = false;
        try {
            HashSet<Bundle> bundlesProvidingConfig = new HashSet<Bundle>();
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".ws-resources-def";
            IExtensionPoint point = registry.getExtensionPoint(epid);
            IExtension[] extensions = point.getExtensions();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension point " + epid);
                Tr.debug(tc, "There are " + extensions.length + " extensions");
            }
            for (int i = 0; i < extensions.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extension found " + extensions[i]);
                }
                bundlesProvidingConfig.add(Platform.getBundle((String)extensions[i].getNamespace()));
            }
            Iterator itr = bundlesProvidingConfig.iterator();
            while (itr.hasNext() && !result) {
                final Bundle bundle = (Bundle)itr.next();
                final String fileNameFinal = fileName;
                Enumeration e = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            return bundle.getResources(fileNameFinal);
                        }
                        catch (IOException ioe) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "io exception caught loading resources " + fileNameFinal);
                            }
                            return null;
                        }
                    }
                });
                while (e != null && e.hasMoreElements() && !result) {
                    try {
                        URL url = (URL)e.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "loading " + url);
                        }
                        InputStream in = url.openStream();
                        this.parse(in);
                        result = true;
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught exception while loading ");
                        }
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.properties.resources.common.PropertiesParser.loadConfigFile", (String)"151", (Object)this);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception while loading " + fileName);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.properties.resources.common.PropertiesParser.loadConfigFile", (String)"156", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigFile", new Boolean(result));
        }
        return result;
    }

    public void loadConfigFileUsingV5Mech(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfigFileUsingV5Mech", fileName);
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassLoaderClassLocator locator = new ClassLoaderClassLocator(loader);
            Enumeration e = locator.locateResources(fileName);
            while (e != null && e.hasMoreElements()) {
                try {
                    URL url = (URL)e.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loading " + url);
                    }
                    InputStream in = url.openStream();
                    this.parse(in);
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught exception while loading ");
                    }
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.commands.properties.resources.common.PropertiesParser.loadConfigFile", (String)"151", (Object)this);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception while loading " + fileName);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.properties.resources.common.PropertiesParser.loadConfigFileUsingV5Mech", (String)"256", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigFileUsingV5Mech");
        }
    }

    private class ClassLoaderClassLocator
    implements ClassLocator {
        private ClassLoader _loader;

        public ClassLoaderClassLocator(ClassLoader loader) {
            this._loader = loader;
        }

        public Class locateClass(final String className) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return ClassLoaderClassLocator.this._loader.loadClass(className);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (ClassNotFoundException)e.getCause();
            }
            return clazz;
        }

        public Enumeration locateResources(final String resourceName) throws IOException {
            Enumeration vEnum;
            try {
                vEnum = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return ClassLoaderClassLocator.this._loader.getResources(resourceName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
            return vEnum;
        }
    }

    private static interface ClassLocator {
        public Class locateClass(String var1) throws ClassNotFoundException;

        public Enumeration locateResources(String var1) throws IOException;
    }
}

