/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.properties.UserDefinedVariableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;

public class PropFileConverter {
    static final String RESID = "ResourceId=";
    String inputFile;
    String outputFile;
    ConfigService cs = null;
    Session session = null;
    UserDefinedVariableMap vMap = null;

    public PropFileConverter(String oldFile, String newFile) throws Exception {
        this.inputFile = oldFile;
        this.outputFile = newFile;
        this.session = new Session();
        Properties props = new Properties();
        props.put("location", "local");
        this.cs = ConfigServiceFactory.getConfigService();
        if (this.cs == null) {
            this.cs = ConfigServiceFactory.createConfigService(true, props);
        }
        this.vMap = new UserDefinedVariableMap();
        Properties vProps = PropertiesUtils.getVariables(oldFile);
        this.vMap.loadVarMap(vProps);
    }

    public void convert() throws Exception {
        FileReader fr = new FileReader(this.inputFile);
        BufferedReader br = new BufferedReader(fr);
        FileWriter fw = new FileWriter(this.outputFile);
        BufferedWriter bw = new BufferedWriter(fw);
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith(RESID)) {
                String id = line.substring(RESID.length()).trim();
                id = this.vMap.expand(id);
                String newId = PropertiesUtils.convertConfigScopeToConfigId(null, id, this.session, this.cs);
                line = RESID + newId;
            } else if (!line.startsWith("#")) {
                line = this.vMap.expand(line);
            }
            bw.write(line);
            bw.newLine();
            line = br.readLine();
        }
        this.cs.discard(this.session);
        br.close();
        fr.close();
        bw.flush();
        fw.flush();
        bw.close();
        fw.close();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: PropFileConverter inputFile outputFile");
            System.exit(0);
        }
        try {
            PropFileConverter pfc = new PropFileConverter(args[0], args[1]);
            pfc.convert();
            System.out.println("Done...");
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

