/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.mapping.CommandInfo;
import com.ibm.ws.management.commands.properties.resources.mapping.PropertyData;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.wasresource.common.WASResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ExtractProperties {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ExtractProperties.class, "ExtractProperties", "com.ibm.ws.management.resources.configservice");

    public static Properties getProperties(ConfigService cs, Session session, ObjectName configId, SectionData section) throws Exception {
        return ExtractProperties.getProperties(cs, session, configId, section, null);
    }

    public static Properties getProperties(ConfigService cs, Session session, ObjectName configId, SectionData section, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", new Object[]{cs, session, configId, section});
        }
        Properties props = null;
        if (section.getName() != null) {
            props = ExtractProperties.getPropertiesNameValue(cs, session, configId, section, res);
        } else {
            PropertyData[] propSection = section.getPropertiesData();
            String sectionType = section.getType();
            props = ExtractProperties.getProperties(cs, session, configId, section.getType(), section.getPropertiesData(), section, res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public static Properties getProperties(ConfigService cs, Session session, ObjectName configId, String configType, PropertyData[] propData, SectionData sectionData) throws Exception {
        return ExtractProperties.getProperties(cs, session, configId, configType, propData, sectionData, null);
    }

    public static Properties getProperties(ConfigService cs, Session session, ObjectName configId, String configType, PropertyData[] propData, SectionData sectionData, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", new Object[]{cs, session, configId, configType, propData});
        }
        Properties props = new Properties();
        for (int i = 0; i < propData.length; ++i) {
            ObjectName oName;
            Object obj;
            String s;
            Iterator itr;
            String pObjType;
            ArrayList arr;
            boolean typePresent;
            Object pObj;
            String attrName;
            String variableName;
            boolean pReadonly;
            boolean pRequired;
            String pType;
            String pValue;
            String pName;
            block120: {
                pName = propData[i].getPropName();
                pValue = null;
                pType = propData[i].getType();
                pRequired = propData[i].propRequired();
                pReadonly = propData[i].isReadOnly();
                variableName = propData[i].getVariableName();
                boolean pTypeRequired = propData[i].propTypeRequired();
                attrName = propData[i].getAttrName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting properties ", new Object[]{pName, attrName, pType});
                }
                pObj = null;
                typePresent = false;
                CommandInfo cmdInfo = sectionData.getGetCommandInfo(pName);
                if (cmdInfo != null) {
                    pObj = cmdInfo.execute(cs, session, configId, null);
                    if (pObj == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Property " + pName + " cannot be obtained ");
                        continue;
                    }
                } else {
                    try {
                        pObj = cs.getAttribute(session, configId, attrName);
                        if (pName.equals("password") || pName.equals("serverPassword")) {
                            pObj = PasswordUtil.passwordEncode((String)((String)pObj));
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block120;
                        Tr.debug(tc, "Attribute cannot be obtained. May be invalid for the node's version.", new Object[]{configId, attrName});
                    }
                }
            }
            if (pType == null || pType.equals("") || pType.startsWith("String")) {
                if (pType.startsWith("String*")) {
                    if (!(pObj instanceof ArrayList)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Required arraylist for property " + attrName + " found " + pObj);
                        }
                    } else {
                        arr = null;
                        arr = pObj == null ? new ArrayList() : (ArrayList)pObj;
                        pValue = "{";
                        boolean firstTime = true;
                        pObjType = null;
                        itr = arr.iterator();
                        while (itr.hasNext()) {
                            s = null;
                            obj = itr.next();
                            if (obj instanceof ObjectName) {
                                oName = (ObjectName)obj;
                                pObjType = ConfigServiceHelper.getConfigDataType(oName);
                                s = ConfigServiceHelper.getDisplayName(oName);
                            } else if (obj instanceof String) {
                                s = (String)obj;
                            }
                            if (!firstTime) {
                                pValue = pValue.concat(",");
                            } else {
                                firstTime = false;
                            }
                            if (s == null) continue;
                            pValue = pValue.concat(s);
                        }
                        pValue = pValue.concat("}");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "value of attr is " + pValue);
                        }
                        if (pObjType != null) {
                            pValue = pValue.concat(" #ObjectName*(" + pObjType + ")");
                            typePresent = true;
                        }
                    }
                } else {
                    String temp;
                    StringTokenizer strTok;
                    String pObjType2 = null;
                    if (pObj != null && pObj instanceof String) {
                        pValue = (String)pObj;
                        if (pValue.contains("\n")) {
                            pValue = pValue.replaceAll("\n", "&#xA;");
                        }
                        if (pValue.contains("\t")) {
                            pValue = pValue.replaceAll("\t", "&#x9;");
                        }
                    } else if (pObj != null && pObj instanceof ObjectName) {
                        pObjType2 = ConfigServiceHelper.getConfigDataType((ObjectName)pObj);
                        pValue = ConfigServiceHelper.getDisplayName((ObjectName)pObj);
                    } else {
                        pValue = pObj != null ? pObj.toString() : "null";
                    }
                    if (pValue != null && (strTok = new StringTokenizer(temp = new String(pValue), "\\/,#$@:;\"*?<>|=+&%'")).hasMoreTokens() && !strTok.nextToken().equals(temp)) {
                        pValue = "\"" + pValue + "\"";
                    }
                    if (pObjType2 != null) {
                        pValue = pValue.concat(" #ObjectName(" + pObjType2 + ")");
                        typePresent = true;
                    }
                }
            } else if (pType != null && pType.startsWith("ObjectName*")) {
                if (pObj != null) {
                    arr = (ArrayList)pObj;
                    pValue = "{";
                    boolean firstTime = true;
                    pObjType = null;
                    itr = arr.iterator();
                    while (itr.hasNext()) {
                        s = null;
                        obj = itr.next();
                        if (obj instanceof ObjectName) {
                            oName = (ObjectName)obj;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ObjectName " + oName);
                            }
                            pObjType = ConfigServiceHelper.getConfigDataType(oName);
                            s = ConfigServiceHelper.getDisplayName(oName);
                            if (s == null) {
                                s = ConfigServiceHelper.getConfigDataId(oName).toString();
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Expected ObjectName for " + pName + " got " + pObj);
                        }
                        if (!firstTime) {
                            pValue = pValue.concat(",");
                        } else {
                            firstTime = false;
                        }
                        pValue = pValue.concat(s);
                    }
                    pValue = pValue.concat("}").concat(" #ObjectName*(" + pObjType + ")");
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("ObjectName")) {
                if (pObj != null && pObj instanceof ObjectName) {
                    String s2;
                    ObjectName oName2 = (ObjectName)pObj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ObjectName " + pObj);
                    }
                    if ((s2 = ConfigServiceHelper.getDisplayName(oName2)) == null) {
                        s2 = ConfigServiceHelper.getConfigDataId(oName2).toString();
                    }
                    pObjType = ConfigServiceHelper.getConfigDataType(oName2);
                    pValue = s2.concat(" #ObjectName(" + pObjType + ")");
                    typePresent = true;
                } else if (pObj != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expected objectname for " + pName + " got " + pObj);
                }
            } else if (pType != null && pType.startsWith("int") && pType.endsWith("*")) {
                if (pObj != null && pObj instanceof ArrayList) {
                    arr = (ArrayList)pObj;
                    pValue = ExtractProperties.convertToString(arr);
                    pValue = pValue.concat(" #integer*");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Integer* expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #integer*";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("int")) {
                if (pObj != null && pObj instanceof Integer) {
                    pValue = pObj.toString().concat(" #integer");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Integer expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #integer";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("long") && pType.endsWith("*")) {
                if (pObj != null && pObj instanceof ArrayList) {
                    arr = (ArrayList)pObj;
                    pValue = ExtractProperties.convertToString(arr);
                    pValue = pValue.concat(" #long*");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Long* expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #long*";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("long")) {
                if (pObj != null && pObj instanceof Long) {
                    pValue = pObj.toString().concat(" #long");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Long expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #long";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("float") && pType.endsWith("*")) {
                if (pObj != null && pObj instanceof ArrayList) {
                    arr = (ArrayList)pObj;
                    pValue = ExtractProperties.convertToString(arr);
                    pValue = pValue.concat(" #float*");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Float* expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #float*";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("float")) {
                if (pObj != null && pObj instanceof Float) {
                    pValue = pObj.toString().concat(" #float");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Float expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #float";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("boolean") && pType.endsWith("*")) {
                if (pObj != null && pObj instanceof ArrayList) {
                    arr = (ArrayList)pObj;
                    pValue = ExtractProperties.convertToString(arr);
                    pValue = pValue.concat(" #boolean*");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Boolean* expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #boolean*";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("boolean")) {
                if (pObj != null && pObj instanceof Boolean) {
                    pValue = pObj.toString().concat(" #boolean");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Boolean expected for " + pName + " got " + pValue);
                    }
                } else {
                    pValue = "null #boolean";
                    typePresent = true;
                }
            } else if (pType != null && pType.startsWith("ENUM")) {
                String[] enumValues;
                if (pObj != null && pObj instanceof String) {
                    enumValues = propData[i].getEnumValues();
                    pValue = ((String)pObj).concat(" #ENUM").concat("(").concat(ExtractProperties.enumString(enumValues)).concat(")");
                    typePresent = true;
                } else if (pObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Enum expected for " + pName + " got " + pValue);
                    }
                } else {
                    enumValues = propData[i].getEnumValues();
                    pValue = "null #ENUM(" + ExtractProperties.enumString(enumValues) + ")";
                    typePresent = true;
                }
            }
            if (pRequired && pValue != null) {
                if (typePresent) {
                    pValue = pValue.concat(",required");
                } else {
                    pValue = pValue.concat(" #required");
                    typePresent = true;
                }
            }
            if (pReadonly && pValue != null) {
                pValue = typePresent ? pValue.concat(",readonly") : pValue.concat(" #readonly");
            }
            if (variableName != null) {
                pValue = PropertiesUtils.variablize(pValue, variableName, res);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value of attr is " + pValue);
            }
            if (pValue != null) {
                props.setProperty(pName, pValue);
                continue;
            }
            props.setProperty(pName, "null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    private static String enumString(String[] enumValues) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; enumValues != null && i < enumValues.length; ++i) {
            if (i != 0) {
                sb.append("|").append(enumValues[i]);
                continue;
            }
            sb.append(enumValues[i]);
        }
        String str = sb.toString();
        return str;
    }

    private static Properties getPropertiesNameValue(ConfigService cs, Session session, ObjectName configId, SectionData section, WASResource res) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesNameValue", new Object[]{cs, session, configId, section});
        }
        Properties result = new Properties();
        String attrName = section.getAttrName();
        String nameField = section.getName();
        String valueField = section.getValue();
        boolean pRequired = section.isPropRequired();
        boolean pTypeRequired = section.isPropTypeRequired();
        AttributeList aList = null;
        try {
            aList = cs.getAttributes(session, configId, new String[]{attrName}, false);
        }
        catch (Exception e) {
            String cType = ConfigServiceHelper.getConfigDataType(configId);
            String aType = section.getType();
            if (aType != null && cType != null && aType.equals(cType)) {
                throw e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no object of type " + aType + " in " + configId + " . Ignoring this section as this may not be set.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesNameValue", null);
            }
            return null;
        }
        List props = (List)((Attribute)aList.get(0)).getValue();
        StringBuffer sb = new StringBuffer();
        if (props != null) {
            for (ObjectName prop : props) {
                Boolean required;
                String pType;
                String pName;
                block47: {
                    pName = (String)cs.getAttribute(session, prop, nameField);
                    pType = null;
                    required = null;
                    try {
                        if (pTypeRequired) {
                            pType = (String)cs.getAttribute(session, prop, "type");
                        }
                        if (pRequired) {
                            required = (Boolean)cs.getAttribute(session, prop, "required");
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block47;
                        Tr.debug(tc, "No type and required attributes");
                    }
                }
                if (valueField.equals("null")) {
                    result.setProperty(pName, "");
                    continue;
                }
                Object pValue = cs.getAttribute(session, prop, valueField);
                if (pValue instanceof String) {
                    String sValue = (String)pValue;
                    pValue = ExtractProperties.variablize(sValue, pName, res);
                }
                String pVal = null;
                boolean typePresent = false;
                if (pValue != null) {
                    if (pType != null) {
                        pVal = pValue.toString().concat(" #").concat(ExtractProperties.getType(pType));
                        typePresent = true;
                    } else if (pValue instanceof Long) {
                        pVal = pValue.toString().concat(" #long");
                        typePresent = true;
                    } else if (pValue instanceof Integer) {
                        pVal = pValue.toString().concat(" #integer");
                        typePresent = true;
                    } else if (pValue instanceof Float) {
                        pVal = pValue.toString().concat(" #float");
                        typePresent = true;
                    } else if (pValue instanceof Boolean) {
                        pVal = pValue.toString().concat(" #boolean");
                        typePresent = true;
                    } else if (pValue instanceof ObjectName) {
                        String objType = ConfigServiceHelper.getConfigDataType((ObjectName)pValue);
                        pVal = ConfigServiceHelper.getDisplayName((ObjectName)pValue).concat(" #ObjectName(" + objType + ")");
                        typePresent = true;
                    } else if (pValue instanceof ArrayList) {
                        ArrayList lst = (ArrayList)pValue;
                        boolean firstTime = true;
                        String pElemType = null;
                        String pElemObjType = null;
                        pVal = "{";
                        for (Object obj : lst) {
                            if (!firstTime) {
                                pVal = pVal.concat(",");
                            } else {
                                if (obj instanceof Long) {
                                    pElemType = " #long";
                                } else if (obj instanceof Integer) {
                                    pElemType = " #integer";
                                } else if (obj instanceof Float) {
                                    pElemType = " #float";
                                } else if (obj instanceof Boolean) {
                                    pElemType = " #boolean";
                                } else if (obj instanceof ObjectName) {
                                    ObjectName on = (ObjectName)obj;
                                    pElemObjType = ConfigServiceHelper.getConfigDataType(on);
                                    pElemType = " #ObjectName(" + pElemObjType + ")";
                                }
                                firstTime = false;
                            }
                            if (obj instanceof ObjectName) {
                                pVal = pVal.concat(ConfigServiceHelper.getDisplayName((ObjectName)obj));
                                continue;
                            }
                            pVal = pVal.concat(obj.toString());
                        }
                        pVal = pVal.concat("}");
                        if (pElemType != null) {
                            pVal = pVal.concat(pElemType);
                            typePresent = true;
                        }
                    } else {
                        pVal = pValue.toString();
                    }
                    if (required != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "property type = " + pType + " propRequired = ", required);
                        }
                        if (required.booleanValue()) {
                            pVal = typePresent ? pVal.concat(",required") : pVal.concat(" #required");
                        }
                    }
                    result.setProperty(pName, pVal);
                    continue;
                }
                result.setProperty(pName, "null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesNameValue", result);
        }
        return result;
    }

    private static String getType(String type) {
        if (type.endsWith("String")) {
            return "String";
        }
        if (type.endsWith("Integer")) {
            return "integer";
        }
        if (type.endsWith("Float")) {
            return "float";
        }
        if (type.endsWith("Long")) {
            return "long";
        }
        if (type.endsWith("Boolean")) {
            return "boolean";
        }
        if (type.endsWith("[Ljava.lang.String;")) {
            return "String*";
        }
        if (type.endsWith("[Ljava.lang.Integer;")) {
            return "integer*";
        }
        if (type.endsWith("[Ljava.lang.Long;")) {
            return "long*";
        }
        if (type.endsWith("[Ljava.lang.Float;")) {
            return "float*";
        }
        if (type.endsWith("[Ljava.lang.Boolean;")) {
            return "boolean*";
        }
        return "String";
    }

    private static String getJavaType(String type) {
        if (type.startsWith("String")) {
            return "java.lang.String";
        }
        if (type.startsWith("int")) {
            return "java.lang.Integer";
        }
        if (type.startsWith("float")) {
            return "java.lang.Float";
        }
        if (type.startsWith("long")) {
            return "java.long.Long";
        }
        if (type.startsWith("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.endsWith("String*")) {
            return "[Ljava.lang.String;";
        }
        if (type.endsWith("int*") || type.endsWith("integer*")) {
            return "[Ljava.lang.Integer;";
        }
        if (type.endsWith("long*")) {
            return "[Ljava.lang.Long;";
        }
        if (type.endsWith("float*")) {
            return "[Ljava.lang.Float;";
        }
        if (type.endsWith("boolean*")) {
            return "[Ljava.lang.Boolean;";
        }
        return "java.lang.String";
    }

    private static String convertToString(ArrayList arr) {
        String pValue = "{";
        boolean firstTime = true;
        for (Object obj : arr) {
            if (!firstTime) {
                pValue = pValue.concat(",");
            } else {
                firstTime = false;
            }
            pValue = pValue.concat(obj.toString());
        }
        pValue = pValue.concat("}");
        return pValue;
    }

    private static String variablize(String pValue, String pName, WASResource res) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "variablize", new Object[]{pValue, pName, res});
        }
        String result = null;
        if (pName != null && pName.equals("WAS_CELL_NAME")) {
            pValue = PropertiesUtils.variablize(pValue, "cellName", res);
        } else if (pName != null && pName.equals("SERVER_LOG_ROOT")) {
            int i = pValue.lastIndexOf("/");
            if (i > 0) {
                String path = pValue.substring(0, i);
                String sName = pValue.substring(i + 1);
                sName = PropertiesUtils.variablize(sName, "serverName", res);
                pValue = path + "/" + sName;
            }
        } else if (pName != null && pName.equals("WAS_SERVER_NAME")) {
            pValue = PropertiesUtils.variablize(pValue, "serverName", res);
        }
        result = pValue;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "variablize", result);
        }
        return result;
    }
}

