/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class EnvVariables {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(EnvVariables.class, "EnvVariables", "com.ibm.ws.management.resources.configservice");
    private Properties variables = new Properties();

    public String variablize(String val, String useThisKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "variablize", new Object[]{val, useThisKey});
        }
        if (val == null || val.equals("null")) {
            return val;
        }
        String newKey = useThisKey;
        Enumeration<Object> keys = this.variables.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.variables.get(key);
            if (!value.equals(val)) continue;
            newKey = "!{" + key + "}";
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "variablize", new Object[]{newKey});
            }
            return newKey;
        }
        int i = 1;
        while (this.variables.containsKey(newKey)) {
            newKey = useThisKey + i;
            ++i;
        }
        this.variables.put(newKey, val);
        newKey = "!{" + newKey + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "variablize", new Object[]{newKey});
        }
        return newKey;
    }

    public String variablize(String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "variablize", new Object[]{val});
        }
        String newKey = val;
        Enumeration<Object> keys = this.variables.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.variables.get(key);
            if (!value.equals(val)) continue;
            newKey = "!{" + key + "}";
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "variablize", new Object[]{newKey});
            }
            return newKey;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "variablize", new Object[]{newKey});
        }
        return newKey;
    }

    public void dumpProperties(String fileName) throws Exception {
        FileOutputStream out = new FileOutputStream(new File(fileName));
        this.variables.store(out, "Environment Variables");
    }

    public void dumpProperties(FileOutputStream os) throws Exception {
        String envVars = "#\n#\nEnvironmentVariablesSection\n#\n#\n#Environment Variables\n";
        os.write(envVars.getBytes());
        Enumeration<Object> keys = this.variables.keys();
        StringBuffer sb = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.variables.get(key);
            sb = sb.append(key).append("=").append(value).append("\n");
        }
        os.write(sb.toString().getBytes());
    }

    public Properties getVariables() {
        return this.variables;
    }
}

